:!GETLAST.SL - GET THE LAST-RECORD-NUMBER FOR A LINKED FILE
:
:# D E S C R I P T I O N
:   RETURNS THE LAST-RECORD-NUMBER FROM RECORD 0 OF A LINKED FILE. IF THE
:LOGICAL RECORD LENGTH IS GREATER THAN OR EQUAL TO 14 THEN THE NUMBER OF
:ACTIVE RECORDS IN THE FILE IS ALSO RETURNED. IF THE LOGICAL RECORD LENGTH
:IS LESS THAN 10 THEN AN ERROR CODE IS RETURNED. THE FILE MUST HAVE BEEN LOPEN'D
:PRIOR TO CALLING GETLAST.
:
:> C A L L I N G     S E Q U E N C E
:
:    F%     - LOGICAL FILE NUMBER
:
:    GOSUB 9950
:
:    LSTREC - LAST RECORD NUMBER
:    ACTREC - NUMBER OF ACTIVE RECORDS CURRENTLY IN FILE (ONLY IF RECORD 
:             LENGTH IS GREATER THAN OR EQUAL TO 14 BYTES)
:    E      - ERROR FLAG AS FOLLOWS:
:                  E  =  0      NORMAL RETURN
:                  E  <> 0      APPROPRIATE ERROR CODE, INDICATES ONE OF FOLLOWING:
:                                   THE LOGICAL FILE IS NOT A LINKED FILE
:                                   THE LOGICAL RECORD LENGTH IS LESS THAN 10 BYTES
:                                   THE LOGICAL FILE NUMBER INPUT (F%) IS OUT OF RANGE
:                  (NOTE - LSTREC & ACTREC ARE UNDEFINED ON AN ERROR RETURN)
:
:$ S T O R A G E     U S E D
:
:    X      - SCRATCH VARIABLE
:
::
9950 REM \ GETLAST
9952 LET E=86                                                 :ERROR CODE FOR BAD F%
9954 IF F%<1 THEN RETURN                                      :EXIT IF F% OUT OF RANGE
9956 IF F%*26>LEN(LFTABL$) THEN RETURN 
9958 LET X=(F%-1)*26+1                                        :SET LFTABL$ POINTER
9960 IF ASC(LFTABL$[X+18,X+19])<10 THEN LET E=45              :CHECK RECORD LENGTH
9962 IF LFTABL$[X+24,X+24]<>"L" THEN LET E=89                 :CHECK LOGICAL FILE TYPE
9964 IF E<>86 THEN RETURN                                     :EXIT IF ERROR OCCURRED
9966 UNPACK "CL",LFTABL$[X],E,LSTREC                          :GET CHANNEL NUMBER & OFFSET
9968 POSITION FILE[E,LSTREC+6]                                :POSITION TO LAST-RECORD-NUMBER
9970 READ FILE[E],LSTREC                                      :READ LAST-RECORD-NUMBER
9972 IF ASC(LFTABL$[X+18,X+19])>=14 THEN READ FILE[E],ACTREC  :READ ACTIVE-RECORDS IF POSSIBLE
9974 LET E=0                                                  :CLEAR ERROR CODE
9976 RETURN                                                   :EXIT
