/*************************************************************************
*
*
*	Name:  tip.h
*
*	Description:  Generic include file for TIP routines.
*				  (Input & output TIP code definitions).
*
*
*	History:
*	Date		By		Comments
*
*	04/20/84	waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
************************************************************************/




/*  Notes -

	** NOTE **
	The TIP output codes are * integer * values.
	The TIP input codes are * char * values.
	All TIP output codes are in the range 256 <= x <= 511, which allows
	character values to be in the range 0 <= c <= 255.
	The TIP input codes are in the range 128 <= x <= 255. Input characters
	are in the range 0 <= c <= 255.

*/

/* waf - Set 'personality' */
#define		DAREDUN		0	/* Allow both new (DG6053 style) display attr
					   		control and TIP style (TO_Vxx) displ attr control.
							If reset, only DG6053 style implemented. */
#define		SMALLTIP	0	/* If set, make a 'minimum' package. This is used,
							in particular, for the sform routines. */



/* Declare TIP fn's */
char	tgetc() ;
int		tputc() ;
int		tputs() ;

/**
*
*	TIP output codes.
*	These codes are used to output control chars via tputc().
*	NOTE - Code value range is :  255 < x < 512
*
*	( '*'ed codes are not implemented (yet) )
*
**/

#define	TO_START	256		/* Starting value (low bound) of TO codes */

#define	TO_INIT 	256
#define	TO_CS		257		/* Clear Screen				*/
#define	TO_MC		258		/* Position cursor			*/
#define	TO_MCH		259		/* Cursor home				*/
#define	TO_MCU		260		/* Cursor up				*/
#define	TO_MCD		261		/* Cursor down				*/
#define	TO_MCR		262		/* Cursor right 			*/
#define	TO_MCL		263		/* Cursor left				*/
#define	TO_MCV		264		/**Move cursor vertical		*/
#define	TO_ERL		265		/* Erase to end of line		*/
#define	TO_ERS		266		/**Erase to end of screen	*/
#define	TO_VN		267		/**Video Normal 			*/
#define	TO_VR		268		/**Video reverse			*/
#define	TO_VNF		269		/**Video normal flashing	*/
#define	TO_VRF		270		/**Video reverse flashing	*/
#define	TO_INSLN	271		/**Insert line				*/
#define	TO_DELLN	272		/**Delete line				*/
#define	TO_INSP		273		/**Insert a space			*/
#define	TO_FRA		274		/**Fill row attributes		*/
#define	TO_VB		275		/**Enhance brightness of	*/

#define	TO_DEL		280		/* Delete character			*/
#define	TO_BELL		281		/* Bell						*/


/* The following codes allow setting and resetting of individual display
   attributes (a la DG6053).
   The specified attr remains in effect until countermanded. */
#define	TO_VNORM	300		/* Set 'normal' display		*/
#define	TO_SDIM		301		/* Start dim				*/
#define	TO_EDIM		302		/* End dim (e.g. Bright)	*/
#define	TO_SUNDL	303		/* Start underline			*/
#define	TO_EUNDL	304		/* End underline			*/
#define	TO_SBLNK	305		/* Start blink				*/
#define	TO_EBLNK	306		/* End blink				*/
#define	TO_SREV		307		/* Start reverse video		*/
#define	TO_EREV		308		/* End reverse video		*/
#define	TO_SSCRL	309		/* Start scroll (scroll enable) */
#define	TO_ESCRL	310		/* End scroll (scroll disable) */
#define	TO_SWRAP	311		/**Start line wrap (wrap enable) */
#define	TO_EWRAP	312		/**End line wrap (wrap disable) */

/**
*
*	TIP input codes.
*	One of these codes is returned by tgetc() if the input is an
*	'extended' control character or ASCII control char.
*	Note that these codes are > 127.
*
**/

#define	TI_START	0x80		/* Starting value (low bound) of TI codes */

/* Control keys */
#define	TI_CAN		0x80		/* Cancel input line (^U) */
#define	TI_DEL		0x89		/* Delete character (DEL key) */
#define	TI_MCH		0x81		/* Move cursor home */
#define	TI_MCU		0x82		/* Move cursor up */
#define	TI_MCD		0x83		/* Move cursor down */
#define	TI_MCR		0x84		/* Move cursor right */
#define	TI_MCL		0x85		/* Move cursor left */
#define	TI_INSLN	0x86		/* Insert line */
#define	TI_DELLN	0x87		/* Delete line */
#define	TI_INS		0x88		/* Insert character */
#define	TI_ERL		0x8a		/* erase rest of line */

/* waf - additional codes */
#define	TI_UNP		0x90		/* 'Unpend' (\n or \l) */
#define	TI_ESC		0x91		/* Escape key */
#define	TI_QUIT		0x92		/* Quit key (^C) */

/* Function keys.
   Key codes are sequential. */
#define	TI_F1		0xc0		/* Function 1 */
#define	TI_F2		0xc1		/* Function 2 */
#define	TI_F3		0xc2		/* Function 3 */
#define	TI_F4		0xc3		/* Function 4 */
#define	TI_F5		0xc4		/* Function 5 */
#define	TI_F6		0xc5		/* Function 6 */
#define	TI_F7		0xc6		/* Function 7 */
#define	TI_F8		0xc7		/* Function 8 */
#define	TI_F9		0xc8		/* Function 9 */
#define	TI_F10		0xc9		/* Function 10 */
#define	TI_F11		0xca		/* Function 11 */
#define	TI_SF1		0xcb		/* Shifted Function 1 */
#define	TI_SF2		0xcc		/* Shifted Function 2 */
#define	TI_SF3		0xcd		/* Shifted Function 3 */
#define	TI_SF4		0xce		/* Shifted Function 4 */
#define	TI_SF5		0xcf		/* Shifted Function 5 */
#define	TI_SF6		0xd0		/* Shifted Function 6 */
#define	TI_SF7		0xd1		/* Shifted Function 7 */
#define	TI_SF8		0xd2		/* Shifted Function 8 */
#define	TI_SF9		0xd3		/* Shifted Function 9 */
#define	TI_SF10		0xd4		/* Shifted Function 10 */
#define	TI_SF11		0xd5		/* Shifted Function 11 */
#define	TI_CF1		0xd6		/* Control Function 1 */
#define	TI_CF2		0xd7		/* Control Function 2 */
#define	TI_CF3		0xd8		/* Control Function 3 */
#define	TI_CF4		0xd9		/* Control Function 4 */
#define	TI_CF5		0xda		/* Control Function 5 */
#define	TI_CF6		0xdb		/* Control Function 6 */
#define	TI_CF7		0xdc		/* Control Function 7 */
#define	TI_CF8		0xdd		/* Control Function 8 */
#define	TI_CF9		0xde		/* Control Function 9 */
#define	TI_CF10		0xdf		/* Control Function 10 */
#define	TI_CF11		0xe0		/* Control Function 11 */
#define	TI_AF1		0xe1		/* Alt Function 1 */
#define	TI_AF2		0xe2		/* Alt Function 2 */
#define	TI_AF3		0xe3		/* Alt Function 3 */
#define	TI_AF4		0xe4		/* Alt Function 4 */
#define	TI_AF5		0xe5		/* Alt Function 5 */
#define	TI_AF6		0xe6		/* Alt Function 6 */
#define	TI_AF7		0xe7		/* Alt Function 7 */
#define	TI_AF8		0xe8		/* Alt Function 8 */
#define	TI_AF9		0xe9		/* Alt Function 9 */
#define	TI_AF10		0xea		/* Alt Function 10 */


#define	TI_UNDEF	0xff		/* Undefined/unsupported char / code */
#define	TI_UNDCC	0xfe		/* Unsupported control code */
#define	TI_UNDFN	0xfd		/* Undefined/unsupported fn key */
