/*************************************************************************
*
*
*	Name:  menu.c
*
*	Description:  Opus menu.
*
*
*	History:
*	Date		By		Comments
*
*	05/84		waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  Opus routines module.  */




/*  Notes -

*/

#include	"/sform/sform.h"
#include	"DEFINES.H"
#include	"EXTERN.H"
#include	"menu.h"
#include	"/sform/stip.h"


extern	int		sf_fldmod ;		/* set if user entered data */
extern	int		x_index ;		/* set to -1 if error during set_type() */


/* Define dedicated Opus fn key translation table.
   Fn's marked with '*' can be returned to menu code. */
extern	int	(*sf_fntable)[][2] ;
int		opusfntbl[][2]	= {
	/*	Char		Function	*/
	TI_FTAB,	SF_NXTFLD,	/** -->		- Next fld				*/
	TI_BTAB,	SF_PRVFLD,	/** <--		- Prev fld				*/
	TI_F2,		SF_HELP,	/*  HELP	- (Full screen) Help	<<< PATCH */
	TI_SF2,		SF_FLDFMT,	/*  		- Show fld format		*/
	TI_F4,		SF_RSTWIN,	/** ERS INP	- Reset all flds		*/
	TI_F6,		SF_CLRFLD,	/*  ERS EOF	- Clear fld				*/
	TI_F8,		SF_NXTENM,	/*  NXT VAL	- Next enumerator		*/
	TI_SF8,		SF_PRVENM,	/*  		- Prev enumerator		*/
	TI_F9,		SF_ABORT,	/** EXIT	- Abort					*/
	TI_F10,		SF_CLRERR,	/*  RESET	- Clear error			*/

	/* end of list */
	0,			0
} ;


/* Define (standard) fn key labels */
char	fnklabel[][FKLABSIZ+1] = {
	"",			/* [0] not used */
	" Send",
	" Help",
	" Recv",
	" Ers Inp",
	"Edit Type",
	" Ers EOF",
	" Aux Menu",
	" Nxt Val",
	" Exit",
	" Reset"
} ;

/* Fn key enabled/disabled flags */
int		fnkflag[11] ;

/* Fn key data */
char	fkdata[11][FKLABSIZ+1] ;		/* Fn key labels */

/* Define Fn Key # to Fld # mapping.
   Index is fn key #, element is fld # in window */
#if	1
#define	fk2fld(FNK)		(FNK - 1)
#else
#define	fk2fld(FNK)		fk2fda[FNK]
static	int	fk2fda[]	= {
	0,		/* [0] not used */
	0,1,2,3,4,5,6,7,8,9
} ;
#endif



char	xftbuf[XFTSIZ] ;	/* tmp buf for xfer type & operands data */
unsigned	reccnt ;		/* (dummy) Record count data */
int		recfmt1, recfmt2 ;	/* Record fmt tmp vars */
int		ttypok ;			/* Set when a legal xfer type exists */

menu ( pc_file, data_set, operands, clr_flg )

char	*pc_file, *data_set ;	/* Filenames	*/
char	*operands ;
int		clr_flg ;				/* if == CLR, reset window */

/*
  Synopsis -
	Opus user menu.

  Return -
	return val	= Completion code.

  Notes -
  > This fn must be 'reenterable', in that the calling code will want the
  main window data 'cleared' in some situations, but in other situations
  the display should not change.
*/

{
	int		i ;
	register int	fc ;		/* completion code */
	struct SF_FIELD (*fldlst)[] ;


	/* Set ptrs to filenames */
	fldlst = fnamwin.sf_fldlist ;
	(*fldlst)[1].sf_bindata = (struct SF_BINDATA *) pc_file ;
	fldlst = dnamwin.sf_fldlist ;
	(*fldlst)[1].sf_bindata = (struct SF_BINDATA *) data_set ;

	/* Chk clr_flg flag.
	   If clr_flag == CLR, the 'main window' data fields
	   should be cleared */
	if ( clr_flg == CLR ) {
		menu_rst(data_set, pc_file) ;	/* reset window */
		clr_flg == NO_CLR ;				/* reset the flag */
		}


start:
	/* Loop until user selects Send, Receive, or Exit */
	fc = SF_OK ;
	for (;;) {


		/* Set up for next/first loop */
		if ( fc == SF_OK ) {
			/* First time thru menu */
			showmain() ;					/* Show filenames & xfer type */
			/* showfnk() ;					/* Show fn keys 			??? */
			fc = SF_ERROR ;					/* reset flag */
		}
		else {
			/* Not first time thru menu */
			if ( fc == UF_RESTART ) {
				/* we're doing a restart */
				menu_rst(data_set, pc_file) ;
				showmain() ;				/* Re-dispay main window */
				*operands = '\0' ;			/* clear operands */
			}
		}


gfnam:	/* Get PC filename */
		fc = getfnam(data_set, pc_file) ;
		if ( fc == SF_PRVFLD )
			goto gxftyp ;
		if ( fc != SF_NXTFLD )
			goto fnsw ;					/* ??? */

gdnam:	/* Get Data set name */
		fc = getdnam(data_set, pc_file) ;
		if ( sf_fldmod ) {
			/* user changed ds name - clear xfer type */
			*operands = *xftbuf = '\0' ;
		}

fnsw:	/* Chk completion code */
		switch ( fc ) {
			case  SF_NXTFLD :
				break ;
			case  UF_SEND :
			case  UF_RECV :
				if ( fnkflag[1] )
					goto xit ;
				else {
					badfnk() ;
					continue ;
				}
			case  SF_PRVFLD :
				/* Back tab */
				goto gfnam ;
			case  UF_EDTYPE :
				goto ledxfp ;
			case  UF_AUXMENU :
			case  UF_EXIT :
				goto xit ;
			case  UF_ERSINP :
				goto lersinp ;
			default :
				sfbeep() ;
				continue ;
		}


gxftyp:	/* Get xfer type */
		fc = getxft(data_set, operands, pc_file) ;	/* user xfer type entry */
		/* Chk completion code */
		switch ( fc ) {
			case  SF_ERROR :
				goto gxftyp ;			/* try again */
			case  SF_NXTFLD :
				continue ;
			case  SF_PRVFLD :
				goto gdnam ;
			case  UF_EDTYPE :
ledxfp:			/* Edit xfer type */
				break ;
			case  UF_SEND :
			case  UF_RECV :
				if ( fnkflag[1] )
					goto xit ;
				else {
					badfnk() ;
					continue ;
				}
			case  UF_EXIT :
			case  UF_AUXMENU :
				goto xit ;
			case  UF_ERSINP :
lersinp:		/* 'reset' filenames & xfer type */
				fc = UF_RESTART ;
				continue ;				/* do a 'restart' */
			default :
				sfbeep() ;
				continue ;
		}


		/* Edit xfer parameters */
		if ( fnkflag[5] == 0 ) {
			/* Edit disabled */
			badfnk() ;
			continue ;
		}
		fc = editxfp(data_set, operands) ;	/* edit parms */
		/* Chk completion code */
		switch ( fc ) {
			case  UF_RESTART :
				sfopen(&xfpwin) ;			/* clear xfp window */
				continue ;
			case  UF_ERSINP :
				goto lersinp ;
			case  UF_SEND :
			case  UF_RECV :
				if ( fnkflag[1] )
					goto xit ;
				else {
					badfnk() ;
					continue ;
				}
			case  UF_EXIT :
				goto xit ;
		}

	/* loop */
	}


xit:	/* Chk return code */
	if ( fc == UF_SEND || fc == UF_RECV ) {

		/* Confirm ready for xfer */
		if ( xfer_chk(pc_file, data_set, operands) == FALSE ) {
			/* can't do it - Warren shows error msg */
			goto start ;
		}

		/* Show record count label (to set attribute) */
		i = 0 ;
		sfwinio(&rcntwin, &i, SF_LABELS) ;
	}


	return(fc) ;
}

/*********************
**	Get Filenames	**
*********************/



getfnam ( data_set, pc_file )

char	*data_set, *pc_file ;		/* binary data ptr */

/* Get PC filename.
   Returns comp code.
*/

{
	register int	fc ;
	int		i ;


	i = 0 ;
	fc = sfwinio(&fnamwin, &i, SF_EDIT) ;
	sfclrerm() ;
	mxfrchk(data_set, pc_file) ;
	return(fc) ;
}



getdnam ( data_set, pc_file )

char	*data_set, *pc_file ;		/* binary data ptr */

/* Get Data Set name.
   Returns comp code.
*/

{
	register int	fc ;
	int		i ;


	i = 0 ;
	fc = sfwinio(&dnamwin, &i, SF_EDIT) ;
	sfclrerm() ;
	mxfrchk(data_set, pc_file) ;
	return(fc) ;
}

/*************************
**	Get xfer type info	**
*************************/


getxft ( data_set, operands, pc_file )

char	*data_set, *operands, *pc_file ;

/* Get transfer type info.
   If user enters new info, set_type is called to chk the new info.
   Note that 'xftbuf' is used for both the file type info and for user input
   data, and alway contains the most recent xfer type 'defined'.
*/

{
	register int	fc ;
	register int	flag ;
	int		i ;


	/* Get xfer type */
	makexft(data_set, operands, pc_file) ;	/* default xfer type */
	mxfrchk(data_set, pc_file) ;			/* chk Send & Recv status */
	i = 0 ;
	fc = sfwinio(&xftwin, &i, SF_EDIT) ;	/* get usr input */
	sfclrerm() ;

	/* Chk for certain return codes */
	if ( chkabend(fc) )
		return(fc) ;						/* abnormal unpend */

	/* Chk for changed data */
	flag = 0 ;
	if ( sf_fldmod ) {
		/* User changed type */
		strcpy(operands, xftbuf) ;		/* usr supplied info */
		if ( sf_fldmod > 0 ) {
			/* user defined xfer type */
			if ( makexft(data_set, operands, pc_file) == FALSE ) {
				/* Bad xfer type */
				dsblsr() ;				/* disable Send & Recv */
				flag-- ;				/* flag the error */
			}
			setfnk(5) ;					/* enable edit on new type */
		}
		else {
			/* xfer type cleared */
			dsblsr() ;					/* disable Send & Recv */
			rstfnk(5) ;					/* disable Edit (& Xfer) */
			flag-- ;					/* flag the error */
		}
		mxfrchk(data_set, pc_file) ;	/* after the smoke has cleared */
		/* Chk if usr input was unpended with a Send or Recv fn key.
		   If so, and if input was not valid, trap the error HERE */
		if ( flag ) {
			if ( fc == UF_SEND || fc == UF_RECV ) {
				xfer_chk(pc_file, data_set, operands) ;		/* report error */
				fc = SF_ERROR ;			/* forget about the Xfer request */
			}
		}
	}

	return(fc) ;
}

makexft ( data_set, operands, pc_file )

char	*data_set, *operands, *pc_file ;

/* Chk xfer type.
   The values in data_set and operands are used to 'make' a transfer
   type value (the 'set_type() fn does the checking).
   Returns FALSE if a legal xfer type could not be made,
   returns TRUE if a legal xfer type could be made.
   'xftbuf' buffer is set with 'xfer type' value.
   Edit fn key is enabled/disabled.
   'ttypok' is given value of return value.
*/

{
	register int	flag ;


	set_type(data_set, operands) ;		/* try to create default */
	if ( x_index != -1 ) {
		/* default xfer type created */
		flag = TRUE ;					/* flag ok */
		/* Put 'result' in xft buffer */
		if ( strlen(operands) == 0 )
			/* xfer type was created from data-set */
			strcpy(xftbuf, x_file_type) ;
		else
			/* xfer type was entered by user */
			strcpy(xftbuf, operands) ;
	}
	else
		flag = FALSE ;					/* flag error */

	/* Set/Reset flags */
	ttypok = flag ;						/* Set/Reset global flag */
	if ( flag == TRUE )
		setfnk(5) ;						/* Enable Edit fn key */
	else
		rstfnk(5) ;						/* Disable Edit fn key */

	return(flag) ;
}

editxfp ( data_set, operands )

char	*data_set, *operands ;

/* Get new xfer parameters */

{
	register int	fc ;
	int		i ;
	extern	int		sf_hifld ;		/* highest fld # in xfp window */
	int		x ;


	/* Show active fn keys */
	strcpy(fkdata[5], "Save Type") ;
	sffldio(&fnkeywin, fk2fld(5), SF_DISPLAY) ;
	strcpy(fkdata[7], " Restart") ;
	sffldio(&fnkeywin, fk2fld(7), SF_DISPLAY) ;

	/* Create 2 recfmt flds from record fmt info */
	fc = x_rec_fmt ;			/* use reg var */
	recfmt1 = (fc > 1)? 1 : 0 ;		/* Variable / Fixed */
	recfmt2 = (fc & 1)? 0 : 1 ;		/* Blked / UnBlked */

	/* Get xfer params */
	i = 0 ;
	sfwinio(&xfpwin, &i, SF_LABELS) ;
	i = 0 ;
	sfwinio(&xfpwin, &i, SF_DISPLAY) ;
	i = 0 ;
	do {
		fc = sfwinio(&xfpwin, &i, SF_EDIT) ;
		sfclrerm() ;
		if ( fc == UF_SAVTYPE || fc == UF_DELTYPE) {
			/* Save/Delete xfer parms */
			save_type(data_set, operands, fc) ;
			fc = SF_NXTFLD ;	/* stay in window */
		}
		else if ( fc == UF_ERSINP ) {
			/* 'reset' all xfer param flds */
			xfer_clr() ;
			x = 0 ;
			sfwinio(&xfpwin, &x, SF_DISPLAY) ;		/* show flds */
			fc = SF_NXTFLD ;
		}
		else {
			i = 0 ;			/* start at 1st fld if looping */
			if ( fc == SF_PRVFLD )
				i = sf_hifld ;		/* goto last fld */
		}
	}	while ( fc == SF_NXTFLD || fc == SF_PRVFLD ) ;
	/* stay in window until fn key */

	/* Clear xfer parms window */
	/* sfopen(&xfpwin) ;			Warren does it */

	/* Derive record fmt from 2 recfmt flds */
	if ( recfmt1 == 0 ) {
		/* Fixed */
		if ( recfmt2 )
			x_rec_fmt = 0 ;		/* Fixed, Unblked */
		else
			x_rec_fmt = 1 ;		/* Fixed, Blocked */
	}
	else {
		/* Variable */
		if ( recfmt2 )
			x_rec_fmt = 2 ;		/* Variable, Unblked */
		else
			x_rec_fmt = 3 ;		/* Variable, Blocked */
	}

	/* Change Edit/Save fn key back to Edit */
	setfnk(5) ; 
	setfnk(7) ;

	return(fc) ;
}

/*********************
**	Show Fn keys	**
*********************/


setfnk ( n )

int		n ;

/* Set fn key label for fn key # n */

{
	int		i ;


	strcpy(fkdata[n], fnklabel[n]) ;
	sffldio(&fnkeywin, fk2fld(n), SF_DISPLAY) ;
	fnkflag[n] = 1 ;				/* flag as 'enabled' */
}



rstfnk ( n )

int		n ;

/* Set fn key label to blanks for fn key # n */

{


	*fkdata[n] = '\0' ;
	sffldio(&fnkeywin, fk2fld(n), SF_DISPLAY) ;
	fnkflag[n] = 0 ;				/* flag as 'disabled' */
}



initfnk ()

/* Show initial fn key labels */

{
	register int	i ;

	/* flag all fn keys as 'disabled' */
	for ( i = 1 ; i <= 10 ; )
		fnkflag[i++] = 0 ;

	rstfnk(1) ; rstfnk(3) ; rstfnk(5) ;
	setfnk(2) ; setfnk(4) ; setfnk(6) ; setfnk(7) ; 
	setfnk(8) ; setfnk(9) ; setfnk(10) ;
}



nsrefnk ()

/* Clear SEND, RECV, & EDIT fn keys */

{

	rstfnk(1) ; rstfnk(3) ; rstfnk(5) ;
}



enblsr ()

/* Enable (set) SEND & RECV fn keys */

{

	setfnk(1) ; setfnk(3) ;
}



dsblsr ()

/* Disable (reset) SEND & RECV fn keys */

{

	rstfnk(1) ; rstfnk(3) ;
}

/*****************
**	Messages	**
*****************/


menu_err ( msg )

char	*msg ;

/* Display error message during menu i/o.
   NOTE - cursor position not restored.
*/

{


	sfbeep() ;
	sf_msg(msg, 1) ;		/* show msg & wait for Clr Err */
}



menu_msg ( msg )

char	*msg ;

/* Show a message on the error line.
   Control is returned immediatly.
*/

{


	sf_msg(msg, 0) ;
}



not_imped ( msg )

char	*msg ;

/* `Stub` to trap un-implemented functionality.
   Message is optional.
*/

{
	char	line[80] ;


	if ( strlen(msg) ) {
		strcpy(line, "Not implemented - ") ;
		strcat(line, msg) ;
	}
	else
		strcpy(line, "Feature not implemented at this time.") ;
	menu_err(line) ;
}



badfnk ()

/* User hit inactive fn key */

{

	menu_err("Function key not active at this time.") ;
}

/*********************
*	Initialize Menu	**
*********************/


menu_init ( hdr1, hdr2 )

char	*hdr1, *hdr2 ;			/* Header lines */

/* 'Initialize' the menu screen.
   This should be called only once.
   (**>> sfinit() must already have been invoked)
*/

{
	int		i ;
	struct SF_FIELD (*fldlst)[] ;
	extern	int		tp_vmode ;
	extern	struct SF_SFDATA	fkdfd ;


	/* Set ptr to dedicated fn key translation table */
	sf_fntable = (int (*)[][2]) opusfntbl ;

	/* Set ptrs to headers */
	fldlst = mainwin.sf_fldlist ;
	(*fldlst)[0].sf_bindata = (struct SF_BINDATA *) hdr1 ;
	(*fldlst)[1].sf_bindata = (struct SF_BINDATA *) hdr2 ;

	/* <<<PATCH
		   If we're using a color monitor, charnge attr's of
		   fn key labels to 'underline' */
	if ( tp_vmode != 7 )
		fkdfd.sf_sdatr = SF_ATUNDL ;

	/* Clear screen & show 'frame' */
	sfopen(&mainwin) ;

	/* Show initial screen */
	i = 0 ;
	sfwinio(&mainwin, &i, SF_LABELS) ;
	i = 0 ;
	sfwinio(&fnamwin, &i, SF_LABELS) ;
	i = 0 ;
	sfwinio(&dnamwin, &i, SF_LABELS) ;
	i = 0 ;
	sfwinio(&xftwin, &i, SF_LABELS) ;

	/* Show initial fn keys */
	initfnk() ;

	/* Initialize data */
	ttypok = FALSE ;
	*xftbuf = '\0' ;
}



menu_rst ( data_set, pc_file )

char	*data_set, *pc_file ;

/* 'Reset' menu fields.
   This call clears all flds in the main window, disables the xfer and
   Edit fn keys, and clears the xfer param window.
*/

{

	*data_set = *pc_file = '\0' ;	/* clear filenames */
	*xftbuf = '\0' ;				/* clear xfer type data */
	/* showmain() ;					/* >> this is done elsewhere */
	nsrefnk() ;						/* reset xfer & edit fn keys */
	sfopen(&xfpwin) ;				/* clear xfer params window */
	ttypok = FALSE ;				/* flag- no xfer type defined */
}

/************
*	Misc	*
************/


showmain ()

/* Show current filenames & xfer type */

{
	int		i ;


	i = 0 ; sfwinio(&fnamwin, &i, SF_DISPLAY) ;
	i = 0 ; sfwinio(&dnamwin, &i, SF_DISPLAY) ;
	i = 0 ; sfwinio(&xftwin, &i, SF_DISPLAY) ;
}



showfnk ()

/* Show fn key labels */

{
	int		i ;


	i = 0 ;
	sfwinio(&fnkeywin, &i, SF_DISPLAY) ;
}



mxfrchk ( data_set, pc_file )

char	*data_set, *pc_file ;

/* Local version of xfer_chk.
   This version chks local data to see if xfer is possible at this time.
   Send & Recv fn keys are enabled/disabled.

  Return -	OK  if xfer is possible (as far as local code knows)
			ERR if xfer is not possible.

  Notes -
   > The 'ttypok' var is used to determine whether or not the xfer type is
   legal. It is set/reset by makexft().
*/

{
	register int	flag ;

	if (	(ttypok == TRUE)		/* xfer type is legal */
			&& (*data_set != '\0')	/* data set name exists */
			&& (*pc_file != '\0')	/* pc filename exists */
	) {
		enblsr() ;					/* enable Send & Recv (Xfer) fn keys */
		flag = OK ;
	}
	else {
		dsblsr() ;					/* disable Send & Recv (Xfer) fn keys */
		flag = ERR ;
	}

	return(flag) ;
}



chkabend ( retcode )

int		retcode ;

/* 'retcode' is an sform completion code.
   Chk the code for certain 'abnormal unpend' fn keys, and return <>0
   if it is one of these values, else return 0.
   Note that, if <>0 is returned, any value input before the fn key
   should be discarded.
   Note - this fn is called only by sub-fn's of menu(), not the main
   line menu() code. A return value of <>0 tells the sub-fn to return
   immediately to the main line menu() code.
*/

{


	switch ( retcode ) {
		case  UF_EXIT :
		case  UF_ERSINP :
			return(-1) ;
		default :
			return(0) ;
	}
}
