/*************************************************************************
*
*
*	Name:  sfinit.c
*
*	Description:  Functions to 'open' and 'close' windows.
*					sfinit()	- Initialize for sform i/o.
*					sfopen()	- 'Open' a window (paint the window).
*					sfexit()	- Exit from sform (resets i/o).
*
*
*	History:
*	Date		By		Comments
*
*	03/16/84	waf
*	05/04/84	waf		Allow multiple windows open simultaneously.
*	05/11/84	waf		sfinit() - Set sf_inatros.
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  NOTE that the sfexit() call is the only call that the USER MUST
	INVOKE. All of the others in this module will be invoked automatically
	by the sform code.
	  Note that, in some environments, if sfexit() is not called,
	the display and/or input characteristics may be fubar'ed.

	Altos notes -
	  Note that, in between the sfinit() and the sfexit() calls, THE USER
	SHOULD NOT ATTEMPT ANY I/O TO THE TERMINAL.
	  At this time, ikeys are disabled and the quit key causes an exit().
	An ikey will cause a message to be displayed, and sform processing is
	continued.

	Note that '0' is not a legal window addr.
*/

#include	"/sform/src/sfint.h"
#include	"/sform/src/stip.h"


#if		SF_ALTOS
#include	<signal.h>
int		(*oldint)() ;	/* save old ikey vector */
int		sfonikey() ;	/* sform ikey vector */
int		(*oldquit)() ;	/* save old quit vector */
int		onquit() ;		/* sform quit vector */
#endif


int		sfinitflg = 0 ;		/* If set, init code has been run	*/

sfinit ()

/*
  Synopsis -
	Initialize for sform i/o.

  Description -
	The terminal characteristics are commandeered.
	Ikeys are trapped.
	The default input attribute offset value is set.
	The default fn key mapping table ptr is set.

  Return -
	return val	= 	SF_OK		if no errors.
					SF_ERROR	if errors.

  Notes -
*/

{
	extern	int	sf_stdftbl[][2] ;	/* fn key mapping table */
	extern	sfnotimp() ;
	extern	(*sf_usrhelp)() ;


	/* Init term handler / characteristics */
	stinit() ;

	/* disable roll */
	sfprat(-18, 3) ;

	/* Trap ikeys & quits */
#if SF_ALTOS
	oldint = signal(SIGINT, sfonikey) ;
	oldquit = signal(SIGQUIT, onquit) ;
#endif
#if	SF_PC
	/* PC code traps ikeys in egetc() */
#endif

	/* Set default input attribute offset value.
		   This value is used to highlight input fields. */
	sf_inatros = SF_INATROS ;

	/* Set default fn key mapping table addr */
	sf_fntable = (int (*)[][2]) sf_stdftbl ;

	/* Set default user help fn ptr */
	sf_usrhelp = sfnotimp ;


	/* Flag that this code was run */
	sfinitflg = -1 ;

	return(SF_OK) ;
}

sfopen ( window )

struct SF_WINDOW *window ;

/*
  Synopsis -
	'Open' a window.
	The window area is 'painted'.
	If this is the first window to be opened, sfinit() is invoked.

  Description -
	If this is the first window to be opened, this fn does any intialization
	necessary when entering the SForm routines. Terminal characteristics are
	'commandeered' after this call & until sfclose() is invoked. Much of this
	will be system dependent.
	The window area is 'painted' by showing spaces with the window display
	attribute set.

  Return -
	return val -	SF_OK		= no errors.
					SF_ERROR	= error condition. User MUST abort.

  Notes -
  *> Note that '0' is not a legal window addr.

  To Do -
  > Should there be some way to chk if the window address parameter is really
  the address of a window ?
*/

{
	register int	wflg ;


	/* Chk for legal addr */
	if ( window == SF_NULL )
		sfpanic("sfopen: Illegal window addr") ;
	/**>> More checking ??? */

	/* Chk for first window.
		   If so, run initialization code. */
	if ( sfinitflg == 0 ) {
		sfinit() ;
	}

	/* Paint the window */
	winpaint(window, window->sf_wdatr) ;

	return(SF_OK) ;
}

#if		0		/* Not currently used */
sfclose ( window )

struct SF_WINDOW *window ;

/*
  Synopsis -
	'Close' a window.

  Description -
	$

  Return -
	return val	= -1 if error.
				   0 if no error.

  Notes -
  *> Display attributes are currently set to 'normal' upon exit. The
  attributes were not saved upon entry (sfopen()), so 'normal' is assumed.
  > Note that the window is not erased upon exit. If the user desires to
  erase the window, do another sfopen() on the window.
*/

{


	/* Chk for legal window addr */
	if ( window == SF_NULL )
		sfpanic("sfclose: Illegal window address.") ;

	/* Chk sf_curwin */
	if ( sf_curwin != window ) {
		sferrmsg("No open window.") ;
		return(-1) ;
	}

	sfexit() ;

	return(SF_OK) ;
}
#endif

sfexit ()

/*
  Synopsis -
	Exit the sform routines.
	Terminal control is returned to the user.

  Description -
	$

  Return -
	return val	= <undefined>

  Notes -
*/

{


	/* Position the cursor to the error row */
	sfposcur(-1, 0) ;


	/** Reset terminal characteristics **/
	stterm() ;

	/* enable roll */
	sfprat(-18, -3) ;

	/* set display attr's to 'normal' */
	sfsetdatr(SF_ATNORM) ;


	/** Re-enable ikeys **/
#if SF_ALTOS
	signal(SIGINT, oldint) ;
	signal(SIGQUIT, oldquit) ;
#endif


	/* Reset flags */
	sf_curwin = SF_NULL ;	/* flag 'No open window' */
	sfinitflg = 0 ;			/* flag 'Init code not run' */

	return ;
}

static	winpaint ( window, datr )

struct SF_WINDOW *window ;
unsigned	datr ;

/*
  Synopsis -
	Paint the window, using the datr param for display attributes.

  Description -
	The display attributes are set using the 'datr' param, then the
	window is filled with blanks to delimit the window.
	Next, the label fields within the window are displayed.
	This fn checks to see if the 'Clear screen' or 'Clear to End Of Line'
	control codes can be used instead of outputting spaces.

  Return -
	return val	= <undefined>

  Notes -
*/

{
	register int	r, c ;
	int		sr, sc ;
	int		er, ec ;


	sfsetdatr(datr) ;	/* set window attr's */

	/* Get starting & ending row & col */
	sr = window->sf_urow ;	/* starting row */
	er = window->sf_lrow ;	/* ending row */
	sc = window->sf_lcol ;	/* starting col */
	ec = window->sf_rcol ;	/* ending col */
	if ( sr < 0 || er > SF_MAXROW || sc < 0 || ec > SF_MAXCOL )
		sfpanic("sfopen: Illegal window size.") ;

	/* Chk 'clear screen'.
		   If the display attribute is 'normal' and the window is defined
		   to be the whole screen, use the 'clear screen' fn. */
	if ( datr == SF_ATNORM				/* if 'normal' display */
	&& sc == 0 && ec == SF_MAXCOL
	    && sr == 0 && er == SF_MAXROW ) {	/*   and window = whole screen */
		sfcls() ;	/* clear screen */
		return ;
	}

	/* Clear window */
	r = sr ;	/* starting row */
	while ( r <= er ) {	/* for every row in the window.. */
		c = sc ;			/* starting col */
		sfposcur(r, c) ;	/* get to start of next line */
		if ( ec == SF_MAXCOL && datr == SF_ATNORM )
			sfceoln() ;				/* clear to end of line */
		else
			sfshwsp(ec - c + 1);	/* show spaces to end of line */
		r++ ;
	}
}

/*****************************
**		Ikey handlers		**
*****************************/



sfonikey ()

/*
	Trap ikeys.
	At this time, ikeys during sform i/o (e.g. inbetween sfopen() and sfclose())
	cause a message to be displayed only.
	(Note that control is returned to the interrupted sform code).
*/

{

#if	1
	sfbeep() ;
#else
	sferwmsg("Ikeys ignored during sform i/o. (Try ABORT)") ;
#endif

#if	SF_ALTOS
	signal(SIGINT, sfonikey) ;		/* reset ikey trap */
#endif
}



#if	SF_ALTOS
static	onquit ()

/*
	Trap quit key.
	At this time, a 'quit' causes an exit(). (No dump is taken).
*/

{

	exit(-1) ;
}

#endif
