/*************************************************************************
*
*
*	Name:  strdisp.c
*
*	Description:  Display a string or generic field.
*					sfstrdisp	- display string field.
*					sfflddisp	- display generic field.
*					sfoutfmt	- build a sfprintf() fmt.
*
*
*	History:
*	Date		By		Comments
*
*	3/16/84		waf
*
*
*
*  This document contains confidential/proprietary information.
*
*  Copyright (c) 1983, 1984 by Digital Communication Assoc..
*
*************************************************************************
*  SForm routines module.  */




/*  Notes -

	  This code uses the dedicated sfprintf() fn. The task of displaying
	a 'field' is split between the sfflddisp() and the sfprintf() functions.

*/

#include	"/sform/src/sfint.h"



sfstrdisp ( fld_desc, data_ptr )

struct SF_FIELD *fld_desc ;
char	*data_ptr ;

/*
  Synopsis -
	Display string field.

  Description -
	The data string is converted to 'c' format, then the sfflddisp() fn is
	invoked to display the data.

  Return -
	return val	= SF_OK

  Notes -
  *> All string data is assumed to be LEFT JUSTIFIED. In particular, nulls
  must not preceed the string data, as 'c' string transfer functions are used.
  > The string pointed to by data_ptr is assumed to be null terminated, and
  the size must be 1 greater than the field width.
  > Display attributes have already been set.
  > Using more that one justification flag will cause strangeness.
*/

{
	register int bptr ;
	register int fwid ;
	unsigned flags ;
	int		rv ;


	/* Get flags & fld wid */
	flags = fld_desc->sf_iodata->sf_flags ;
	fwid = fld_desc->sf_width ;

	/* Convert string data to 'c' format.
			If data is null filled, it is already 'c' format.
			If data is blank filled, find the last non-blank char,
			  and set the next char to null.
			'bptr' marks the position of the inserted null
			  (-1 if none inserted) */
	if ( flags & SF_BFILL ) {	/* if blank filled */
		for ( bptr=fwid-1 ; bptr >= 0 && *(data_ptr + bptr) == ' ' ; bptr-- )
			;		/* find last non-blank */
		/* bptr = char pos of last non-blank char.
				   Set the next char to null to flag end of string. */
		bptr++ ;		/* offset of first blank */
		if ( bptr == fwid )		/* if field is full */
			bptr = -1 ;		/* no null inserted */
		else
			*(data_ptr + bptr) = '\0' ;		/* null terminate str data */
	}
	else
		/* null filled data */
		bptr = -1 ;		/* flag that null was not inserted */

	/* Display the fld */
	rv = sfflddisp(fld_desc, data_ptr, 's') ;

	/* Restore the data to internal format.
			If a null was inserted in the str data,
			replace it with a ' '. */
	if ( bptr != -1 )	/* if null was inserted */
		*(data_ptr + bptr) = ' ' ;

	return(rv) ;
}

sfflddisp ( fld_desc, data_ptr, dtype )

struct SF_FIELD *fld_desc ;
char	*data_ptr ;
char	dtype ;		/* type of data (conversion char) */

/*
  Synopsis -
	Display a 'generic' field.

  Description -
	The 'dtype' char and the bit flags are used to build a fmt string,
  then sfprintf() is invoked to display the data.
	Note that the display of all fields goes through this function.

  Return -
	return val	= SF_OK

  Notes -
  **> At this time, all display functionality is handled by sfprintf().
  This is preferable, unless a display feature is desired which could not
  (or should not) be handled by sfprintf(). In that case, some or all of the
  display functionality would be moved into this function.
  > Note that this function is called to display every type of field, and
  data_ptr can be pointing to any type of data. The 'dtype' param is tells
  us what type of data it is.
*/

{
	register char	*fptr ;
	char	*sfoutfmt() ;



	/* Position cursor */
	sfposcur(fld_desc->sf_row, fld_desc->sf_col) ;

	/* Get fmt */
	fptr = sfoutfmt(fld_desc, dtype) ;

	/* Show it */
	sfprintf((char *)0, fptr, data_ptr) ;

	return(SF_OK) ;
}


static	char	fmt[16] ;	/* build format here */



char	*sfoutfmt ( fld_desc, dtype )

struct SF_FIELD *fld_desc ;

/* Create a format descriptor based upon information in the fld desc.
   The output data is of type 'dtype'.
   The bit flags are used to build the fmt desc.

   Returns ptr to format string.
*/

{
	register int	fix ;		/* index into format */
	register unsigned flags ;	/* bit flags */


	fmt[0] = '%' ;
	fix = 1 ;

	/* Get flags */
	flags = fld_desc->sf_iodata->sf_flags ;

	/* Chk left or center justify */
	if ( flags & SF_LJUST )
		fmt[fix++] = '-' ;		/* left justify */
	else if ( flags & SF_CJUST )
		fmt[fix++] = '+' ;		/* center justify */

	/* Chk zero fill */
	if ( flags & SF_ZFILL )
		fmt[fix++] = '0' ;

	/* Set fld wid */
	sfprintf((fmt + fix), "%d", fld_desc->sf_width) ;
	strcat(fmt, ".") ;
	sfprintf((fmt + strlen(fmt)), "%d", fld_desc->sf_width) ;

	/* Set conv char */
	sfprintf((fmt + strlen(fmt)), "%c", dtype) ;

	return(fmt) ;
}
