/*
	write  files given to /dev/tar using common character compression

10/27/83	waf		Show # blocks.
02/07/84	waf		Don't abort if file not found. Show msg & continue.
*/

#define	SUBR	0	/* if set, this is called by tactar */

#include <stdio.h>

#define BUFSIZE 10240
#define TARSIZE 1147900		/* # bytes on floppy disk */

char	buf1[BUFSIZE],buf2[BUFSIZE*3];
long	fdlth;
unsigned fdblks;


#if	(SUBR == 0)
main(argc,argv)
int	argc;
char	*argv[];
#else
tbk()
#endif

{
	char	*cp,file[500];
	register int	i;
	register FILE	*fdo,*fpi;
	FILE	*chktar();
	unsigned n,x;
	long	nbytes;		/* # bytes used by file */
	unsigned nbufs;		/* # buffers used by file */
	unsigned tblks;		/* # blks used on floppy */
	int		fnfnd ;		/* set if one or more files not found */


#if	( SUBR == 0 )
	cp = argv[0];
	if (argc != 1) {
		fprintf(stderr,"%s: Usage - %s <filelist\n",cp,cp);
		exit(-1);
		}
#endif


	fnfnd = 0 ;		/* reset 'file not found' flag */
	fdlth = TARSIZE ;				/* # bytes on a floppy */
	fdblks = (int)(fdlth >> 9) ;	/* # blks on a floppy */
	/* printf(">> fdlth,fdblks = %D %d\n", fdlth,fdblks); */
	tblks = 0 ;

	if ((fdo = fopen("/dev/tar","w")) == NULL) {
		fprintf(stderr,"%s: Can't open /dev/tar\n",cp);
		exit (-1);
		}


	/** process next file **/
	while (gets(file) != NULL) {
		if ((fpi = fopen(file,"r")) == NULL) {
			fprintf(stderr,"\007%s: Can't open %s\n",cp,file);
			fnfnd = 1 ;
			continue ;
			}
		nbytes = 0L ;
		x = strlen(file);
		fdo = chktar(fdo,x+sizeof(unsigned)+1);
		fwrite("N",1,1,fdo);			/* Name record */
		fwrite(&x,sizeof(unsigned),1,fdo);	/* length of name */
		fwrite(file,1,x,fdo);			/* write out name */

		/* write to floppy */
		printf( "a  %s  - ", file );
		nbufs = 0 ;
		while ((x = fread(buf1,1,BUFSIZE,fpi)) != 0) {
			n = cmprs(buf1,x,buf2);		/* compress it */
			nbytes += (long) n ;
			/* check for room */
			fdo = chktar(fdo,n+sizeof(unsigned)+1);
			fwrite("D",1,1,fdo);		/* write out data rec */
			fwrite(&n,sizeof(unsigned),1,fdo);
			fwrite(buf2,1,n,fdo);
			nbufs++ ;		/* inc blk cntr */
			}
		fdo = chktar(fdo,1);
		fwrite("F",1,1,fdo);
		fclose(fpi);

		x = (int)(nbytes >> 9) + 1 ;	/* # blks dumped */
		tblks += x ;
		/* printf( "%d blks.\n", x ); */
		printf(" %D / %d\n", nbytes, x) ;
		}

	printf( "%d blks used\n", tblks );
	printf( "%d blks left\n", (fdblks - tblks)) ;
	if ( fnfnd )
		puts("** Input file(s) not found.") ;

	fdo = chktar(fdo,1);
	fwrite("E",1,1,fdo);
	fclose(fdo);
	exit(0);
	}

FILE *chktar(fd,length)
FILE	*fd;
unsigned length;
{
	char	buf[10];
	int	fdt;

	fdlth -= length;

	if (fdlth <= 1) {
		fwrite("Z",1,1,fd);
		fdlth = TARSIZE;
		fclose(fd);
		fdt = open("/dev/tty",0);
		fprintf(stderr,"Mount next disk - press newline to continue");
		read(fdt,buf,1);
		close(fdt);
		return(fopen("/dev/tar","w"));
		}
	return(fd);
	}
