  .page
  .sbttl	'floppy disk reads and writes'
  .prntx	'made it to flop rd/wr'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	8 and 5 Inch Floppy Disk Drivers	+
; +						+
; +	last modified>	05 Dec 83 dsb		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

  .ife	OptFlopAny,[
     .ife	Flop5opt,[OPTM0 = OPTM0+(1<Flop5DMS)]
     .ife	Flop8opt,[OPTM0 = OPTM0+(1<Flop8)]

     .ife	 Flop8opt,[
;
;----------
; Single Density read
SDrd:
	lxi	D,7Dh<8+readDMA ; set up params
	mvi	B,rdSDFLOP
	jmpr	SDfloppy

;---------
; Single Density write
SDwr:
	lxi	D,79h<8+writeDMA ; set up params
	mvi	B,wrSDFLOP
;----------
; Single Density Floppy (Read and Write common)
SDfloppy:
	lhld	cpmDMA	; set DMA address
	shld	DMAFadr
	lhld	cpmBYT	; set DMA size
	dcx	H	; DMA wants size - 1
	shld	DMAFsize
	xra	a	; set FLOPPY density
	sta	FLOPden
	lhld	cpmDESC ; iobDESC <- cpmDESC (3)
	shld	iobDESC
	lda	cpmSEC
	sta	iobPSEC ; physical sector is cpmSEC
	jmp	Floppy
	]		; end ' Flop8opt '
;----------
; Double Density read
;
    .ife	Flop8opt,[
DDrd:
	lda	cpmTRK	; track 0 DD is SD
	ora	A
	jrz	SDrd
	]		; end ' Flop8opt '

M2rd:			; Entry point for 2-sided mini
rd5or8:
	lda	cpmBYT	; 256+ byte read operation
	ora	A	; (low byte = 0)
	jz	DDrdspec
;
	lded	cpmDESC ; is sector in wrbuffer
	lhld	wrbDESC
	ora	A
	dsbc	D
	jrnz	..1
;
	lda	cpmSEC
	mov	B,A
	lda	wrbSEC
	sub	B
	jrnz	..1	; if not then read from disc
;
	lded	cpmDMA	; else just get it from wrbuf
	lxi	H,wrbuffer
	lxi	B,128
	ldir
	ret
;
..1:	call	convIC	; set up iobDESC
	call	DDrdflop ; read the disc
	push	PSW	; save I/O status
	lda	iobSEC	; move 128 byte block from
	rrc		; get rightmost bit
	lxi	H,rdbuffer ; set rdbuffer high or low
	jrc	..2	; depending on leftmost bit
;
	lxi	H,rdbuffer+128
..2:	lded	cpmDMA	; move rdbuffer to curDMA
	lxi	B,128	
	ldir
	pop	PSW	; restore I/O status
	ret

;----------
; Double Density write
DDwr:
    .ife	Flop8opt,[
	lda	cpmTRK	; track 0 DD is SD
	ora	A
	jrz	SDwr
	]
M2wr:			; Entry for double-sided mini
wr5or8:
	lda	cpmBYT	; check for 256+ byte operation
	ora	A
	jz	DDwrspec
;
	lda	cpmSEC	; check for high-low sector
	rrc
	jrnc	DDwrhigh

DDwrlow:
	call	clrDDbf ; flush wrbuffer
	call	convIC	; wrbDESC <- cpmDESC
	lhld	iobDESC ; through iobDESC
	shld	wrbDESC
	lhld	iobDESC+2
	shld	wrbDESC+2
	lhld	cpmDMA	; write 128 bytes to low wrb
	lxi	D,wrbuffer
	lxi	B,128
	ldir
	sub	A	; return A = 0
	ret

DDwrhigh:
	call	convIC	; iob is now cpm
	lxi	H,wrbDESC ; is low already in buffer
	call	cmpIOB
	jrz	..1
;
	call	clrDDbf ; if not flush wrbuffer
	call	convIC	; read low wrbuffer from disc
	call	DDrdflop ; for read-modify-write
	lxi	H,rdbuffer ; modify low 128 bytes
	lxi	D,wrbuffer
	lxi	B,128
	ldir

..1:	lhld	cpmDMA	; move in upper 128 bytes
	lxi	D,wrbuffer+128
	lxi	B,128
	ldir
	jmp	DDwrflop ; write out the buffer
;
;----------
; Flush (clear) the Double Density wrbuffer
clrDDbf:
	lda	wrbPSEC ; is buffer full
	ora	A
	rz		; return if empty
;
	lxi	H,wrbDESC ; otherwise read-modify-write
	lxi	D,iobDESC ; first set iobDESC
	ldi
	ldi
	ldi
	call	DDrdflop ; read
	lxi	H,rdbuffer+128 ; modify
	lxi	D,wrbuffer+128
	lxi	B,128
	ldir
	jmpr	DDwrflop ; write
;
;----------
; Compare 3 bytes, (HL) and iobDESC
cmpIOB:
	lda	iobDSK	; test DISK byte
	cmp	M
	rnz
;
	lda	iobTRK	; test TRACK byte
	inx	H
	cmp	M
	rnz
;
	lda	iobPSEC ; compare physical sector
	inx	H
	cmp	M
	ret

;----------
; Move cpmDESC to iobDESC and convert PSEC for DD
convIC:
	lhld	cpmDESC ; two bytes at a time
	shld	iobDESC
	lda	cpmSEC	; store sector
	sta	iobSEC
	adi	1	; and calculate PSEC
	srlr	A
	sta	iobPSEC ; and store it
	ret

;----------
; Double Density special 256+ byte read
DDrdspec:
	lxi	D,7Dh<8+readDMA ; load r/w params
	mvi	B,rdDDFLOP
	jmpr	DDspec

;----------
; Double Density special 256+ byte write
DDwrspec:
	lxi	D,79h<8+writeDMA ; load r/w params
	mvi	B,wrDDFLOP
;
; Double Density special 256+ byte read/write
DDspec:
	lhld	cpmBYT	; set DMA size
	dcx	H	; DMA wants size - 1
	shld	DMAFsize
	lhld	cpmDMA	; set DMA address
	shld	DMAFadr
	call	convIC	; set up iobDESC
	jmpr	DDsflop ; jump to middle of DDfloppy

;----------
; Special read double density for buffer
DDrdflop:
	lxi	H,rdbDESC ; is buffer in memory
	call	cmpIOB
	jrnz	..1
;
	xra	a	  ; if so, return 0
	ret

..1:	lxi	H,iobDESC ; otherwise load rdbDESC
	lxi	D,rdbDESC ; with iob to reflect new
	ldi		  ; rdbuffer
	ldi
	ldi
	lxi	D,7Dh<8+readDMA ; set up params
	mvi	B,rdDDFLOP ; for double density read
	lxi	H,rdbuffer ; set DMA address
	shld	DMAFadr
	jmpr	DDfloppy

DDwrflop:
	lxi	H,rdbDESC ; is rdbuffer the same as
	call	cmpIOB	  ; wrbuffer
	jrnz	..1
;
	lxi	H,wrbuffer ; if so update rdbuffer
	lxi	D,rdbuffer
	lxi	B,256
	ldir

..1:	lxi	H,0
	shld	wrbPSEC    ; set wrbuffer empty
	lxi	D,79h<8+writeDMA ; load params for
	mvi	B,wrDDFLOP ; double density write
	lxi	H,wrbuffer ; set DMA address at wrbuf
	shld	DMAFadr

;----------
; Double Density Floppy (Read and Write common)
DDfloppy:
	lxi	H,255	; set DMA size 
	shld	DMAFsize
DDsflop:mvi	A,1	; set FLOPPY density
	sta	FLOPden
;----------
; Floppy read/write -  single/double density
;
; Setup the DMA chip
Floppy:
	mov	A,E
	sta	DMAFc2	; read/write command
	mov	A,D
	sta	DMAFc1	; read/write command also
;
; Setup the floppy read/write command
	mov	A,B
	sta	FLOPcom ; read/write command
	lda	iobPSEC ; set sector number
	sta	FLOPsec

; Normally, retry 10 times before printing error msg
	lxi	H,RTRYflop
	mvi	M,RETRY 	; 10 retries 

; If using FDTEST, don't retry errors
; - implies booting from floppy

  .ife	BootFlopAny,[

	lda	Mode
	bit	ModeTRY,A
	jrnz	tryf
;
	mvi	M,1	; 0 retries
	]		; end ' BootFlopAny '

tryf:
  .ife	Flop8opt!Flop5opt,[
	call	iobMAP
	dcx	H
	mov	A,M	; media type in Acc
	cpi	SD
	jrz	..trf8
;
	cpi	DD
	jrz	..trf8
;
	cpi	MINI1
	jrz	..trf5
;
	cpi	MINI2
	jrz	..trf5
	]		; end ' both floppys '
;
  .ife	Flop8opt,[
..trf8:
	call	IOBmap	; get current disk map
	sta	FLOPdsk ; drive number
	rrc
	rrc
	ani	1
	sta	FLOPsid ; side number
	lda	iobTRK	; track number
	sta	FLOPtrk
	]		; end ' Flop8opt '
;
  .ife	Flop5opt,[
..trf5:
	mvi	B,0	; init for later
	lda	IOBtrk	; get track #
	mov	C,A	; track # in C
	cpi	80
	jrc	..side0 ; side 0 if track < 80
;
	inr	B	; make it side 1
	mvi	A,159
	sub	C	; compute phys trk #
	mov	C,A	; put it in C
..side0:
	sbcd	FLOPtrk ; store this mess at FLOPtrk
	call	IOBmap
	ani	3	; drive # in A
	mov	C,A	; store in C
	mov	A,B
	add	A
	add	A	; A <- B * 4
	ora	C	; drive is 0-3 or 4-7
	sta	FLOPdsk ; store it
	]		; end ' Flop5opt '
;
; Seek for I/O track
begRTRY:
	lxi	H,seekFLOP+2
	lda	FLOPtrk ; Get track for next operation
	mov	M,A	; move track into command
	dcx	H	; adr of seekDSK
	call	SEEK	; go to tracks 1-76

; Set up the DMA chip
	call	lockDMA ; reserve the DMA chip
	lxi	H,DMAFdone
	shld	DMAvect ; setup the DMA vector
	sub	A
	out	PIOAD	; multiplex floppy to DMA
	lxi	H,DMAFprog
	lxi	B,DMAF$<8+DMA
	outir		; program the DMA chip
;
; Execute the floppy command
	mvi	a,0ffh
	sta	FLOPbusy; floppy is busy
	lxi	H,FLOPcom
	call	COMMAND
	ei		; interrupts OK now
	call	RESULT
	lda	FLOPbusy; if flop is not busy
	ora	a	; then DMA int was ok
	jrz	..noERR
;
	di		; no interrupts allowed
	mvi	a,rstDMA; reset DMA so that errors
	out	DMA	; are handled correctly
	sub	A
	sta	lockbyte; unlock the DMA chip
	sta	FLOPbusy
	ei		; allow interrupts again
..noERR:
	call	idleMOTOR; don't need motor anymore
	lda	FLOPstat; get first result byte
	ani	0C0h	; mask out top 2 bits
	rz		; return to CP/M if no errors
;
; Check for recoverable errors
	lxi	H,RTRYflop	; floppy err retry cnt
	lxi	B,FLOPstat+3	; point to THS
	lda	FLOPstat+2
	bit	5,A		
	jrz	chkTRAC
;
	dcr	M
DATAerr:cz	IOERR	; data CRC error (st2,b5)
	jmpr	retryf

chkTRAC:bit	4,A	
	jrz	chkMADR
;
	dcr	M
TRACerr:cz	IOERR	; on wrong track (st2,b4)
	call	reHOME	; rehome disk and try again
	jmpr	retryf

chkMADR:bit	0,A
	jrz	chkID
;
	dcr	M
MADRerr:cz	IOERR	; missing or deleted data 
	jmpr	retryf	; address mark (st2,b0)

chkID:	lda	FLOPstat+1
	bit	5,A
	jrz	chkSECT
;
	dcr	M
IDerr:	cz	IOERR	; ID CRC error (st1,b5)
	jmpr	retryf

chkSECT:bit	2,A
	jrz	chkENDT
;
	dcr	M
SECTerr:cz	IOERR	; cannot find sector (st1,b2)
	jmpr	retryf

chkENDT:bit	7,A
	jrz	chkDENS
;
	dcr	M
ENDTerr:cz	IOERR	; read beyond end-of-track 
			; (st1,b7)
	jmpr	retryf

chkDENS:bit	0,A
	jrz	chkORUN
;
	dcr	M
DENSerr:cz	IOERR	; missing ID address mark 
			; (st1,b0)
	jmpr	retryf
;
chkORUN:bit	4,A
	jrz	chkPROT
;
	dcr	M
ORUNerr:cnz	IOERR	; overrun -DMA failure (st1,b4)
	jmpr	retryf

chkPROT:bit	1,A
	jrz	WHATerr

PROTerr:cnz	IOERR	; write-protected (st1,b1)
	jmpr	retryf

WHATerr:call	IOERR	; unknown error

;-------
; entry>	none
; exit> 	none
; retry floppy func if any error encountered
retryf:
	lxi	H,errFLOP
	inr	M		; incr flop err cnt
	jmp	begRTRY 	; re-execute failed cmd
;
;----------
; Handle the transfer-done interrupt from the DMA chip
FLOPbusy:
	.byte	0	; 0FFh if busy, 0 if not busy

DMAFdone:
	push	PSW
	in	STOPFLOP; reset the floppy chip
	mvi	a,rstDMA
	out	DMA	; reset the DMA chip
	sub	A
	sta	lockbyte; unlock the DMA chip
	sta	FLOPbusy; floppy not busy anymore
	pop	PSW
	ei
	ret

;----------
; Send a command to the floppy controller
;  Regs in:   HL = address of command string
;  Regs out:  none
;  Destroyed: A, HL
COMMAND:
	mov	D,H
	mov	E,L	; Copy HL to DE

;    mark end of command:  done here because upon error
;    the FLOPstat buf is filled with status
	mvi	A,endcom
	sta	FLOPstat; mark end of floppy command
..1:
	mov	A,M
	cpi	endcom
	rz		; return if end-of-command
;
	call	WAITDR
	jrnc	..2	; Jump if no 'SYNC' error
;
	call	RESULT	; SYNC err - clear result reg.
	xchg		; Put cmd. start addr. in HL
	jmpr	COMMAND ; Restart cmd. sequence
..2:
	mov	A,M
	out	FLOPDR	; send a byte to controller
	inx	H	; point to next byte
	jmpr	..1

;----------
; Collect a result from the floppy controller
;  Regs in:   none
;  Regs out:  none
;  Destroyed: A, HL
RESULT:
	lxi	H,FLOPstat
..getStat:
	call	WAITDR	; wait for status byte
	rnc		; return if no status bytes
;
	in	FLOPDR	; get a result byte
	mov	M,A	; store it away
	inx	H
;
; NEC says FDC requires min 12 uSecs after DR r/w
; and before SR read -- bit test of mem waits 3 uSecs
	bit	0,m
	jmpr	..getStat

;----------
; Wait until floppy data register is ready
;  Regs in:   none
;  Regs out:  A = status register, shifted left by 1
WAITDR:
	in	FLOPSR
	rlc
	jrnc	WAITDR
;
	rlc
	ret
;
;----------
; onMOTOR - turn on a drive motor and pre-compensate
;  entry>	a = drive number
;  exit>	none
;  used>	a, bc
;
; PreComp is determined as follows:
;	qComp	=	bit 5  > H to use PreComp
;	S/L*	=	bit 4  > H to use Small PreComp
;	LCT	=	FDC    > H to use low current
;
;    Track	qComp	S/L*   LCT
;    -----	-------------------
;  000 - 021   |  L   |  H   |	L  |  no PreComp
;  022 - 041   |  H   |  H   |	L  |   62.5 nSec
;  042 - 058   |  H   |  H   |	H  |  125   nSec
;  059 - 079   |  H   |  L   |	H  |  250   nSec
;  080 - 100   |  H   |  L   |	H  |  250   nSec
;  101 - 117   |  H   |  H   |	H  |  125   nSec
;  118 - 137   |  H   |  H   |	L  |   62.5 nSec
;  138 - 159   |  L   |  H   |	L  |  no PreComp

curMOTOR:.byte	0FFh	; current drive

onMOTOR:
	push	PSW	; save new drive number
	mov	B,A
	res	5,b	; init to no preComp
	set	4,b	; default to small
;
	lda	iobTRK
	cpi	OnPreCmp; turn on preComp if track
	jrc	..LdHead; is greater than 21
;
	cpi	160-OnPreCmp
	jrnc	..LdHead; and less than 138
;
	set	5,B	; bit 5 = preComp
;
	cpi	maxprec ; reset S/L* bit if track
	jrc	..LdHead; is greater than 58
;
	cpi	160-MaxPrec
	jrnc	..LdHead; and less than 101
;
	res	4,b	; bit 4 = S/L*

..LdHead:
	set	2,B	; bit 2 = head load
	di		; disallow timer interrupt
	lda	timeMOTOR
	mov	C,A
	mov	A,B
	out	PIOBD
	sub	A	; force motor on until idle
	sta	timeMOTOR
	ei		; interrupts OK now
;
	pop	psw	; get new drive number
	mov	b,a
	lda	curMOTOR
	cmp	B	; compare old and new
	jrnz	..delay ; force delay if old <> new
;
	mov	A,C	; if old time is zero, then
	ora	A	; do head load/motor on delay
	rnz

..delay:
	mov	a,b
	sta	curMOTOR; save current drive number
	push	h
	push	d
	call	cpmMAP	; get drive type
	dcx	h
	mov	a,m
	pop	d
	pop	h
	cpi	MINI2
	lxi	b,wait4motor	; 180 mSec delay for 5"
	jz	delay		; motor to hit speed
;
	lxi	B,HeadSettle	; 36 mSec delay for
	jmp	DELAY		; 8" head load settle
;
;----------
; idleMOTOR - the motor can be turned off now
idleMOTOR:
	mvi	A,unloadHEAD ; wait 60 clock ticks,
	sta	timeMOTOR;  then turn off the motor
	ret

;----------
; offMOTOR - turn off all drive motors
;
; This routine is called from TIMERint.  It is called
;  when the floppy motor counter reaches zero.
offMOTOR:
	call	clrDDbuf; clear double density buffer
	xra	a
	out	PIOBD	; unload the head
	ret

;----------
; Floppy controller commands
endcom	==	0FFh	; command terminator
homeFLOP:
	.byte	7	; recalibrate command
	.byte	0	; curDSK
	.byte	endcom

seekFLOP:
	.byte	15	; seek command
	.byte	0	; curDSK
	.byte	0	; curTRK
	.byte	endcom

IsenseFLOP:
	.byte	8	; sense interrupt status
	.byte	endcom
;
;----------
; DMA command
DMAFprog:
	.byte	0C3h	; master reset		2D
	.byte	0C7h	; reset port A		2D
	.byte	0CBh	; reset port B		2D
DMAFc1: .byte	0	; filled by Floppy	1A
DMAFadr:.word	0	; filled by Floppy
DMAFsiz:.word	0	; filled by Floppy
	.byte	14h	; port A inc, memory	1B
	.byte	28h	; port B fixed, I/O	1B
	.byte	95h	; byte mode		2B
	.byte	FLOPP	; port B 
	.byte	12h	; interrupt at end of block
	.byte	DMAvect&0FFh ; interrupt vector
	.byte	9Ah	; stop at end of block 
	.byte	0CFh	; load starting address 2C
DMAFc2: .byte	0	; filled by Floppy	2D
	.byte	0CFh	; load starting address 1A
	.byte	0ABh	; enable interrupts	2D
	.byte	87h	; enable DMA		2D
DMAF$	==	.-DMAFprog
	]		; end ' either floppy '
address 1A
	.byte	0ABh	; enable interrupts	2D
	.byte	87h