	.page
	.sbttl	' Station header for SYSLIB, part 2 '

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	Station Header Block Generator		+
; +  (this part goes at the end of the source)	+
; +	last revised>	13apr84  kgh		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

; Throughout the source code there have been pseudo-ops
; to set bits in the option map.  We are now ready to
; create the header, which contains the option map,
; product map, and OS type.  This header will be read
; by SYSLIB and will become the first 23 bytes of the
; OS Table entry for this BIOS.
;
;
.ife Station,[
	.loc	CBOOT-128	; put it in front

PROD0	=	okzsbc3 < ZSBC3 +  okdsc4 < DSC4 
PROD0	=	PROD0 + ok1280 < DMS1280 + ok3C < DMS3C
PROD0	=	PROD0 + ok816 < DMS816
PROD1	=	okpc < (IBMPC-8)

	.byte	OStype

	.byte	PROD0,PROD1,0,0,0,0,0,0
	.byte	0,0,0,0,0,0,0,0
	.byte	OPTM0 
	.byte	OPTM8
	.byte	OPTM10
	.byte	OPTM18
	.byte	OPTM20
	.byte	OPTM28

; Now since we are writing 128-byte records but SAVE
; saves 256-byte records, it would be prudent to put
; the actual record count in here where SYSLIB can
; consult it.

	.word	(-CBOOT)/128

; Since we still have room left, we allow possible auto-
; matic recognition of this header by SYSLIB, by putting
; a string that identifies this as a BIOS header:

	.ascii	"THIS IS A HEADER" ; (unambiguous)

	.reloc
	]		; end " Station "

	.end