  .page
  .sbttl	'spooling routines (b83spool.asm)'
  .prntx	'made it to spooling routines'

  .ife	SPOOLopt,[
; +++++++++++++++++++++++++++++++++++++++++++++++++++++
; +						      +
; +	S P O O L I N G   R O U T I N E S	      +
; +						      +
; +	last modified>	14apr84	kgh		      +
; +						      +
; +++++++++++++++++++++++++++++++++++++++++++++++++++++

; The spool table contains up to 8 entries.
; Each entry is 16 bytes long.	Each entry contains
; the following information:

; SPLstat  ==	0	; status of spool job

;  	   <VALUES ARE>

SPLstart   ==	0	; start spooling
SPLspool   ==	1	; spooling
SPLready   ==	2	; ready to print
SPLprint   ==	3	; printing
SPLdone    ==	4	; stop print (ctrlZ found)
SPLwait    ==	5	; waiting to print
SPLabort   ==	0E5h	; abort job

; SPLusr   ==	1	; user number
; SPLid    ==	2	; spool id of current user
; SPLmins  ==	3	; min when job started
; SPLhrs   ==	4	; hour when job started
; SPLtrk   ==	5-6	; current spool track
; SPLsec   ==	7	; current spool sector
; SPLnam   ==	8-15	; user name

lenSPOOL   ==	16	; length of a spool table entry
lenSbuf    ==	128	; length of print spool buffer


;		Spool Data Storage
;		-------------------
srchid:	.byte	0	; spool id for jobmatch
SPL$id:	.byte	0	; spool id for processing
splend:	.byte	0	; end track for print
; The following info is filled in by cold boot code

SPLdsk: .byte	0	; spool partition number
SPLsiz: .byte	0	; spool partition size (1-16)
SPLvol: .byte	0	; spool HD drive (volume, 0-3)

; The following info is sent to user when spool started

SPL$resp:	.byte	0	; AckSpStart
SPL$dsk:	.byte	0	; spool disk
SPL$trk:	.word	0	; spool track
SPL$sec:	.byte	0	; spool sector
SPL$vol:	.byte	0	; spool volume
SPL$siz:	.byte	0	; spool size
; Print job info

PRTcont:	.word	0ffh	; print if printing
PRINTjob:	.word	0	; job being printed
PRINTtrk:	.word	0	; track being printed
PRINTsec:	.byte	0	; sector being printed

PRNTbuf:	.blkb	128	; print buffer
nxtSout:	.byte	lenSbuf	; ptr to next prnt char
SPLman: 	.byte	0	; normally 0, non-zero
				; if waiting for entry

; ok2prnt indicates whether X-ON or X-OFF were ret'd
; by a serial printer to stop and restart printing
ok2prnt:	.byte	0FFh	; Init to allow print


;		Spool Messages
;		--------------

SPLprep:
	.asciz	' Ready to print'

SPLask:

  .ifn	FoxOpt,[
	.asciz	'
A <CR> = Abort
W <CR> = Wait
S <CR> = Serial
P <CR> = Parallel
  <CR> = Next
Choice:  '
	]		; end ' not FoxOpt '

  .ife	FoxOpt,[
	.asciz	'
A <CR> = Abort
W <CR> = Wait
S <CR> = Serial
  <CR> = Next
Choice:  '
	]		; end ' FoxOpt '

  .page
;----------
; Start a spooling job
MMstart:
	lda	SPLsiz
	ora	A
	jrz	..no	; no spool partition

	lxi	D,(0FFh<8)!SPLabort
	mvi	a,AckSpStart
	sta	SPL$resp; say startSpool received
;
	call	JOBmatch
	jrnz	..ok
;
..no:	sub	A	; no room, so ...
	sta	SPL$dsk ; deny spool request
	ret

..ok:	push	H	; save table entry
	lda	SPLvol
	sta	SPL$vol ; set spool volume no.
	lda	SPLdsk
	sta	SPL$dsk ; set spool disk no
	sded	SPL$trk ; set beginning track no
	mov	A,D
	ora	E
	jrz	..trk0
	xra	A	; spooling really begins at 1
	jmpr	..con
..trk0:	mvi	A,2	; spooling really begins at 3
..con:	sta	SPL$sec ; set beginning sector no
	lda	SPLsiz
	sta	SPL$siz
;
	lda	MASTusr
	inx	H
	mov	M,A	; spool user number
;
	inx	H
	lda	SPL$id
	mov	M,A	; spool job id
;
	dcx	H
	dcx	H
	lxi	B,8
	dad	B	; point to area for name
	push	H
	call	curUSR
	inx	H	; HL = name in user table
	pop	D	; DE = name in spool table
	ldir		; move name
;
	pop	H	; restore spool table address
	mvi	A,SPLstart; set status to "start spool"
	jmp	SPLupdate

;----------
; Stop a spooling job
MMstop:
	lxi	H,SPL$id
	call	dcrsrchid
	mvi	E,0ffh
	call	usermatch ; look for previous block
	jrz	..con1   ; none exists
;
	mov	A,M
	cpi	SPLwait  ; waiting?
	jrz	..con2
;
	cpi	SPLready ; Ready?
	jrz	..con3
;	
..con1:
	lda	Mode	; check for autowait
	bit	ModeWAIT,A
	jrz	..con3
;
..con2:	; Mark it "waiting"
	mvi	C,SPLwait
	jmpr	MMspexit
;
..con3:	; Mark it "ready"
	mvi	C,SPLready
MMspexit:
	jmp	FNDspool  ; find current user job

;----------
; Spool 128 bytes
MMspool:
	lxi	H,MASTtrk
	lxi	D,SPL$trk
	lxi	B,3
	ldir		; update current spool trk, sec
;
	mvi	C,SPLspool; set status to "spooling"
	jmpr	MMspexit

;----------
; Abort spool job
MMabort:
;
	mvi	C,SPLabort; status is "job aborted"
	jmpr	MMspexit
;
;----------
; CHKspool is invoked once per master pass
; Process user response to query if manual-print mode
CHKspool:
	lda	SPLsiz
	ora	A	; why waste time if there
	rz		; isnt a spool partition

	lda	SPLman
	ora	A	; jump if we're not waiting for
	jrz	..act	;  a response to "Print" msg
;
	call	ConSt
	ora	A	; check for char available
	rz
;
	call	ConIn	; get the response
	push	PSW
	mov	C,A
	call	ConOut	; echo response
	pop	PSW
	cpi	cr
	jrz	..entered
;
	cpi	' '
	rz		; ignore spaces
;
	sta	SPLman	; save selection byte
	ret

..entered:
	mvi	C,lf
	call	conOUT
	lxi	H,SPLman
	mov	A,M	; get selection byte
	mvi	M,0	; allow local user console I/O
	cpi	'a'
	jrc	..chkopt
;
	sui	'a'-'A' ; convert lower to upper case
..chkopt:
	lxi	H,Mode

  .ifn	FoxOpt,[
	cpi	'P'	; print on parallel port
	jrz	..parallel
	]		; end ' not FoxOpt '
;
	cpi	'S'	; print on serial port
	jrz	..serial
;
	lhld	PRINTjob
	cpi	'W'	; wait (ie, suspend printout)
	jrz	..wait
;
	cpi	'A'	; abort this printout
	jz	..abort
;
	cpi	cr	; cycle to next job
	jrz	..cycle
;
	jmp	..reprompt; error, so re-ask question

;----------
  .ifn	FoxOpt,[
..parallel:
	set	ModePRT,M ; select parallel printer
	jmp	..print
	]		; end ' not FoxOpt '
;----------
..serial:
	res	ModePRT,M ; select serial printer
	jmp	..print

;----------
..wait:
	mvi	A,SPLwait
	call	SPLupdate ; set status to "waiting"
	jmp	..newjob

;----------
; Cycle through all ready print jobs
..cycle:
	lxi	D,(0ffh<8)!SPLready
	call	JOBcheck
	jrnz	..ok
;
	lxi	D,(0ffh<8)!SPLready
	call	JOBmatch
	jrz	..cycle ; if not, continue scanning
; This is bizarre because it has to find the job
;	that caused the initial cr!!!	
..ok:	jmp	..nxtjob

;----------
; If no print job active, check for new job
..act:
	lhld	PRINTjob
	mov	A,H
	ora	L
	jz	..newjob
;
; If cntlZ found or SPOOL ABORT, then terminate print
	mov	A,M
	cpi	SPLdone
	jrnz	..chkrdy
;
	call	PRNToff ; turn off print interrupts
	jmp	..ckend

..abort:	;will abort this job and any ready
		; blocks after this one
	call	nxtblock
	jz	..endjob
	mov	A,M
	cpi	SPLready
	jrz	..abcont
	cpi	SPLwait
	jrz	..abcont
	jmp	..endjob

..abcont:
	push	H
	mvi	A,SPLabort
	call	SPLupdate
	pop	H
	jmpr	..abort

; If SPOOL RETRY, then put print job on ready queue
..chkrdy:
	cpi	SPLready
	jrnz	..chkbuf
;
	call	PRNToff ; turn off print interrupts
	jmp	..newjob

;----------
; Check if buffer is empty.  This indicates that
; the current print job needs to be supplied with a
; new sector. If the buffer isn't empty, print now.
..chkbuf:
	lda	nxtSout
	cpi	lenSbuf
	jrnc	..newsect; service this or next job
;
  .ifn	FoxOpt,[
	call	checkp	; check SIO, ready for char
	jrnz	..par	; Jump if parallel
	]		; end ' not FoxOpt '
;
	lda	ok2prnt
	ora	A
	rnz		; Return if already printing
;
	call	PORT2st
	rz		; Return if no char ready
;
	call	PORT2in ; Clear Rx buffer, assume X-ON
	mvi	A,0FFh
	sta	ok2prnt ; Allow print again
	jmpr	..STprint ; Jump to re-start print

..par:
    ; If parallel printer, print chars until
    ; buffer is flushed or printer is busy

  .ifn	FoxOpt,[
	in	PIOAD	; get transmitter status
	bit	6,A	
	jrz	..prtchar; parallel printer ready
;
	mvi	A,10010111b
	out	PIOAC	; turn on parallel print ints
	mvi	A,10111111b
	out	PIOAC
	ret

..prtchar:
	call	PRINTchar; print next char
	jrnz	..chkbuf; repeat until all buff printed
			; or parallel port isn't ready

	jmpr	..endjob; cntl-Z found, so end of job
	]		; end ' not FoxOpt '
;-----------
; Check for end of Print job - no more blocks for job id
..ckend:
	lhld	PRINTjob
	call	nxtblock
	jrz	..endjob
;
	mov	A,M
	cpi	SPLspool
	rz	; if its spooling then wait
;
	cpi	SPLready
	jrz	..ckexit
;
	jmpr	..endjob	; cant wait if just started
				; because it may be hung
..ckexit:
	xra	A
	sta	PRTcont	; continue printing
	push	H
	lhld	PRINTjob
	mvi	M,SPLabort
	ora	M	; clear zero flag
	pop	H
	jmpr	..nxtjob

;----------
; Print next sector
..newsect:
	lxi	H,PRINTsec
	mov	A,M
	cpi	128	; check for last sect on trk
	jrnz	..read
;
	lxi	H,PRINTtrk
	lda	splend
	cmp	M	; check if last track of block
	jrz	..ckend
;
	inr	M	; inc track
	inx	H
	inx	H	; reset sector pointer
	mvi	M,0
..read:
	inr	M	; inc sector
	lded	PRINTtrk; track
	mov	C,M	; sector
	lda	SPLvol
	mov	B,A	; HD drive (volume)
	lda	SPLdsk	; disk
	lxi	H,PRNTbuf
	call	HARDr	; read next sect into buff
	sub	A
	sta	nxtSout

;----------
; Activate printer (parallel or serial)
..print:
	lhld	PRINTjob
	mvi	A,SPLprint
	call	SPLupdate ; update spool table
	call	checkp	; check SIO, ready for char
	rnz		; don't do anything if parallel

..STprint:
	call	serON	; turn on serial interrupts
			; check SIO buffer status
	rz		; zero is full, do not send chr
	call	PRINTchar ; ELSE, print first char
	rnz		; return if not cntl-Z

	call	PRNToff ; turn off serial interrupts

;----------
; Abort current job
..endjob:
	lhld	PRINTjob
	mvi	A,SPLabort
	sta	PRTcont		; new job to print
	call	SPLupdate

;----------
; Search for new print job
..newjob:
	lxi	D,(0FFh<8)!SPLready
	call	JOBmatch
	jrz	..nxtjob ; not graceful but suffices
;
..new1:	shld	PRINTjob
	sded	PRINTtrk
	inx	H
	mov	D,M
	dcx	H
	mov	A,B ; jobmatch returns id in B
	call	dcrsrchid ; look for previous block
	mvi	E,0ffh
	call	usermatch
	jrz	..newcont
	mov	A,M
	cpi	SPLready
	jrnz	..newcont ; not ready go with last	
	jmpr	..new1    ; keep looking for first
..nxtjob:
	shld	PRINTjob
	rz		; no job waiting
;
	sded	PRINTtrk; set beginning track, sect
..newcont:
	lded	PRINTtrk ; could enter from newjob
	lda	SPLsiz
	add	E
	dcr	A
	sta	splend
	mov	A,D
	ora	E
	jrz	..new0
;
	mvi	A,1
	jmpr	..newt
;
..new0:	mvi	A,3
..newt:	sta	PRINTsec

;----------
; Read first sector, and check for forms info
	mov	C,A	; sector
	lda	SPLvol	; HD drive (volume)
	mov	B,A
	lda	SPLdsk	; disk
	lxi	H,PRNTbuf
	call	HARDr	; read first sector
	sub	A
	sta	nxtSout ; reset buffer pointer
	lda	PRTcont
	ora	A
	jz	..print	; continue printing

	lhld	PRINTjob
	inx	H
	inx	H
	mov	A,M	; get spool id
	ani	0fh	; mask off block id
	jrnz	..chkmode ; only check forms if block 0
;
	lxi	H,PRNTbuf
	mov	A,M
	cpi	'('	; check for begin of form info
	jrnz	..chkmode ; jump if not found
;
	mvi	B,lenSbuf-3
..look: inx	H
	mov	A,M
	cpi	')'	; check for end of form info
	jrz	..found
;
	djnz	..look
;
	jmpr	..chkmode ; jump if not found

..found:
	mvi	A,lenSbuf-1
	sub	B
	sta	nxtSout ; don't print form info
	jmpr	..reprompt; if forms info, manual prt

;----------
; If manual-print option selected, print message
..chkmode:
	lda	Mode
	bit	ModeSPL,A
	jz	..print ; start immed. if autoprint
;
; Print "*** USER ID AND NAME Ready to print "
..reprompt:
	mvi	A,cr
	sta	SPLman	; turn off local user con I/O
	lxi	H,msgSTAR+1
	call	PRTMSG	; print "*** "
	lhld	PRINTjob
	inx	H
	inx	H
	mov	A,M
	call	PrtByt
	lxi	B,6
	dad	B	; point to name in spool table
	mvi	B,8
	call	PRTSTR	; print user name
	lxi	H,SPLprep
	call	PRTMSG	; print "Ready to print"
;
; Print forms information, if any
	lda	nxtSout
	ora	A
	jrz	..ask	; jump if no forms info
;
	mov	B,A
	lxi	H,PRNTbuf
	call	PRTSTR	; print forms info
;
; Print "Abort,Wait,Serial,(Parallel),<CR>"
..ask:
	lxi	H,SPLask
	jmp	PRTMSG

; return to master polling loop after printing prompt

  .page
  .sbttl	'spooling utilities'
;----------------------------------------------
;  S P O O L I N G   U T I L I T I E S
;----------------------------------------------

; Force the local user to wait for console I/O if
; the spooler is in manual mode, and waiting to print
WAITspool:
	lda	LOCALflag
	ora	A
	rnz		; allow console I/O if master
;
	lda	SPLman
	ora	A	; wait until console is free
	jrnz	WAITspool
	ret
;
;
; Decrement search id for job match routines
;  used when searching for previous job entry
;	Entry A=spool id to be block decremented
dcrsrchid:
	mov	C,A
	ani	0f0h
	mov	B,A
	mov	A,C
	ani	0fh
	dcr	A
	ani	0fh
	ora	B
	sta	srchid
	ret
;
; Used to find spool entry for next block of job
;  Returns Z flag set if not found. Is entered
;  with HL pointing to current entry
nxtblock:
	inx	H
	mov	D,M
	inx	H
	call	blkidinc
	sta	srchid
	mvi	E,0ffh
	call	jobmatch
	ret
;
; Used to increment HL to next Spool table entry
;  returns Z flag set if past last entry. The 
;  table must be aligned so that last entry
;  address is xxFFh.
INRspool:
	mov	A,L
	ani	0f0h
	mov	L,A	; forces HL to start of
			; current entry
	push	D
	lxi	D,lenspool
	dad	D
	pop	D
	mov	A,L
	ora	A
	ret
;
;----------
; Search spool job table for match with userno and stat
;  Regs in:  E = status (0,1,2,3,4,E5 or FF for match on ID)
;	     D = user number (ignore if 0FFh)
;  Regs out: HL= pointer to matching entry
;	     DE= beginning track
;	     B = spool id of entry	
;	     (HL = 0 and Z flag set if no match found)
usermatch:	; enter to match on current user
	lda	MASTusr
	mov	D,A
JOBmatch:	; enter to search from first entry
	lxi	H,SPOOLlist
JOBcheck:	; enter to search from current entry
	mov	A,E
	cpi	0ffh
	jrz	..job1	; dont check status
;
	cmp	M
	jrnz	..nomatch
;
..job1:	inx	H	; get user field
	mov	A,D
	cpi	0ffh
	jrz	..found	; dont check user
;
	cmp	M
	jrz	..found	; match or defaults
;
..nomatch:
	call	inrspool ; get next entry
	jrnz	JOBcheck
	ret	; at end of list
;
..found:	; if E=ff then we want to matchon
	; search id else we return current spool id
	; in B
	inx	H	; get spool id field
	mov	B,M	; put it in B
	mov	A,E
	cpi	0ffh
	jrnz	..job2	; id match not wanted
;
	lda	srchid
	cmp	B
	jrnz	..nomatch ; around again
;
..job2:	dcx	H
	dcx	H	; restore pointer
			; and fall into jobfound
;
; Returns starting track for spool "bucket"
;  i.e. starting track is determined by position
;  in spool list
JOBfound:
	mvi	D,0
	mov	E,L	; compute 1st track no
	lda	SPLsiz
..shift:
	rlc
	cpi	20h
	jrz	..fin
;
	srlr	E
	jmpr	..shift
;
..fin:	ora	A	; clear Z flag 
	ret
;
;----------
; Find active spooling job for current user
FNDspool:
	mvi	E,SPLspool; search for "spooling" job
	call	usermatch
	jrnz	..fndexit
;
	mvi	E,SPLstart; search for "starting" job
	call	usermatch
	rz	; none exists
;
..fndexit:
	mov	A,C ; get status and fall into update
;
; Update spool job table
;  Regs in:  HL = pointer to current job table entry
;	     A	= status byte
SPLupdate:
	mov	M,A	; set status byte
	xchg
	inx	D
	inx	D
	inx	D
	lxi	H,mins
	lxi	B,2
	ldir		; set sec, min, hr
	cpi	SPLready; update trk, sect
	jrnc	..1	;  only if starting, spooling.
;
	lxi	H,SPL$trk
	lxi	B,3
	ldir
..1:	cpi	SPLspool; update job table on disk
	rz		;  only if starting, ready,
;
	cpi	SPLprint;  or aborting.
	rz	
;
	mvi	A,writeNET
	sta	MASTcom
	lda	SPLdsk
	sta	MASTdsk
	lda	SPLvol
	sta	mastvol ;set up with spool volume
	lxi	H,0
	shld	MASTtrk
	mvi	A,1
	sta	MASTsec
	lxi	H,SPOOLlist
	call	MMwrite ; update spool table on disk
	mvi	A,2
	sta	MASTsec
	lxi	H,SPOOLlist+128
	jmp	MMwrite
  .page
  .sbttl	'spooling interrupt driver'
  .prntx	'made it to spooler interrupt'
;-----------------------------------------------------
;  S P O O L I N G   I N T E R R U P T   D R I V E R
;-----------------------------------------------------
; Process a printer interrupt
PRNT.SP:.word	0
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
PRNTstack:
PRNTint:
	push	psw
	call	disPRINT	; no other print int
	lda	LOCALflag	; 0 = local user active
	ora	a
	jrz	..saveregs
;
	ei
..saveregs:
	sspd	PRNT.SP
	lxi	sp,PRNTstack
	push	h
	push	d
;
	lda	ok2prnt	; zero means don't print
	ora	A
	jrz	..ret
;
	lda	nxtSout	
	cpi	lenSbuf	; check for end-of-buff
	jp	..endbuf; jump if end-of-buffer
;
	call	PRINTchar; get next char from buffer
	jrnz	..ret	; jump if not cntl-Z
;
	lhld	PRINTjob
	mvi	M,SPLdone ; cntl-Z found

; End of buffer, so turn off transmitter ints
..endbuf:

  .ifn	FoxOpt,[
	call	checkp	; check SIO, ready for char
	jrz	..offser
;
	mvi	A,00000011b
	out	PIOAC	; disable parallel ints
	jmpr	..ret
	]		; end ' not FoxOpt '

..offser:
	mvi	A,28h	; reset pending serial int
	out	SIO2AC	; because no char was sent
..ret:
	pop	d
	pop	h
	di
	call	serON	; serial only, parallel
	lspd	PRNT.SP	; on done in ..chkbuf
	pop	psw
	ei
	reti

;----------
; Handle external status interrupt from printer
PRNTerr:
	push	PSW
	mvi	A,10h
	out	SIO2AC	; reset ext status int
	pop	PSW
	ei
	reti

;----------
; disable serial or parallel ints
disPRINT:

  .ife	FoxOpt,[jmpr	SerOff]
  .ifn	FoxOpt,[
	call	checkp	; check SIO, ready for char
	jrz	serOFF
;
	mvi	a,3
	out	pioAC
	ret
	]		; end ' not FoxOpt '
;
;----------
; Turn off printer interrupts
PRNToff:
	call	serOFF
	ei		; serOFF disables ints
	mvi	A,lenSbuf; force buffer empty
	sta	nxtSout
	ret

;-----------
; disable serial print ints
serOFF:
	di	; can't have serial prt int here
	mvi	a,11h
	out	sio2ac
	xra	a
	out	sio2ac
	ret	; ei done in caller when desired

;----------
; check to see if we want to enable prnter ints
; this is because we've turned them off during
; polling to avoid conflicts with recFIRST ints
; do nothing if spooler is parallel printer
CkPrtOn:
	call	checkp	; check SIO, ready for char
	rnz		; parallel spooler
;
	lhld	PRINTjob
	mov	a,h
	ora	l
	rz		; job not available
;
	mov	a,m
	cpi	SPLprint
	rnz		; job not printing
;
	lda	ok2prnt
	ora	a
	rz		; printer busy
;
	lda	nxtSout
	cpi	lenSbuf
	rp		; buffer empty
;
	di
	call	serON	; enable printer ints, SR ret
	jrz	..enaEND ;zero if SIO not ready
;
	call	PRINTchar; print next char
	jnz	..enaEND; char not a ctl-z
;
	lhld	PRINTjob
	mvi	m,SPLdone ; set job to done
..enaEND:
	ei
	ret
;----------
; Turn on printer interrupts
serON:
	mvi	A,11h
	out	SIO2AC
	mvi	A,00000011b
	out	SIO2AC
	in	sio2ac
	bit	TxRdy,a	; set value for inline tests
	ret
;----------
checkp:	lda	Mode	
	bit	ModePRT,A ;set the zero flag if busy
	ret
.page
;----------
; Print next char and process cntlZ if found
;  Regs out:  Z flag set if cntlZ found
;	      If Z flag set, HL = job pointer
PRINTchar:

  .ifn	FoxOpt,[
	call	checkp	; check SIO, ready for char
	jrnz	..print	; Jump if parallel
	]		; end ' not FoxOpt '
;
	call	PORT2st	; Check if char present
	jrz	..print	; Jump if no char
;
	call	PORT2in	; Get char
	cpi	cntlS	; Check if X-OFF
	jrnz	..print	; Jump if not
;
	sub	A
	sta	ok2prnt	; Indicate no print
	call	serOFF	; shut off serial prnt ints
	ei
	jmpr	..git	; Do ret with Z flag reset

..print:
	lxi	h,nxtSout
	mov	e,m
	inr	m
	lxi	H,PRNTbuf
	mvi	D,0
	dad	D
	mov	A,M	; get next char to print
	cpi	cntlZ
	rz		; return if cntl-Z
;
; Print one character

  .ifn	FoxOpt,[
	lxi	H,Mode
	bit	ModePRT,M
	jrz	..outser
;
	out	CENTP	; print character
	in	PPSTROBE
	ret
	]		; end ' not FoxOpt '

..outser:
	out	SIO2AD	; print character
..git:
	ori	1	; reset Z flag
	ret
	]		; end ' spool opt '
  .page
