  .page
  .sbttl	'conditional assembly options (b83defs.asm)'

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +	Assembly Option Selections		+
; +						+
; +	last modified>	25apr84 msh		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;
;-------
;
;
;	-----	CP/M 2.2   ----
;	conditional assembly options



.ife config,[
Select	=\ '      1 =>  stand-alone system
      2 =>  network master
      3 =>  network station
choice	=  '    
]

alone		==	SELECT-1
master		==	SELECT-2
station 	==	SELECT-3


.ife config,[
NumDisks	=\ 'Number of CP/M disks desired
      1 =>  mininum valid number
     16 =>  maximum valid number
choice	=  '

HiDosOpt	=\ '      0 =>  HiDos option
      1 =>  standard CP/M
choice	=  '
]
  .page
;---------------

  .ife	alone,[
    .ife config,[
eitherHARD	=\ '      0 =>  hard disk boot
      1 =>  flop disk boot
choice	=  '
    ]

    .ife	eitherHARD,[
      .ife config,[
Hard5boot	=\ '      0 =>  5 inch hard boot
      1 =>  8 inch hard boot
choice	=  '

Flop5opt	=\ '      0 =>  5 inch flop disks
      1 =>  8 inch flop disks
      2 =>  neither flop disk
choice	=  '

DriveDopt	=\ '      0 =>  enable DriveDopt
      1 =>  disable DriveDopt
choice	=  '
      ] ; end 'ife config'

Hard5opt	==	Hard5boot
Hard8boot	==	1-Hard5boot
Hard8opt	==	Hard8boot
Flop8opt	==	1-Flop5opt
Flop8boot	==	1
Flop5boot	==	1
	]		; end ' eitherHARD '


    .ifn	eitherHARD,[
      .ife config,[
Flop5boot	=\ '      0 =>  5 inch flop boot
      1 =>  8 inch flop boot
choice	=  '
      ]
; Floppy boots don't really have space for hard disk
; drivers so force hard5opt false
;
; Hard5opt	=\ '      0 =>  5 inch hard disk
;	1 =>  8 inch hard disk
;	2 =>  neither hard disk
; choice	=  '

; force no hard disk drives
Hard5opt	==	2

Flop8boot	==	1-Flop5boot
Flop5opt	==	Flop5boot
Flop8opt	==	Flop8boot
Hard8boot	==	1
Hard5boot	==	1
Hard8opt	==	1-Hard5opt
	]		; end ' not eitherHARD '


NETboot 	==	1
MASTopt 	==	1
NETopt		==	1
FLOPshare	==	1
HARDshare	==	1
	]		; end ' stand alone '
  .page
;---------------

  .ife	master,[
    .ife config,[

HardMast	=\ '      0 =>  hard disk master
      1 =>  flop disk master
choice	=  '
    ] ; end 'ife config'

    .ife	HardMast,[
      .ife config,[
Hard5opt	=\ '      0 =>  5 inch hard disks
      1 =>  8 inch hard disks
choice	=  '

Flop5opt	=\ '      0 =>  5 inch flop disks
      1 =>  8 inch flop disks
choice	=  '
      ] ; end 'ife config'

Hard8opt	==	1-Hard5opt
Flop8opt	==	1-Flop5opt
Hard5boot	==	1
Hard8boot	==	1
Flop5boot	==	1
Flop8boot	==	1
DriveDopt	==	1

NetBoot 	==	0
MastOpt 	==	0
NetOpt		==	0
HardShare	==	0
FlopShare	==	1
	]		; end ' HardMast '


    .ifn	HardMast,[
      .ife config,[
Flop5opt	=\ '      0 =>  5 inch flop disks
      1 =>  8 inch flop disks
choice	=  '
      ]

Flop8opt	==	1-Flop5opt
Flop5boot	==	1
Flop8boot	==	1
Hard5boot	==	1
Hard8boot	==	1
Hard5opt	==	1
Hard8opt	==	1
HardShare	==	1

NetBoot 	==	0
MastOpt 	==	0
NetOpt		==	0
FlopShare	==	0
	]		; end ' not HardMast '

.ife config,[
numusr		=\ '      Number of Logged-in Users desired
      4 =>  Floppy server
     32 =>  Small system (5" master)
     64 =>  Large system (8" master)
choice  =  '

numlock		=\ '      Number of lock strings
      0 =>  Floppy server
     32 =>  Small CP/M system
     64 =>  Small HiDos system (5" master)
    128 =>  Large Hidos system (8" master)
choice  =  '
] ; end 'ife config'

	]		; end ' master '

MaxPossible == 3Fh	; currently largest possible
			; user number
  .page
;---------------

  .ife	station,[
    .ife config,[

; It is not currently possible to actually have both
; hard disks so for now don't prompt for this assembly
; option. Insert this phrase into <HaveHard> when this
; option becomes possible -
;     2 =>  both hard disks

HaveHard	=\ '      0 =>  5 inch hard disks
      1 =>  8 inch hard disks
      7 =>  neither hardOpt
choice	=  '

HaveFlop	=\ '      0 =>  5 inch flop disks
      1 =>  8 inch flop disks
      2 =>  both flop disks
      7 =>  neither flopOpt
choice	=  '
      ] ; end 'ife config'

Hard5opt	==	(HaveHard-2)&(HaveHard)
Hard8opt	==	(HaveHard-2)&(HaveHard-1)
Flop5opt	==	(HaveFlop-2)&(HaveFlop)
Flop8opt	==	(HaveFlop-2)&(HaveFlop-1)

Hard5boot	==	1
Hard8boot	==	1
Flop5boot	==	1
Flop8boot	==	1
FlopShare	==	1
MastOpt 	==	1
DriveDopt	==	1

NetOpt		==	0
NetBoot 	==	0
HardShare	==	0
	]		; end ' station '
  .page
;----------
; Misc. conditional assembly options (0 to select):

OptHardAny	==	Hard8opt&Hard5opt
BootHardAny	==	Hard8boot&Hard5boot

OptFlopAny	==	Flop8opt&Flop5opt
BootFlopAny	==	Flop8boot&Flop5boot

TimerOpt	==	0	; real-time clock

  .ife	Master,[
    .ife config,[
FoxOpt	=\	'Console Driver Selection
      0 =>  parallel port console
      1 =>  serial port console
choice	=  '
     ] ; end 'ife config'
	]		; end ' Master '

  .ifn	Master,[
    .ife config,[
FoxOpt	=\	'Console Driver Selection
      0 =>  polled serial port0
      1 =>  interrupt driven serial port0
choice	=  '
    ] ; end 'ife config'
	]		; end ' not Master '

.ife config,[
WriteModes	=\ '      0 =>  use Write Modes
      1 =>  ignore Write Modes
choice	=  '
]

  .ife	Master,[
AheadOpt	==	0	; port 0 typeAhead
SpoolOpt	==	0	; print spooler
AH3opt		==	1	; port 3 typeAhead
FrontOpt	==	1	; front panel int.
	]

  .ifn	Master,[
FrontOpt	==	0	; front panel int.
	]

  .ife	station,[
    .ife config,[
AH3opt	=\	"      0 =>  Port 3 buffered
      1 =>  Port 3 not buf'd
choice	=  "

BuffOpt =\	'      0 =>  Net Buf Opt
      1 =>  no Net Buf Opt
choice	=  '
    ] ; end 'ife config'

AheadOpt	==	1-FoxOpt; port 0 typeAhead
AddsOpt 	==	0	; Adds aux print port
SpoolOpt	==	BuffOpt ; Print Spooling
	]			; end ' station '

  .ifn	station,[
BuffOpt 	==	1	; 1k Net read opt
AddsOpt 	==	1	; Adds aux print port
	]

  .ife	alone,[
AheadOpt	==	1-FoxOpt; port 0 typeAhead
AH3opt		==	1	; port 3 typeAhead
EXECopt 	==	0	; cold boot exec opt
SpoolOpt	==	1	; no Print spooler
	]

  .ifn	alone,[
EXECopt 	==	1	; cold boot exec opt
	]

  .ife	BootFlopAny,[
port3debug	==	1	; modem debug option
	]

  .ifn	BootFlopAny,[
port3debug	==	0	; modem debug option
	]

ErrDisp 	=\ '      0 =>  inhibit err disp
      2 =>  enable  err disp
choice	=  '

BiosGrants	==	0ffffh	; no auto Wr_Grants

SysMode 	==	0c5h + ErrDisp
  .page
  .sbttl	'adrs of bios,bdos,ccp and important tables (b83defs.asm)'
	.pabs
	.phex
;
;----------
; Addresses of BIOS, BDOS, CCP, and important tables:
;
lenCCP	==	800h	; length of CCP
lenBDOS =	0E00h	; length of BDOS
lenBIOS =	580h	; length of BIOS kernal
lenDPB	=	31	; length of Disk Param Block
lenDPH	==	16	; length of Disk Param Header
FlpVec	==	64	; len of flop check / alloc vec
  .ife HiDosOpt,[ NetVec == 256] ; len of net alloc vec
	 [NetVec == 512] ; len of net check / alloc vec


; HiDos Disk Parameter Blocks are larger than standard
  .ife	HiDosOpt,	   [lenDPB  = lenDPB   +0004]

; Extra memory for HiDos code
  .ife	HiDosOpt,	   [lenBdos = lenBdos +0100h]

; Extra memory for alloc and check vectors
  .ife	BootFlopAny,	   [
	lenBios =	  lenBios +(NumDisks *FlpVec)

    .ife	OptHardAny,[
	lenBios =	   lenBios +(NetVec -FlpVec)]
	]		; end ' BootFlopAny '

  .ifn	BootFlopAny,	   [
	lenBios =	 lenBios +(NumDisks *NetVec)]

; Extra memory for Disk Parameter Headers
	lenBios =	  lenBios +(NumDisks *lenDPH)

; Extra memory for Disk Parameter Blocks
	lenBios =	  lenBios +(NumDisks *lenDPB)

; Extra memory for fudging lenBios
  .ife	Alone,[
    .ife	Flop5boot, [lenBios = lenBios +0010h]
    .ifg	5-NumDisks,[lenBios = lenBios +0032h]
	]		; end ' Alone '
  .ife	Station,[
    .ife Flop5opt, [lenBios = lenBios +0100h]
	]	; end 'Station fudge '	

; Extra memory for separated  boot
  .ife Master,		   [lenBIOS = lenBIOS +0480h]

; Extra mem for Master table sizes
;  spool table
  .ife Master,	[lenBios = lenBIOS +(16*16)]
;  lock table
  .ife Master,	[lenBIOS = lenBIOS +(numlock*16)]
;  user table
  .ife Master,  [lenBIOS = lenBIOS +(numusr*16)]

; Extra memory for Write Mode usage
  .ife	WriteModes,	   [lenBios = lenBios +0220h
    .ife	BiosGrants,[lenBios = lenBios +0060h]
    .ife	Master,    [lenBios = lenBios +0160h
      .ife	Hard8opt,  [lenBios = lenBios +0020h]
	.ife	BiosGrants,[lenBios = lenBios +0030h]
	]		; end ' Master '
	]		; end ' WriteModes '

; Extra mem for disk device drivers
  .ife	OptFlopAny,	   [lenBIOS = lenBIOS +0650h]
  .ife	Flop8opt,	   [lenBIOS = lenBIOS +0040h]
  .ife	Flop5opt,	   [lenBIOS = lenBIOS +0020h]

  .ife	Hard5opt,	   [lenBIOS = lenBIOS +0910h]
  .ife	Hard8opt,	   [lenBIOS = lenBIOS +01e0h]

  .ife	Master,[

    .ife SpoolOpt,[	    lenBios = lenBios +01e0h
      .ifn FoxOpt,	   [lenBios = lenBios +0040h]
	]		; end ' SpoolOpt '

    .ife Hard8opt,	   [lenBios = lenBios +01e0h]
    .ife Hard5opt,	   [lenBIOS = lenBIOS +0c30h]
    .ife HardShare,	   [lenBIOS = lenBIOS +1400h]
    .ife FlopShare,	   [lenBIOS = lenBIOS +0200h]
	]		; end ' Master '

  .ife	SpoolOpt,	   [lenBios = lenBios +0200h]
  .ife	NETopt, 	   [lenBIOS = lenBIOS +0590h]
  .ife	BUFFopt,	   [lenBIOS = lenBIOS +0470h]

; Extra mem because of SIO bug fix in ConStat
  .ife	Station,	   [lenBios = lenBios +0040h]

; Extra mem for serial port type-ahead
  .ife	AheadOpt,	   [lenBIOS = lenBIOS +0050h]
  .ife	AH3opt, 	   [lenBIOS = lenBIOS +0050h]

; Extra mem for modem port debug
  .ife	port3debug,	   [lenBios = lenBios +0050h]

lenBIOS =	(lenBIOS + 0ffh) & 0ff00h

  .ife	OptFlopAny,[
LenWrBuf==	100h	; len of flop write buf
LenRdBuf==	100h	; len of flop read buf
	]		; end ' OptFlopAny '

  .ifn	OptFlopAny,[
LenWrBuf==	000h	; len of flop write buf
LenRdBuf==	000h	; len of flop read buf
	]		; end ' not OptFlopAny '

; Extra mem for cold boot code
  .ife	Master, 	   [lenBoot = 0a00h]
  .ife	Station,	   [lenBoot = 0500h]
  .ife	Alone,[
    .ife BootFlopAny,[
	lenBoot = lenRdBuff + 80h + (NumDisks * FlpVec)]
    .ife OptHardAny,[
	lenBoot = lenBoot + (Netvec - FlpVec)]
	]		; end ' Alone '

;	Important CP/M constants
lenCPM		==	lenCCP + lenBDOS
lenSysImage	==	lenCPM + lenBoot + lenBios
BIOS		==	64*1024-lenBIOS ; adr of BIOS
BDOS		==	BIOS-lenBDOS+6	; adr of BDOS
CPM		==	BIOS-lenCPM	; adr of CCP
TPA		==	100h		; adr of TPA

  .ife	BootHardAny,[	       
GenColdAdr	==	TPA	; reloc to here
zOffset 	=	GenColdAdr - CBoot
	]		; end ' Hard Boot '

  .ife	NetBoot,[
GenColdAdr	==	TPA	; reloc to here
zOffset 	=	GenColdAdr - CBoot

; if a Station then leave room for the header
    .ife Station,[zOffset  =	zOffset +80h]
	]		; end ' Net Boot '

  .ife	BootFlopAny,[
GenJumpTable	==	lenCPM + 0A00h
zOffset 	=	GenJumpTable - Bios
	]		; end ' BootFlopAny '

; Table addresses for hard disk network master
; Number of users increased from 32 to 64.
; Number of lock strings increased from 32 to 128.
; All lists, floppy read/write and net buffers moved
  .ife	MASTopt!HARDshar,[
		SPOOLlist== 0-(16*16)
		LOCKlist == SPOOLlist-(numlock*16)
		USERlist == LOCKlist-(numusr*16)
		MASTbuf == USERlist-400h
	]		; end ' MASTopt!HARDshar '

; Table addresses for floppy disk network master
  .ife	MASTopt!FLOPshar,[
		USERlist == 0-(numusr*16)
		MASTbuf  == USERlist-80h
	]		; end ' MASTopt!FLOPshar '

  .ifn	MASTopt,[ MASTbuf == 0 ]

wrBUFF	==	MASTbuf-LenWrBuf; .(flop write buf)
rdBUFF	==	WrBuff-LenRdBuf ; .(flop read buf)

  .ife	BuffOpt,[
netBUFF ==	rdBuff-400h	; .(network read buf)
	]		; end ' BuffOpt '

  .ifn	BuffOpt,[
netBUFF ==	rdBuff-1	; .(network read buf)
	]		; end ' not BuffOpt '

  .ife	MASTopt,[  MASTstack == netBUFF ]

  .page
  .sbttl	'important constants (b83defs.asm)'
;------
; Miscellaneous constants
ReBoot		==	0000h	; cp/m warm boot adr
ccpDsk		==	0004	; ccp default disk adr
typeahead	==	31	; type-ahead length
DebugMask	==	20h	; port3 debug mask

;---------
; Cold Boot Assign values
MaxAllocEntry	==	64
LenAllocEntry	==	16
LenAssnStr	==	14

;---------
; Character constants
Null	==	00	; pad char
cntlC	==	03h	; <control-C>
bell	==	07h	; <bell>
backsp	==	08h	; <backspace>
lf	==	0Ah	; <linefeed>
cr	==	0Dh	; <return>
cntlP	==	10h	; <control-P>
cntlQ	==	11h	; <control-Q>
ctlR	==	12h	; <control-R>
cntlS	==	13h	; <control-S>
ctlT	==	14h	; <control-T>
cntlZ	==	1Ah	; <control-Z>
Esc	==	1bh	; <control-[>
rubout	==	7Fh	; <rubout>

;----------
; Device types
SD	==	0<5	; single density map
DD	==	1<5	; double density map
HARD	==	2<5	; hard disk map
NET	==	3<5	; network map
MINI1	==	4<5	; 1 sided mini map
MINI2	==	5<5	; 2 sided mini map
fHARD	==	6<5	; DMS-15 hard disk map

;----------
; Transmit and receive bits
RxRDY	==	0	; receiver ready bit
TxRDY	==	2	; transmitter ready bit
CTS	==	5	; Clear To Send
  .page
;----------
; Floppy-related constants

Retry	==	11	; num of flop err retries(+1)
OnPreCmp==	22	; track to turn on part precomp
MaxPrec ==	59	; track to turn on full precomp
sect5	==	16	; sectors per trk, 5 inch
sect8SD ==	26	; sectors per trk, 8 inch SD
sect8DD ==	26	; sectors per trk, 8 inch DD
gap5	==	32	; gap for specify, 5 inch
gap8SD	==	7	; gap for specify, 8 inch SD
gap8DD	==	14	; gap for specify, 8 inch DD
stp5	==	0dfh	; 5" step @ 6 ms (4 MHz clock)
stp8	==	8Fh	; Shugart 800 step rate 8 ms
stp8DS	==	0DFh	; Shugart 850 step rate 3 ms
WBlen5	==	(sect5-1)*256	; Warm boot len, 5 inch
WBlen8	==	(sect8SD-2)*128 ; Warm boot len, 8 inch

;----------
; Timing constants

$halfms 	==	50h	; 1/2 ms delay SENDNET
$1ms		==	10h	; 1ms delay in RECNET
$16ms		==	100h	; 16ms delay in RECNET
$1sec		==	4000h	; 1sec delay in RECNET
$4sec		==	0	; 4sec delay in RECNET
wakeup		==	1	; wakeup master time
sendboot	==	62	; boot broadcast freq
sendlog 	==	20	; login poll freq

HeadSettle	==	1000h
		   ; 8" head load settle (~40 mSec)

wait4motor	==	HeadSettle*4
		   ; 5" motor on delay (~160 mSec)

StepSettle	==	HeadSettle/4
		   ; head step settle time (~10 mSec)

unloadHEAD	==	62
		   ; if inactive 1 sec unload head
  .page
;		- Writing.equ -
  .ife WriteModes,[
    .ife	Master,[

; Master Write_Ownership address equates

M.Generic.Mode	=    MastCom	; Write_Mode
M.Request.Mode	=    MastDtn	; Gt/Rel/Frc/Qy
M.Volume.Mode	=    MastSrc	; volume
M.Unit.Mode	=    MastDsk	; unit
M.Value.Mode	=    MastTrk	; status
M.User.Mode	=    MastTrk +1 ; user#
	]		; end ' master '

; Station Write_Ownership address equates

N.Generic.Mode	=    NetCom	; Write_Mode
N.Request.Mode	=    NetDtn	; Gt/Rel/Frc/Qy
N.Volume.Mode	=    NetSrc	; volume
N.Unit.Mode	=    NetDsk	; unit
N.Value.Mode	=    NetTrk	; status
N.User.Mode	=    NetTrk +1	; user#

; Write_Ownership value equates

Not.Owned.Unit	==	0ffh	; no user owns the unit
Rd.Wr.Unit	==	0feh	; any user may write
Rd.Only.Unit	==	0fdh	; no user may write
Shared.Unit	==	0fch	; HiDos users may write
MultiGrant	==	0fbh	; duplicate grant sent
GenericErr	==	0fah	; generic error status

WrGrant 	==	00	; specific Grant
WrRelease	==	01	; specific Release
WrForce 	==	02	; specific Force
WrQuery 	==	03	; specific Query
WrClear 	==	04	; specific Clear
	]		; end ' WriteModes '

MaxVol		==	04 -1	; vols	00 - 03
MaxUnit 	==	64 -1	; units 00 - 63

; miscellaneous equates

dpbCtlDisp	==	-15
.ife master,[ MaxUser == numusr-1 ]
  .page
;----------
; BIOS low-memory contents:
ticks	==	40h	; 1/60ths \
secs	==	41h	; seconds  \  Time since
mins	==	42h	; minutes   \  cold boot
hrs	==	43h	; hours     /
month	==	44h	; month    /
day	==	45h	; day	  /  Set by SETTIME
year	==	46h	; year	 /
NETusr	==	47h	; network user number
ticsec	==	48h	; ticks per second
LOCKstat==	49h	; HiNet lock status
LOCKadr ==	4Ah	; address of HiNet lock
RTRYflop==	4ch	; current floppy err retry cnt
errFLOP ==	4DH	; floppy errors since cold boot
Mode	==	4Eh	; system mode bits
errNET	==	4Fh	; network or hard disk
			; errors since cold boot
;----------
; BIOS high-memory contents:
	.loc	0FFE0h
highcon:
	.byte	0,0,0,0,0,0 ; placeholders
PWBYTE:	.byte	0ffh	; pswd protection enabled
IOBYTE:
  .ife	FOXopt,[
	 .byte	56h ]	; default IOBYTE, Fox
	[.byte	54h ]	; default IOBYTE, DSC/3 or 4

baud1:	.byte	45h	; port 1
	.byte	2	; default 500K baud
baud23: .byte	45h	; ports 2,3
	.byte	13	; default 9600 baud

hertz:	.byte	62	; clock hertz rate
DefMode:.byte	SysMode ; default mode bits
FLOPmdl:.byte	0	; 0 for Shugart 800, 1 for 850

COLDbas:
  .ife BootFlopAny,	   [.word BIOS ]
  .ife NETboot&BootHardAny,[.word CBOOT]

CPMbase:	.word	CPM	; CP/M base address

	.byte	version * 10 + revision / 100
	.byte	revision @ 100
	.byte	patch
  .page
;
;----------------------------
;
; 
;		Mode bits
;		---------
;
;
;	everybody
;	---------
modeTRY ==	0	; 0 = dont retry floppy errors
			; 1 = retry floppy errors

modeMSG ==	1	; 0 = don't print USER messages
			; 1 = print USER error messages

;	master only
;	-----------
modeSPL ==	2	; 0 = automatic spool mode
			; 1 = manual spool mode

modePRT ==	3	; 0 = spool on serial printer
			; 1 = spool on parallel printer

modeWAIT==	4	; 0 = ready when spooling done
			; 1 = wait when spooling done

;	everybody
;	---------
modeDebug==	5	; 0 = no port3 debug
			; 1 = use port3 debug

;	stand alone only
;	----------------
modeCLDX==	6	; 0 = NOT cold boot
			; 1 = Just cold booted

;	everybody
;	---------
modeCONT==	7	; 0 = auto continue on Hd8 errs
			; 1 = query user on Hard8 errs
	.reloc
  .page
  .sbttl	'port definitions and standard CPM entry points (b83defs.asm)'
;----------
; Port definitions:
DMA	==	38h	; dma port
enaDMA	==	87h	; enable DMA
rstDMA	==	0c3h	; reset DMA
readDMA ==	01	; read using DMA
writeDMA==	05	; write using DMA

CTC0	==	30h	; CTC channel 0 (port 0)
CTC1	==	31h	; CTC channel 1 (port 1)
CTC2	==	32h	; CTC channel 2 (ports 2,3)
CTC3	==	33h	; CTC channel 3 (clock)

SIO1AC	==	2Ah	; SIO-1 channel A, control
SIO1AD	==	28h	; SIO-1 channel A, data -port 0
SIO1BC	==	2Bh	; SIO-1 channel B, control
SIO1BD	==	29h	; SIO-1 channel B, data -port 1
SIO2AC	==	22h	; SIO-2 channel A, control
SIO2AD	==	20h	; SIO-2 channel A, data -port 2
SIO2BC	==	23h	; SIO-2 channel B, control
SIO2BD	==	21h	; SIO-2 channel B, data -port 3
rstEOM	==	0d0h	; reset SIO underrun flag
rstInt	==	10h	; reset SIO interrupt latch
rstChan ==	18h	; reset SIO channel

PIOAC	==	0Ah	; PIO channel A, control
PIOAD	==	08h	; PIO channel A, data
PIOBC	==	0Bh	; PIO channel B, control
PIOBD	==	09h	; PIO channel B, data
HARDP	==	01h	; Hard disk parallel port
CENTP	==	02h	; Centronix parallel port
PPSTROBE==	00h	; Parallel port 2 strobe

FLOPP	==	18h	; Floppy DMA channel
FLOPSR	==	10h	; Floppy status register
FLOPDR	==	11h	; Floppy data register
STOPFLOP==	03h	; Stop floppy controller

SETMAP	==	03h	; Set memory map register
OFFPROM ==	02h	; De-activate DSC/3 PROM
ONMAP	==	00h	; Activate DSC/4 memory map

TimeOut ==	07h	; Net dead test bit,true low
crc$ovr ==	60h	; crc and ovrun error mask
PollRcv ==	00	; REClast found a poll
  .page
;----------
; Standard CP/M entry points
	.loc	BIOS

	jmp	CBOOT	; cold boot
	jmp	WBOOT	; warm boot
	jmp	CONST	; console status
	jmp	CONIN	; console input
	jmp	CONOUT	; console output
	jmp	LIST	; list output
	jmp	PUNCH	; punch output
	jmp	READER	; reader input
	jmp	HOME	; home drive
	jmp	SELDSK	; select drive
	jmp	SETTRK	; select track
	jmp	SETSEC	; select sector
	jmp	SETDMA	; set DMA address
	jmp	READ	; read disk
	jmp	WRITE	; write disk
	jmp	LISTST	; list status
	jmp	SECTRAN ; sector translate
  .page
  .sbttl	'interrupt vectors (b83defs.asm)'
;----------
; Interrupt vectors
	.loc	BIOS+40h ; vectors stored at fixed loc.
vectors:
SIO1vect:	.word	INTerr	; port 1
		.word	INTerr

.ife	NETopt,[.word	RECfirst  ; SDLC first char
		.word	REClast ] ; SDLC last char

.ifn	NETopt,[.word	INTerr
		.word	INTerr	]

		.word	INTerr	; port 0
		.word	INTerr


.ifn	master,[
  .ife	AHEADo,[.word	PORTint  ; receiver ready
		.word	PORTint] ; parity error

  .ifn	AHEADo,[.word	INTerr
		.word	INTerr]
		]		 ; end ' not MASTER '

.ife	master,[.word	INTerr
		.word	INTerr]  ; end ' master '
	; mast console polled in timer int


CTCvect:	.word	INTerr
		.word	INTerr
		.word	INTerr

.ife	TIMERopt,[
		.word	TIMERint] ; real-time clk
.ifn	TIMERopt,[
		.word	INTerr]

DMAvect:	.word	INTerr
			; whoever uses DMA sets this up

PIOvect:
.ife	FRONTopt,[
		.word	FRONTint] ; front-panel
.ife	MASTopt,[
		.word	PRNTint ] ; parallel print
  .page
  .sbttl	'DMS specific jump vectors (b83defs.asm)'
; +++++++++++++++++++++++++++++++++++++++++++++++++++++
; +						      +
; +		DMS specific jump vectors	      +
; +		--------------------------	      +
; +						      +
; +++++++++++++++++++++++++++++++++++++++++++++++++++++

	.loc	BIOS+5Dh	; vectors at fixed loc
;	----------------

;---
;	**  Network Masters  **
;	    ---------------

  .ife	Master,[
			; flush flop write buf
    .ife   OptFlopAny,[jmp	clrDDbuf]
    .ifn   OptFlopAny,[jmp	CallErr ]

	jmp	NETlock ; HiNet lock
	jmp	CPMMAP	; logical to physical map
	jmp	NETunloc; HiNet unlock
	jmp	SETBYT	; set I/O byte count

	.byte	revision-200	; bios revision level
	.word	NETmsg	; point to net command
			; (used by ASSIGN)

	jmp	SENDnet ; send a block on the net
	jmp	RECnet	; receive a block from the net
LOCALcall:
	jmp	INTERCEPT; do local net request
LOCALtime:
	jmp	INTERUPT; do local timer int
	jmp	PORTUout; user printer driver
	jmp	CALLerr ; no SETppa in the master
	jmp	CALLerr ; no RECtime in the master

  .ife	OptHardAny,[jmp  HDstat]    ; local HD status
  .ifn	OptHardAny,[jmp  CALLerr]

	jmp	NetHdStat ; master HD status
	jmp	SetNetMode; null routine in master
	jmp	CallErr ; no Adds opt

			; hard disk software reset
  .ife	OptHardAny,[jmp InitHard]
  .ifn	OptHardAny,[jmp CallErr]

  .ife	WriteModes,[jmp MakeModeRequest]
  .ifn	WriteModes,[jmp CallErr]

	jmp	Describe    ; get machine description
	]		; end ' Master '
  .page
;-------
;	**  Network Stations  **
;	    -----------------

  .ife	Station,[
			; flush flop write buf
    .ife   OptFlopAny,[jmp	clrDDbuf]
    .ifn   OptFlopAny,[jmp	CallErr ]

	jmp	NETlock ; HiNet lock
	jmp	CPMMAP	; logical to physical map
	jmp	NETunloc; HiNet unlock
	jmp	SETBYT	; set I/O byte count

	.byte	revision-200	; bios revision level
	.word	NETmsg	; point to net command
			; (used by ASSIGN)

	jmp	SENDnet ; send a block on the net
	jmp	RECnet	; receive a block from the net
	jmp	NACKpoll; don't ack polls
	jmp	ACKpoll ; ack polls
	jmp	PORTUout; user printer driver
	jmp	SETppa	; set poll-prime addr
	jmp	RECtime ; Set RECNET timeout

  .ife	OptHardAny,[jmp  HDstat]    ; local HD status
  .ifn	OptHardAny,[jmp  CallErr]

	jmp	NetHdStat	; master HD status
	jmp	SetNetMode	; Net Buf Usage
	jmp	SetListType	; AddsOpt type

				; HD software reset
  .ife	HardShare &OptHardAny,[jmp	InitHard]
  .ifn	HardShare &OptHardAny,[jmp	CallErr]

  .ife	WriteModes,[jmp MakeModeRequest]
  .ifn	WriteModes,[jmp CallErr]

	jmp	Describe
	]		; end ' Station '
  .page
;-------
;	**  Stand Alone Systems  **
;	   --------------------

  .ife	Alone,[
			; flush flop write buf
    .ife   OptFlopAny,[jmp	clrDDbuf]
    .ifn   OptFlopAny,[jmp	CallErr ]

	jmp	CALLerr ; --- not used ---
	jmp	CPMMAP	; logical to physical map
	jmp	CALLerr ; --- not used ---
	jmp	SETBYT	; set I/O byte count

	.byte	revision-200	; bios revision level
	.word	.	; --- not used ---

	jmp	CALLerr ; --- not used ---
	jmp	CALLerr ; --- not used ---
	jmp	CALLerr ; --- not used ---
	jmp	CALLerr ; --- not used ---
	jmp	PORTUout; user printer driver
	jmp	CALLerr ; no SETppa
	jmp	CALLerr ; no RECtime

  .ife	OptHardAny,[jmp  HDstat]    ; local HD status
  .ifn	OptHardAny,[jmp  CALLerr]

	jmp	CallErr ; no master HD status
	jmp	CallErr ; no Net Buf Mode for Alone
	jmp	CallErr ; no AddsOpt

			; hard disk software reset
  .ife	OptHardAny,[jmp InitHard]
  .ifn	OptHardAny,[jmp CallErr]

	jmp	CallErr ; no WriteModes
	jmp	Describe; machine description
	]		; end ' Alone '
  .page
  .sbttl	'Disk and Net command/status tables (b83defs.asm)'
;---------
; Floppy disk controller command and status

  .ife	OptFlopAny,[
fMFM	==	40h	; floppy double density bit
rdSDflop==	6	; read single density floppy
wrSDflop==	5	; write single density floppy
rdDDflop==	6 +fMFM ; read double density floppy
wrDDflop==	5 +fMFM ; write double density floppy
SenseInt==	08	; sense interrupt status

FLOPcom:.byte	0	; readFLOP or writeFLOP here
FLOPdsk:.byte	0	; curDSK
FLOPtrk:.byte	0	; curTRK
FLOPsid:.byte	0	; head address
FLOPsec:.byte	0	; curSEC
FLOPden:.byte	00h	; 128 byte sector

  .ife	FOXopt,[
MAXsec: .byte	sect5	; last sec number, 5 inch
FLOPgap:.byte	gap5	; gap length, 5 inch
	.byte	0	; sector size, 5 inch
	]		; end ' FOXopt '

  .ifn	FOXopt,[
MAXsec: .byte	sect8SD ; last sec number, 8 inch SD
FLOPgap:.byte	gap8SD	; gap length, 8 inch SD
	.byte	128	; sector size, 8 inch SD
	]		; end ' not FOX '

FLOPstat:.blkb	7	; floppy controller status
	]		; end ' either floppy '

;----------
; Harddisk controller command and status

  .ife	Hard8opt,[
readHARD	==	11h	; read a sector
writeHARD	==	12h	; write a sector
selHARD 	==	13h	; select a unit
flushHard	==	14h	; flush hard disk bufs
read1HARD	==	15h	; read 1K
assnHARD	==	17h	; assign a unit
statHARD	==	18h	; Get HD subsys status
HdFlushErr	==	31h	; error on auto flush
Hd8rts		==	51h	; ready_to_send_to_HDC
Hd8cts		==	52h	; clear_to_send_to_Host
Hd8unknown	==	0a1h	; HDC answer to bad cmd
Hd8dummy	==	#Hd8rts ; deliberately bad cmd
resetHard	==	0ffh	; reset hd dsk software

HARDcom:	.byte	0	; hard disk command
HARDdsk:
HARDsec:	.byte	0	; sector/drive number
HARDtrk:	.word	0	; track number
		.word	0	; - not used -
		.byte	RETRY	; retry count
		.byte	0	; - not used -
HARDstat:	.blkb	8	; HD controller status
	]			; end ' Hard8opt '

  .ife	Hard5opt,[
qHrd5		==	3	; IOBYTE bit 3 = 1
				; if Hard5 present
HighAlloc	==	0
MidAlloc	==	0
LowAlloc	==	3ch
	]			; end ' Hard5opt '
  .page
;
;----------
; Network station command and status
  .ife	NETopt,[

NETmsg: .byte	0	; response byte
NETcom: .byte	0	; command byte
NETdtn: .byte	0	; destination
NETsrc: .byte	0	; source
NETdesc:
NETdsk: .byte	0	; drive number
NETtrk: .word	0	; track number
NETsec: .byte	0	; sector number
NETvol: .byte	0	; volume number
NETdma: .word	0	; DMA address

	.loc	NETcom+1
NETnam: .blkb	8	; unit name
NETpsw: .blkb	6	; unit password

NETassn ==	NETnam	; put unit assignment here
lencom	==	15	; length of HiNet command
NETifo	==	NETnam	; put netinfo address here
	]		; end ' NETopt '

;------
; AddsOpt Terminal Print Control Sequence

  .ife	AddsOpt,[

; default to Adds Regent 25 emulation
AuxEna: .byte	'3',Esc ; ena print sequence
AuxDis: .byte	'4',Esc ; dis print sequence
	]		; end ' AddsOpt '
;
;---------
; Shared Hard Disk Status Buffer Address

  .ife	HardShare,[
HSTadr: .word	0fffh	; HDstat block address
	]
  .page
;----------
; More interrupt vectors
;
	.loc	(.+10h)&0FFF0h	; Locate on
				; 16 byte boundary
SIO2vect:
  .ife	AHEADopt,[
  .ife	AH3opt,  [
	.word	INTerr	; Port 3, out -- polled
	.word	INTerr
	.word	P3int	; Port 3, in
	.word	P3int
	]		; end ' AH3opt '

  .ifn	AH3opt,  [
	.word	INTerr
	.word	INTerr
	.word	INTerr
	.word	INTerr
	]		; end ' not AH3opt '
	]		; end ' AHEADopt '
;
  .ifn	AHEADopt,[
	.word	INTerr	; Port 3 out
	.word	INTerr
	.word	INTerr	; Port 3 in
	.word	INTerr
	]
;
  .ife	MASTopt,[.word PRNTint	; transmit ready
		 .word PRNTerr] ; ext st change
  .ifn	MASTopt,[.word INTerr	; port 2 output
		 .word INTerr]

	.word	INTerr		; Port 2 input
	.word	INTerr
  .page
  .sbttl	'type ahead buffer (b83defs.asm)'
;
;-------
; ++	Type-ahead  buffers	++
;	-------------------

  .ife	Station&AheadOpt,[
PORT0buf:.blkb	typeahead+1	; Port 0 input
	]

  .ife	AH3opt,[
PRT3buf:.blkb	typeahead+1	; Port 3 input
	]

  .ife	Station&AheadOpt,[
; Port 0 input typeahead pointers
nxtin:	.byte	0	  ; next input char
nxtout: .byte	typeahead ; next output char
	]

  .ife	AH3opt,[
; Port 3 input typeahead pointers
nxt3in: .byte	0
nxt3out:.byte	typeahead
	]
  .page
 .sbttl 'buffer and command status (b83defs.asm)'
;----------
; Network master command and status
  .ife	MASTopt,[
MASTsnd:.byte	0	; message sent to user
MASTcom:.byte	0	; command or message from user
MASTdtn:.byte	0	; destination
MASTsrc:.byte	0	; source

MASTdesc:
MASTdsk:.byte	0	; disk
MASTtrk:.word	0	; track
MASTsec:.byte	0	; sector
MASTvol:.byte	0	; HD drive (volume) #
MASTdma:.word	0	; DMA address

	.loc	MASTsnd
LOGresp:.blkb	1	; login request response
LOGnum: .blkb	1	; login users net number
LOGclk: .blkb	7	; login time for user
LOGser: .blkb	4	; serial num for user

	.loc	MASTcom
MASTnum:.blkb	1	; user number
MASTtim:.blkb	7	; login time
	
	.loc	MASTcom+1
SPOOLid:.blkb	1	; user job and block id
	
	.loc	MASTcom+1
MASTnam:.blkb	8	; user name
MASTpsw:.blkb	6	; user password

	.loc	MASTcom
LOGcom: .byte	0	; sent but not used now
LOGname:.blkb	8	; login users name
LOGpsw: .blkb	6	; login users password
LOGprom:.blkw	2	; user prom num in binary
LOGpt:	.blkb	1	; user product type
	]		; end ' master '

;----------
; Current floppy buffer information
  .ife	OptFlopAny,[
iobDESC:
iobDSK: .byte	0FFh	; disk	 for I/O operation
iobTRK: .byte	0FFh	; track  for I/O operation
iobPSEC:.byte	0	; sector for I/O operation 
iobSEC: .byte	0	; sector for I/O operation(log)

rdbDESC:
rdbDSK: .byte	0FFh	; disk	 of read buffer
rdbTRK: .byte	0FFh	; track  of read buffer
rdbPSEC:.byte	0	; sector of read buffer (phys)

wrbDESC:
wrbDSK: .byte	0FFh	; disk	 of write buffer
wrbTRK: .byte	0FFh	; track  of write buffer
wrbPSEC:.byte	0	; sector of write buffer (phys)
wrbSEC: .byte	0	; sector of write buffer (log)
	]		; end ' either floppy '

;----------
; Current network buffer information
  .ife	BUFFopt,[
netbDSK:	.byte	0FFh	; disk in buffer
netbTRK:	.word	0FFFFh	; track in buffer
netbSEC:	.byte	0FFh	; sector in buffer
netbVOL:	.byte	0FFh	; volume in buffer
netbMode:	.byte	0	; mode = 0,1 or 2
	]		; end ' BUFFopt '

;-----------
; Current XEBEC HD controller information
  .ife	Hard5opt,[
actDESC:
actDSK: .byte	0FFh	; init to illegal to show
actTRK: .word	0FFFFh	; we don't have valid data
actSEC: .byte	0FFh	; in the buffer before the
actVOL: .byte	0FFh	; the first actual read

hd5desc:
hd5dsk: .byte	0FFh	; init to illegal to show
hd5trk: .word	0FFFFh	; we don't have valid data
hd5sec: .byte	0FFh	; in the buffer before the
hd5vol: .byte	0FFh	; the first actual read
hd5dma: .word	0ffh
	]		; end ' Hard5opt '

;----------
; Current network spool information
  .ife	SPOOLopt,[
RespSpStart:	.byte	0	; start spool ack
SPOOLdsk:	.byte	0	; spool disk
SPOOLtrk:	.word	0	; spool track
SPOOLsec:	.byte	0	; spool sector
SPOOLvol:	.byte	0	; spool volume
SPsiz:		.byte	0	; spool size
	]		; end ' SPOOLopt '

;----------
; Current CP/M information
cpmDESC:	
cpmDSK: .byte	0FFh	; disk	 from CPM
cpmTRK: .word	0	; track  from CPM
cpmSEC: .byte	0	; sector from CPM
cpmVOL: .byte	0	; volume for NET r/w
cpmDMA: .word	80h	; DMA address from CPM
cpmBYT: .word	80h	; LENGTH of transfer from CPM

;-------------------------
; Deblocking data

LocType:	.byte	0	; local user wrType
wrTYPE: 	.byte	0	; from bdos

wrALLOC 	==	0	; group written prev
wrDIR		==	1	; write to directory
wrUNalloc	==	2	; never written prev

;-------------------------
; Implementation-specific parameter block
;  (option map, machine serial number, etc.)
; so user programs can refer to it safely
  .ife  MASTopt,[defprod = 1] ; default product
		[defprod = 0] ; master=1 else 0 
MachDesc:			
prodval:	
	.byte	defprod
	.byte	ostype
	.byte	version
	.byte	revision
	.byte	patch
	.byte	mod
serial: .blkb	4
	.byte	OPTM0
	.byte	OPTM8
	.byte	OPTM10
	.byte	OPTM18
	.byte	OPTM20
	.byte	OPTM28
	.byte	0ffh	; pass word byte
  .ifn	BootFlopAny,[		; needed for TRANSFER
	.word	dmavec
  .ife  config-3,[
	.word	0
	.word	0	] [
	.word	flopbusy
	.word	timemotor ]	; end 'config-3'
	.word	lockbyte
	.word	lockdma
	.byte	0,0,0	; reserved
	.word	0	; reserved for extensions
	]	; end ' BootFlopAny '
