  .page
  .sbttl	'CPMMAP get current disk map'
  .prntx	'made it to cpmmap'

; +++++++++++++++++++++++++++++++++++++++++++++++++++++
; +						      +
; +	Drive Mapping Tables			      +
; +						      +
; +	last modified>	23 oct 83 dsb		      +
; +						      +
; +++++++++++++++++++++++++++++++++++++++++++++++++++++
OPTM10	=   OPTM10 + (NumDisks<(DriveNum-10h))
;
;----------
; Get current disk map
; cpmMAP returns in HL the addr of the disk drive#
; or the partition unit #. This addr is also one
; less than the addr of the DPB for this drive or
; partition. If SELDSK has been called with a
; drive # of 0FFh it returns in HL a pointer to
; the warm boot device drive/partition #.
;
;  Regs in:   none
;  Regs out:  HL = pointer to unit # (DPBaddr-1)
;	      DE = pointer to DPH
;	      A  = unit number
;
cpmMAP:
	lda	cpmDSK	; get current disk number

  .ife	OptFlopAny,[
	jmpr	map1

iobMAP:
	lda	iobDSK	; get current flop disk #
map1:
	]		; end ' OptFlopAny '

	cpi	0FFh	; check for boot disk
	jrnz	map2
;
	lxi	H,DSKBOOT+2
	mov	A,M	; return boot unit# in a
	ret

map2:
	rlc
	rlc
	rlc
	rlc		; A = disk number * 16
	mvi	H,0
	mov	L,A	; HL <- disk # * 16
	lxi	D,DSKMAP; Disk param header array
	dad	D	; HL = addr of DPH
	push	H	; save addr of DPH
	lxi	D,10
	dad	D	; point to DPB addr
	mov	E,M
	inx	H
	mov	D,M
	dcx	D	; DE <- DPB addr - 1
	ldax	D	; get map byte
	pop	H	; restore DPH addr
	xchg
	ret
  .page
  .sbttl	'default logical to physical disk maps 2.2'
;----------
; Default logical to physical disk maps
;
;----------
; Warm boot disk
; In the def below, 0<8 is the unit #,
; and the byte whose symbolic name appears
; is the disk media type.
DSKBOOT:

  .ife	Flop8boot, [
	.byte	0	; HD drive (volume)
	.byte	DD	; media type
	.byte	0	; unit #
	]

  .ife	Hard8boot, [
	.byte	0
	.byte	HARD
	.byte	0
	]

  .ife	Hard5boot,[
	.byte	0
	.byte	fHard
	.byte	0
	]

  .ife	HARDshar, [
	.byte	0
	.byte	NET
	.byte	0
	]

  .ife	FLOPshar, [
	.byte	0
	.byte	0FFh	; not used
	.byte	0
	]

  .ife	Flop5boot, [
	.byte	0
	.byte	MINI2
	.byte	0
	]
  .page
  .sbttl	'Disk Parameter Headers'

;	-----	Disk Parameter Headers	 -----
; Drives A to P, depending on assembly choices
DSKMAP:

GenDisk =	0

  .ifg	NumDisks - GenDisk,[

DSK0:	
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb0	; disk parameter block
	.word	check0	; check vector
	.word	alloc0	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK1:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb1	; disk parameter block
	.word	check1	; check vector
	.word	alloc1	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK2:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb2	; disk parameter block
	.word	check2	; check vector
	.word	alloc2	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK3:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb3	; disk parameter block
	.word	check3	; check vector
	.word	alloc3	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '


  .ifg	NumDisks - GenDisk,[

DSK4:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb4	; disk parameter block
	.word	check4	; check vector
	.word	alloc4	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK5:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb5	; disk parameter block
	.word	check5	; check vector
	.word	alloc5	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK6:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb6	; disk parameter block
	.word	check6	; check vector
	.word	alloc6	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK7:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb7	; disk parameter block
	.word	check7	; check vector
	.word	alloc7	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK8:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb8	; disk parameter block
	.word	check8	; check vector
	.word	alloc8	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK9:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	DSKpb9	; disk parameter block
	.word	check9	; check vector
	.word	alloc9	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK10:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	dpb10	; disk parameter block
	.word	ckVc10	; check vector
	.word	alVc10	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK11:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	dpb11	; disk parameter block
	.word	ckVc11	; check vector
	.word	alVc11	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK12:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	dpb12	; disk parameter block
	.word	ckVc12	; check vector
	.word	alVc12	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK13:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	dpb13	; disk parameter block
	.word	ckVc13	; check vector
	.word	alVc13	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK14:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	dpb14	; disk parameter block
	.word	ckVc14	; check vector
	.word	alVc14	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '

  .ifg	NumDisks - GenDisk,[

DSK15:
	.word	sectab	; sector translate table
	.word	0,0,0	; scratch area
	.word	dirbuf	; directory buffer
	.word	dpb15	; disk parameter block
	.word	ckVc15	; check vector
	.word	alVc15	; allocation vector

GenDisk =	GenDisk + 1
	]		; end ' if valid drive '
block
	.word	ckVc15	; check vector
	.word	a