  .page
  .sbttl	'warm boot'
  .prntx	'made it to warm boot code'
	.reloc

; +++++++++++++++++++++++++++++++++++++++++++++++
; +						+
; +		Warm Boot Routine		+
; +						+
; +	last modified>	18 Oct 83 dsb		+
; +						+
; +++++++++++++++++++++++++++++++++++++++++++++++

;----------
; Warm boot
WBOOT:
;
	di
	lxi	SP,80h	; setup a stack pointer
	mvi	A,(vectors>8)&0FFh
	stai		; setup interrupt register
	im2
	ei		; enable interrupts
	mvi	A,0C3h	; setup jump to WBOOT at 0,1,2
	sta	0
	lxi	H,BIOS+3
	shld	1
	sta	30h	; setup jump to WBOOT at 30-32
	shld	31h
	sta	5	; setup jump to BDOS at 5,6,7
	lxi	H,BDOS
	shld	6

  .ife	MASTopt,[
	lxi	H,INTERUPT
	shld	LOCALtime+1	; Init INTERUPT jump
	]

  .ife	Station,[
	lxi	H,SETppa
	shld	BIOS+7Fh; Init SETppa jump
	lxi	H,PPAdefault
	shld	PPAadr	; Init poll-prime addr
	lxi	H,$4sec
	shld	Rtime	; Init RECNET timeout
;
	xra	a	; ensure dma is available
	sta	LockByte

; init NetBufMode to always use the 1k Net buf
    .ife	BuffOpt,[sta	netbMode]

	call	AckPoll ; ensure poll response
	]		; end ' Station '
;
;----------
; Warm boot from floppy
  .ife	BootFlopAny,[
	call	RESULT	; flush floppy controller
	call	clrDDbf ; flush double-density buffer
	mvi	C,0FFh
	call	SELDSK	; select boot disk
	call	HOME	; home boot drive
	mvi	C,3	; start at sector 3
	call	SETSEC
	lxi	B,CPM
	call	SETDMA	; start at base of CP/M

    .ife	Flop5boot,[lxi B,WBlen5]
    .ife	Flop8boot,[lxi B,WBlen8]

	call	SETBYT
	call	READ
	lxi	B,1
	call	SETTRK	; move to track 1
	mvi	C,1
	call	SETSEC	; start at sector 1

    .ife	Flop5boot,[lxi B,CPM+WBlen5]
    .ife	Flop8boot,[lxi B,CPM+WBlen8]

	call	SETDMA

    .ife	Flop5boot,[lxi B,lenCPM-WBlen5]
    .ife	Flop8boot,[lxi B,lenCPM-WBlen8]

	call	SETBYT
	call	READ
	lxi	B,128	; default DMA length
	call	SETBYT
	]	; end ' either floppy boot '
		; Next comes jump to CCP

;----------
; Warm boot from harddisk network or hard network
  .ife	HARDshar&BootHardAny,[
      .ife	  OptFlopAny,[call clrDDbuf]

    .ife HARDshar,[
	mvi	A,clrlockNET
	sta	NETcom
	call	NETreq	; clear all active locks

    .ife	SPOOLopt,[
	lda	SPOOLdsk
	ora	A	; check whether spooling active
	jrz	..ok	; jump if not active
;
	lxi	H,SPLmsg
	call	PRTMSG	; print spool message
	mvi	C,cntlZ
	call	PORTNout; flush spool buffer
..ok:	]		; end ' SPOOLopt '
	]		; end ' HARDshar'
 
	mvi	C,0FFh
	call	SELDSK	; select boot disk

	lbcd	yWarmTrack
	call	SETTRK

	lda	yWarmRecord
	mov	C,A
	call	SETSEC	; beginning sector

	lxi	B,128
	call	SETBYT

	lhld	yCPMbase
	lda	yNumCPMRecs
	mov	B,A
	call	READBLK

	jmpr	gotoCCP

yWarmTrack:  .word 0
yWarmRecord: .byte 0
yNumCPMRecs: .byte lenCPM/128
yCPMbase:    .word CPM

gotoCCP:	 ; Next comes jump to CCP
	]		; end ' HARDshare '

;----------
; Warm boot from floppy network
  .ife	FLOPshar,[

    .ifn	MASTopt,[
	call	ACKpoll
	mvi	C,1]	; slave on drive 1

    .ife	MASTopt,[
	mvi	C,0]	; master on drive 0

	call	SELDSK
	call	HOME
	mvi	C,3
	call	SETSEC
	lxi	B,128
	call	SETBYT
	lxi	H,CPM
	mvi	B,24	; read 24 sectors from track 0
	call	READBLK
	lxi	B,1
	call	SETTRK
	mvi	C,1
	call	SETSEC
	mvi	B,lenCPM/128-24; read rest of CP/M
	call	READBLK
	]		; end ' FLOPshare '
;
;---------------
; Jump to console command processor (CCP)
	lda	4
	mov	C,A	; get current disk number
;
  .ifn	Alone,	[jmp	CPM+3]	; dont exec cmd buf

  .ife	Alone,	[
	lxi	H,Mode		; cold/warm boot
	bit	modeCLDX,M	
	jz	CPM+3		; dont exec cmd buf
;
	res	modeCLDX,M	; warm boot next
	jmp	CPM		; exec ccp cmd buf
	]			; end ' Alone '
;
;----------
; Read consecutive sectors from a disk
;  Regs in:   HL = DMA address
;	      B  = number of sectors to read
;  Regs out:  none
;  Destroyed: A, BC, DE, HL
  .ife	BootHardAny&NETboot,[
READBLK:
	push	B	; save record count
	shld	cpmDMA

	call	READ
	lxi	H,cpmSEC
	inr	M	; increment record number
	mvi	A,129
	cmp	M	; check for sector too big
	jrnz	..ok
;
	mvi	M,1	; reset sect#
	lxi	H,cpmTRK
	inr	M	; increment track number
..ok:	lhld	cpmDMA
	lxi	D,128
	dad	D	; increment DMA address
	pop	B	; restore sector count
	djnz	READBLK
	ret
	]	; end ' Hard5 or Hard8 or Net boot '

	dad	D	; increment DMA address
	pop	B	; restore sector count
	djnz	READBLK
	ret
	]	; end '