.title	'Harddisk to tape backup utility '
	.sbttl	'CARTBACK'
	.ident	CARTBK
version	==	3
revision==	05 	; 05/23/83 Doug
patch	==	' '
	.pabs
	.phex
	.loc	100h
;----------
; Harddisk Backup Utility to tape
;
; Written by Robert Kavaler, June 1981
; Modified by Peter Kavaler, July 1981
; Modified by David Stein,   Aug  1981
; Version 2.1		     July 1982
;
; 1.0	(07/01/81)  Initial version
; 1.1	(07/13/81)  Reprogram ints after EXPAND
;		Unload floppy head before running
; 1.2		Conditional assembly added for DEBUG
;		option-Backup All runs indefinitely.
; 1.3 		Tape error messages installed.
;		Escape-to-restart option installed.
;		TPstat bytes now stored at 103h.
; 1.4           Infinite test loop now incorporates
;		backup and loading of all partitions
; 1.5,1.6
; 1.7		Modifications made to improve user
;		I/O during hard disk to tape backup.
;		*LIST command added to list out alloc
;		table.
; 1.8, 1.9      More user I/O improvements made for
;		the tape to hard disk loading sec-
;		tion. Fixed bug that stopped loading
;		onto a disk that had no alloc table.
;		Load command added: *LIST
; 2.0i		'Blocks written' message now printed
;  (09/04/81)  	after each partition is streamed
;		onto the tape. Partition name veri-
;		fication added to LOAD section.
;		'Blocks rewritten' message now will
;		be printed if 10h blocks per 100h 
;		are reported to have been rewritten.
;		The tricky algorithm is at BACKe.
;		Partitions now must be loaded onto
;		the hard disk under the same name
;		as the tape.
;
; 2.1 (7/82)	Brought this assembly file up to
;		date with the patched version 2.0m.
;		Implemented multiple hard disk code.
;		Fixed alloc/bst and eof/eot mixup.
;		Two eof marks are now written after
;		end-of-tape and end-of-tape-data.
;		Two new commands added:
;		"C" changes hard disk volumes
;		"F" backs up all partitions with
;		control bytes of 80h or higher (the
;		7th bit of the alloc control byte
;	   	must be high).
;		The HARDHELP code was removed 
;		from the skeleton due to the larger
;		size of CARTBACK and also because
;		HARDHELP has been rewritten and is
;		itself quite larger. Later versions
;		should re-incorportate the HARDHELP
;		feature.              D.Stein 7/82
;
; 3.00		The Hardhelp code was re-inserted
;		at 7A00h and is now an option ONLY
;		after startup.
;		Cartback now boots directly into
;		the monitor (at 4900h). See MONITOR:
;		The monitor (Cartmon) was exten-
;		sively modified.       D.Stein 7/82
;
; 3.01		Cartback is now more lenient.
;		Users are now allowed to have alloc
;		table entries that dont necessarily
;		match those on the tape. These
;		changes now reside in LOADall.
;		Cartback's main menu has been
;		spiffed up a tad, and the "Cartback
;		Construction" documentation (below)
;		was hopefully made more clear.
;					 D. Stein 9/82
; 3.02 01/18/83 Increased amount of memory read on
;		the tape from memory. *Cart was not
;		read on the tape completly.  Also
;		added code to talk to a 46 meg disk.
;		Messages for alloc table question
;		and BST question reversed.  DB
;
; 3.03 02/24/83	Add code so a Cartback LOAD to disk 
;		from tape will work on a disk that has
;		been formatted with CTRL x.  Used .page
;		to help organize the program.  Write a
;		table of contents.  Doug
;
; 3.04 02/28/83 Eliminate the ERASE if the user selects
;		the LOAD option.  Add code so user can
;		not load Cartback from network
; 3.05 05/23/83 Install Hardhelp.com version 3.80 in
;		Cartback.  New version number so we can
;		tell which version the cust uses. DRB
.page
;
;            CONSTRUCTION OF THE CARTBACK PROGRAM
;
;     The CARTBACK program has four parts:
;
;1.  CARTBACK - Cartridge backup and restore program.
;2.  HARDHELP - Hard disk format and diagnostic program.
;3.  CARTMON  - A small 1K monitor used to select which
;               program should be executed.
;4 DDT,BIOӠ-  simpl operatin syste unde whic
;               CARTBACK is always executed.
;
;    Memory Map:
;
;  0 	 - FFh	: CPM area (perm)
;  100h  - 48FFh: CARTBACK (3000h+ is unused)
;  4900h - 4CFFh: 1K monitor (this program)
;  4D00h - 4DFFh: 0-100 (when compressed, temp)
;  4E00h - 79FFh: DDT, CPM, BIOS (when compressed)
;  7A00h - C500h: HARDHELP (initially) & Buffer space
;  D400h - FFFFh: DDT, CPM, BIOS (perm)
.page
;******************************************************
;*                                                    *
;*              DANGER! WARNING! WATCHOUT!            *
;*                                                    *
;*  Cartback Runs under the CP/M 1.4 Operating System.*
;* Upon booting, Cartback expands itself over the ex- *
;* isting O/S and proceeds to use its own. Also, since*
;* Cartback is so large, DDT (not ZDTI) must be used. *
;*                                                    *
;******************************************************
;
;I  modificatio ha bee mad t jus th CARTBAC,
;CARTMON, or HARDHELP files then this procedure should
;be followed:
;
;A>ddt cartback.com ;load in complete cartback program
;DDT
;-ifilename.hex     ;overlay new hex code
;-r  <-- use appropriate address from earlier Mem map!
;-^C     (don't forget 100h offset if it applies)
;A>save 195 newCback.com  
;
;     Thfil CARTBACK.CO cabcreatefroscratc
;b followin thi procedure:
;
;A>ddt
;DDT 1.4
;-mD400,FFFE,4E00    ; get a copy of DDT,BDOS,BIOS
;-m0,FF,4D00         ; get a copy of 0h-0FFh
;-a6B03
;6B03  jmp 4900      ; jump to monitor on warm boot
;-ihardhelp.com
;-r7900              ; load HARDHELP at 7A00h
;-icartmon.hex
;-r                  ; load CARTMON  (at 4900h)
;-icartback.hex
;-r                  ; load CARTBACK
;-^C
;A>save 195 cartback.com
.PAGE
cr	==	0Dh	; carriage return
lf	==	0Ah	; linefeed
ctrlC	==	03h	; abort
ctrlH	==	08h	; backspace
del	==	07Fh	; delete
DMA	==	38h	; DMA data port
PIOAD	==	08h	; PIO channel A, data
PIOBD	==	09h	; PIO channel B, data
HARD	==	01h	; hard disk data port
TAPE	==	02h	; cassette tape port
STROBE	==	00h	; strobe for tape status
BDOS	==	5	; address of BDOS call
DEBUG	==	1	; We dont use debug anymore
			; 2/24/83 debug code removed
bell	==	7h
noera	==	1	; set value for loadflg
usernum	==	47h
	JMP	MONITOR	; Get Monitor addr and jump
	JMP	START	; Jump into Cartback FROM
			; the monitor
; Vital statistic storage area.
; From DDT enter: -D100
;----------
; Tape status bytes - See archive manual
	.ascii	'TP STAT'
TPstat:	.byte	0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	
;----------
; Version 2.1 addition
; Flag for enabling code in GObkALL to backup
;only those partitions with the 7th bit of
;their control byte HIGH. (High=enable=on)

ctrlflg:.byte	00h
.page
;------------
; We arrive here from beginning execution at 100h.
; This routine calculates the cold boot entry point
; of the Cartback Monitor (Cartmon at 4900h) and
; jumps there. (Right now its 4903h, but you never
; know...)
MONITOR:
	lxi	sp,stack; always a stack
	mvi	B,00	; stall a few msec
	djnz	.	; then 
	lda	usernum
	cpi	0FFh	; user # is FFh is standalone
	jrz	..ok	; so ok to use cartback
	lxi	H,nonet$ ;ELSE, network, can not
	call	prtmsg	; use Cartback
	jmp	0
..ok:	sub	A	; OK to use Cartback
	out	PIOBD	; unload floppy head.
	di		; Cant allow interupts, yet
	lda	2
	stai
	call	EXPAND	; Set up the OS
	lhld	1	; Get BIOS wb addr which
	inx	H	; (skip the C3 instruction)	
	mov	E,M	; holds the wboot addr
	inx	H	; of the Monitor.
	mov	D,M	; DE = addr of wboot entry
			; addr into the monitor.
	xchg		; HL = above
	inx	H	; Cboot monitor entry point
	inx	H	; is 3 bytes in from wboot.
	inx	H
	pchl		; Jump into Monitor's
			; cold boot code.
.page
START:
;----------
; Set the stack
	lxi	SP,stack
	di
;----------
; Create OS
	call	EXPAND
	lda	2
	stai		; use new BIOS int vectors
;
; Note:  The chips which might generate interrupts
;        must be re-programmed so that they are
;	 compatible with CP/M 1.433, because CARTBACK
;	 executes only under 1.433, which comes "built
;	 in" with the program.
CTC0	==	30h
	mvi	A,50h
	out	CTC0	; timer int
PIOAC	==	0Ah
	mvi	A,5Ah
	out	PIOAC	; front-panel int
PIOBD	==	09h
	sub	A
	out	PIOBD	; unload floppy head
SIO1BC	==	2Bh
	mvi	A,2
	out	SIO1BC
	mvi	A,30h
	out	SIO1BC	; type-ahead int
	ei
	lhld	1	; Setup DMA vector at
	mvi	L,0	; base of BIOS
	mvi	M,DMAdone&0FFh
	inx	H
	mvi	M,(DMAdone>8)&0FFh
.page
;-----------
;Greet the user
	lxi	H,hello$
	call	prtmsg	; greet the user
	call	READst  ; read in 4 32-bype buffers
			;from HDC
selHD:	
	call	selVOL	; select harddisk vol, get
	mvi	A,0	; disk size from controller
	sta	HARDtrk ; program. Store # of tracks
	sta	HARDhead ;and read-write heads
	mvi	A,1	; setup to read alloc and BST
	sta	HARDsec	; tables from HD
	lxi	H,iobuff
	call	READh	; read alloc and bad sec table
;
; Determine the type of hard disk we are on.
; Load our max track value from the 128 byte volume
; info buffer at volbuffr. The x register points
; the start of the 32 byte buf we are currenly using.
	mov	A,vlitype(x)
	lxi	H,size8	; possibly print 8" message
	cpi	11	; sects/trk on 8 inch disk
	jrz	..ok
	cpi	23	; sects per trk on 46 meg
	jrz	..ok
	lxi	H,size14; possibly print 8" message
	cpi	17	; sects/trk on 14 inch disk
	jrz	..ok
	lxi	H,badctl$ ; Bad controller program
	jmp	ERROR
;
..ok:	call	PRTMSG	; print hard disk size
	lxi	H,vl2msg
	call	PRTMSG
	lda	volnum	; print the volume number, too.
	adi	'0'
	mov	C,A
	call	CONOUT
.page
; Load our max track and sector info from the 128 byte
; volume info buffer at volbuffr. The x register points
; the start of the 32 byte buf we are currenly using.

	mov	A,vlitracks(x)
	sui	3	; mate with our max trk
	sta	maxtrk	; tracks in volume
	mov	A,vlitype(x)
	sta	maxsec	; sectors per track
	mov	A,vlisize(x)
	sta	maxhead	; heads per track
;
; Ask user what he/she wants to do
SELASK:
	sub	A	; turn off ctrl byte flag
	sta	ctrlflg	; (explained below)
	sta	loadflg ; set loadflg to zero
	lxi	H,vl1msg
	call	PRTMSG	; print "current volume" msg
	call	prtlabel
	lxi	H,select$ ; Selection menu.
	call	PRTMSG	; print his options
..ask:	call	INSTRING
	lda	conbuf
	cpi	'B'	; check for backup
	jz 	GObackup; backup from disk to tape
	cpi	'F'	; backup alloc-control-byte
	cz	..setflg; set the control flag and
	jz	GObkALL	; back-up-all does rest.
	cpi	'L'	; load
	jz	GOload	; load from tape to disk
	cpi	'A'	; backup all
	jz	GObkALL
	cpi	'D'	; Display cur alloc tbl?
	push	PSW	; save our zero flag
	cz	ALLOC	; possibly read in alloc table
	pop	PSW
	push	PSW
	cz	prtALCtbl ; print out alloc tbl
	pop	PSW	
	jz	SELASK	; restart if we printed
	cpi	'C'	; C means change volume
	jrnz	..error
.page
; User wants to change current Hdisk selection
	lxi	h,volask$ ; ask user for volume number
	call	PRTMSG
	call	INSTRING  ; get string from console
	lda	conbuf
	sui	30h	  ; make vol num numeric
	push	PSW	  ; save volume number
	cpi	4	  ; Is is possibly valid (0-3)?
	jrnc	..badvol  ; No. Print error message.
	call	setvolptr ; Yes.Set x to new vol inf
	mov	A,vlipresent(x)	; FF means valid volume
	cpi	0FFh	  ; Is this a valid volume?
	jrnz	..badvol  ; Oops. No.
	pop	PSW	  ; Yes. Restore and save
	sta	volnum	  ; the new volume number.
	jmp	selHD	  ; and re-select our volume.
..badvol:
	pop	PSW	  ; Rebalance the stack,
	lxi	H,badvol  ; bad volume select
	call	prtmsg
	mvi	C,bell
	call	CONOUT	  ; let the
	jmp	selHD	  ; user start again.
..error:lxi	H,error$
	call	PRTMSG
	jmpr	..ask
..setflg:
	lxi	H,ctrlflg ; This flag (high)  enables
	mvi	M,0FFh	  ; code in GObkALL that allows
	ret		  ; back up of only those par-
			  ; titions that have the 7th
			  ; bit of their control-byte
			  ; high.
.page
;----------
; Backup from disk to tape

GObackup:
	call	MNTWRT	; mount a writeable tape
	call	GETDATE	; get the date and time
	call	ALLOC	; read alloc table
	lxi	H,backw$; warn and wait for 1st wr
	call	waitCR
	call	BACKsys ; backup the system (P ,0)
NEXTbackup:
	lxi	H,part$
	call	PRTMSG
	call	INSTRING; get partition name
	lxi	H,conbuf
	lxi	D,name%
	lxi	B,8
	ldir		; save partition name for later
	mvi	B,8	; prepare for compares
	lxi	D,name%	; to name
	lxi	H,end$	; check for *END
	call	STRCOMP
	jnz	BACKend
	lxi	H,blnk$	; check for <CR>
	call	STRCOMP
	jnz	NEXTbackup; ask again if <CR>
	lxi	H,list$	  ; check for *LIST
	call	STRCOMP
	cnz	prtALCtbl ; destroys HL!
	jnz	NEXTbackup; ask again
;----------
; Backup a partition
	call	FINDPART; find partition name
	ora	A
	jrnz	..foundpart
	lxi	H,nopart$
	call	PRTMSG	; tell the user he goofed
	jmpr	NEXTbackup
..foundpart:
	mov	B,A	; set up parameters
	mov	C,M	; to BACKdisk
	call	BACKdisk; call it
	jmpr	NEXTbackup; and loop
GObkALL:call	MNTWRT  ; mount a writeable tape
	call	GETDATE
	call	ALLOC
	lxi	H,backa$; wait for verify
	call	waitCR
.page
	call	BACKsys	; backup the system
	jmp	BACKall	; backup entire disk and get
			; next selection
MNTWRT:	lxi	H,newt$	; selectable message
	call	NEWTAPE	; mount a new tape
	call	RDSTAT	; read the status
	lda	TPstat	; make sure it is writeable
	bit	4,A
	rz
	lxi	H,writp$; print error message
	call	PRTMSG
	jmpr	MNTWRT	; and loop
GETDATE:lxi	H,date$
	call	PRTMSG
	call	INSTRING; get date
	lxi	H,conbuf
	lxi	D,date%
	lxi	B,8
	ldir		; save date for later
	lxi	H,time$
	call	PRTMSG
	call	INSTRING; get time
	lxi	H,conbuf
	lxi	D,time%
	lxi	B,5
	ldir		; save time for later
	ret
;--------------
BACKsys:
	call	COMPRESS; first compress the OS
	lxi	B,8	; name is *CART
	lxi	D,name%
	lxi	H,cart$
	ldir
	lxi	H,96	
	shld	numWRblk; 62 is number of blocks
			; that will be written.
	mvi	A,'P'	; type is 'P'
	sta	size%
	call	BACKmem
	lxi	B,8	; name of part0 is *PART0
	lxi	D,name%
	lxi	H,part0$
	ldir
	lxi	B,0<8+1	; set up params to BACKdisk
	call	BACKdisk
	ret
.page
BACKall:
	lxi	H,ALLOCtab+16; back up all partitions
	mvi	B,1	; B is start block number
..loop:	mov	A,M	; M is length
	ora	A
	jrz	BACKend	; 0 is end
;-------------
; Ver. 2.1 option! If ctrlflg is high (not zero) then
; the last byte of this entry (the control byte) is
; checked for a 7th-bit-high condition.  A "high"
; indicates back-up-flag high.  A "low" entry is
; skipped.
	push	PSW	; save the size
	lda	ctrlflg ; load our enbl/dsbl flg
	ora	A	; 0 = disabled
	jrz	..cont	; skip test if disabled.
	push	H	; load alloc tbl addr
	pop	y	; load into y register
	mov	A,15(y)	; get 15th byte into A
	bit	7,A	; no Zflg = high = backup
	jrz	..next	; Zflg = skip this one.
..cont:	pop	PSW	; restore the size
	mov	C,A	; set up param to BACKdisk
	push	PSW	; save regs
	push	H
	push	B
	push	B
	inx	H	; move in name
	lxi	B,8
	lxi	D,name%
	ldir
	pop	B
	call	BACKdisk; backup
	pop	B	; restore regs
	pop	H
..next:	pop	PSW
	add	B	; inc start
	mov	B,A
	lxi	D,16	; skip entry
	dad	D
	jmpr	..loop
;----------
; End of BACKUP tape
BACKend:
	mvi	A,wrfmTP; write second file mark
	call    SENDCMD
	lxi	H,allwr$; print all written
	call	PRTMSG
	call	REMTAPE ; remove the tape
	jmp	SELASK	; backup another tape
.page
;----------
; Backup from B length C
BACKdisk:
	push	B	; save params
	mov	H,B	; calculate start block
	mvi	L,1
	call	CVTblk
	pop	B
	mov	H,C	; calculate length
	mvi	L,0
	shld	DSKxfr	; disk
	dad	H
	shld	TAPxfr	; and tape
	shld	numWRblk; for info mess when done
	call	CVTsize	; set size
	call	BACKb	; write tape header
	call	initQ	; initialize the queue
	call	RDHstrt ; start disk read
	jmpr	..1
..loop: lda	Qcond	; if queue has 2 consecutive
	sui	(Qlen>9)-1 ; even boundried blocks
	jp	..1
	lhld	DSKxfr	; and there are disk blocks
	mov	A,H	; left to read
	ora	L
	jrz	..1
	in	PIOAD	; and ready to read from 
	bit	4,A	; hard disk
	cnz	RDHnext	; then read disk block
..1:	lda	Qcond	; check for empty queue
	ora	A
	jrz	..loop  ; if so, maybe end
	call	ckstat	; check if READY or EXCEPTION
	.word	..tpo	; if either, do the output
	.word	..tpo
	jmpr	..loop	; else try the hard disk
..tpo:	call	WRTnext ; if Q not empty & ready
	jrnz	..loop	; returns 0 if done
	jmpr	BACKe	; end the backup
;
BACKmem:
	call	BACKb	; write tape header
	lxi	H,100h	; start xfr at 100h
..loop:	push	H	; save addr
	call	wrblk	; write it
	pop	H
	push	H
	lxi	D,0C100h ;value on 512 byte boundary
	ora	A	; test for end of xfr
	dsbc	D
	pop	H
	jrz	BACKe
	lxi	D,512	; next 512 bytes
	dad	D
	jmpr	..loop	; and loop
;
BACKb:	lxi	H,info%	; print header
	call	PRTMSG	
	mvi	A,wrTAPE; send write command
	call	SENDCMD
	lxi	H,info%	; 1st block on tape is info
	call	wrblk
	ret
;--------------
; Finished
BACKe:	mvi	A,wrfmTP; write a file mark
	call	SENDCMD
	CALL	RDSTAT	; read our status bytes
	lxi	H,done$	; print 'BLOCKS WRITTEN :'
	call	PRTMSG	;
	lxi	H,numWRblk+1
	mov	A,M
	push	H
	call	prtbyt
	pop	H
	dcx	H
	mov	A,M
	call	prtbyt
	lxi	H,endmsg
	call	prtmsg  ; print how many bytes written
;Check if any blocks were rewritten.  If so, then print
;out status information.
	lhld	numWRblk  ; HL = num of block writes
	mvi	B,4	  ; loop count
	sub	A	  ; reset carry
..loop:	srar	H
	rarr	L	  ; HL = num of acceptable
	djnz	..loop	  ; block rewrites.
	lded	TPSTAT+2  ; DE = num of block rewrites
	mov	A,D
	mov	D,E	  ; DE stored halfass backwards
	mov	E,A
	ora	A
	dsbc	D	  ; HL-DE <0 ? 
	cc	prtWRbyts ; Tell user how many rewrites
			  ; & overruns if too many 
	ret		  ; rewrites.  Return.
.page
;--------------
; Load from tape to disk
GOload:
	mvi	A,noera ; set a flag so erase is
	sta	loadflg	; is not available
	call	ALLOC	; read alloc table
	lxi	H,loadt$
	call	NEWTAPE	; load a new tape
	call	RDThead	; skip first file (*CART)
	call	RDTeof
LOADlp:	lxi	H,postp$; print position question
	call	PRTMSG
	call	INSTRING; get answer
	lxi	H,conbuf; save it
	lxi	D,name%
	lxi	B,8
	ldir
	mvi	B,8	; length is 8
	lxi	D,name%
	lxi	H,end$	; is it *END
	call	STRCOMP
	jrnz	..end
	lxi	H,rwnd$	; is it *REWIND
	call	STRCOMP
	jrnz	..rwnd
	lxi	H,all$
	call	STRCOMP	; is it *ALL
	jrnz	..all
	lxi	H,next$	; is it *NEXT
	call	STRCOMP
	jrnz	..next	; search for next partition
	lxi	H,part0$
	call	STRCOMP	; is it *part0
	jrnz	..part0
	lxi	H,blnk$	; is it blank (cr)
	call	STRCOMP
	jrnz	LOADlp  ; ask again if only cr
	lxi	H,list$	  ; check for *LIST
	call	STRCOMP
	cnz	prtALCtbl ; destroys HL!
	jnz	LOADlp	  ; ask again
	
..scan:	lxi	H,LDvfy$; ask user if tape scan desired
	call	askYNq	; Get yes or no answer
	cpi	'Y'	; Search the tape?
	jnz	LOADlP	; No. Go back to main menu
..doscan:		; Yes. Search the tape
	lxi	H,scantp$
	call	prtmsg	; tell user were scanning
	call	RDThead ; read a header
	jrz	..eot	; check for no header
	lxi	D,namer%; is it *CART
	lxi	H,name%	
	mvi	B,8
	call	STRCOMP
	jrnz	..found	; if so continue
..skip:	call	RDTeof	; skip to EOF
	jmpr	..doscan
..rwnd:	call	REMTAPE	; rewind the tape
	jmp	LOADlp	; and loop
..next:	call	RDThead	; just read the header
	jrnz	..found	; check for EOT
..eot:	lxi	H,noprt$; tell user partn not found
	call	PRTMSG	; and continue into ..end
..end:	call	REMTAPE	; remove the tape
	jmp	SELASK	; and rewind and newtape
..all:	call	RDThead	; read our 1st header
	jmp	LOADall	; and start loading everything
..part0:call	REMTAPE	; rewind the tape
	call	RDThead	; read *cart header
	call	RDTeof	; and pass it by.
	call	RDThead	; read *part0 header, fall thru
..found:lxi	D,name%	; make sure name is in name%
	lxi	H,namer%
	lxi	B,8
	ldir
	lxi	H,crlf$
	push	H
	call	prtmsg	; space down and
	lxi	H,infor%; print the header
	call	PRTMSG
	pop	H
	call	prtmsg	; and space down again
..ask:	lxi	H,ldflq$; ask if file to be loaded
	call	askynq	; ask user
	cpi	'N'	; NO, position again
	jrz	..N
	cpi	'Y'	; Load just this file?
	jrnz	..ask	; bad entry, ask again
	lxi	H,tpload$ ; tell user were loading
	call	prtmsg
	jmpr	LOADfile  ; and lets go and load.
..N:	lxi	H,skiptp$
	call	prtmsg	; tell user were advancing
	call	RDTeof	; read to end of file
	jmp	LOADlp
.page
;----------
; Load a single file
LOADfile:
	call	LOAD	; try the load
	jrnz	..done	; if successful, get next
	lxi	H,nopart$ ; else error, and try
	call	prtmsg  ; (print ALLOC tbl info)
..done:	jmp	LOADlp	; get next user command
;---------------
; Load all files to end of tape
LOADall:
	lxi	H,ldall$; print a message
	call	PRTMSG
..loop:	lxi	D,name%	; move namer% to name%
	lxi	H,namer%
	lxi	B,8
	ldir
	lxi	H,infor%; print info again
	call	PRTMSG
	call	LOAD
	jrz	..nopart; if zero then no partition
	call	RDThead	; read next file
	jrnz	..loop	; loop if there
	lxi	H,etmsg$; print ending message
	call	PRTMSG	
	call	REMTAPE	; remove the tape
	jmp	SELASK	; get next command
..nopart:
	lxi	H,noptn$; no partition message
	call	PRTMSG
	jmpr	..loop  ; keep trying to load.
.page
;---------------
; Load a file on tape to name% partition
LOAD:
	mvi	B,8	; check for *PART0
	lxi	D,name%
	lxi	H,part0$
	call	STRCOMP
	jrnz	..p0
	call	FINDPART; if not, find in alloc
	ora	A	; First byte 0, end of table
	rz		; return if 0.
	jmp	LOADM	; ELSE, load it using LOADM
..p0:	lxi	H,16	; read allocation table
	call	CVTblk
	lxi	H,oldalc ;Alloc table off disk
	call	READh
	lxi	H,17	; and bad sector table
	call	CVTblk
	lxi	H,oldbst ;BST off disk
	call	READh
	lxi	H,qbst$	; ask bst question
	call	askynq
	sta	bstynq
	lxi	H,qalc$	; ask alloc load question
	call	askynq
	sta	alcynq
	lxi	H,crlf$
	call	prtmsg	  ; and space down a line
	lxi	H,ALLOCta ; start at top of alc table
	sub	A	  ; start is A=0
	call	LOADM	  ; now load
	lda	alcynq	  ; check load old alc
	cpi	'Y'
	jrz	..1
	lxi	H,16	; write allocation table
	call	CVTblk
	lxi	H,oldalc
	call	WRITEh
..1:	lda	bstynq	; check load old bst
	cpi	'Y'
	jrz	..2
	lxi	H,17	; write bad sector table
	call	CVTblk
	lxi	H,oldbst
	call	WRITEh
..2:	call	del5sec	; delay 5 seconds
	out	0	; reset harddisk controller
	call	selVOL	; re-select current volume
	call	ALLOC	; reread ALLOC
	mvi	A,0FFh	; return nz
	ora	A
	ret
.page
del5sec:	; Delay 5 seconds to flush controller
	sub	A	
..1:	push	PSW	
	lxi	H,0FFFFh ; count from FFFF down to 0000
..2:	dcx	H	 ; in inner loop 
	mov	A,L	 
	cpi	0
	jrnz	..2
	ora	H
	jrnz	..2
	pop	PSW	 
	inr	A	 ; count from 0 to 11
	cpi	11	 ; in outer loop
	jrc	..1
	ret		 ; and return
.page
;---------
; Main part of LOAD (LOADM)
LOADM:
	push	PSW	; save starting block #
	mov	H,M	; get length
	mvi	L,0	; *256 =
	shld	DSKxfr	; this is # of 1K blocks
	dad	H	; twice as many 512 byters
	shld	TAPxfr	; this is # of 512 byters
	call	CVTsize	; set size
	pop	PSW	; restore block addr
	mov	H,A
	mvi	L,1
	call	CVTblk	; compute starting THS
	lxi	H,sizer%; compare partition sizes
	lda	size%
	cmp	M	; must be equal, if yes,
	jrz	..cont	; continue,
	lxi	H,ALLOCtab; ELSE, warn user and
	lxi	H,badpart$
	call	PRTMSG	  
	lxi	H,waitmsg
	call	waitCR	 
	jmp	loadlp    ; get next load command.
;
..cont:	mvi	A,wrHARD; send fake write to start
	call	CMDHARD
	lxi	H,0
	lxi	B,1024
	call	SENDHARD
	call	initQ	; initialize the queue
..loop:	lda	Qcond	; write disc if 2 blocks
	cpi	2	; in queue
	jm	..1
	in	PIOAD	; and disk is ready
	bit	4,A
	cnz	WRHnext
..1:	lhld	TAPxfr	; check if end of tape
	mov	A,H
	ora	L
	jrz	..2	; if so check for end
        lda	Qcond	; read tape if queue is
	cpi	Qlen>9	; not full
	jrz	..loop
	call	ckstat	; and is tape ready?
	.word	..rdy	; Yes. Keep loading.
	.word	..EXC	; Trap possible EOT.
	jmpr	..loop	; No. wait until ready
..rdy:	call	RDTnext	; do the read
	jrz	..EXC	; Zflg = read error or EOT
	mvi	B,100	; wait
	djnz	.
	jmpr	..1
.page
..2:    lda	Qcond	; if end of tape and
 	ora	A	; queue is empty then stop
	jrnz	..loop
	call	RDTeof	; flush the tape
	call	WRHres	; read final result
	lxi	H,done2$
	call	PRTMSG	; tell user partition written
 	mvi	A,0FFh
	ora	A
	ret		; and return non-zero
;------------------
; Unexpected exception-line raise occurred. This COULD
;be a end of tape or a short tape error. We read for
;two file marks.  If they're received, its end of
;tape.  Otherwise, its an error condition.
;Identical code appears in LOADm.
..EXC:	lda	TPstat
	bit	0,A	; 0 hold file-mark-detected bit
	jrz	..err	; means maybe EOT.
	call	RDTeof	; read the 2nd eof.
	lda	TPstat	; Was it there?
	bit	0,A
	jrz	..err	; NO. This is a short tape.
	call	EOT	; Yes. Mount next tape
	jmpr	..rdy	; and continue loading.
..err:	lxi	H,TSFerr; Handle a tape error.
	jmp	rdERROR

.page
;---------
; Memory Management COMPRESS and EXPAND
;
COMPRESS:
	lxi	B,100h	; setup 0-100h
	lxi	H,0
	lxi	D,4D00h
	ldir
	lxi	B,2C00h	; setup DDT, BDOS, BIOS
	lxi	H,0D400h
	lxi	D,4E00h
	ldir
	ret
EXPAND:
	lxi	B,100h
	lxi	H,4D00h
	lxi	D,0
	ldir
	lxi	B,2C00h
	lxi	D,0D400h
	lxi	H,4E00h
	ldir
	ret
.page
;--------------
; Read the allocation table and compute block
; lengths
ALLOC:
	lxi	H,16	
	call	CVTblk	; compute track, head, sector
	lxi	H,ALLOCta
	call	READh	; read allocation table
	lxi	H,ALLOCta
	mov	A,m	; First byte of Alloc table
	cpi	0	; If = 0, stuff 1 there
	jrnz	..ok
	mvi	m,1	; 1 is stuffed
..ok:	lxi	D,16
	mvi	B,0	; B = cumulative block count
..alloc:
	mov	A,M	; get partition size
	ora	A
	jrz	..end	; jump if at end of table
	stc
	mvi	C,0	; compute C = partition blocks
..rot:	ralr	C
 	dcr	A
	jrnz	..rot
	mov	M,C	; change size to # blocks
	mov	A,B
	add	C	; increment total block count
	mov	B,A
	dad	D	; move to next partition
	jmpr	..alloc
..end:	mov	A,B	; save final length
	sta	ALClen
	ret
.page
;---------------
; Search ALLOC table for partition name match
;  Regs out:  A  = 0 if partition not found
;	      A  = starting block #
;	      HL = address of ALLOC entry
FINDPART:
	lxi	H,ALLOCtab
	mvi	B,0	; first block is 0
..next:	mov	A,M	; check for end-of-table
	ora	A
	rz
	mov	C,B	; this block starts at C
	add	B	; calculate starting block
	mov	B,A	; remember as B
	push	B
	inx	H
	lxi	D,name%
	mvi	B,8	; compare 8 bytes
	call	STRCOMP
	pop	B	; restore block #
	jrnz	..equal
;
; Match not found, so continue searching
	lxi	D,7	; move to next entry
	dad	D
	jmpr	..next
;
; Match found, so return entry address
..equal:
	lxi	D,9
	ora	A	; clear C flag
	dsbc	D
	mov	A,C
	ret
.page
;----------
; Convert block number to track, head, sector
;  Regs in:    HL = block number
;  Destroyed:  All
CVTblk:
	lda	MAXsect
	mvi	B,0
	mov	C,A
	call	DIVIDE	; compute blockno/sects
	mov	A,L	; sector = remainder
	ora	A
	jrnz	..ok
	lda	MAXsect
	dcx	D
..ok:	sta	HARDsec
	lda	MAXhead
	mov	C,A
	ana	E	; head = low bits of result
	sta	HARDhead
	xchg
	mvi	B,0
	inr	C
	call	DIVIDE	; compute track
	mov	A,E
	sta	HARDtrk
	ret
.page
;---------
; Subroutine prtALCtbl: Print DAT from memory.
; Regs  in:	none (PSW non zero)
; Regs out:	none (PSW non zero)
; Destroyed:	All 
; Halt if a size value of 0 is found.
; Print the 63rd listing always.
prtALCtbl:

	mvi	A,0
	sta	unit      ; re-initialize 
	lxi	H,crlf$
	call	prtmsg
	lxi	H,HEADmsg
	call	prtmsg	  ; print table header
	lxi	H,ALLOCta
..1:	call	prtline	  ; print a table line
	jrz	..2	  ; print 63rd line if
			  ;end of table found
	lda	unit
	inr	A  	  ; increment the line
	sta	unit
	cpi	63
	jrnz	..1
..2:	mvi	A,63
	sta	unit
	lxi	H,ALLOCta+(63*16) ; addr of 63rd entry
	call	prtline    ; print 63rd listing
	lxi	H,crlf$
	call	prtmsg	   ; space down
	ora	H	   ; return non zero
	push	PSW	   ; save non-zero status
 	lxi	H,waitmsg   ; wait for user to
	call	waitCR	   ; finish looking at
	pop	PSW	   ; table before 
	ret		   ; returning.
.page
;--------------
; Subroutine prtline: print one line of DAT
; Regs  in:	HL=addr in the allocation table
; Regs out:	HL=next addr in the allocation table
;Destroyed:	A,B,C
;
prtline:
	mov	A,M	;Test this entry, if first
	cpi	0	;is 0, this is end of table
	rz		;so return.
	shld	tabladr	;ELSE, store current addr
	lxi	H,crlf$ ; space down a line
	call	prtmsg	
	lxi	H,space4 ; space over 4 spaces
	call	prtmsg	
	lda	unit	; unit number in A
	call	cvtbcd  
	call	prtbyt	; print the unit number
	lxi	H,space4
	call	prtmsg	; space over 4
	lhld	tabladr	; restore current addr
	mov	A,M	; get the size in A
	call	prtbyt	; print the size
	lhld	tabladr
	inx	H	; get to name addr
	mvi	B,8
	call	dochr	; print 8 chr name
	mvi	B,6
	call	dochr	; print 6 chr password
	push	H
	lxi	H,space4
	call	prtmsg	; just space over 4
	pop	H
	mov	A,M
	call	prtbyt
	lhld	tabladdr
	inx	H	; next addr in table
	ora	H	; return non-zero
	ret
;---------------
; "Hard-to-follow but Byte-mizing" Routines
dochr:	push	H
	push	B
	lxi	H,space4
	call	prtmsg		; space over 4 spaces
	pop	B
	pop	H
	call	prtchr
	shld	tabladr
	ret
.page
;----------
; Subroutine prtchr: Print chars to console
; Regs  in:	B =length of string
;		HL=addr of string
; Regs out:	HL=addr right after string
;Destroyed:	A,B,C
;
prtchr:
	mov	A,M
	ora	A	; is char a null ( 0 )?
	jrnz	..1	; No.
	mvi	A,' '	; Yes. Print a blank out.
..1:	mov	C,A	; char goes out in C
	push	H
	push	B
	call	CONOUT
	pop	B	; save our counter
	pop	H
	inx	H	; next chr addr
	djnz	prtchr
	ret
;--------------
; Subroutine cvtbcd: Convert a byte to BCD
; Regs  in: 	A=character to be converted to BCD
; Regs out:	A=BCD character
; Destroyed:	Any,all
;
cvtbcd:	ora	a
	rz		; return. No conversion needed
	mov	B,A	; hex byte in B
	sub	A	; start out A at 0
..1:	adi	01	; step up A while down
	daa		; counting B.
	djnz	..1	
	ret		; return when B=0
;---------------
; Set size% from TAPxfr
CVTsize:
	lda	TAPxfr+1; get msb of size
	rar		; divide by 2
	mvi	B,0	; start at 0
..loop:	inr	B	; add one for each shift
	rar	
	jrnc	..loop
	mov	A,B	; add '0'
	adi	'0'
	sta	size%	; store as size
	ret
.page
;-----------------
; Subroutine newtape:  Handle new tape
; Reg in:  HL = ASCII Message
;
NEWTAPE:
	call	PRTMSG
..ask:	call	INSTRING; get response
	call	RESETT	; reset the controller
	call	RDSTAT
	lda	conbuf	; A = response
	cpi	'R'	; look it up
	jrz	..rwd
	cpi	'T'
	jrz	..ret
	push	PSW
	lda	loadflg	; If enter from LOAD, you
	cpi	noera	; can not erase
	jrz	..no
	pop	PSW
	cpi	'E'	; ELSE, see if erase
	jrz	..era
..no:	lxi	H,error$; print error
	call	PRTMSG
	jmpr	..ask
..rwd:	mvi	A,rwdTAPE ; rewind command
	jmpr	..pos
..ret:	mvi	A,retTAPE ; retension command
	jmpr	..pos
..era:	mvi	A,eraTAPE ; ERASE command
..pos:	call	SENDCMD	; send the command
..loop:	call	ckstat	; loop until done or error
	.word	..done
	.word	..err
	jmpr	..loop
..done:	ret		; return if no error

..err:	call	RDSTAT	; if error, read the status
	lxi	H,notap$; no tape, probably
	call	PRTMSG
	lxi	H,loadt$
	jmpr	NEWTAPE	; ask again
;---------------
; Remove a tape, rewind it first.
REMTAPE:
	mvi	A,rwdTAPE ; send rewind command
	call	SENDCMD
	call	RDSTAT	; read the status
	ret
.page
;---------------
; Read tape header
RDThead:
	mvi	A,rdTAPE; send read command
	call	SENDCMD
	lxi	H,iobuff; iobuff is buffer
	call	rdblk	; read a block
	ret		; pass back A as status
;---------------
; Skip to next file on tape
RDTeof:
	lxi	H,Qstrt	; read into Qstrt
	call	rdblk	; read a block
	jrnz	RDTeof	; loop until eof
	ret
;---------------
; Read next block on tape (into queue)
RDTnext:
	call	putQ	; put this block on queue
	call	rdblk
	rz		; RETURN zero if ERROR.
	lhld	TAPxfr	; decrement # of blocks
	dcx	H
	shld	TAPxfr
	ori	0FFh	; Return non-zero if no error.
	ret
;---------------
; Write next block on tape (from queue)
WRTnext:
	call	getQ	; get a block address
	call	wrblk
	lhld	TAPxfr	; decrement # of blocks
	dcx	H
	shld	TAPxfr
	mov	A,H	; set Z flag
	ora	L
	ret
.page
;-----------------
; Routines for TAPE
RESETT:
	in	STROBE	; strobe RESET
	mvi	A,11010b
	out	TAPE
	in	STROBE
	mvi	A,11011b
	out	TAPE
	ret
;---------------
; Check READY and EXCEPTION, return to first
; parameter if READY, second if EXCEPTION
; continue if neither
ckstat:
	pop	H	; get return addr.
	in	STROBE	; read status
	in	TAPE
	bit	1,A	; check READY
	jrz	..rdy
	bit	2,A	; check EXCEPTION
	jrz	..exc
	inx	H	; skip params
	inx	H	
	inx	H
	inx	H
	pchl		; return
..exc:	inx	H	; skip first parameter
	inx	H
..rdy:	mov	A,M	; get lsb
	inx	H
	mov	H,M	; get msb
	mov	L,A	; move in lsb
	pchl		; go to the routine
.page
;--------------
SENDCMD:
	push	PSW	; save the command
..wait:	call    ckstat  ; loop until READY or EXCEPT
	.word   ..cont
	.word   ..cont
	jmpr	..wait
..cont:	in	STROBE
	mvi	A,11011b
	out     TAPE    ; set up RR protocol
	pop	PSW	; restore the command
	cma		; active low
	out	TAPE	; send command to buffer
	in	STROBE
	mvi	A,11001b
	out 	TAPE	; assert REQUEST
..loop:	in	STROBE	; loop until READY
	in	TAPE
	bit	1,A
	jrnz	..loop
	in	STROBE
	mvi	A,11011b
	out     TAPE  	; turn REQUEST off
	mvi	B,32	; wait for 100 Usec
	djnz	.
	ret		; return
;---------------
RDSTAT:
	mvi	A,stTAPE; send the command
	call	SENDCMD ; to get status
	lxi	H,TPstat; set up to read 6 status
	mvi	B,6	; bytes
..1:	in	STROBE	; wait for READY
	in	TAPE
	bit	1,A
	jrnz	..1
	in	TAPE	; read the status byte
	cma		; active low
	mov	M,A	; store it
	in	STROBE	; assert REQUEST
	mvi	A,11001b
	out     TAPE    ; assert REQUEST
..2:	in	STROBE	; wait for READY not
	in	TAPE
	bit	1,A
	jrz	..2
	in	STROBE	; assert REQUEST not
	mvi	A,11011b
	out	TAPE
	inx	H	; next byte
	djnz	..1
	mvi	B,8	; wait for 20 Usec
	djnz	.
	ret		; return
.page
wrblk:	
	push	H	; HL is address
..loop: call    ckstat  ; loop until READY
	.word   ..cont
	.word   wrex	; if EXCEPTION, then error
	jmpr	..loop
..cont:	pop	H	; restore HL
	shld	wrtadr	; save it
	in	STROBE
	mvi	A,01011b; clear XFER-ACK FF
	out	TAPE
	in	STROBE
	mvi	A,10011b
	out	TAPE	; XFER-ACK protocol

	mvi	A,7	; multiplex STATB to DMA
	out	8
	lxi	H,DMAwrt; set up DMA chip
	lxi	B,lenwrt<8+DMA
	outir		; run the DMA
	jmp	WAITdma
;---------------
rdblk:	
	push	H	; save HL
..loop:	call	ckstat	; loop for READY
	.word	..cont
	.word	rdex	; EXCEPTION implies error
	jmpr	..loop
..cont:	pop	H	; restore HL
	shld	rdtadr	; put it into DMA
	in	STROBE	; XFER-ACK protocol
	mvi	A,10011b
	out	TAPE
	
	mvi	A,7	; multiplex STATB to DMA
	out	8
	lxi	H,DMArdt; set up DMA chip
	lxi	B,lenrdt<8+DMA
	outir		; run the DMA
	call	WAITdma
	mvi	A,0FFh	; return non-zero
	ora	A
	ret
.page
;----------
; Exception during write : EOT or error
wrex:
	call	RDSTAT	; get the status
	lda	TPstat	; check for EOT
	bit	3,A	; 
	jrnz	..eot
	pop	H	 ; rebalance stack
	lxi	H,TRUWerr; unrecoverable tape write err
	jmp	wrERROR
..eot:	mvi	A,wrfmTP; write a file mark
	call	SENDCMD
	mvi	B,100
	djnz	.	; wait
	mvi	A,wrfmTP; and write another one.
	call	SENDCMD
	lxi	H,eot$	; print a message
	call	PRTMSG
	call	REMTAPE	; remove the tape
	call	MNTWRT  ; mount a new tape
	mvi	A,'-'	; continuation is '-'
	sta	size%
	call	BACKb	; write tape header
	pop	H	; pop previous block
	jmp	wrblk	; and continue
;---------------
; Exception during read : EOF or error
rdex:
	call	RDSTAT	; read the status
	lda	TPstat
	bit	3,A	; look for EOT ;**Never occurs!
	jrnz	EOT
	bit	0,A	; then EOF
	jrnz	..eof
	pop	H	 ; rebalance stack
	lxi	H,TRURerr; unrecoverable tape read err
	jmp	rdERROR
..eof:	sub	A	; return A=0 for EOT
	pop	H	; remove HL from stack
	ret
.page
;--------------
; Subroutine: 	EOT
; Regs in: 	none
; Regs out:	none
; Arrive here when two file marks encountered after
;a short partition encountered during a LOAD operation.
; Mount and verify next (continuation) tape and return
;to LOADM.
;
EOT:	lxi	H,eot$	; get next TAPE
	call	PRTMSG
..ng:	call	REMTAPE
	lxi	H,loadt$
	call	NEWTAPE
	mvi	A,rdTAPE; read the new tape
	call	SENDCMD
	lxi	H,infor%; read new info%
	call	rdblk
	lxi	H,crlf$	; print crlf
	call	PRTMSG
	lxi	H,infor%; print new info
	call	PRTMSG
	lda	sizer%	; size should be -
	cpi	'-'
	jrz	..ok	; and it is.
	lxi	H,badtp$; Oops. Incorrect tape.
	call	prtmsg	; tell user
	jmpr	EOT	; and ask again.
..ok:	lxi	H,reld$ ; ask if corect tape
	call	PRTMSG
	call	CONIN	; get answer
	cpi	cr
	jrz	..ret	; if cr then return
	call	RDTeof	;
	jmpr	..ng	; and ask again.
..ret:	lxi	H,crlf$
	call	PRTMSG	; space down
	ret		; and return to LOADM
;--------------
 Selec th volum (default t 0 ca b changed
;by the user through the C commmand). VOLsel is the
;command byte, VLselstr is the command string that is
;copied into HARDcom and sent to the HDC.  Volnum is
;contained in the VLselstr string.
selVOL:
	lxi	H,VLselstr ; eight byte sel string
	lxi	D,HARDcom ; eight byte HDC string
	lxi	B,8	 ; load the string
	LDIR
	mvi	A,VOLsel ; send the command
	call	CMDHARD		
	lda	volnum
	call	setvolptr ; point the x register to
	ret		; current volumes buffer
.page
;--------------
; Read 1K from the harddisk put result in queue
;
RDHnext:
	call	RESHARD
	call	putQ	; HL -> block
	push	H
	call	putQ	; make it 1k
	pop	H
	push	H	; save HL again
	lxi	B,1024
	call	RECHARD
 	call	NEXTh	; inc THS
	pop	H	; see if write past end
	mov	A,H	; of Queue
	cpi	(Qstrt+Qlen-512)>8
	jrnz	RDHstrt	; if not, then init. read
	lxi	B,512	; if so, move upper 512 bytes
	lxi	D,Qstrt ; into bottom of Queue
	lxi	H,Qstrt+Qlen
	ldir
RDHstrt:
	lhld	DSKxfr	; don't read past end
	mov	A,H
	ora	L
	rz 
	mvi	A,8Ah	; 10 retries with ECC
	sta	HARDret
	mvi	A,rdHARD; start next read
	call	CMDHARD
	ret	
;----------         
; Read 1K from harddisk
;  Regs in:   HL = Input buffer address
;  Regs out:  A  = Nonzero if disk error
READh:
	push	H
	mvi	A,8Ah	; 10 retries with ECC
	sta	HARDret
	mvi	A,rdHARD	
	call	CMDHARD
	call	RESHARD
	pop	H
	lxi	B,1024
	call	RECHARD
	sub	A
	ret
;----------         
; Read volume info into HDC status buffer
;  Regs in:   none
;  Regs out:  none
READst:
	mvi	A,volSTAT	
	call	CMDHARD
	call	RESHARD
	lxi	H,volbuffr
	lxi	B,128
	call	RECHARD
	sub	A
	ret
.page
; Write 1K block from queue onto Harddisk
;
WRHnext:
	call	WRHres	; get hard result
	call	getQ	; get 1K block
	push	H
	call	getQ
	pop	H
	push	H
	mov	A,H	; see if read past end of
	cpi	(Qstrt+Qlen-512)>8
	jrnz	..wrt	; queue
	lxi	B,512	; if so, move lower block up
	lxi	H,Qstrt	; so that 1K is continuous
	lxi	D,Qstrt+Qlen
	ldir
..wrt:	mvi	A,0Ah	; 10 retries and no verify
	sta	HARDret
	mvi	A,wrHARD; send write command
	call	CMDHARD
	pop	H	; send data to be written
	lxi	B,1024
	call	SENDHARD
	call	NEXTh
	ret
WRHres: call	RESHARD	; just get result
	ret
;----------
; Write 1K to HARDDISK
;  HL is input buffer
WRITEh:
	push	H
	mvi	A,8Ah	; 10 retries with reread
	sta	HARDret
	mvi	A,wrHARD
	call	CMDHARD
	pop	H
	lxi	B,1024
	call	SENDHARD
	call	RESHARD
	ret
;----------
; Move to next track, head, sector
;  Regs out:  A = nonzero if beyond last sector
NEXTh:
	lxi	H,HARDsec
	lda	MAXsect
	cmp	M
	jrnz	..inr	; jump to increment sector
	mvi	M,1	; reset to sector 1
	dcx	H
	lda	MAXhead
	cmp	M
	jrnz	..inr	; jump to increment head
	mvi	M,0	; reset to head 0
	dcx	H
..inr:	inr	M	; increment track, head, sector
	lhld	DSKxfr	; decrement disk blocks
	dcx	H
	shld	DSKxfr
	ret		; return with OK status
.page
;----------
; Send a block to the harddisk controller
;  Regs in:   HL = block address
;	      BC = byte count
;  Regs out:  none
;  Destroyed: all
SENDHARD:
	mov	A,B
	ora	A
	jrnz	..SENDmany
	mov	B,C	; Send fewer than 256 bytes	
	mvi	C,HARD	; so use status loop
..wait:	in	PIOAD
	bit	3,A
	jrnz	..wait
	outi
	jrnz	..wait
	ret
;
..SENDmany:	; Send > 256 bytes, use DMA chip
	shld	wrhadr	; DMA address
	dcx	B
	sbcd	wrhlen	; DMA length - 1
	mvi	A,4	
	out	PIOAD	; multiplex DMA to harddisk
	lxi	H,DMAwrh
	lxi	B,lenwrh<8+DMA
	outir		; program DMA chip
	jmp	WAITDMA	; wait for DMA completion
.page
;----------
; Receive a block from the harddisk controller
;  Regs in:   HL = block address
;	      BC = byte count
;  Regs out:  none
RECHARD:
	mov	A,B
	ora	A
	jrnz	..RECmany
	mov	B,C	; Receive fewer than 256 bytes
	mvi	C,HARD  ; so use status loop
..wait:	in	PIOAD
	bit	4,A
	jrz	..wait
	ini
	jrnz	..wait
	ret
;
..RECmany:	; Receive > 256 bytes, use DMA chip
	shld	rdhadr	; DMA address
	dcx	B
	sbcd	rdhlen	; DMA length - 1
	mvi	A,5	
	out	PIOAD	; multiplex DMA to harddisk
	lxi	H,DMArdh
	lxi	B,lenrdh<8+DMA
	outir		; program DMA chip
	jmp	WAITDMA	; wait for DMA completion
.page
;----------
; Send a command to the harddisk controller
;  Regs in:   A = command byte
;  Regs out:  none
;  Destroyed: all
CMDHARD:
	sta	HARDcom
..flush:in	HARD
	mvi	A,51h	; "request to send"
	out	HARD
..wait: in	PIOAD	; wait for response
	bit	4,A
	jrz	..wait
	in	HARD
	cpi	52h
	jrnz	..flush ; retry if not "clear to send"
	lxi	H,HARDcom
	lxi	B,8
	jmpr	SENDHARD; send command
;----------
; Receive status from the harddisk controller
;  Regs in:   none
;  Regs out:  none
;  Destroyed: all
RESHARD:
	lxi	H,HARDstat
	lxi	B,8
	call	RECHARD
	lda	HARDstat+7
	ora	A	; ZF high means no error
	cnz	HDerr	; handle hard disk error
	ret
.page
;---------------
; Routines to handle QUEUE
;
; Initialize the QUEUE
initQ:
	lxi	H,Qstrt	; init the pointers
	shld	putQp	; to start
	shld	getQp
	sub	A	; length is zero
	sta	Qcond
	ret
;--------------
; Put block into QUEUE
;  returns HL -> address
putQ:
	lda	Qcond	; check for full queue
	cpi	Qlen>9
	jrz	Qerr
	inr	A	; queue is 1 bigger
	sta	Qcond
	lhld	putQp	; get pointer
	push	H
	call	incp	; inc the pointer
	shld	putQp
	pop	H	; restore pointer
	ret
;---------------
; Get block from QUEUE
;  returns HL -> address
getQ:
	lda	Qcond	; check for empty queue
	ora	A
	jrz	Qerr
	dcr	A	; queue is 1 smaller
	sta	Qcond
	lhld	getQp	; get pointer
	push	H
	call	incp	; inc the pointer
	shld	getQp
	pop	H	; restore pointer
	ret
;---------------
; Increment and mod the pointer
;  HL is argument
incp:
	lxi	D,512	; add 512
	dad	D
	mov	A,H	; mod it
	sui	Qstrt>8
	ani	(Qlen>8)-1
	adi	Qstrt>8
	mov	H,A
	ret
Qerr:	rst	6	; stop here
.page
;----------
; Wait for an interrupt from the DMA chip
WAITDMA:
	sub	A
	sta	DMAflag
	ei		; make sure interrupts enabled
..wait:	lda	DMAflag
	ora	A
	jrz	..wait
	ret
;----------
; Process an interrupt from the DMA chip
DMAflag:.byte	0	; non-zero signals DMA complete
DMAdone:
	push	PSW
	mvi	A,0C3h
	out	DMA	; reset the DMA chip
	sta	DMAflag	; signal DMA completion
	pop	PSW
	ei
	ret
;----------
; Divide HL by BC, put result in DE and remainder in HL
;  (Use a very simple algorithm - speed isnt important)
DIVIDE:
	lxi	D,0
	ora	A
..div:	dsbc	B	; subtract BC from HL
	jrc	..ret
	inx	D	; increment result each pass
	rz
	jmpr	..div
..ret:	dad	B	; compute correct remainder
	ret
;----------
; Process a general error. Rewind tape,jump back to CPM
ERROR:
	call	PRTMSG	; print the error
	call	REMTAPE	; remove the tape
	jmp	0	; go back to CPM
.page
;----------
; Routine:	rdERROR
; Regs  in:	none
; Regs out:	none
; Print out an error header, then analyze the 1st 2
;status bytes and print out error messages for respec-
;tive high bits. Bit 7 of both bytes is used as a flag
;to indicate whether any of the other bits are set.
;Next, the tape status bytes themselves are printed.
;The next two bytes of the tape status are then dis-
;played - this is a 16 bit counter of soft read errors.
;The last two bytes of the tape status are then dis-
;played - this is a 16 bit counter of read buffer
;underruns.  See the ARCHIVE manual for details.
; The routine concludes by jumping to CPM (00h).
rdERROR:
	lxi	H,TRURerr ; Print 'READ' err msg
	call	prtmsg
	call	dispERR   ; Print what type of err(s)
	call	prtRSTAT  ; Print error statuses
	JMP	0	  ; and go back to CPM
;
prtRSTAT:	;Display the 2 status bytes to console
	call	prtSTb	; print 1st 2 status bytes
	lxi	H,..sofmsg ; Print soft read
	call	prtmsg	   ; error message.
	lxi	H,TPstat+2 ; addr of 1st byte of 
	mov	A,M	   ; Data error counter
	push	H
	call	prtbyt	
	pop	H
	inx	H
	mov	A,M
	call	prtbyt	   ; Print num of soft
			   ; read errors.
	lxi	H,endmsg
	call	prtmsg	   ; and space down.
	lxi	H,..urunmsg; Print read buffer
	call	prtmsg	   ; underruns message.
	lxi	H,TPstat+4 ; addr of 1st byte of 
	mov	A,M	   ; underrun error counter
	push	H
	call	prtbyt	
	pop	H
	inx	H
	mov	A,M
	call	prtbyt	   ; Print # of underrun errs
	lxi	H,endmsg
	call	prtmsg	   ; and space down.
	ret
..sofmsg:.ascis	[cr][lf]'Soft read errors: '
..urunmsg:
	.ascis	[cr][lf]'Read buffer underruns: '
.page
;----------
; Routine:	wrERROR
; Regs  in:	none
; Regs out:	none
; Print out an error header, then analyze the 1st 2
;status bytes and print out error messages for respec-
;tive high bits. Bit 7 of both bytes is used as a flag
;to indicate whether any of the other bits are set.
;Next, the tape status bytes themselves are printed.
;The next two bytes of the tape status are then dis-
;played - this is a 16 bit counter of block rewrites.
;The last two bytes of the tape status are then dis-
;played - this is a 16 bit counter of extended gaps.
;See the ARCHIVE manual for details.
; The routine concludes by jumping to CPM (00h).
wrERROR:
	lxi	H,TRUWerr ; Print 'WRITE' error msg
	call	prtmsg
	call	dispERR	  ; Print what type of err(s)
	call	prtWSTAT  ; Print statuses
	JMP	0	  ; and jump back to CPM
prtWSTAT:
	call	prtSTb	  ; print 1st 2 status bytes
prtWRbyts:
	lxi	H,..rewrmsg ; Print soft read
	call	prtmsg	   ; error message.
	lxi	H,TPstat+2 ; addr of 1st byte of 
	mov	A,M	   ; Data error counter
	push	H
	call	prtbyt	
	pop	H
	inx	H
	mov	A,M
	call	prtbyt	   ; Print # of soft read ers
	lxi	H,endmsg
	call	prtmsg	   ; and space down.
	lxi	H,..urunmsg; Print read buffer
	call	prtmsg	   ; underruns message.
	lxi	H,TPstat+4 ; addr of 1st byte of 
	mov	A,M	   ; underrun error counter
	push	H
	call	prtbyt	
	pop	H
	inx	H
	mov	A,M
	call	prtbyt	   ; Print # of underrun errs
	lxi	H,endmsg
	call	prtmsg	   ; and space down.
	ret
..rewrmsg:.ascis  [cr][lf]'Blocks rewritten: '
..urunmsg:.ascis [cr][lf]'Extended gaps: '
.page
HDerr:
	lxi	H,DISKerr
	call	PRTMSG
	lxi	H,..strmsg
	call	PRTMSG
	lxi	H,HARDstat
	mvi	B,8
..prtstat:
	mov	A,M
	push	H
	push	B
	call	prtbyt
	mvi	C,' '
	call	CONOUT
	pop	B
	pop	H
	inx	H
	djnz	..prtstat ; prt 8 HDC status bytes
	ret
..strmsg:.ascis	[cr][lf]'HDC status bytes: '
.page
;----------
; Subroutine	dispERR
; Regs  in:	none
; Regs out:	none
; Find and print print error type.
dispERR:
	lda	TPstat	  ; tape status byte number 0
	bit	7,A	  ; Is error held in this byte?
	jrz	..byt1test; No. Test stat byte 1
	bit	6,A
	lxi	H,CARTerr
	cnz	prtERR    ; Cartridge not in place
	bit	5,A
	lxi	H,DRIVerr
	cnz	prtERR    ; Drive not on line
	bit	2,A
	lxi	H,DATAerr
	cnz	prtERR    ; Unrecoverable data error
	bit	1,A
	lxi	H,BIEerr
	cnz	prtERR    ; BIE not located
	lxi	H,ERbyt0info
	call	prtmsg	  ; print closing info 
..byt1test:
	lxi	H,TPstat+1; get 2nd status byte
	mov	A,M	  ; into the accumulator
	bit	7,A	  ; Is error held in this byte?
	rz		  ; No. No more to do.
	bit	6,A
	lxi	H,COMerr  ; Illegal command
	cnz	prtERR
	bit	5,A
	lxi	H,NODATerr; No data detected
	cnz	prtERR
	bit	0,A
	lxi	H,RESerr
	cnz	prtERR	  ; Reset occurred
	lxi	H,ERbyt1info
	call	prtmsg	  ; print closing info
	ret		  ; and were done.
.page
;----------
; Subroutine 	prtSTb
; Print 1st 2 status bytes
prtSTb:
	lxi	H,..0statmsg
	call	prtmsg
	lda	TPstat
	call	prtbyt
	lxi	H,endmsg
	call	prtmsg
	lxi	H,..1statmsg
	call	prtmsg
	lda	TPstat+1
	call	prtbyt
	lxi	H,endmsg
	call	prtmsg
	ret
..0statmsg:
	.ascis	[cr][lf]'Tape status byte 0: '
..1statmsg:
	.ascis	[cr][lf]'Tape status byte 1: '
;----------
; Print a message on the console
; Terminate on encountered sign bit.
;  Regs in:   HL = address of message
;  Regs out:  none
;  Destroyed: all
PRTMSG:
	mov	A,M
	bit	7,A	; test for sign bit
	mov	C,A
	jrnz	..lstchr
	push	H
	call	CONOUT
	pop	H
	inx	H
	jmpr	PRTMSG
..lstchr:
	res	7,C	; turn off sign bit
	jmp	CONOUT	; print last chr and return.
.page
;----------
; Print an error message on the console
;  Regs in:   HL = address of message
;  Regs out:  none
;  Destroyed: all
prtERR:
	push	PSW	; save tape status
	call	prtmsg
	pop	PSW
	ret		; restore tape status
;----------
;		Subroutine: prtbyt
; Regs  in:	A=byte to be printed
; Regs out:	none
; Destroyed:	A,B,C
;Print a byte on the console
prtbyt:
	push	PSW	; save the chr
	rlc
	rlc
	rlc
	rlc
	call	prtnbl
	pop	PSW
	call	prtnbl
	ret
prtnbl:	ani	0Fh
	adi	'0'
	mov	C,A	; chr goes out in C
	cpi	'9'+1
	jc	CONOUT
	adi	'A'-('9'+1)
	mov	C,A	; chr goes out in C
	jmp	CONOUT
;--------------
; Wait for a cr to be typed
;
waitCR:	call	PRTMSG	; print message
..loop:	call	CONIN	; read a char
	cpi	cr	; loop if not cr
	jrnz	..loop
	ret		; return if cr
;----------
; Ask yes/no question
;
askynq:	call	PRTMSG	; print message
	call	INSTRING
	lda	conbuf
	cpi	'Y'	; 'Y' and 'N' are valid
	rz
	cpi	'N'
	rz
	lxi	H,error$; else error
	jmpr	askynq	; and loop
.page
;----------
; Input a string from the console
;
lencon	==	10	; buffer length
	.byte	lencon,0
conbuf:	.blkb	lencon  ; console buffer
INSTRING:
	lxi	D,conbuf-2; let BDOS do work
	mvi	C,10
	call	BDOS
	lxi	H,conbuf; convert lower to upper
	lda	conbuf-1; case
	mov	B,A
	ora	A
	jrz	..fill
..lp1:	mov	A,M
	call	CVTluc
	mov	M,A
	inx	H
	djnz	..lp1
..fill:	lda	conbuf-1; fill rest of buffer
	sui	lencon
	neg	
	rz  
	mov	B,A
..lp2:	mvi	M,' '
	inx	H
	djnz	..lp2
	ret
;----------
; Compare two strings for equal
;  Regs in:  B = length
;	     HL -> string1
;	     DE -> string2
;  Regs out: HL -> after string1
;	     DE -> string2
;	     Z-flag  cleared if equal
;	     A = 0FFh if equal 0 else
STRCOMP:
	push	B
	push	D
	mvi	C,0FFh
..cmp:	ldax	D
	cmp	M
	jrz	..same
	mvi	C,0	; not the same
..same:	inx	D
	inx	H
	djnz	..cmp
	mov	A,C
	ora	A	; set Z-flag
	pop	D
	pop	B
	ret
.page
;---------
; get character from console (using BDOS) then
; convert lower to upper case.
; Abort on CTRL-C, restart on ESC
CONIN:	mvi	C,1	; command 1
	call	BDOS	; read a char
	cpi	ctrlC
	jz	0	; abort if ctrlC
	cpi	1Bh
	jz	SELASK	; restart if ESC
	call	CVTluc	; convert to upper case
	ret		; and return
;---------
; print char in C (using BDOS)
;
CONOUT:	push	PSW	; save A
	mov	E,C	; char is in C
	mvi	C,2	; command 2
	call	BDOS	; print the char
	pop	PSW	; get A back
	ret		; thats all
;
CVTluc:	cpi	'a'	; convert upper to lower case
	jm	..up
	cpi	'z'+1
	jp	..up	
	sui	'a'-'A'
..up:	ret
;---------------
; Subroutine setvolptr	 Set the x register to point
;			 to the next volume in volbuff
; Reg in: A  =volume number to set x pointer to
; Reg out: x = addr of volume info
; Destroyed: A,DE,HL
;
setvolptr:
	mvi	B,5
..mult:	slar	A	;A = A*32 = offset
	djnz	..mult
	mov	E,A
	mvi	D,0
	lxi	H,volbuffr ; addr of vol info buffer
	dad	D	;HL points to vol info pointer
	push	H
	pop	x	;x points to start of vol info
	ret		;for current volume
.page
;---------------
; Subroutine prtlabel:  Print the volume label
; Reg in:  None
; Reg out: None
; Destroyed: A
;
prtlabel:
	mvi	C,' '
	call	conout
	mo	C,vlivollabel(x)
	call	conout
	mov	C,vlivollabel+1(x)
	call	conout
	mov	C,vlivollabel+2(x)
	call	conout
	mov	C,vlivollabel+3(x)
	call	conout
	mov	C,vlivollabel+4(x)
	call	conout
	mov	C,vlivollabel+5(x)
	call	conout
	mov	C,vlivollabel+6(x)
	call	conout
	mov	C,vlivollabel+7(x)
	call	conout
	mov	C,vlivollabel+8(x)
	call	conout
	mov	C,vlivollabel+9(x)
	call	conout
	mvi	C,' '
	call	conout
	ret		; volume label printed
.page
;----------
; DMA commands
;
; Read 512 bytes from tape to memory
DMArdt:
	.byte	0C3h
	.byte	0C7h
	.byte	0CBh
	.byte	7Dh
rdtadr:	.word	0	; DMA address
	.word	511	; DMA length - 1
	.byte	14h
	.byte	28h
	.byte	95h
	.byte	TAPE
	.byte	12h
	.byte	0	; DMA vector
	.byte	9Ah
	.byte	0CFh
	.byte	1
	.byte	0CFh
	.byte	0ABh
	.byte	87h
lenrdt	==	.-DMArdt
;----------
; Write 512 bytes from memory to tape
DMAwrt:
	.byte	0C3h
	.byte	0C7h
	.byte	0CBh
	.byte	79h
wrtadr:	.word	0	; DMA address
	.word	511	; DMA length - 1
	.byte	14h
	.byte	28h
	.byte	95h
	.byte	TAPE
	.byte	12h
	.byte	0	; DMA vector
	.byte	92h
	.byte	0CFh
	.byte	5
	.byte	0CFh
	.byte	0ABh
	.byte	87h
lenwrt	==	.-DMAwrt
.page
;----------
; Read 1K from harddisk to memory
DMArdh:
	.byte	0C3h
	.byte	0C7h
	.byte	0CBh
	.byte	7Dh
rdhadr:	.word	0	; DMA address
rdhlen:	.word	0	; DMA length - 1
	.byte	14h
	.byte	28h
	.byte	95h
	.byte	HARD
	.byte	12h
	.byte	0	; DMA vector
	.byte	9Ah
	.byte	0CFh
	.byte	1
	.byte	0CFh
	.byte	0ABh
	.byte	87h
lenrdh	==	.-DMArdh
;----------
; Write 1K from memory to harddisk
DMAwrh:
	.byte	0C3h
	.byte	0C7h
	.byte	0CBh
	.byte	79h
wrhadr:	.word	0	; DMA address
wrhlen:	.word	0	; DMA length - 1
	.byte	14h
	.byte	28h
	.byte	95h
	.byte	HARD
	.byte	12h
	.byte	0	; DMA vector
	.byte	92h
	.byte	0CFh
	.byte	5
	.byte	0CFh
	.byte	0ABh
	.byte	87h
lenwrh	==	.-DMAwrh
.page
;----------
; Messages
;
hello$:	.ascii	[cr][lf]'Harddisk to tape '
	.ascii	'Backup Program '
	.ascii	[cr][lf]'CARTBACK '
	.ascii	' version '
	.byte	version+'0','.',revision/10+'0'
	.byte	revision@10+'0'
	.byte	patch!80h	; sign bit terminates
size8:	.ascii	[cr][lf][lf]
	.ascis	'HARD DISK:  8 inch Fujitsu-Memorex'
size14:	.ascii	[cr][lf][lf]
	.ascis	'HARD DISK:  14 inch Shugart'
badctl$:.ascii	[cr][lf][lf][7]
	.ascii	'Controller program old (before '
	.ascis	'V 2.0) or bad.'
badtp$:	.ascii	[cr][lf]'This tape is not a '
	.ascis	'continuation of the previous tape.'
select$:.ascii	[cr][lf][lf]
	.ascii	'Select one of the following options:'
	.ascii	[cr][lf]
	.ascii	[cr][lf]'  A = Backup ALL disk '
	.ascii	'partitions '
	.ascii	[cr][lf]'  B = BACKUP selected disk '
	.ascii	'partitions '
	.ascii	[cr][lf]'  C = CHANGE volumes (mult'
	.ascii	'iple volumes only).'
	.ascii	[cr][lf]"  D = DISPLAY volumes' curren"
	.ascii	"t ALLOC table"
	.ascii	[cr][lf]'  F = Backup all FLAGGED '
	.ascii	'partitions (ALLOC control byte set)'
	.ascii	[cr][lf]'  L = LOAD disk from the TAPE'
	.ascis	[cr][lf][lf]'Enter choice: '
volask$:.ascis	[cr][lf]'Desired volume (0 to 3) :'
vl1msg:	.ascis	[cr][lf]'Current volume is'
vl2msg:	.ascis	', volume number '
date$:	.ascii	[cr][lf]"Enter optional date "
	.ascis	"(MM/DD/YY): "
time$:	.ascis	[cr][lf]"Enter optional time (HH:MM): "
waitmsg:.ascis	[cr][lf]'Type RETURN to continue.'
.page
part$:	.ascii	[cr][lf][lf]'Hard disk to tape '
	.ascii	'drive BACKUP'[lf][cr][lf]
	.ascii	[9]'  Valid BACKUP commands:'[cr]
	.ascii	[lf][9]'  ----------------------'[lf]
	.ascii	[cr][lf][9]'name     Name of hard disk'
	.ascii	' partition to BACKUP.' 
	.ascii	[cr][lf][9]'*END     Mark end of tape.'
	.ascii	[cr][lf][9]'*LIST    List hard disk'
	.ascii	' ALLOCation table.'
	.ascis	[cr][lf][lf]'Enter BACKUP command :'
nopart$:.ascii	[cr][lf]"Name not found in hard "
	.ascis	"disk ALLOCation table."[cr][lf]
badpart$:.ascii	[cr][lf][07]"PARTITION SIZES DON'T MAT"
	.ascii	"CH."[cr][lf]"A load of the system par"
	.ascis	"tition (*PART0) is necessary."
error$:	.ascii	[cr][lf]"Incorrect entry.  Use CTRL-C "
	.ascis	"to abort."[cr][lf]" Please re-enter :"
done$:	.ascis	' Blocks written: '
done2$:	.ascis	' Partition loaded.'
crlf$:	.ascis	[cr][lf]
newt$:	.ascii	[cr][lf]'Insert cassette, then '
	.ascii	'select one of the following:'
	.ascii	[cr][lf]
	.ascii	[cr][lf]' R - Rewind    (up to 2.5 '
	.ascii	'min.)'
	.ascii	[cr][lf]' T - Retension (about 5 min.)'
	.ascii	[cr][lf]' E - Erase     (about 5 min.)'
	.ascii	[cr][lf]
	.ascis	[cr][lf]' Enter Choice :'
writp$:	.ascii	[cr][lf]'The tape cartridge is write '
	.ascis	'protected. '
notap$:	.ascis	[cr][lf]'No tape in drive.'[cr][lf]
backw$:	.ascii	[cr][lf]'Type RETURN to write system'
	.ascis	' software and partition *PART0.'
backa$:	.ascis	[cr][lf]'Type RETURN to start back-up. '
eot$:	.ascii	[cr][lf]'End of TAPE.'
        .ascii  [cr][lf]'Tape is being rewound.'
endtp$: .ascis  [cr][lf][07]'Please mount next cassette.'
reld$:	.ascii	[cr][lf][lf]
	.ascii	'If correct tape type RETURN, '
	.ascis	'otherwise type anything else. '
allwr$:	.ascii	[cr][lf]'All partitions written'
	.ascis	' to TAPE.'
.page
postp$:	.ascii	[cr][lf][lf]'Tape drive to hard '
	.ascii	'disk LOAD '[cr][lf][lf]
	.ascii	[9]'  Valid LOAD commands are: '[cr][lf]
	.ascii	[9]'  -----------------------'[lf]
	.ascii	[cr][lf][9]'name     Search for tape '
	.ascii	'partition "name". '
	.ascii	[cr][lf][9]'*ALL     Load all partit'
	.ascii	'ions (including system partition).'
	.ascii	[cr][lf][9]'*LIST    List the hard dis'
	.ascii	'k ALLOCation table.'
	.ascii	[cr][lf][9]'*END     Exit LOAD section.'
  	.ascii	[cr][lf][9]'*REWIND  Rewind the tape.'
	.ascii	[cr][lf][9]'*PART0   Load the system '
	.ascii	'partition.'[cr][lf]
	.ascii	[9]'*NEXT    Find the next partition.'
	.ascis	[cr][lf][lf]' Enter LOAD command :'
LDvfy$:	.ascii	[cr][lf]'Proceed with tape search?'
	.ascis 	' (Y/N) :'
etmsg$:	.ascis	[cr][lf]'End Of Tape data.'
ldflq$:	.ascii	[cr][lf]' Load this tape partition '
	.ascis	'onto hard disk? (Y/N) :'
qbst$:	.ascii	[cr][lf]'Shall bad sector table be '
	.ascis	'loaded from tape (Y/N)? '
qalc$:	.ascii	[cr][lf]'Shall allocation table be '
	.ascis	'loaded from tape (Y/N)? '
scantp$:.ascis [cr][lf]' WAIT - Searching the tape'[cr]
skiptp$:.ascis [cr][lf]' WAIT - Skipping partition'[cr]
tpload$:.ascis [cr][lf]' WAIT - Loading '[cr]
noprt$:	.ascis	[cr][lf]'Partition not found on tape.'
ldall$:	.ascis	[cr][lf][lf]'Loading all partitions.'
noptn$:	.ascis	[cr][lf]'Partition not on this disk.'
loadt$: .ascii	[cr][lf]'Insert cassette, then '
	.ascii	'select one of the following:'
	.ascii	[cr][lf]
	.ascii	[cr][lf]' R - Rewind    (up to 2.5 '
	.ascii	'min.)'
	.ascii	[cr][lf]' T - Retension (about 5 min.)'
	.ascii	[cr][lf]
	.ascis	[cr][lf]' Enter Choice :'
.page
TSFerr:	.ascis	[cr][lf]'Short partition encountered.'
TRURerr:.ascii	[cr][lf][lf][7]
	.ascis	'*** Unrecoverable TAPE read error: '
TRUWerr:.ascii	[cr][lf][lf][7]
	.ascis	'*** Unrecoverable TAPE write error: '
CARTerr:.ascis	[cr][lf]'CARTRIDGE NOT IN PLACE.'
DRIVerr:.ascis	[cr][lf]'DRIVE NOT ON LINE.'
DATAerr:.ascis	[cr][lf]'UNRECOVERABLE DATA ERROR.'
BIEerr:	.ascis	[cr][lf]'B I E  NOT LOCATED.'
ERbyt0info:
	.ascii	[cr][lf]'Error(s) detected from byte 0'
	.ascis	' of the 6 tape status bytes.'
COMerr:	.ascis	[cr][lf]'ILLEGAL COMMAND.'
NODATerr:
	.ascis	[cr][lf]'NO DATA DETECTED.'
RESerr:	.ascis	[cr][lf]'RESET OCCURRED.'
ERbyt1info:
	.ascii	[cr][lf]'Error(s) detected from byte 1'
	.ascis	' of the 6 tape status bytes.'
endmsg:	.ascis	'h '
DISKerr:.ascii	[cr][lf][lf][7]
	.ascii	'Unrecoverable DISK read/write '
	.ascis	'error.'
badvol:	.ascis	[cr][lf][lf]'No volume here'
nonet$: .ascii	[cr][lf][lf]'You can not use Cartback '
	.ascis		'while on HiNet.'
;----------
; Strings for compare
;
all$:	.ascii	'*ALL    '
end$:	.ascii	'*END    '
blnk$:	.ascii	'        '
rwnd$:	.ascii	'*REWIND '
cart$:	.ascii	'*CART   '
part0$:	.ascii	'*PART0  '
list$:	.ascii	'*LIST   '
next$:	.ascii	'*NEXT   '
.page
;----------
; Alloc table printout data and defs
HEADmsg:.ascii	[cr][lf]'   Unit  Size     Name  '
	.ascii	'   Password  Ctrl'
	.ascii	[cr][lf]'   ----  ----     ----  '
	.ascis	'   --------  ----'
space4:	.ascis	'    '
unit:	.byte	0	; holds current unit number
tabladr:.word	0000h	; holds current table addr
;----------
; Tape commands
;
rwdTAPE	==	21h	; rewind command
eraTAPE	==	22h	; erase command
retTAPE ==	24h	; retension command
rdTAPE  ==	80h	; read the tape
wrTAPE	==	40h	; write the tape
stTAPE	==	0C0h	; read status
wrfmTP  ==	60h	; write file mark
rdfmTP	==	0A0h	; read file mark ;*** ver 2.1
;
	.inser	VOLINFO.ASM
;
wrHARD	==	2
rdHARD	==	1
volSEL	==	13h	; volume select byte
volSTAT	==	18h	; volume status request byte
.page
VLselstr:.byte	volSEL	; Volume select byte
	.byte	0	; partition number
volnum:	.byte	0	; current volume number
	.byte	0,0,0	; unused
	.byte	'M'	; for Multiple hard disk
	.byte	0	; unused
;Eight character command string to be sent to HDC
HARDcom:.byte	0	; command
HARDtrk:.byte	0	; track
HARDhed:.byte	0	; head
HARDsec:.byte	0	; sector
	.byte	0	; tag 0
	.byte	0	; tag 1
HARDret:.byte	8Ah	; 10 retries, with ECC
	.byte	0
HARDstat:.blkb	8	; harddisk status
loadflg:.byte	0	; storage for erase check
;---------------
; Queue information
;
Qstrt	==	4F00h	; start address of QUEUE
Qlen	==	8000h	; length of QUEUE
getQp:	.word	0	; get Queue pointer
putQp:	.word	0	; put Queue pointer
Qcond:	.byte	0	; number of used buffers
.page
;----------
; Disk information
;
DSKxfr:	.word	0	; # of DISK blocks to xfer
TAPxfr:	.word	0	; # of TAPE blocks to xfer
numWRblk:.word	0	; same (kept for print out).
ALClen:	.byte	0	; length of disk from ALLOC
MAXtrk:	.byte	0	; last track
MAXhead:.byte	0	; last head
MAXsect:.byte	0	; last sect
;---------------
; Information on first 512 byte block of a file
;
info%:
	.ascii	[cr][lf]"Date: "
date%:	.ascii	"XX/XX/XX"
	.ascii	" Time: "
time%:	.ascii	"XX:XX"
	.ascii	" Name: "
name%:	.ascii	"XXXXXXXX"
	.ascii	" Type/Size: "
size%:	.ascii	"X"
	.ascis	' '
.page
iobuff	==	4D00h
infor%	==	iobuff
dater%	==	date%-info%+iobuff
timer%	==	time%-info%+iobuff
namer%	==	name%-info%+iobuff
sizer%	==	size%-info%+iobuff
;
;----------
; Buffer and stack area
volbuffr:
	.blkb	128	; holds HDC status buffer
ALLOCta:.blkb	400h

alcynq:	.byte	0
bstynq:	.byte	0
oldalc:	.blkb	400h
oldbst:	.blkb	400h
	.byte	0

        .ascii  'STACK START'
	.blkb	100h
	.byte	0FFh,0FFh,0FFh,0FFh,0FFh,0FFh,0FFh
	.ascii	'******END'
stack:
LASTbyt	=	.
	.end

