.title "Format floppy disks."
	.sbttl "FORMAT"
version	==	3
revision==	3
patch	==	' '
;
;LAST REVISED 22JUL82MdG
;
	.pabs
	.phex

;			Update History

;   Version 2.0 - (7/29)   Escape can be used for
;			program restart. See CONIN.
;			Head step delay lengthened to
;			15ms.  Head load delay of 50ms
;			inserted in ONMOTOR routine.
;			I/O errors do not terminate
;			the program anymore.
;			Conditional assembly for
;			testing (TFORMAT) installed.
;			Floppy buffer is printed to
;			console if IO error occurs
;			under TFORMAT.
;   Version 3.0 - 3/16  Convert program to format 
;			5 1/4 " floppy disks.
;
;   Version 3.1 - 5/28	Changed sector skew to 1 for
;			minis. Skew still =4 for
;			8 inch. Skew factors are in
;			equates now. -28MAY82MdG
;			Changed loadset to 7800h from
;			1E00h.
;
; Ver 3.2  11JUN82MdG	8 inch assembly fixed.
; Ver 3.2c 15JUN82MdG	Fixes for 8 inch continuing.
; Ver 3.2d 16JUN82MdG	Formats OK but CP/M crashes.
; Ver 3.2e 02JUL82MdG	Changed gap size for 5 inch.
;			Still does not work correctly.
; Ver 3.2F 21JUL82MdG	Change for both sides of FOX disks.
;			8 inch still causes errors - TRAC
;			errors reported after using FORMAT.
; Ver 3.3  22JUL82MdG	Changed the head step time in the
;			specflop command. Works fine on 8
;			inch now.
;
;----------
; Data and address definitions:
;
cr	=	0Dh	; <return>
lf	=	0Ah	; <linefeed>
userno	=	47h	; Network user number
drivno	=	04h	; Currently selected drive num
onprecmp=	22	; turn on pre-compensation
maxprec	=	59	; turn off S/L bit
stepset	=	900h	; head step settle time = 15ms
loadset	=	7800h	; head load settle time = 200ms
;
skew8	==	4	; stagger addend for 8 inch
skew5	==	1	; stagger addend for 5 inch
;
gapS8	==	1Bh	; Gap length for 8 inch SD
gapD8	==	36h	; Gap length for 8 inch DD
gapD5	==	32h	; Gap length for 5 inch DD
			; gapD5  will change for 18
			; sectors/trk
;
WBOOT	=	1	; for bios calls
;
; Port definitions:
;
DMA	=	38h
PIOAD	=	08h	; PIO channel A, data
PIOBD	=	09h	; PIO channel B, data
FLOP	=	18h	; Floppy DMA channel
FLOPSR	=	10h	; Floppy status register
FLOPDR	=	11h	; Floppy data register
STOPFLOP=	03h	; Stop floppy controller
	
TFMTflg	=\ "
	  Enter 0 for FORMAT  (interleaving sectors)
		1 for TFORMAT (linear sectors)       "
miniflag=\ "
	  Enter 0 for 5 inch floppy disk
	  	1 for 8 inch floppy disk "
;
;---------
; Entry Points for ZDT
;
	.loc	100h
	jmp	TEST
	jmp	START

TEST:	lda	userno	; Make sure we're not on
	cpi	00h	; a Hinet master.
	jrnz	START	; We are not. Proceed
	lxi	H,..NOGOmsg
	call	prtmsg  ; We are. Tell user.
	jmp	0	; and boot.
..NOGOmsg:
	.ascii	[cr][lf]'FORMAT cannot be used on a '
	.asciz	'HiNet master. '

START:	lxi	sp,stack; Set up our stack
	lhld	WBOOT	; use interrupt vector in bios
	mvi	L,0	; where cold boot was
	mvi	M,DMAdone&0FFh ; low
	inx	H
	mvi	M,(DMAdone>8) & 0FFh ; then high
	lxi	H,specflop			
	call	command ; issue specify command
       	call	FORMAT	; format the disk(s)
	jmp	EXIT	; and warm boot.
	.page
;----------
; Home selected disk drive to track 0
HOME:
	mvi	A,0	; current track now zero
	sta	curTRK
	lxi	H,homeFLOP+1 ; point to drive number
	jmpr	seek	; share code with SETTRK
;----------
; Select disk drive
SELDSK:
	lxi	H,DEVqst ; ask which disk
	call	PRTMSG
	call	CONIN	; get the answer
	cpi	03h	; check for cntrl-C
	jz	EXIT	; Prepare to EXIT if CTRL C
	mov	C,A
	call	CONOUT	; echo it
	sui	'0'
	jm	SELDSK
	cpi	8
	jp	SELDSK
	sta	curDSK
	ret
DEVqst:	.asciz	[cr][lf][lf]'Enter Disk Number (0-7): '
;----------
; Set track
SETTRK:
	lda	curTRK	; get current track
	lxi	H,seekFLOP+2 ; point to track number
	mov	M,A	; store into command
	dcx	H
;
; Seek a track (used by SETTRK and HOME)
seek:
	lda	curDSK	; get current disk
	mov	M,A	; store into command
	dcx	H
	call	onMOTOR	; turn on the drive motor
reseek: mov	D,H	; save ptr to seek command
	mov	E,L
	call	COMMAND	; seek
sense:	lxi	H,IsenseFLOP
	call	COMMAND	; sense interrupt status
	call	RESULT
	mov	H,D	; restore ptr to seek command
	mov	L,E
	lda	resbuf	; get first result byte
	bit	3,A	; check ready bit
	jrnz	reseek	; jump if not ready
	bit	5,A	; mask out top 2 bits
	jrz	sense	; loop until seek completed
	ani	0D0h
	cnz	reseek
	lxi	B,stepset; delay 10 ms for step settle
;---------
; Delay loop
DELAY:	dcx	B
	mov	A,B
	ora	C
	jrnz	DELAY
	ret
	.page
;----------
; Format the entire disk single or double density
;
FORMAT:
	lxi	H,FORMstr ; print start-up message
	call	PRTMSG
..form:	call	SELDSK	; ask which disk
	rz		; return if cntrl-C
;
	.ifn	miniflag,[
	call	ASKDEN	; ask for density on 8 inch
	]
;
	call	WAITCR	; wait for return
..rept:
	call	HOME	; recalibrate the disk drive
;
	.ifn	miniflag,[
	mvi	D,0
	call	TABLIN	; first trk linear for 8 inch
	]
;
	.ife	miniflag,[
	mvi	A,1	; minifloppy all double dens
	sta	curDEN	; Store in RAM
	mov	D,A	; Put in reg. D for FORM1TK
;
	.ife	TFMTflag,[
	mvi	A,skew5
	call	TABSTAG	; Set up the table we want
	]
;
	.ife	TFMTflag-1,[
	call	TABLIN
	]
;
	]		; miniflag
;
	call	FORM1TK	; format the first track
..1:	call	SETTRK	; seek to next track
	lda	curDEN	; rest of disk is specified
	mov	D,A	; density
;
	.ifn	miniflag,[
	cpi	0	; single density is linear
	jrz	..2
	lda	curTRK	; so is track 1
	cpi	1
	jrz	..2
	]
;
	push	D	; save density
;
	.ife	miniflag,[
	mvi	A,skew5	; 5 inch skew factor put in A
	]
;
	.ifn	miniflag,[
	mvi	A,skew8	; 8 inch skew factor put in A
	]
;
	.ife	TFMTflg,[
	call	TABSTAG ; stagger table for FORMAT
 						   ]
	.ife	TFMTflg-1,[
	call	TABLIN	; dont stagger for TFORMAT 
						   ]
	pop	D
	jmpr	..3
..2:	call	TABLIN	; make table linear
..3:	call	FORM1TK ; format next track
	cpi	78+(2-(2*miniflag))
	jrnz	..1	; if not, loop
;
	.ife	miniflag, [
	lda	rptctr	; repetition counter
	ora	A	; Check if never repeated
	jrnz	..done	; Jump if already repeated
	inr	A	; Increment count
	sta	rptctr	; Store it
;
	lda	curDSK	; Get floppy drive #
	adi	4	; 2nd side of the phys drive
	sta	curDSK	; Store it
	jmpr	..rept
..done:
	]
;
	lxi	H,FORMdon ; say 'done'
	call	PRTMSG
	sub	A	; A = 0
;
	.ife	miniflag,[
	sta	rptctr	; Reset repetition counter
	]
;
	out	PIOBD	; unload the head
	jmpr	..form
;
;---------------
; Data areas
	.ife	miniflag, [
rptctr:	.byte	0	; repetition counter for
			; number of sides formatted
	]
;
FORMstr:.ascii	[cr][lf]
	.ife	TFMTflg-1, [.ascii " TEST " ]
	.ife	miniflag, [.ascii "5 Inch  " ]
	.ifn	miniflag, [.ascii "8 Inch  " ]
	.ascii	'floppy disk format program, version '
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.byte	patch
	.ascii	[cr][lf]
infomsg:.ascii	[cr][lf]'Use ESC to restart, '
	.asciz	'Control-C to abort. '

FORMdon:.asciz	[cr][lf]'FORMAT COMPLETED'[cr][lf]

	.ifn	miniflag,[
;----------
; Ask what density
ASKDEN:
	lxi	H,DENqst ; set up message
	call	PRTMSG
	call	CONIN	; get answer
	mov	C,A
	call	CONOUT	; echo it
	cpi	's'	; check for single
	jrz	..1
	cpi	'S'	; check for single
	jrnz	..2
..1:	mvi	A,0	; set single density
	sta	curDEN
	ret
..2:	cpi	'd'	; check for double
	jrz	..3
	cpi	'D'
	jrz	..3
	cpi	3	; 3 is control-C
	jz	EXIT	; Prepare to exit if CTRL-C
	jmpr	ASKDEN	; Bad entry.
..3:	mvi	A,1	; set double density
	sta	curDEN
	ret
DENqst:	.asciz	[cr][lf]'Single or Double density? '
	]
;----------
; Wait for CR
WAITCR:
	lxi	H,WCRqst ; print a message
	call	PRTMSG
..1:	call	CONIN	; get an answer
	cpi	3	; 3 is control-C
	jz	EXIT	; Prepare to exit if CTRL-C.
	cpi	cr	; is it cr?
	jrnz	..1	; if not loop
	mov	C,A
	call	CONOUT	; echo it
	ret
WCRqst:	.asciz	[cr][lf]'Type return to start.'
;----------
; Format curTRK and increment it.
;
; Build Sector Table (linear)
TABLIN:
	lxi	H,bufFLOP ; build sector table in buf
	lda	curTRK	; C should have curTRK
	mov	C,A
	mvi	A,1	; A has sector number

..1:	mov	M,C	; fill in TRACK
	inx	H
	push	PSW
	lda	curDSK
	rrc
	rrc
	ani	1	; compute head (ie, side)
	mov	M,A	; fill in HEAD (0 or 1)
	pop	PSW
	inx	H
	mov	M,A	; fill in SECTOR (counting)
	inx	H
	mov	M,D	; code for BYTES/SECTOR
	inx	H
	inr	A	; set to next sector
	cpi	27	; end of list?
	jrnz	..1	; no, then loop
	ret

;
; Build staggered sector table
TABSTAG:
	push	D	; save density
	lxi	H,bufFLOP ; zero out the output buffer	
	mvi	M,0
	lxi	D,bufFLOP+1
	lxi	B,255
	ldir

	lxi	H,bufFLOP ; build the sector table
	mov	B,A	; B has the stagger count
	lda	curTRK	; C has the track number
	mov	C,A
	pop	D	; restore density
	mvi	A,1	; first sector is 1

..1:	mov	M,C	; fill in TRACK
	inx	H
	push	PSW
	lda	curDSK
	rrc
	rrc
	ani	1
	mov	M,A	; fill in HEAD (0 or 1)
	pop	PSW
	inx	H	
	mov	M,A	; fill in SECTOR (counting)
	inx	H
	mov	M,D	; fill in BYTES/SECTOR
	inx	H
	cpi	16+10*miniflag; if flag = 0, 16
	rz		; return if yes
	inr	A	; set next sector
	push	B	; save stagger count
..2:	inx	H	; increment HL by 4 for each
	inx	H	; 1 sector to stagger
	inx	H
	inx	H
	djnz	..2	; repeat for stagger count
	pop	B	; restore stagger counter
	push	PSW	; save A
..3:	mov	A,L	; check for HL overflow
	cpi	(16+10*miniflag)*4
	jm	..4
	sbi	(16+10*miniflag)*4 ;if overflow sub 
	mov	L,A	; extra from HL
..4:	inx	H	; check if this sector already
	inx	H	; filled
	mov	A,M
	ora	A
	jrz	..5
	inx	H	; if so skip it, and try next
	inx	H	; next sector
	jmpr	..3
..5:	dcx	H	; restore HL
	dcx	H
	pop	PSW	; restore A
	jmpr	..1	; fill next sector

FORM1TK:
;
; Set up the DMA chip
	mvi	A,0	; multiplex Floppy to DMA
	out	PIOAD
	lxi	H,DMAfmt
	lxi	B,DMAfm$<8+DMA
	outir		; program the chip
;
; Set up the floppy format command
	lda	curDSK	; set up current disk
	sta	FORMdsk
	mov	A,D	; set up floppy density
	sta	FORMmod 
	cpi	0	; check for density
	jrnz	..2	; and fill in special fields
	mvi	A,0Dh	; set up for single density
	sta	FORMcom	; format command
	mvi	A,gapS8	; set gap size
	sta	FORMgap
	jmpr	..3
..2:	mvi	A,4Dh	; set up for double density
	sta	FORMcom	; format command
;
	.ifn	miniflag,[
	mvi	A,gapD8	; set gap size
	]
	.ife	miniflag,[
	mvi	A,gapD5
	]
;
	sta	FORMgap
..3:
;
; Execute the floppy command
	lxi	H,FORMcom
	call	EXflop
	lxi	B,0B0h
	call	delay
;
; Increment to next track
	lda	curTRK
	inr	A
	sta	curTRK

	ret		; return
;
; Execute the floppy command
EXflop:	ei		; turn on interupts
	call	COMMAND
	call	RESULT
	lda	resbuf	; get first result byte
	ani	0C0h	; mask out top 2 bits
	cnz	IOERR	; jump if abnormal termination
	lda	resbuf+1 ; get second result byte
	ani	33h	; check for CRC error
	cnz	IOERR
	ret
;
; Handle the floppy-done interrupt from the DMA chip
DMAdone:push	PSW
	in	STOPFLOP; reset the floppy chip
	mvi	A,0C3h	; reset the DMA chip
	out	DMA
	pop	PSW
	ei
	reti
;----------
; Handle an I/O error
;
; Print a message of the form 'I/O Error '.  If we
; are assembling  under the  Tformat option, then
; print the address from which the call here was
; made, and print the floppy result buffer.
; Next, space down and await a control C or ESC.
errmsg:	.asciz	[cr][lf]'*** I/O Error '
IOERR:
	lxi	H,errmsg
	call	PRTMSG		; Print error message
	pop	H
	shld	bufFLOP-2
	shld	erradr		; save our error addr
;---------------
;Print out error details if this is TFORMAT
;
	.ife	TFMTflg-1, [
;
	lxi	H,..frommsg
	call	prtmsg
	lxi	H,erradr+1
	mvi	A,1
	call	PRTBYTS
	lxi	H,erradr  
	mvi	A,1		; print addr where
	call	PRTBYTS		; error occured
	lxi	H,..resmsg
	call	prtmsg
	lxi	H,resbuf
	mvi	A,7
	call	PRTBYTS		; print result buf
				                  ]
;Tell user what his options are now and wait for him.
	lxi	H,infomsg
	call	prtmsg		; print CTRL-C,ESC info
..wait:	call	CONIN
	cpi	'3'	;loop until ctrl-c
	jrnz	..wait  ;(or ESCAPE from conin)
	jmp	EXIT	;exit if ctrl-c

..frommsg:
	.asciz	'from addr '
..resmsg:
	.asciz	'. Result buffer: '

locerr	=	bufFLOP-2
	.page
;----------
; Utility routines
;
; PRTMSG  - print a message
; PRTBYTS - print specified number of bytes
; COMMAND - send a command to the floppy controller
; RESULT  - get a result from the floppy controller
; WAITDR  - wait for floppy data register
; MOTORon - turn on the drive motor
;----------
; Print a message
;  Regs in:   HL = address of message (ended by null)
;  Regs out:  none
;  Destroyed: A, HL
PRTMSG:
	mov	A,M	; get a byte
	ora	A	; if null, then return
	rz
	mov	C,A	; put it where CONOUT wants it
	push	H	; save HL
	call	CONOUT	; output the byte
	pop	H	; restore HL
	inx	H	; point to next byte
	jmpr	PRTMSG
;----------
; Print a specified number of bytes
;  Regs  in: 	A = number of bytes to  print
;		HL= addr of 1st byte
;  Regs out:	none
;  Destoyed:	any/all
PRTBYTS:cpi	1
	rc		; nothing to print
	jrz	..prtbyt; print just 1 char

..loop:	push	PSW	; save number of chrs
	push	H
	call	..prtbyt; print 1 byte to console
	pop	H
	pop	PSW	; restore number of chrs
	inx	H	; get to next byte
	dcr	A	; Reduce our count
	rz		; and return when finished.
	jmpr	..loop

; Regs  in:	HL=addr of byte to be printed
..prtbyt:
	mov	A,M
	push	PSW	; save the chr
	rlc
	rlc
	rlc
	rlc
	call	..prtnbl
	pop	PSW
	call	..prtnbl
	ret
..prtnbl:
	ani	0Fh
	adi	'0'
	cpi	'9'+1
	mov	C,A	; chr goes out in C
	jc	CONOUT
	adi	'A'-('9'+1)
	mov	C,A	; chr goes out in C
	jmp	CONOUT

;----------
; Console input
CONIN:	call	..1
	cpi	1Bh	; Is entry ESCAPE?
	rnz		; No. Return the chr.
	jmp	FORMAT	; Yes. Restart program.

..1:	lhl	WBOOT	; call the bios
	lxi	D,06h
	dad	D
	pchl
;----------
; Console output
CONOUT:	
	lhld	WBOOT	; call the bios
	lxi	D,09h
	dad	D
	pchl
;----------
; Select original drive then exit
EXIT:
	call	..seldrv; Select orig driv
	jmp	0	; and warm boot

..seldrv:
	lda	drivno	; Get orig driv num
	mov	C,A	; in C. 
	lhld	WBOOT	; Send it to BIOS
	lx	D,1B	;
	dad	D
	pchl

;----------
; Send a command to the floppy controller
;  Regs in:   HL = address of command string
;  Regs out:  none
;  Destroyed: A, HL
COMMAND:
	mov	A,M
	cpi	endcom	
	rz		; return if end-of-command
	call	WAITDR
	cc	IOERR	; direction is wrong
	mov	A,M
	out	FLOPDR	; send a byte to controller
	inx	H	; point to next byte
	jmpr	COMMAND
;----------
; Collect a result from the floppy controller
;  Regs in:   none
;  Regs out:  B = length of result string
;  Destroyed: A, HL
RESULT:
	lxi	H,resbuf
readDR:	call	WAITDR
	rnc
	mvi	A,0C3h
	out	DMA	; reset DMA chip
	in	FLOPDR	; get a result byte
	mov	M,A	; store it away
	inx	H
	jmpr	readDR
;----------
; Wait until floppy data register is ready
;  Regs in:   none
;  Regs out:  A = status register, shifted left by 1
WAITDR:
	in	FLOPSR
	rlc
	jrnc	WAITDR
	rlc
	ret
;----------
; onMOTOR - turn on a drive motor
;  Regs in:   A = drive number
;  Regs out:  none
;  Destroyed: A, B
onMOTOR:
	mov	B,A
	lda	curTRK	; set precomp
	cpi	onprecmp
	jrc	..1
	set	5,B	; bit 5 = pre-comp
	cpi	maxprec
	jrnc	..1
	set	4,B	; bit 4 = S/L
..1:	set	2,B	; bit 2 = head load
	mov	A,B
	out	PIOBD
	lxi	B,loadset; delay 50ms after
	call	DELAY	; head load
	ret
	.page
;----------
; Current disk position information
curDSK:	.byte	0	; current physical drive
curTRK:	.byte	0	; current physical track
curSEC:	.byte	1	; current physical sector
curBYT:	.word	256	; current length of operation
curDMA:	.word	bufFLOP ; I/O buffer
curDEN:	.byte	1	; current density

;----------
; Floppy controller commands
endcom	=	0FFh	; command terminator
homeFLOP:
	.byte	7	; recalibrate command
	.byte	0	; curDSK
	.byte	endcom
specflop:
	.byte	3
;
	.ife	miniflag,[
	.byte	0AFh	; step rate & head unload
	]
;
	.ifn	miniflag,[
	.byte	08Fh	; step rate & head unload
	]
;
	.byte	02h	; FDC head load param.
			; LSB should stay reset.
			; Not used by DMS.
	.byte	endcom
seekFLOP:
	.byte	15	; seek command
	.byte	0	; curDSK
	.byte	0	; curTRK
	.byte	endcom
IsenseFLOP:
	.byte	8	; sense interrupt status
	.byte	endcom
readFLOP =	46h	; DOUBLE DENSITY
writeFLOP=	45h
erradr:	.word	0		; err addr holder
resbuf: .byte	0,0,0,0,0,0,0	; result buffer

;----------
; FORMAT command for Floppy Controller
FORMcom:
	.byte	4Dh	; format command (SD/DD)
FORMdsk:.byte	0	; curDSK
FORMmod:.byte	1	; 0=SD, 1=DD
	.byte	16+10*miniflag ; 26 sectors/track 8"
FORMgap:
;
	.ife	miniflag,[
	.byte	gapD5
	]
	.ifn	miniflag,[
	.byte	gapD8
	]
;
	.byte	0E5h	; fill byte
	.byte	endcom


;----------
; DMA commands for FORMAT command
DMAfmt:
	.byte	0C3h	; master reset
	.byte	0C7h	; reset port A
	.byte	0CBh	; reset port B
	.byte	079h	; read from memory
	.word	bufFLOP	; address
	.word	103	; size - 1
	.byte	14h	; port A inc, memory
	.byte	28h	; port B fixed, I/O
	.byte	95h	; byte mode
	.byt	FLO	 por B
	.byte	12h	; interrupt at end of block
	.byte	00	; interrupt vector
	.byte	9Ah	; stop at end of block
	.byte	0CFh	; load starting address
	.byte	05	; write to I/O
	.byte	0CFh	; load starting address
	.byte	0ABh	; enable interrupts
	.byte	87h	; enable DMA
DMAfm$	=	.-DMAfmt
bufFLOP	=	3000h	; location of I/O buffer
	.blkb	100h	; Room for the stack.
	stack	=	.
.end
