	.page
	.sbttl	'bitmap routines'
bitmversion ==	0
bitmrevision == 8	;last modified 20-Dec-82
;
;	0.1	Les Wilson	23-Nov-82
;	this module contains bitmap routines
;	to be included in all crt emulations for
;	the fox which require them.  The routines
;	for maintaing the bitmap are common to
;	all emulations but routines for using
;	the bitmap to set screen characteristics
;	are unique for each emulation
;
;
;	the following routines are present:
;	(parameters are registers in parens)
;
;	bmreset - reset (zero) the entire bitmap
;	bmset	- set the entire bitmap


;	bmrreset(a) - a is row to reset
;	bmrset(a) - a is row to set

;	bmbreset(h,l) - h is row,l is column of bit
;			to reset
;	bmelreset(h,l) - h is row,l is column of bit
;			to reset and to end of line
;	bmesreset(h,l) - h is row,l is column of bit
;			to reset, and to end of screen

;	bmbset(h,l) - h is row,l is column of bit
;			to set
;	bmelset(h,l) - h is row,l is column of bit
;			to set and to end of line
;	bmesset(h,l) - h is row,l is column of bit
;			to set, and to end of screen

;	bmbtest(h,l) - h is row, is column of bit to 
;		test.  return with zero flag set if
;		bit not set, clear if bit set

;	bmscrreset -	scroll the bit map up filling
;			new last line to reset
;	bmscrset -	scroll the bit map up filling
;			new last line to set

;
;	bmilreset(a) -	a is row of line to insert 
;		reset.  all lines below scroll down
;	bmdlreset(a) - a is row of line to delete, all
;		lines below scroll up and bottom
;		line is reset


bmreset:	;reset entire bitmap
	lxi	h,bml0	;start of bitmap
	mvi	m,0
	push	h
	pop	d
	inx	d
	lxi	b,24*10-1 ;number of bytes of bits
			;less one
	ldir
	ret

bmset:		;set entire bitmap
	lxi	h,bml0	;start of bitmap
	mvi	m,0ffh
	push	h
	pop	d
	inx	d
	lxi	b,24*10-1 ;number of bytes of bits
			;less one
	ldir
	ret

bmrreset:	;a reg is row to reset
	slar	a	;mult by 2
	lxi	h,bmlineentry
	mov	c,a
	mvi	b,0
	dad	b
	indirect	;hl becomes address of line
	mvi	m,0
	push	h
	pop	d
	inx	d
	lxi	b,9	;remaining bytes of bits on line
	ldir
	ret


bmrset:		;a reg is row to set
	slar	a	;mult by 2
	lxi	h,bmlineentry
	mov	c,a
	mvi	b,0
	dad	b
	indirect	;hl becomes address of line
	mvi	m,0ffh
	push	h
	pop	d
	inx	d
	lxi	b,9	;remaining bytes of bits on line
	ldir
	ret


bmbreset:	;h is row, l is column of bit to 
		;reset
	push	h
	mov	c,h
	slar	c
	mvi	b,0
	lxi	h,bmlineentry
	dad	b
	indirect	;hl now address of line
	pop	d	
	mov	a,e	;column
	srlr	a
	srlr	a
	srlr	a
	mov	c,a
	mvi	b,0
	dad	b	;hl now points to byte
			;containing bit
	mov	a,e
	ani	7	;get low three bits
	inr	a	;do one rotate for zero bit
	mov	b,a
	mvi	a,0ffh	;set all bits
	ora	a	;clear carry to rotate in
..loop:
	ral
	djnz	..loop
	ana	m	;reset the bit
	mov	m,a
	ret

bmelreset:	;h is row, l is column of bit to reset
		;and to end of line
	push	h
	call	bmbreset
	pop	h
	inr	l
	mov	a,l
	cpi	charsperline
	jrnz	bmelreset
	ret

bmesreset:	;h is row, l is column of bit to reset
		;and to end of line
	push	h
	call	bmelreset
	pop	h
..loop:
	inr	h
	mov	a,h
	cpi	linesonscreen - 1
	rz
	push	h
	call	bmrreset	;reset a row
	pop	h
	jmpr	..loop

bmbset:		;h is row, l is column of bit to 
		;set
	push	h
	mov	c,h
	slar	c
	mvi	b,0
	lxi	h,bmlineentry
	dad	b
	indirect	;hl now address of line
	pop	d	
	mov	a,e	;column
	srlr	a
	srlr	a
	srlr	a
	mov	c,a
	mvi	b,0
	dad	b	;hl now points to byte
			;containing bit
	mov	a,e
	ani	7	;get low three bits
	inr	a	;do one rotate for zero bit
	mov	b,a
	mvi	a,0	;reset all bits
	stc		;set carry to rotate in
..loop:
	ral
	djnz	..loop
	ora	m	;set the bit
	mov	m,a
	ret

bmelset:	;h is row, l is column of bit to set
		;and to end of line
	push	h
	call	bmbset
	pop	h
	inr	l
	mov	a,l
	cpi	charsperline
	jrnz	bmelset
	ret

bmesset:	;h is row, l is column of bit to set
		;and to end of line
	push	h
	call	bmelset
	pop	h
..loop:
	inr	h
	mov	a,h
	cpi	linesonscreen - 1
	rz
	push	h
	call	bmrset	;reset a row
	pop	h
	jmpr	..loop

bmbtest:	;h is row, l is column of bit to 
		;test, return zero if clear
		;nonzero if set
	push	h
	mov	c,h
	slar	c
	mvi	b,0
	lxi	h,bmlineentry
	dad	b
	indirect	;hl now address of line
	pop	d	
	mov	a,e	;column
	srlr	a
	srlr	a
	srlr	a
	mov	c,a
	mvi	b,0
	dad	b	;hl now points to byte
			;containing bit
	mov	a,e
	ani	7	;get low three bits
	inr	a	;do one rotate for zero bit
	mov	b,a
	mvi	a,0	;reset all bits
	stc		;set carry to rotate in
..loop:
	ral
	djnz	..loop
	ana	m	;test the bit
	ret

	.page
;
;	bit map scroll routines, scroll with set bits
;	filliing last line, or reset bits
;
bmscrreset:		;scroll with reset
	call	bmscr
	lxi	h,bml23
	lxi	d,bml23+1
	lxi	b,9
	mvi	m,0
	ldir
	ret

bmscrset:		;scroll with set
	call	bmscr
	lxi	h,bml23
	lxi	d,bml23+1
	lxi	b,9
	mvi	m,0ffh
	ldir
	ret

bmscr:		;scroll up with no fill at bottom
	lxi	h,bml1
	lxi	d,bml0
	lxi	b,230	;twenty three lines of 
			;10 bytes each
	ldir
	ret

bmilreset:	;insert line of reset bits, a is row
	push	psw	;save row
	mov	b,a
	mvi	a,23	;lines on screen - 1
	sub	b	;lines to scroll
	jrz	..justreset	;last line,nothing to
			;scroll
	slar	a	;*2
	mov	b,a
	slar	a
	slar	a	;*8
	add	b	;*10, bytes per row
	mov	c,a
	mvi	b,0
	lxi	d,bml23+9	;last byte of bit map
	lxi	h,bml22+9
	lddr
..justreset:
	pop	psw
	jmp	bmrreset	;reset inserted
			;row and return

bmdlreset:	;a is row to delete, scroll up
		;and insert line of reset at bottom
	push	psw	;save row
	mov	b,a
	mvi	a,23	;lines on screen - 1
	sub	b	;lines to scroll
	jrz	..justreset	;last line,nothing to
			;scroll
	slar	a	;*2
	mov	b,a
	slar	a
	slar	a	;*8
	add	b	;*10, bytes per row
	mov	c,a
	mvi	b,0
	pop	psw
	push	b
	slar	a	;mult by 2
	lxi	h,bmlineentry
	mov	c,a
	mvi	b,0
	dad	b
	mov	e,m
	inx	h
	mov	d,m	;line to copy to
	inx	h
	mov	c,m
	inx	h
	mov	b,m	;line to copy from
	push	b
	pop	h
	pop	b
	ldir
	jmpr	..doreset
..justreset:
	pop	psw
..doreset:
	mvi	a,23	;reset last line
	jmp	bmrreset	;return from there

	.page
	.sbttl	'bitmap data structures'
;	NOTE: THIS SECTION MUST NOT BE PLACED
;	IN ROM !!!!!!!!!!!!

;
;	the line entry table contains the addresses
;	of the bitmap for each screen line
;
bmlineentry:
	.word	bml0
	.word	bml1
	.word	bml2
	.word	bml3
	.word	bml4
	.word	bml5
	.word	bml6
	.word	bml7
	.word	bml8
	.word	bml9
	.word	bml10
	.word	bml11
	.word	bml12
	.word	bml13
	.word	bml14
	.word	bml15
	.word	bml16
	.word	bml17
	.word	bml18
	.word	bml19
	.word	bml20
	.word	bml21
	.word	bml22
	.word	bml23

;
;	the bit map for each line, set to zero 
;	initially
;
bml0:	.byte	0,0,0,0,0,0,0,0,0,0
bml1:	.byte	0,0,0,0,0,0,0,0,0,0
bml2:	.byte	0,0,0,0,0,0,0,0,0,0
bml3:	.byte	0,0,0,0,0,0,0,0,0,0
bml4:	.byte	0,0,0,0,0,0,0,0,0,0
bml5:	.byte	0,0,0,0,0,0,0,0,0,0
bml6:	.byte	0,0,0,0,0,0,0,0,0,0
bml7:	.byte	0,0,0,0,0,0,0,0,0,0
bml8:	.byte	0,0,0,0,0,0,0,0,0,0
bml9:	.byte	0,0,0,0,0,0,0,0,0,0
bml10:	.byte	0,0,0,0,0,0,0,0,0,0
bml11:	.byte	0,0,0,0,0,0,0,0,0,0
bml12:	.byte	0,0,0,0,0,0,0,0,0,0
bml13:	.byte	0,0,0,0,0,0,0,0,0,0
bml14:	.byte	0,0,0,0,0,0,0,0,0,0
bml15:	.byte	0,0,0,0,0,0,0,0,0,0
bml16:	.byte	0,0,0,0,0,0,0,0,0,0
bml17:	.byte	0,0,0,0,0,0,0,0,0,0
bml18:	.byte	0,0,0,0,0,0,0,0,0,0
bml19:	.byte	0,0,0,0,0,0,0,0,0,0
bml20:	.byte	0,0,0,0,0,0,0,0,0,0
bml21:	.byte	0,0,0,0,0,0,0,0,0,0
bml22:	.byte	0,0,0,0,0,0,0,0,0,0
bml23:	.byte	0,0,0,0,0,0,0,0,0,0
