;last modified	14-Dec-82
	.page
	.sbttl	'equates for crtfox rom'

romavail ==	1000h

verloc	==	36h	;location of version in rom
revloc	==	37h	;location of revision in rom

true	==	0ffh
false	==	0

crts	==	39h		;8276  control port
crtm	==	38h		;8276 mode port
ppstat	==	18h		;host stat port
ppdati  ==	20h     	;host data in
ppdato  ==	28h             ;host data out
int8048 ==	08h		;keyboard data
portbright ==	10h		;brightness control port

;
;	commands for 8275-8276 (sent to control port)
;
reset8275 ==	0	;note: 4 bytes to mode port
			;must follow

start8275 ==	20h	;note: low bits must have
			;dma burst and cycles info
burstspace ==	0	;no clocks between dma bursts
burstlength ==	3	;8 bytes per dma burst

stop8275 ==	40h	;stop display

readdlightpen == 60h	;note: must be followed by two
			;reads of status for col then row

loadcursor ==	80h	;must be followed by two bytes
			;to mode port for col then row

enable8275interupts == 0a0h

disable8275ints	== 0c0h 

preset8275counters == 0e0h
;
;	byte 1 of 8275-8276 programming sequence
;	bit definitions for reset command
;
nonspacedrows	==	0
spacedrows	==	80h
horzcharperrow	==	4fh	;for display of 80

;
;	byte 2 of 8275-8276 programming sequence
;	bit definitions for reset command
;
rowpervrtc	==	40h	;for two character
				;row times per vertical 
				;retrace
rowsperframe	==	18h	;for 25 rows

;
;	byte 3 of 8275-8276 programming sequence
;	bit definitions for reset command
;
linenumberofunderline == 90h	;for tenth line
linesperchar	==	9	;for ten lines

;
;	byte 4 of 8275-8276 programming sequence
;	bit definitions for reset command
;
lcm	==	80h	;line counter mode
nontransparent == 40h	;field attribute mode
transparent ==	0	;field attribute mode
;	cursor control formats
revblink ==	0	;reverse blinking
underblink ==	10h	;underline blinking
revnoblink ==	20h	;reverse non blinking
undernoblink ==	30h	;underline non blinking

charperhrtc ==	12	;horizontal retrace
			;character count

;
;	codes to send to keyboard
;
getresync ==	2		;keyboard should send resync count
getver	==	3		;keyboard should send version

;
;	bit definitions for screen attribute chars
;	NOTE: BIT 7 MUST BE A 1 AND BIT 6 A 0
;
bitunderline	== 5
bitreversevideo == 4
bitalternateset == 3
bitunused	== 2
bitblink	== 1
bithalfintensity== 0
	
;
;	non-printing ascii characters
;
home	==	01h
backward==	08h
delete  ==	7fh
forward ==	06h
bell	==	07h
tab	==	09h
lf	==	0ah
erascr  ==	0ch
cr	==	0dh
up	==	1ah
escape  ==	1bh

;
;	special symbols for screen
;
symcr	==	28	;displays as cr
symlf	==	29	;displays as lf
symcntrshift == 30	;Displays as uparrow over S

;
;	reserved special function keys
;
progchar  ==	0e1h	;control shift f1
localchar ==	0e2h	;control shift f2
delchar	  ==	0e2h	;control shift f2
trapchar  ==	0f0h	;control shift f16
escchar   ==	0fbh	;control shift f27
resetchar ==	0fdh	;control shift f29
flushchar ==	0feh	;control shift f30

;
;	screen discriptions
;
linesonscreen ==	25
charsperline ==		80
controlcharsperline ==	16	;maximum control chars per line
				;for 8275
typeahead ==		253		;characters buffered from
					;keyboard and to host

;
;	screen numbers
;
hostscrn	==	0	;screen for use of host computer
crtscrn		==	1	;screen for crt driver use
hinetscrn	==	2	;screen for hinet(message) use

;
;	ram table size equates
;
ramloc	==	4000h	;location of ram 
			;in crt controller
ramavail ==	4000h	;length of ram availible

lencode	==	1000h	;length of space allocated to
			;downloadable code
lenstatusline == 60h	;length of buffer for status
			;line at top of screen
lenprogtab == 96*2	;length of table of pointers
			;to programed strings
			;allow 96 entries though only
			;90 used
lenpbuf	==	800h	;allow 2k for programable key
			;strings
lentranspose ==	80h	;length of keyboard and display
			;transposition tables
