	.title	'Share HiNet partitions'
	.sbttl	'SHARE'
version	==	1
revision==	0
TRACElock==	1	; trace locks and unlocks
;----------
; Share all HiNet partitions
;
; Relocate the SHARE code to high core (immediately
; below the CCP).  All BDOS calls will be intercepted
; and analysed to see if partition sharing is required.
;
; This program is a temporary fix to the partition
; sharing problem (also known as the R/O problem).
; 
; The algorithm is as follows:
;
; Intercept every BDOS call.  Process only those calls
; which may cause one or more disk writes.  
;
; Function  Description
; --------  -----------
;    16     close file
;    19     delete file
;    21     write sequential
;    22     make file
;    23     rename file
;    30     set file attributes
;    34     write random
;    40     write random, zero fill
;
;  The locking algorithm is always used for all calls
;  except function 21.  Since write sequential 
;  is the most common, the FCB and cr (current record)
;  are examined to see if a new block is required.
;  If not, the locking algorithm can be bypassed.
;
;  The locking algorithm is as follows:
;
;  1.  Determine the name of the partition to be locked
;  2.  Lock the partition.
;  3.  Reset the selected drive.
;  4.  Do the BDOS operation.
;  5.  If write-seq or write-rnd, close the file.
;  6.  Unlock the partition.
;----------
; To create the SHARE.COM file:
;
; A>azm share o  (base address = 0)
; A>ren share0.hex=share.hex
; A>azm share o  (base address = 100h)
; A>ddt share.hex
; -ishare0.hex
; -r400
; -^C
; A>save 5 share.com
;----------
	.pabs
	.phex
BASE	=\	"Enter base address (0 or 100h)"
	.loc	BASE
;----------
; Initialization code
;----------
	.ife	BASE-100h,[
	lxi	D,hellomsg
	mvi	C,9
	call	5	; greet the user
	mvi	C,12
	call	5	; get CP/M version number
	mov	A,L
	ora	A
	jrz	..cpm14	; jump if CP/M 1.4
	cpi	22h
	jrz	..cpm22 ; jump if CP/M 2.2
	lxi	D,badver
	mvi	C,9
	call	5	; bad version number
	ret
..cpm14:
..cpm22:
	mvi	B,8	; CCP is 800h bytes
	lhld	6	; get real BDOS address
	push	H
	mov	A,H	; address of BDOS
	sub	B	; CCP code
	sui	(lenSHARE+0FFh)/100h; SHARE code
	sta	7	; store new BDOS address
;----------
; Compute offsetted addresses within SHARE program
	lxi	H,SHARE
	lxi	D,SHARE+200h
	lxi	B,lenSHARE
..reloc:	
	ldax	D
	cmp	M
	jrz	..next
	lda	7
	sui	2	; SHARE assembled at 200h
	add	M	; offset to high core
	mov	M,A
..next:
	inx	H
	inx	D
	dcx	B
	mov	A,B
	ora	C
	jrnz	..reloc
	pop	H
	shld	BDOSadr
;----------
; Intercept all SELDSK calls (so that location of
; SHARE code will not be lost across a warmboot)
	lhld	1
	lxi	D,19h
	dad	D	; point to adr of SELDSK
	mov	E,M
	inx	H
	mov	D,M	; get adr of SELDSK
	xchg
	shld	SELadr	; store in SHARE code
	lxi	H,SELdsk-206h
	lbcd	6
	dad	B	; compute new address of seldsk
	mov	B,H
	mov	C,L
	xchg
	mov	M,B
	dcx	H
	mov	M,C	; store adr of new SELDSK
;----------
; Intercept all Warmboots, print message
	lhld	1
	lxi	D,1
	dad	D	; point to adr of WBOOT
	mov	E,M
	inx	H
	mov	D,M	; get adr of WBOOT
	xchg
	shld	WBadr	; store in WBOOT code
	lxi	H,WBOOT-206h
	lbcd	6
	dad	B	; compute new address of wboot
	mov	B,H
	mov	C,L
	xchg
	mov	M,B
	dcx	H
	mov	M,C	; store adr of new WBOOT
;----------
; Move SHARE code to high memory, then return to CCP
	lxi	H,SHARE
	lded	6
	mvi	E,0
	lxi	B,lenSHARE
	ldir		; move the code
	jmp	0	; return to the op sys
;----------
; Greeting message
hellomsg:
	.ascii	"SHARE version "
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.byte	'$'
badver:
	.ascii	"Unknown CP/M version$"
	.loc	BASE+100h
	]
	.page
;----------
; Base of new BDOS
;----------
SHARE:	.byte	0,0,0,0,0,0 ; serial number stored here
	jmp	SHAREcpm
BDOS:	.byte	0C3h	; jump to real BDOS
BDOSadr:.word	0	; filled in by initial code
;----------
; Ignore non-write BDOS functions
SHAREcpm:
	mov	A,C
	cpi	16	; close file
	jc	BDOS	; ignore console functions
	jrz	..try
	cpi	19	; delete file
	jrz	..try
	cpi	21	; write sequential
	jrz	..try
	cpi	22	; make file
	jrz	..try
	cpi	23	; rename file
	jrz	..try
	cpi	30	; set file attributes
	jrz	..try
	cpi	34	; write random
	jrz	..try
	cpi	40	; write random, zero fill
	jrnz	BDOS	; ignore other funcs
..try:
	sspd	usersSP
	lxi	SP,shareSTACK
	sbcd	usersBC
	sded	usersDE
;
; Determine drive number
	lded	usersDE
	ldax	D	; get drive code from FCB
	ora	A	; if zero, use default drive
	jrz	..curdsk
	dcr	A	; else drive = code - 1
	cpi	4	; check for bad drive number
	jnc	goBDOS	; go to BDOS if error
	jmpr	..curpart
..curdsk:
	mvi	C,25
	call	BDOS	; get default drive number
;
; Determine partition number and name
..curpart:
	sta	lockdrive; save for later
	mov	C,A
	call	SELDSK  ; HiNet 2.2 gives DE = mapbyte
	xchg
	dcx	H
	lxi	D,lockname+7
	lxi	B,8
	lddr		; move partition name to lock
;
; If write-sequential, must lock only if new alloc block
; (For simplicity, will assume 2K block size - this 
;  will not work for 1/4 Mbyte partition, and is 
;  a little inefficient for 8 Mbyte partition.
;
	lda	usersC
	cpi	21
	jrnz	..lock	; skip if not write-seq
	lhld	usersDE	; get FCB address
	lxi	D,32
	dad	D	; point to current record no.
	mov	A,M	; get record no.
	cpi	7Fh	; must lock at end of extent
	jrz	..lock
	ani	0Fh
	jnz	goBDOS	; must lock at start of block
;
; Ask HiNet to lock the partition
..lock:
	.ife	TRACElock,[
	lxi	D,lockmsg
	call	PRTMSG	; tell user we're locking
	]
	lxi	H,lockstring
	shld	LOCKadr	; point to lock string
	call	LOCK	; lock this partition
	lda	LOCKres
	ora	A	; loop until partition is avail
	jrnz	..lock
;---------------------------------
; Reset the current drive
;	lxi	D,1	; assume resetting drive A
;	lda	lockdrive
;	ora	A
;	jrz	..reset
;..shift:rlcr	E	; shift drive select bit left
;	dcr	A
;	jrnz	..shift
;..reset:
;	mvi	C,37
;	call	BDOS	; reset drive selected by DE
;
; Call the BDOS
;------------------------------------
;
; Get current DMA address (very gludgy code)
	lhld	1
	lxi	D,22h
	dad	D	; point to "JMP SETDMA"
	mov	E,M
	inx	H
	mov	D,M
	xchg		; point to "SETDMA: SBCD dma"
	inx	H
	inx	H	; skip "SBCD"
	mov	E,M
	inx	H
	mov	D,M
	xchg		; point to "dma: .word 0"
	mov	E,M
	inx	H
	mov	D,M
	sded	curDMA	; save current DMA address
;
; Get current default drive
	mvi	C,25
	call	BDOS
	sta	curDRIVE; save drive number
;
; Reset the disk system
	mvi	C,13
	call	BDOS
;
; Reset DMA address
	lded	curDMA
	mvi	C,26
	call	BDOS
;
; Reset current drive
	lda	curDRIVE
	mov	E,A
	mvi	C,14
	call	BDOS
;
; Call BDOS
        lded	usersDE
	lbcd	usersBC
	call	BDOS
	push	PSW	; save BDOS result
;
; If write-sequential or write-random, close the file
; (this causes directory to be updated)
	lda	usersC
	cpi	21	; write sequential
	jrz	..close
	cpi	34	; write random
	jrz	..close
	cpi	40	; write random, zero-fill
	jrnz	..unlock
..close:
	lded	usersDE	; point to users FCB
	mvi	C,16
	call	BDOS	; close the file
;
; Unlock the partition
..unlock:
	.ife	TRACElock,[
	lxi	D,unmsg
	call	PRTMSG
	]
	call	UNLOCK
	pop	PSW	; restore BDOS result
	lspd	usersSP
	ret		; return to user
;----------
; Jump to the real BDOS
goBDOS:
	lded	usersDE
	lbcd	usersBC
	lspd	usersSP
	jmp	BDOS
;----------
; The lock string is stored here
;
lockstring:
	.byte	lenlock
	.ascii	"$"
lockname:
	.blkb 	8	; 8 bytes for partition name
	.ascii	"$"
lenlock	==	.-lockstring-1
lockdriv:.byte	0	; drive number to be locked
curDMA:	.word	0	; current DMA address
curDRIV:.byte	0	; current drive
	.ife	TRACElock,[
lockmsg:
	.byte	0Dh,0Ah
	.ascii	"---------- Locking ----------$"
unmsg:
	.byte	0Dh,0Ah
	.ascii	"---------- Unlocking ----------$"
	]
;----------
; Call the HiNet lock and unlock functions
LOCKadr	==	4Ah	; address of lock string
LOCKres ==	49h	; lock result status
;----------
LOCK:	lhld	1
	lxi	D,5Dh
	dad	D
	pchl
;----------
UNLOCK:	lhld	1
	lxi	D,63h
	dad	D
	pchl
;----------
SELDSK:	lxi	H,SHARE
	shld	6	; "reload" the SHARE code
	.byte	0C3h
SELadr:	.word	0	; jump to real seldsk
;----------
WBOOT:	lxi	SP,80h	; use temporary stack
	lxi	D,bootmsg
	call	PRTMSG	; tell user we're sharing
	.byte	0C3h
WBadr:	.word	0	; jump to real wboot
bootmsg:.ascii	[0Dh][0Ah]"(Sharing)$"
;----------
; Print a variable length string (terminated by "$")
;  Reg in:  DE = address of string
PRTmsg:
	ldax	D
	cpi	'$'
	rz		; terminate if "$"
	call	PRTchr
	inx	D
	jmpr	PRTmsg
;----------
; Print a character
;  Reg in:  A = char to print
PRTchr:
	push	H
	push	D
	push	B
	push	PSW
	mov	E,A
	mvi	C,2
	call	BDOS
	pop	PSW
	pop	B
	pop	D
	pop	H
	ret
;----------------------------------------
; Storage area
crlf:	.byte	0Dh,0Ah,'$'
usersSP:.word	0
usersDE:.word 	0
usersC: 
usersBC:.word	0
;----------
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
	.byte	76h,76h,76h,76h,76h,76h,76h,76h
shareSTACK:
lenSHARE==	.-SHARE
	.end
