version	==	1
revision==	0
	.title	'SYSTEM GENERATION PROGRAM FOR DSC3/4'
	.pabs
	.phex
;
;-------------------------------------
;
;     CP/M system generation program
;
; Define some constants:
cr	=	0Dh	; define carraige return
lf	=	0Ah	; define line feed
sysstrt =	900h	; start memory loc of system
;
;----------
; Main Program
	.loc	100h
start:
	ei		  ; enable interrupts
	lxi	SP,stack  ; define the stack
	lxi	H,initMSG ; print initial message
	call	prtmsg
..0:	lxi	H,srcQST  ; print source question
	call	prtmsg
	call	getdsk	  ; get result disk
	jrz	..1	  ; if cr then skip source
	sta	srcdsk	  ; store disk in print message
	lxi	H,srcMSG  ; print verify message
	call	prtmsg
	call	waitcr	  ; wait for a cr
	jrnz	..0	  ; if not cr then reask
	lxi	H,READF	  ; read the system into memory
	shld	IOdir
	call	RWSYS
	lxi	H,donMSG  ; print function complete
	call	prtmsg

..1:	lxi	H,dstQST  ; print destination question
	call	prtmsg
	call	getdsk	  ; get result disk
	jz	..2	  ; warm boot if cr
	sta	dstdsk	  ; print verify message
	lxi	H,dstMSG
	call	prtmsg
	call	waitcr	  ; wait for a cr
	jrnz	..1	  ; if not cr then reask
	lxi	H,WRITF   ; write system from memory
	shld	IOdir
	call	RWSYS
	lxi	H,donMSG  ; print function complete
	call	prtmsg
	jmpr	..1
	
..2:	lxi	H,exitMSG ; print an exit message
	call	prtmsg
	jmp	0	  ; Warm boot

initMSG:.ascii	'System Generation Program '
	.byte	version+'0','.'
	.byte	revision/10+'0',revision@10+'0'
	.asciz	[cr][lf][lf]
srcQST:	.asciz	'Source disk name: (return to skip) '
srcMSG:	.ascii	'SOURCE ON '
srcdsk:	.byte	'A'
	.asciz	', type return to continue.'
dstQST:	.ascii	'Destination disk name: (return to '
	.asciz	'reboot) '
dstMSG:	.ascii	'DESTINATION ON '
dstdsk:	.byte	'A'
	.asciz	', type return to continue.'
donMSG: .asciz	'FUNCTION COMPLETE'[cr][lf]
exitMSG:.asciz	[lf]'Exit SYSGEN.'

	.blkb	30
stack	=	.
;----------
; Get disk name, select disk, and return 0 if cr
getdsk:
	call	CONIN	; get a char
	cpi	60h	; check for u/l case
	jm	..1
	sbi	20h	; make everything lower
..1:	cpi	'A'	; is char legal?
	jrz	..2
	cp	'B'
	jrz	..2
	cpi	'C'
	jrz	..2
	cpi	'D'
	jrz	..2
	cpi	cr
	jrnz	getdsk	; if not get another char
	lxi	H,crlfMSG ; type crlf
	call	prtmsg
	sub	A	; return A=0
	ret

..2:	push	PSW	; save the char
	sta	retdsk	; echo char then crlf
	lxi	H,retMSG
	call	prtmsg
	pop	PSW	; restore PSW
	push	PSW	; and resave it
	sbi	'A'	; get select disk name
	mov	C,A
	call	SELDSK	; select the disk
	pop	PSW	; get back the char
	ora	A	; set not zero flag
	ret

;----------
; Wait for a cr
waitcr:
	call	CONIN	; get a char
	cpi	cr	; loop if cr
	push	PSW
	lxi	H,crlfMSG ; print crlf
	call	prtmsg
	pop	PSW
	ret

;----------
; Print a message 
prtmsg:
	mov	A,M	; get next char
	ora	A
	rz		; return if zero
	push	H	; save HL
	mov	C,A	; output the char
	call	CONOUT
	pop	H	; restore HL
	inx	H	; increment to next char
	jmpr	prtmsg	; print it

retMSG:
retdsk:	.byte	'A'
crlfMSG:.asciz	[cr][lf]
;----------
; Read or Write the system (depending on IOdir)
RWSYS:
	call	HOME	; Home to track 0
	lxi	B,sysstrt ; load system start address
	call	SETDMA
	mvi	C,1	; start at sector 1
	call	SETSEC
	lxi	B,26*128 ; transfer entire track
	call	SETBYT
	call	RDWR	; read or write data

	mvi	C,1	; go to track 1
	call	SETTRK
	lxi	B,sysstrt+26*128 ; load address is 26
	call	SETDMA	; sectors later
	mvi	C,1	; start at sector 1
	call	SETSEC
	call	CPMMAP	; determine density
	lxi	B,52*128 ; assume double
	ani	0C0h	; mask out for density
	cpi	0	; check for single density
	jrnz	..1
	lxi	B,26*128 ; if single load 26 sectors
..1:	call	SETBYT
	call	RDWR	; transfer the data
	ret

;----------
; Call bios directly using WBOOT in low memory
WBOOT	=	1

CONIN:
	lhld	WBOOT
	lxi	D,06h
	dad	D
	pchl

CONOUT:
	lhld	WBOOT
	lxi	D,09h
	dad	D
	pchl

HOME:
	lhld	WBOOT
	lxi	D,15h
	dad	D
	pchl
	
SELDSK:
	lhld	WBOOT
	lxi	D,18h
	dad	D
	pchl

SETTRK:
	lhld	WBOOT
	lxi	D,1Bh
	dad	D
	pchl

SETSEC:
	lhld	WBOOT
	lxi	D,1Eh
	dad	D
	pchl

SETDMA:
	lhld	WBOOT
	lxi	D,21h
	dad	D
	pchl

RDWR:
	lhld	WBOOT
	lded	IOdir
	dad	D
	pchl
IOdir:	.word	0
READF	=	24h
WRITF	=	27h

CPMMAP:
	lhld	WBOOT
	lxi	D,60h
	dad	D
	pchl

SETBYT:
	lhld	WBOOT
	lxi	D,66h
	dad	D
	pchl

.end
