/*
 *	@(#) /usr/include/assert.h 1.1 84/09/19 Copyright Microsoft Corporation, 1983
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/***	assert.h
 *
 *	MODIFICATION HISTORY
 *	M000	RRR	9/29/82
 *	- Added ASSERT to work indistinguishable from a function call. 
 *	M001	05 Oct 82	andyp
 *	- Parenthesized 'expr' in macro expansion.  Previously negation
 *	  operator ('!') would bind incorrectly in expressions like:
 *	     ASSERT (a < b && c < d);
 *	M002	14 Apr 83	andyp
 *	- 3.0 upgrade.  Removed 'ASSERT', fixed 'assert'.  'assert' now does
 *	  what 'ASSERT' did, i.e. it works correctly.  Note that it matches
 *	  the documentation, so there is no compatibility issue.  'ASSERT'
 *	  was never documented.
 */

/***	assert -- program verification
 *
 *	assert(expr);
 *	_assert(expr);
 *	int  expr;
 */

#ifndef	M_LINT	/*{*/

#ifndef	NDEBUG	/*{*/
#  define	_assert(expr)\
	if (!(expr)) {\
		fprintf(stderr,"Assertion failed: file %s, line %d\n", __FILE__, __LINE__);\
		exit(1);\
	}\
		else
#  define	assert(expr)	_assert(expr)
#else		/*}{*/
#  define	_assert(expr)
#  define	assert(expr)
#endif		/*}*/

#endif		/*}*/
