/*
 *	@(#) h/locking.h 1.4 84/09/16 Copyright Microsoft Corporation, 1983
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/*
 *	@(#) h/locking.h 1.4 84/09/16 Copyright Microsoft Corporation, 1983
 */




/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */



/*
 *   Flag values for locking system call (sys/sys/locking.c)
 */

#define LK_UNLCK  0	/* unlock request */
#define LK_LOCK   1	/* lock request */
#define LK_NBLCK  2	/* non-blocking lock request */
#define LK_RLCK   3	/* read permitted only lock request */
#define LK_NBRLCK 4	/* non-blocking read only lock request */

struct locklist {
	    /* NOTE: ll_link must be first in struct */
	struct locklist	*ll_link;	/* link to next lock region */
	ushort  	ll_flags;	/* misc flags ** sleeping */
	struct proc	*ll_proc;	/* process which owns region */
	off_t		ll_start;	/* starting offset */
	off_t		ll_end;		/* ending offset, zero is eof */
};

extern struct locklist locklist[]; /* The lock table itself */

/* ll_flags */
#define LROLOCK   01	/* record is locked & is read only */
