/*
 * math.h
 *
 * constant definitions and external subroutine declarations for the math
 * subroutine library.
 *
 * Copyright (C) Microsoft Corporation, 1984
 */

/* external subroutine declarations - defines the names for all available
 * routines in the math subroutine library
 */

extern double acos(), asin(), atan(), atan2();
extern double cos(), sin(), tan();
extern double cosh(), sinh(), tanh();
extern double atof();
extern double j0(), j1(), jn(), y0(), y1(), yn();
extern double ceil(), fabs(), floor(), fmod();
extern double exp(), log(), log10(), pow(), sqrt();
extern double frexp(), ldexp(), modf();
extern double hypot(), cabs();

/* Constant definitions - here we should have definitions for such things
 * as the largest and smallest float/double values, and any others which
 * might be desirable
 */

extern double HUGE;
