/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS SPECIFIC TO THE
 * INTEL 80286 CPU AND MAY REQUIRE MODIFICATION
 * WHEN ADAPTING XENIX TO NEW HARDWARE.
 */

/*
**
**	MODIFICATION HISTORY
**
**	M000 	9/27/84	lees
**	- Added support for IPC messages.
**
**	M001	10/30/84	lees
**	- Added support for UNIX System V semaphores.
**
**	M002	11/07/84	lees
**	- Integrated new format for map structure.
**
**	M003	12/19/84	lees
**	- Added support for UNIX System V shared data.
**
**	M004	03/08/85	lees
**	- Changed the number of entries in sdtab[].
**
**	M005	07/09/85	lees
**	- Removed #include "machdep.h"
*/

#define NOEXTGDT	/* 
			 * This prevents mmu.h from redefining gdt[] -
		   	 * necessitated by the fact that you cannot initialize
		   	 * a union. Refer to dtab and desctab in relsym86.h
			 */
#include  "buf.h"
#include  "proc.h"
#include  "text.h"
#include  "dir.h"
#include  "a.out.h"
#include  "user.h"
#include  "mmu.h"
#include  "file.h"
#include  "inode.h"
#include  "map.h"
#include  "callo.h"
#include  "mount.h"
#include  "var.h"
#include  "systm.h"
#include  "utsname.h"

#ifdef PROFILING
#include  "sysinfo.h"
#endif

#include  "locking.h"
#include  "ipc.h"	/* M000 */
#include  "sd.h"
#include  "msg.h"	/* M000 */
#include  "sem.h"	/* M001 */

int Timezone=TIMEZONE;
int Dstflag=DSTFLAG;
int Cmask=CMASK;

int nfs1=0;	/* DSA */
int nfs2=0;	/* DSA */
int do_nfc;	/* DSA */

#if NBUF==0
struct buf buf[MAXBUF+NSABUF];
#else
struct buf buf[NBUF+NSABUF];
#endif
char sabuf[NSABUF][BSIZE];
struct	hbuf	hbuf[NHBUF];	/* buffer hash table */
struct file file[NFILE];
struct inode inode[NINODE];
struct locklist locklist[NFLOCKS];
struct sd sdtab[NSDSEGS * NSDSLOTS];		/* M004 */
struct shmid_ent shmid_tab[NSDSEGS];            /* M003 */
int    shmid_pos;				/* M003 */
struct proc proc[NPROC];
struct text text[NTEXT];
struct mapent coreent[CMAPSIZ];			/* M002 */
struct map    coremap = {0, CMAPSIZ, coreent};	/* M002 */
struct mapent swapent[SMAPSIZ];			/* M002 */
struct map    swapmap = {0, SMAPSIZ, swapent};	/* M002 */
struct callo callout[NCALL];
struct cblock cfree[NCLIST];
struct mount mount[NMOUNT];

#ifdef PROFILING
struct sysinfo sysinfo;
struct syswait syswait;
#endif

int Hz=HZ;

/*
 * Global Descriptor Table --- statically initializes the GDT.
 *    - The gdt, tss, stack and data live in the same segment.
 *    -	The memory for the kernel starts at kmemstart.
 *    - The selector values defined in the include file, mmu.h, MUST 
 *	agree with the gdt table entries in order for this xenix to work.
 *    - The initialization of this table should not have to change 
 *	for a new port.
 *    - For middle-model kernel, the start-up code will fill in the
 *	kernel text and data entries and the KENTRY entry point.
 */

extern	struct idt	idt[];
extern	struct idt	idtfp[];
extern 	unsigned	tss[];

int Ngdt=NGDT;

int Num8259=NUM_8259;

#define KDSOFF(x)	((unsigned) (x))

#define DCA_TSS		(DST_ATASK  | DSA_PRESENT)		/* tss */
#define DCA_CGATE	(DST_CGATE  | DSA_PRESENT | DSA_RING3)	/* call gate */

#define GDTLIM	(sizeof(gdt) - 1)			/* gdt limit */
#define STKLIM	(KSSIZE - 1)				/* ksp limit */

struct dtab gdt[NGDT] = {
    { 0, 0, 0, 0, 0 },				/* 0 Empty slot  */
    { GDTLIM, KDSOFF(gdt), 0, DSA_DATA, 0 },	/* 8 GDT alias */
    { IDTLIM, 0, 0, DSA_DATA, 0 },		/* 10 IDT alias */
    { 0, 0, 0, 0, 0 },				/* 18 kernel ds */
    { 0, 0, 0, 0, 0 },				/* 20 kernel auxdata */
    { 0, 0, 0, 0, 0 },				/* 28 kernel cs SEG 1 */
    { 0, 0, 0, 0, 0 },				/* 30 kernel cs SEG 2 */
    { 0, 0, 0, 0, 0 },				/* 38 kernel cs SEG 3 */
    { 0, 0, 0, 0, 0 },				/* 40 kernel cs SEG 4 */
    { STKLIM, KDSOFF(&u), 0, DSA_DATA, 0 },	/* 48 kernel ss  */
    { TSSLIM, KDSOFF(tss), 0, DCA_TSS, 0 },	/* 50 tss */
    { TSSLIM, KDSOFF(tss), 0, DSA_DATA, 0 },	/* 58 tss alias */
    { 0, 0, 0, 0, 0 },				/* 60 Kernel work */
    { 0, 0, 0, 0, 0 },				/* 68 Kernel work */
    { 0, 0, 0, 0, 0 },				/* 70 Kernel work */
    { 0, 0, 0, 0, 0 },				/* 78 Map Work fuss */
    { 0, 0, 0, 0, 0 },				/* 80 Kernel work (copyio) */
    { 0, 0, 0, 0, 0 },				/* 88 CLDT_SEL */
 /* { ftooff(kentry), ftoseg(kentry), 1, DCA_CGATE, 0 }, */
    { 0, 0, 1, DCA_CGATE, 0 },			/* 90 Kernel Entry */
    { 0, 0, 0, 0, 0 },				/* 98 Kernel work (buffers) */
    { 0, 0, 0, 0, 0 },				/* A0 Kernel work (buffers) */
    { 0, 0, 0, 0, 0 },				/* A8 Kernel work (buffers) */
    { 0, 0, 0, 0, 0 },				/* B0 Kernel work (swapper) */
    { 0, 0, 0, 0, 0 },				/* B8 Kernel work (swapper) */
    { 0, 0, 0, 0, 0 },				/* C0 Kernel work (swapper) */
    { 0, 0, 0, 0, 0 },				/* C8 Kernel work (swapper) */
};

/*
 * Permanently mapped to the current proc's ldt array.
 * ldt[FIRSTU_SEL/SELSZ] references the FIRSTU_SEL ldt.
 */
fdesc_t	*ldt = (fdesc_t *) sotofar(ULDT_SEL, 0);

/*
 * Permanently mapped to the current proc's ldt info array.
 * This array is parallel to the ldt one and holds extra information
 */
struct ldtinf far *ldtinfo = (struct ldtinf far *) sotofar(ULINFO_SEL, 0);

paddr_t	kmemstart;

/* message facility */		/* M000 */
struct	mapent		msgent[MSGMAP];			/* M002 */
struct	map		msgmap = {0, MSGMAP, msgent};	/* M002 */
struct  msqid_ds	msgque[MSGMNI];
struct	msg		msgh[MSGTQL];
struct	msginfo		msginfo = 
{
	MSGMAP,
	MSGMAX,
	MSGMNB,
	MSGMNI,
	MSGSSZ,
	MSGTQL,
	MSGSEG
};

/* System V semaphore facility */	/* M001 */
struct	semid_ds	sema[SEMMNI];
struct	sem		sem[SEMMNS];
struct	mapent		sement[SEMMAP];			/* M002 */
struct	map		semmap = {0, SEMMAP, sement};	/* M002 */
struct	sem_undo	*sem_undo[NPROC];
#define SEMUSZ	(sizeof(struct sem_undo) + sizeof(struct undo) * SEMUME)
int	semu[((SEMUSZ * SEMMNU) + NBPW - 1) / NBPW];
union	
{
	ushort		semvals[SEMMSL];
	struct		semid_ds	ds;
	struct		sembuf		semops[SEMOPM];
}	semtmp;
struct	seminfo		seminfo =
{
	SEMMAP,
	SEMMNI,
	SEMMNS,
	SEMMNU,
	SEMMSL,
	SEMOPM,
	SEMUME,
	SEMUSZ,
	SEMVMX,
	SEMAEM,
};

struct var v=
{
	NBUF,
	NSABUF,
	NHBUF,
	NHBUF-1,
	MAXBUF,
	NCALL,
	NINODE,
	&inode[NINODE],
	NFILE,
	&file[NFILE],
	NMOUNT,
	&mount[NMOUNT],
	NPROC,
	&proc[NPROC],
	NTEXT,
	&text[NTEXT],
	NCLIST,
	MAXUPRC,
	MAXMEM,
	NFLOCKS,
	NSDSEGS,
	NSDSLOTS,
	MSGMAP,
	MSGMAX,
	MSGMNB,
	MSGMNI,
	MSGTQL,
	MSGSSZ,
	MSGSEG,
	SEMMAP,
	SEMMNI,
	SEMMNU,
	SEMMSL,
	SEMOPM,
	SEMUME,
	SEMVMX,
	SEMAEM,
	SEMMNS,
	SEMUSZ,
};


