/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS SPECIFIC TO THE
 * INTEL 80286 CPU AND MAY REQUIRE MODIFICATION
 * WHEN ADAPTING XENIX TO NEW HARDWARE.
 */

/*
**	MODIFICATION HISTORY
**
**	M000	9/27/84	lees
**	- Added support for IPC messages.
**
*/

typedef	struct { int r[1]; }	*physadr;
typedef	long		daddr_t;
typedef	char		*caddr_t;
typedef	unsigned short	ushort;
typedef	unsigned short	ino_t;
typedef	char		cnt_t;
typedef	long		time_t;
typedef	int		label_t[6];	/* return, sp, si, di, bp */
typedef	short		dev_t;
typedef	long		off_t;
typedef	long		paddr_t;
typedef	unsigned short	mloc_t;		/* memory region location */
typedef	unsigned short	msize_t;	/* memory region size */
typedef long		key_t;		/* IPC key	      */   /* M000 */

/* 80286 special types */
#define	faddr_t		char far *		/* far address */
#define	fdesc_t		struct desctab far	/* far ldt entry */

	/* selectors and constructor for device code */
#define major(x)        (((unsigned)(x)>>8))
#define minor(x)        ((x)&0377)
#define makedev(x,y)	(dev_t)((x)<<8 | (y))


/* 'void' type compatibility */
#ifdef	M_OLDVOID
typedef	int	void;
#endif

/* 'unsigned' type compatibility */
#ifdef	M_OLDSIGN	/* { */

typedef	char	uchar_t;
typedef	long	ulong_t;

#define	GETUCHAR(uc)	(0xff & (uc))		/* extract value */
/* WARNING: you will lose the high bit */
#define	GETULONG(ul)	(0x7fffffffL & (ul))	/* extract value */

#else			/* }{ */

typedef unsigned char uchar_t;
typedef unsigned long ulong_t;
#define	GETUCHAR(uc)	(uc)
#define	GETULONG(ul)	(ul)

#endif			/* } */

struct saddr {			
	unsigned short	sa_seg;
	long		sa_off;
};
