/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS SPECIFIC TO THE
 * INTEL 80286 CPU AND MAY REQUIRE MODIFICATION
 * WHEN ADAPTING XENIX TO NEW HARDWARE.
 */


/*
 * Text structure.
 * One allocated per pure procedure on swap device.
 * Manipulated by text.c
 */
struct text
{
	unsigned short	x_daddr;	/* disk address of 1st text seg */ 
	msize_t		x_size;		/* size (in pages) of first text seg */
	mloc_t  	x_caddr;        /* core address of 1st text seg */
	struct inode 	*x_iptr;	/* inode of prototype */
	char		x_count;	/* reference count */
	char		x_ccount;	/* number of loaded references */
	char		x_flag;		/* traced, written flags */
	char		x_lcount;	/* lock count */
	unsigned short	x_fcsel;	/* first code selector */
	unsigned short	x_lsize;	/* size of the text ldt in bytes */
};

extern struct text text[];

#define	XTRC	01		/* Text may be written, exclusive use */
#define	XWRIT	02		/* Text written into, must swap out */
#define	XLOAD	04		/* Currently being read from file */
#define	XLOCK	010		/* Being swapped in or out */
#define	XWANT	020		/* Wanted for swapping */
#define XFPU    0100            /* text uses floating point */
#define XLARGE	0200		/* large text */
