/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */
/***	mnttab.h
 *
 *	MODIFICATION HISTORY
 *	M000	14 Apr 83	andyp	3.0 upgrade
 *	- Added comments.
 *	- Added ISMNTFREE() macro.
 *	- Added various pathname macros.
 */

#define	NMOUNT	32	/* arbitrarily large; actual value is configurable */

/*
 * Format of the /etc/mnttab file which is set by the mount(1m)
 * command
 */
struct mnttab {
	char	mt_dev[LFNMAX];	/* name of place special file mounted */
	char	mt_filsys[LPNMAX];	/* root name of mounted special file */
	short	mt_ro_flg;	/* read/write permissions */
	time_t	mt_time;	/* date on which mounted */
};

#define	ISMNTFREE(mp)	((mp)->mt_dev[0] == '\0')

#define	PNMNTTAB	"/etc/mnttab"		/* administrative mount table */
#define	MDMNTTAB	0644			/* mode of same */
#define	PNMNTLCK	"/etc/mntlock"		/* lock for same */
#define	PNMNTTMP	"/tmp/mntXXXXXX"	/* skel for mktemp(3) */
