/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */



/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */



/*
 * Declaration of block device switch. Each entry (row) is
 * the only link between the main unix code and the driver.
 * The initialization of the device switches is in the file conf.c.
 */
extern struct bdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_strategy)();
	struct iobuf *d_tab;
} bdevsw[];

/*
 * Character device switch.
 */
extern struct cdevsw
{
	int	(*d_open)();
	int	(*d_close)();
	int	(*d_read)();
	int	(*d_write)();
	int	(*d_ioctl)();
	struct tty	*d_ttys;
} cdevsw[];

extern	int	bdevcnt;
extern	int	cdevcnt;

/*
 * Line discipline switch.
 */
extern struct linesw
{
	int	(*l_open)();
	int	(*l_close)();
	int	(*l_read)();
	int	(*l_write)();
	int	(*l_ioctl)();
	int	(*l_input)();
	int	(*l_output)();
	int	(*l_mdmint)();
} linesw[];

extern	int	linecnt;

/*
 * Terminal switch.
 */
extern struct termsw
{
	int	(*t_input)();
	int	(*t_output)();
	int	(*t_ioctl)();
} termsw[];

extern	int	termcnt;

extern	int		(*vecintsw[])( );
extern	int		vintmin, vintmax;

extern	int		bdevcnt, bdevmax;
extern	int		cdevcnt, cdevmax;

struct vecshrsw {
	int		shr_ivec;		/* interrupt level */
	int		(*shr_intr)( );		/* ptr to xxintr */
};
extern	struct vecshrsw	vecshrsw[];
extern	int		vshrcnt, vshrmax;

extern			nodev( ), nulldev( ), novec( );
extern			shrvec( );

#include "idd.h"

extern	struct iddsw	far *iddsw[];
extern	int		iddcnt, iddmax;

extern	int		(*dinitsw[])(), (*binitsw[])(), (*cinitsw[])();
