/*
 *	%Z% %M% %I% %D% %Q%
 *
 *	Copyright (C) Microsoft Corporation, 1983
 *
 *	This Module contains Proprietary Information of Microsoft
 *	Corporation and AT&T, and should be treated as Confidential.
 */

/*
 * THIS FILE CONTAINS CODE WHICH IS DESIGNED TO BE
 * PORTABLE BETWEEN DIFFERENT MACHINE ARCHITECTURES
 * AND CONFIGURATIONS. IT SHOULD NOT REQUIRE ANY
 * MODIFICATIONS WHEN ADAPTING XENIX TO NEW HARDWARE.
 */



/*
 * One file structure is allocated for each open/creat/pipe call.
 * Main use is to hold the read/write pointer associated with
 * each open file.
 */
struct	file
{
	char	f_flag;
	char	f_res;		/* reserved field to word align */
	ushort	f_count;	/* reference count */
	struct inode *f_inode;	/* pointer to inode structure */
	union {
		off_t	f_off;		/* read/write character pointer */
		struct file *f_slnk;    /* next waiter for semaphore */
	} f_un;
};

#define	f_offset	f_un.f_off

extern struct file file[];	/* The file table itself */

/* flags */
#define	FOPEN	(-1)
#define	FREAD	00001
#define	FWRITE	00002
#define	FNDELAY	00004
#define	FAPPEND	00010
#define FSYNC   0100
#define	FMASK	00377

/* open only modes */
#define	FCREAT	00400
#define	FTRUNC	01000
#define	FEXCL	02000
