/* this program generates the proper defines for those variables with
   funny offsets within the u_struct.  Unfortunately c seems to be too
   dumb to let us just use the expression in OFFSET below
   in static variable initializations in print.c */
   
#include <sys/param.h>
#include <sys/dir.h>

#include <sys/user.h>

#define OFFSET(x) ( (char *)&u.x - (char *)&u )
#define PROFF(name,p) printf("#define %s (USTRUCT+%d)\n",name,OFFSET(p));

struct user u;	
main() {
	/* Take a snapshot of the user struct size on the machine on which
	 * adb is built. Use this for run time checking of the user struct
	 * size to determine if there has been a change. User structure size
	 * is an entry in the symbol table of /vmunix (userSIZE).
	 */
printf("#define ADB_USIZE %d\n", sizeof(struct user));
PROFF("PROCP", u_procp); 	/* proc table entry pointer */
PROFF("P0BR", u_pcb.pcb_p0br); 	/* seg 0 base register */
PROFF("P0LR", u_pcb.pcb_p0lr); 	/* seg 0 length register and astlevel */
PROFF("P1BR", u_pcb.pcb_p1br); 	/* seg 1 base register */
PROFF("P1LR", u_pcb.pcb_p1lr); 	/* seg 1 length register and pme */
PROFF("UERROR", u_error);
PROFF("U_SSIZE", u_ssize);	/* stack size in clicks. */
PROFF("U_DSIZE", u_dsize);	/* data size in clicks. */
PROFF("U_CODE", u_code); 	/* signal info in the uarea */
PROFF("U_AR0", u_ar0);		/* Pointer to user's saved r0 */
PROFF("U_FLOATMASK", u_floatmask); /* mask of floating point facilities */
}


