/* $Header:kill.c 12.0$ */
/* $ACIS:kill.c 12.0$ */
/* $Source: /ibm/acis/usr/src/bin/RCS/kill.c,v $ */

#ifndef lint
static char *rcsid = "$Header:kill.c 12.0$";
#endif

static	char *sccsid = "@(#)kill.c	4.4 (Berkeley) 4/20/86";
/*
 * kill - send signal to process
 */

#include <signal.h>
#include <ctype.h>
#include <stdio.h>

char *signm[] = { 0,
"HUP", "INT", "QUIT", "ILL", "TRAP", "IOT", "EMT", "FPE",	/* 1-8 */
"KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "URG",	/* 9-16 */
"STOP", "TSTP", "CONT", "CHLD", "TTIN", "TTOU", "IO", "XCPU",	/* 17-24 */
"XFSZ", "VTALRM", "PROF", "WINCH", 0, "USR1", "USR2", 0,	/* 25-31 */
};
char *progname;

main(argc, argv)
char **argv;
{
	register signo, pid, res;
	int errlev;
	extern char *sys_errlist[];
	extern errno;
	progname = argv[0];

	errlev = 0;
	if (argc <= 1) {
	usage:
		fprintf(stderr, "usage: %s [ -sig ] pid ...\n",progname);
		printf("for a list of signals: kill -l\n");
		exit(2);
	}
	if (*argv[1] == '-') {
		if (argv[1][1] == 'l') {
			for (signo = 0; signo <= NSIG; signo++) {
				if (signm[signo])
					printf("%s ", signm[signo]);
				if (signo == 16)
					printf("\n");
			}
			printf("\n");
			exit(0);
		} else if (isdigit(argv[1][1])) {
			signo = atoi(argv[1]+1);
			if (signo < 0 || signo > NSIG) {
				printf("%s: %s: number out of range\n",
					progname, argv[1]);
				exit(1);
			}
		} else {
			char *name = argv[1]+1;
			for (signo = 0; signo <= NSIG; signo++)
				if (signm[signo] && !strcmp(signm[signo], name))
					goto foundsig;
			printf("%s: %s: unknown signal; kill -l lists signals\n", progname, name);
			exit(1);
foundsig:
			;
		}
		argc--;
		argv++;
	} else
		signo = SIGTERM;
	argv++;
	while (argc > 1) {
		if (!(isdigit(**argv) || **argv == '-'))
			goto usage;
		res = kill(pid = atoi(*argv), signo);
		if (res<0) {
			printf("%u: %s\n", pid, sys_errlist[errno]);
			errlev = 1;
		}
		argc--;
		argv++;
	}
	return(errlev);
}
