/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:lex.yy.c 12.0$ */
/* $ACIS:lex.yy.c 12.0$ */
/* $Source: /ibm/acis/usr/src/etc/named/tools/ns.lookup/src/RCS/lex.yy.c,v $ */

#ifndef lint
static char *rcsid = "$Header:lex.yy.c 12.0$";
#endif

# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX 200
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin ={stdin}, *yyout ={stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 *******************************************************************************
 *
 *	Copyright (c) 1985 Regents of the University of California.
 *	All rights reserved.  The Berkeley software License Agreement
 *	specifies the terms and conditions for redistribution.
 *
 *	@(#)commands.l	5.3 (Berkeley) 2/14/86
 *
 *  commands.l
 *
 *  	Andrew Cherenson 	CS298-26  Fall 1985
 *
 *	Lex input file for the nslookup program command interpreter.
 *	When a sequence is recognized, the associated action
 *	routine is called. The action routine may need to
 *	parse the string for additional information.
 *
 *  Recognized commands: (identifiers are shown in uppercase)
 *
 *	server NAME	- set default server to NAME, using default server
 *	lserver NAME	- set default server to NAME, using initial server
 *	finger [NAME]	- finger the optional NAME
 *	root		- set default server to the root
 *	ls NAME		- list the domain NAME
 *	view FILE	- sorts and view the file with more
 *	set OPTION	- set an option
 *	help 		- print help information
 *	? 		- print help information
 *	opt[ions]	- print options, current server, host
 *	NAME		- print info about the host/domain NAME 
 *			  using default server.
 *	NAME1 NAME2	- as above, but use NAME2 as server
 *
 *
 *   yylex Results:
 *	0		upon end-of-file.
 *	1		after each command.
 *  
 *******************************************************************************
 */

#include "res.h"
extern char rootServerName[];

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
	{ 
					    /* 
					     * 0 == use current server to find
					     *	    the new one.
					     * 1 == use original server to find
					     *	    the new one.
					     */
					    SetDefaultServer(yytext, 0); 
					    return(1);
					}
break;
case 2:
	{ 
					    SetDefaultServer(yytext, 1); 
					    return(1);
					}
break;
case 3:
			{ 
					    SetDefaultServer(rootServerName, 1);
					    return(1);
					}
break;
case 4:
	{
					    /* 
					     * 2nd arg. 
					     *  0 == output to stdout
					     *  1 == output to file
					     */
					    Finger(yytext, 1); 
					    return(1);
					}
break;
case 5:
	{ 
					    Finger(yytext, 0); 
					    return(1);
					}
break;
case 6:
	{ 
					    ViewList(yytext); 
					    return(1);
					}
break;
case 7:
	{ 
					    /* 
					     * 2nd arg. 
					     *  0 == output to stdout
					     *  1 == output to file
					     */
					    ListHosts(yytext, 1);
					    return(1);
					}
break;
case 8:
	{ 
					    ListHosts(yytext, 0);
					    return(1);
					}
break;
case 9:
 	{ 
					    SetOption(yytext); 
					    return(1);
					}
break;
case 10:
			{ 
					    extern void PrintHelp();

					    PrintHelp();
					    return(1);
					}
break;
case 11:
			{ 
					    PrintHelp();
					    return(1);
					}
break;
case 12:
			{ 
					    ShowOptions(TRUE); 
					    return(1);
					}
break;
case 13:
	{
					    /* 
					     * 0 == output to stdout
					     * 1 == output to file
					     */
					    LookupHost(yytext, 1); 
					    return(1);
					}
break;
case 14:
	{
					    LookupHost(yytext, 0); 
					    return(1);
					}
break;
case 15:
	{
					    /* 
					     * 0 == output to stdout
					     * 1 == output to file
					     */
					    LookupHostWithServer(yytext, 1); 
					    return(1);
					}
break;
case 16:
{
					    LookupHostWithServer(yytext, 0); 
					    return(1);
					}
break;
case 17:
			{ 
					    return(1);
					}
break;
case 18:
				{ 
					    printf("Unrecognized command: %s", 
					    		yytext); 
					    return(1);
					}
break;
case 19:
				{ ; }
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
int yyvstop[] ={
0,

19,
0,

17,
18,
19,
0,

-14,
0,

-11,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

18,
0,

17,
18,
0,

-14,
0,

14,
18,
0,

11,
18,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-16,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-12,
-14,
0,

-14,
0,

-14,
0,

-14,
0,

-14,
0,

-16,
0,

16,
18,
0,

-14,
0,

-10,
-14,
0,

-8,
-16,
0,

-14,
0,

-12,
-14,
0,

12,
14,
18,
0,

-14,
0,

-3,
-14,
0,

-14,
0,

-14,
0,

-14,
0,

-13,
0,

-14,
0,

-10,
-14,
0,

10,
14,
18,
0,

-8,
-16,
0,

8,
16,
18,
0,

-14,
0,

-14,
0,

-3,
-14,
0,

3,
14,
18,
0,

-14,
0,

-9,
-16,
0,

-9,
0,

-14,
0,

-13,
0,

13,
18,
0,

-5,
-14,
0,

-14,
0,

-14,
0,

-14,
0,

-9,
-16,
0,

9,
16,
18,
0,

-9,
0,

9,
18,
0,

-6,
-16,
0,

-6,
0,

-15,
0,

-5,
-14,
0,

5,
14,
18,
0,

-8,
0,

-8,
0,

-14,
0,

-12,
-14,
0,

-14,
0,

-6,
-16,
0,

6,
16,
18,
0,

-6,
0,

6,
18,
0,

-15,
0,

15,
18,
0,

-5,
-16,
0,

-7,
-15,
0,

-8,
0,

8,
18,
0,

-8,
0,

-14,
0,

-1,
-16,
0,

-5,
-16,
0,

5,
16,
18,
0,

-7,
-15,
0,

7,
15,
18,
0,

-2,
-16,
0,

-1,
-16,
0,

1,
16,
18,
0,

-4,
-13,
0,

-2,
-16,
0,

2,
16,
18,
0,

-4,
-13,
0,

4,
13,
18,
0,

-7,
0,

-4,
-15,
0,

-7,
0,

7,
18,
0,

-4,
-15,
0,

4,
15,
18,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] ={
0,0,	0,0,	0,0,	0,0,	
2,4,	0,0,	4,4,	0,0,	
0,0,	0,0,	0,0,	1,3,	
2,5,	2,6,	4,4,	4,16,	
7,18,	7,19,	5,17,	8,8,	
8,20,	9,4,	29,41,	11,4,	
42,41,	18,18,	18,19,	0,0,	
10,4,	9,18,	9,19,	11,18,	
11,19,	12,4,	0,0,	13,4,	
10,18,	10,19,	23,32,	62,78,	
55,72,	12,18,	12,19,	13,18,	
13,19,	2,7,	21,4,	4,4,	
2,4,	7,7,	4,4,	22,4,	
7,7,	41,41,	21,18,	21,19,	
34,48,	34,49,	18,28,	22,18,	
22,19,	63,79,	9,7,	73,72,	
11,7,	9,7,	2,8,	11,7,	
72,72,	10,7,	93,92,	5,8,	
10,7,	78,78,	12,7,	29,42,	
13,7,	12,7,	18,29,	13,7,	
74,74,	74,75,	116,115,	39,39,	
39,40,	126,125,	41,56,	21,7,	
24,4,	41,56,	21,7,	130,129,	
22,7,	55,73,	0,0,	22,7,	
24,18,	24,19,	85,85,	85,86,	
0,0,	72,89,	0,0,	14,26,	
72,89,	2,9,	78,94,	2,10,	
15,27,	27,38,	5,9,	2,11,	
5,10,	43,57,	2,12,	25,35,	
5,11,	2,13,	2,14,	5,12,	
0,0,	2,15,	5,13,	5,14,	
31,44,	9,21,	5,15,	35,51,	
10,22,	24,7,	23,33,	26,36,	
24,7,	26,37,	28,39,	28,40,	
39,55,	11,23,	30,4,	47,64,	
32,4,	37,53,	37,19,	50,65,	
12,24,	13,25,	30,18,	30,19,	
32,32,	32,19,	52,68,	33,4,	
34,50,	36,4,	57,76,	21,30,	
64,80,	46,62,	22,31,	33,18,	
33,19,	36,18,	36,19,	38,4,	
46,62,	48,48,	48,49,	28,28,	
65,81,	46,63,	28,28,	38,18,	
38,19,	68,82,	37,7,	44,58,	
44,59,	37,7,	77,92,	30,7,	
80,96,	32,45,	30,7,	81,97,	
32,46,	0,0,	32,4,	45,60,	
45,61,	51,66,	51,67,	79,79,	
33,7,	0,0,	36,7,	33,7,	
0,0,	36,7,	48,28,	0,0,	
32,4,	32,29,	0,0,	24,34,	
38,7,	53,4,	0,0,	38,7,	
44,7,	54,71,	54,19,	44,7,	
0,0,	53,53,	53,19,	56,74,	
56,75,	0,0,	48,29,	71,71,	
45,45,	0,0,	51,7,	45,45,	
79,95,	51,7,	58,58,	58,59,	
0,0,	60,60,	60,61,	77,93,	
66,66,	66,67,	32,4,	69,83,	
69,84,	0,0,	83,83,	83,84,	
30,43,	0,0,	54,7,	101,101,	
101,102,	54,7,	53,69,	106,115,	
56,56,	53,70,	0,0,	56,56,	
71,87,	70,85,	70,86,	71,88,	
0,0,	76,90,	76,91,	58,28,	
0,0,	82,98,	82,19,	92,92,	
33,47,	66,28,	53,29,	0,0,	
69,69,	0,0,	36,52,	69,69,	
71,29,	87,99,	87,100,	88,101,	
88,102,	89,103,	89,104,	58,29,	
0,0,	38,54,	60,77,	90,90,	
90,91,	66,29,	70,70,	94,108,	
94,109,	70,70,	76,7,	83,55,	
0,0,	76,7,	82,7,	0,0,	
92,107,	82,7,	0,0,	92,107,	
106,116,	95,110,	95,109,	99,99,	
99,100,	119,125,	87,87,	123,129,	
88,88,	87,87,	89,89,	88,88,	
115,115,	89,89,	96,111,	96,19,	
90,105,	0,0,	97,48,	97,49,	
94,94,	103,103,	103,104,	94,94,	
98,98,	98,19,	105,113,	105,114,	
107,117,	107,118,	108,108,	108,109,	
110,110,	110,109,	95,95,	0,0,	
90,106,	95,95,	111,111,	111,19,	
112,121,	112,122,	113,113,	113,114,	
0,0,	115,124,	125,125,	96,7,	
115,124,	0,0,	96,7,	97,7,	
117,117,	117,118,	97,7,	0,0,	
99,55,	98,112,	119,126,	105,105,	
123,130,	107,107,	105,105,	129,129,	
107,107,	120,127,	120,128,	121,121,	
121,122,	124,131,	124,132,	111,120,	
0,0,	112,112,	127,127,	127,128,	
112,112,	98,29,	0,0,	125,133,	
131,131,	131,132,	125,133,	108,119,	
0,0,	133,135,	133,136,	135,135,	
135,136,	134,137,	134,138,	111,29,	
137,137,	137,138,	0,0,	113,123,	
129,134,	0,0,	120,120,	129,134,	
0,0,	120,120,	124,124,	0,0,	
0,0,	124,124,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	133,133,	0,0,	
121,55,	133,133,	134,134,	0,0,	
0,0,	134,134,	0,0,	127,55,	
0,0};
struct yysvf yysvec[] ={
0,	0,	0,
yycrank+1,	0,		0,	
yycrank+-3,	0,		0,	
yycrank+0,	0,		yyvstop+1,
yycrank+-5,	0,		0,	
yycrank+-8,	yysvec+2,	0,	
yycrank+0,	0,		yyvstop+3,
yycrank+-7,	yysvec+4,	yyvstop+7,
yycrank+-10,	yysvec+4,	yyvstop+9,
yycrank+-20,	0,		yyvstop+11,
yycrank+-27,	0,		yyvstop+13,
yycrank+-22,	0,		yyvstop+15,
yycrank+-32,	0,		yyvstop+17,
yycrank+-34,	0,		yyvstop+19,
yycrank+-2,	yysvec+10,	yyvstop+21,
yycrank+-3,	yysvec+9,	yyvstop+23,
yycrank+0,	0,		yyvstop+25,
yycrank+0,	0,		yyvstop+27,
yycrank+-16,	yysvec+4,	yyvstop+30,
yycrank+0,	0,		yyvstop+32,
yycrank+0,	0,		yyvstop+35,
yycrank+-45,	0,		yyvstop+38,
yycrank+-50,	0,		yyvstop+40,
yycrank+-29,	yysvec+10,	yyvstop+42,
yycrank+-87,	0,		yyvstop+44,
yycrank+-4,	yysvec+13,	yyvstop+46,
yycrank+-17,	yysvec+24,	yyvstop+48,
yycrank+-8,	yysvec+10,	yyvstop+50,
yycrank+-125,	yysvec+4,	yyvstop+52,
yycrank+-13,	yysvec+4,	0,	
yycrank+-137,	0,		yyvstop+54,
yycrank+-12,	yysvec+12,	yyvstop+56,
yycrank+-139,	0,		yyvstop+58,
yycrank+-150,	0,		yyvstop+60,
yycrank+-47,	yysvec+9,	yyvstop+62,
yycrank+-11,	yysvec+24,	yyvstop+65,
yycrank+-152,	0,		yyvstop+67,
yycrank+-132,	yysvec+4,	yyvstop+69,
yycrank+-162,	0,		yyvstop+71,
yycrank+-74,	yysvec+4,	yyvstop+73,
yycrank+0,	0,		yyvstop+75,
yycrank+-44,	yysvec+4,	0,	
yycrank+-15,	yysvec+4,	0,	
yycrank+-12,	yysvec+10,	yyvstop+78,
yycrank+-166,	yysvec+4,	yyvstop+80,
yycrank+-178,	yysvec+4,	yyvstop+83,
yycrank+-60,	yysvec+4,	0,	
yycrank+-21,	yysvec+36,	yyvstop+86,
yycrank+-156,	yysvec+4,	yyvstop+88,
yycrank+0,	0,		yyvstop+91,
yycrank+-32,	yysvec+13,	yyvstop+95,
yycrank+-180,	yysvec+4,	yyvstop+97,
yycrank+-49,	yysvec+10,	yyvstop+100,
yycrank+-204,	0,		yyvstop+102,
yycrank+-200,	yysvec+4,	yyvstop+104,
yycrank+-31,	yysvec+4,	0,	
yycrank+-206,	yysvec+4,	yyvstop+106,
yycrank+-40,	yysvec+33,	yyvstop+108,
yycrank+-217,	yysvec+4,	yyvstop+110,
yycrank+0,	0,		yyvstop+113,
yycrank+-220,	yysvec+4,	yyvstop+117,
yycrank+0,	0,		yyvstop+120,
yycrank+-30,	yysvec+4,	0,	
yycrank+-52,	yysvec+4,	0,	
yycrank+-55,	yysvec+10,	yyvstop+124,
yycrank+-58,	yysvec+21,	yyvstop+126,
yycrank+-223,	yysvec+4,	yyvstop+128,
yycrank+0,	0,		yyvstop+131,
yycrank+-59,	yysvec+33,	yyvstop+135,
yycrank+-226,	yysvec+4,	yyvstop+137,
yycrank+-244,	yysvec+4,	yyvstop+140,
yycrank+-210,	yysvec+53,	yyvstop+142,
yycrank+-59,	yysvec+4,	0,	
yycrank+-54,	yysvec+4,	0,	
yycrank+-71,	yysvec+4,	yyvstop+144,
yycrank+0,	0,		yyvstop+146,
yycrank+-248,	yysvec+4,	yyvstop+149,
yycrank+-169,	yysvec+4,	0,	
yycrank+-64,	yysvec+4,	0,	
yycrank+-182,	yysvec+4,	0,	
yycrank+-66,	yysvec+33,	yyvstop+152,
yycrank+-68,	yysvec+11,	yyvstop+154,
yycrank+-252,	yysvec+4,	yyvstop+156,
yycrank+-229,	yysvec+4,	yyvstop+158,
yycrank+0,	0,		yyvstop+161,
yycrank+-89,	yysvec+4,	yyvstop+165,
yycrank+0,	0,		yyvstop+167,
yycrank+-264,	yysvec+4,	yyvstop+170,
yycrank+-266,	yysvec+4,	yyvstop+173,
yycrank+-268,	yysvec+4,	yyvstop+175,
yycrank+-274,	yysvec+4,	yyvstop+177,
yycrank+0,	0,		yyvstop+180,
yycrank+-254,	yysvec+4,	0,	
yycrank+-61,	yysvec+4,	0,	
yycrank+-278,	yysvec+4,	yyvstop+184,
yycrank+-292,	yysvec+4,	yyvstop+186,
yycrank+-305,	yysvec+4,	yyvstop+188,
yycrank+-309,	yysvec+4,	yyvstop+190,
yycrank+-315,	yysvec+4,	yyvstop+193,
yycrank+-294,	yysvec+4,	yyvstop+195,
yycrank+0,	0,		yyvstop+198,
yycrank+-234,	yysvec+4,	yyvstop+202,
yycrank+0,	0,		yyvstop+204,
yycrank+-312,	yysvec+4,	yyvstop+207,
yycrank+0,	0,		yyvstop+209,
yycrank+-317,	yysvec+4,	yyvstop+212,
yycrank+-238,	yysvec+4,	0,	
yycrank+-319,	yysvec+4,	yyvstop+215,
yycrank+-321,	yysvec+4,	yyvstop+218,
yycrank+0,	0,		yyvstop+220,
yycrank+-323,	yysvec+4,	yyvstop+223,
yycrank+-329,	yysvec+4,	yyvstop+225,
yycrank+-331,	yysvec+4,	yyvstop+227,
yycrank+-333,	yysvec+4,	yyvstop+230,
yycrank+0,	0,		yyvstop+233,
yycrank+-303,	yysvec+4,	0,	
yycrank+-73,	yysvec+4,	0,	
yycrank+-343,	yysvec+4,	yyvstop+237,
yycrank+0,	0,		yyvstop+240,
yycrank+-296,	yysvec+4,	0,	
yycrank+-356,	yysvec+4,	yyvstop+244,
yycrank+-358,	yysvec+4,	yyvstop+247,
yycrank+0,	0,		yyvstop+250,
yycrank+-298,	yysvec+4,	0,	
yycrank+-360,	yysvec+4,	yyvstop+254,
yycrank+-337,	yysvec+4,	0,	
yycrank+-76,	yysvec+4,	0,	
yycrank+-365,	yysvec+4,	yyvstop+257,
yycrank+0,	0,		yyvstop+260,
yycrank+-354,	yysvec+4,	0,	
yycrank+-82,	yysvec+4,	0,	
yycrank+-371,	yysvec+4,	yyvstop+264,
yycrank+0,	0,		yyvstop+267,
yycrank+-376,	yysvec+4,	yyvstop+271,
yycrank+-380,	yysvec+4,	yyvstop+273,
yycrank+-378,	yysvec+4,	yyvstop+276,
yycrank+0,	0,		yyvstop+278,
yycrank+-383,	yysvec+4,	yyvstop+281,
yycrank+0,	0,		yyvstop+284,
0,	0,	0};
struct yywork *yytop = yycrank+427;
struct yysvf *yybgin = yysvec+1;
char yymatch[] ={
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
011 ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,'*' ,01  ,01  ,'-' ,'*' ,'-' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,01  ,01  ,01  ,'-' ,01  ,01  ,
01  ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,01  ,01  ,01  ,01  ,'-' ,
01  ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,'*' ,
'*' ,'*' ,'*' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] ={
0,1,1,1,1,1,1,1,
1,1,1,1,1,1,1,1,
1,0,0,0,0,0,0,0,
0};
/*	ncform	4.1	83/08/11	*/

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank){		/* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
