#!/bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# $Header:tailor.uucp.sh 12.0$ 
# $ACIS:tailor.uucp.sh 12.0$ 
# $Source: /ibm/acis/usr/src/etc/tailor/RCS/tailor.uucp.sh,v $ 

UUCP=/usr/lib/uucp
if [ $# != 10 ]
then
      echo Ten parameters are required.
      exit 1
fi
ohost=$1; shift
nhost=$1; shift
opass=$1; shift
npass=$1; shift
odial=$1; shift
ndial=$1; shift
omodem=$1; shift
nmodem=$1; shift
oport=$1; shift
nport=$1; shift
#Find site name in L.sys. May not be same as host name at installation.
osite=`awk '/ibmsupt/ {print $9}' $UUCP/L.sys | sed 's/^U//'`
#Load parameters into L.sys and L-devices files.
ex - $UUCP/L.sys << EOF
/^ibmsupt/s/ U$osite/ U$nhost/
s/ $opass/ $npass/
s/ $odial/ $ndial/
w!
q
EOF
ex - $UUCP/L-devices << EOF
/^ACU/s/ $oport/ $nport/
s/ $omodem/ $nmodem/
w!
q
EOF
#Set /etc/ttys file entry as disabled, 1200 baud
ex - /etc/ttys <<EOF
/^$nport\>/s/\<on\>/off/       
w!
q
EOF
