/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:dumpapa16.c 12.0$ */
/* $ACIS:dumpapa16.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/bitprt_ca/RCS/dumpapa16.c,v $ */

#ifndef lint
static char *rcsid = "$Header:dumpapa16.c 12.0$";
#endif

/* 
 * dumpapa16 -- prepares a file (or standard out)
 *	of the bitmap contents of the apa16 screen
 * 	for use by subsequent filters 
 */

#include <stdio.h>
#include <sys/file.h>
#include <sys/errno.h>

extern int errno, perror();
#define SCANLINES 768
#define LPIXELS 1024
#define LBYTES (LPIXELS/8)
#define BLOCKSIZE 4096
#define READLINES (BLOCKSIZE/LBYTES)

#define APA16BUF 0xf4d80000	/* top of display memory */
#define APA16CSR 0xf0000d12	/* control/status register */
#define INVERTED 0x0400		/* BLACK ON WHITE BACKGROUND bit */
#define SIZE unsigned short


main(argc,argv)
int argc; 
char *argv[];
{
	int i,j,k,inverted;
	int dumpdev;
	char *framebuf;
	SIZE *control;
	char *pbuf,buf[BLOCKSIZE];
	struct  {
		int screenwidth;
		int screenheight;
	} 
	screensize;
#ifdef DEBUG
	fprintf(stderr,"dumpapa16 started.\n");
#endif

	dumpdev = fileno(stdout);
	if (argc > 1)
	{
		fprintf(stderr,"dumpapa16 takes no argument\n");
	}
	screensize.screenwidth = LPIXELS;
	screensize.screenheight = SCANLINES;
	/* first fill the screen buffer */
	if (open("/dev/bus",O_RDONLY) < 0) /* gain bus access */
	{
		perror("/dev/bus");
		exit(2);
	}
	if (((open("/dev/apa16",O_RDONLY)) < 0) &&
	    (errno == EBUSY))  /* see if we even have one */
	{
		perror("/dev/apa16");
		exit(2);
	}
	framebuf = (char *) APA16BUF;
	/* check hardware to see if image color is reversed */
	control = (SIZE *) APA16CSR;
	inverted = (*control) & INVERTED;	
#ifdef DEBUG
	fprintf(stderr,"apa16 csr = %0x  inverted=%d\n",*control,inverted);
#endif DEBUG
	write(dumpdev,&screensize,sizeof(screensize));
	for (i=0;i<SCANLINES;i+=READLINES)
	{
		pbuf = buf;
		for (j=0;j<READLINES;j++)
		{
			if (inverted) /*reverse bits */
				for (k=0;k<LBYTES;k++)
					pbuf[k] = ~(framebuf[k]); 
			else
				for (k=0;k<LBYTES;k++)
					pbuf[k] = framebuf[k]; 
			pbuf += LBYTES;
			framebuf += LBYTES; 
		}
		if (write(dumpdev,buf,BLOCKSIZE) < 0)
		{
#ifdef DEBUG
			fprintf(stderr,"dumpdev=%d\n",dumpdev);
#endif
			perror("could not write to file");
			exit(2);
		}
	}
	exit(0);
}
