/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:strextract.c 12.0$ */
/* $ACIS:strextract.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/lib/src/RCS/strextract.c,v $ */

#ifndef lint
static char *rcsid = "$Header:strextract.c 12.0$";
#endif

/**************************************************************************\
* 									   *
* Name: strextract - string extract					   *
* 									   *
* Synopsis:								   *
* 									   *
* char *strextract(s1, s2, n)						   *
* char *s1, s2;								   *
* int n;								   *
* 									   *
* Description:								   *
* 									   *
* This function extracts upto the first n characters from s2 and puts	   *
* them in s1 which is then null terminated if necessary.  This is	   *
* different from strncpy(3) in that s1 will always be null terminated and  *
* therefore may be n+1 bytes long ( i.e. strlen(s1) may be n).		   *
* s1 is returned.							   *
* 									   *
* See also:								   *
* 									   *
* string(3)								   *
* 									   *
* Bugs:									   *
* 									   *
* This routine does not check for overflow of s1.			   *
* 									   *
\**************************************************************************/

char *strextract (s1, s2, n)
    char *s1;			/* target string */
    char *s2;			/* source string */
    int n;			/* maximun number of non null characters to
				   be copied */
{
    char   *endpt;		/* one past the last character in s2 to be
				   copied */
    char   *orginal_s1;

    orginal_s1 = s1;
    endpt = s2 + n;
    while (*s2 && (s2 != endpt)) {
	*s1++ = *s2++;
    }
    *s1 = '\0';
    return (orginal_s1);
}
