/*
 * 5799-CGZ (C) COPYRIGHT IBM CORPORATION 1986,1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header: getn.c,v 12.0 88/11/11 12:37:37 root dec88 $ */
/* $Source: /ibm/acis/usr/src/ibm/fdb_ca/src/RCS/getn.c,v $ */

#ifndef lint
static char *rcsid = "$Header: getn.c,v 12.0 88/11/11 12:37:37 root dec88 $";
#endif

#include <ctype.h>
#include <stdio.h>
char *lastNonWhite(), *getLeft(), *getRight(), *eatLeadingSpace(), *nextWhite();
char buf[128];
#define not !
getNames(fp, a)
register FILE *fp;
char *a[];
{
	if(fgets(buf, sizeof(buf), fp) == (char *)0)
		return(0);
	trimComment(buf);
	if(strlen(buf) == 0) {
		a[0] = (char *) 0;
		return(1);
	}
	a[0] = getLeft(buf);
#ifdef DEBUG
	printf("strlen a[o]=%d\n",strlen(a[0]));
#endif
	a[1] = getRight(&buf[strlen(a[0])+1]);
	return(1);
}
trimComment(s)
register char *s;
{
	register int c;
	for(; c = *s; ++s) {
		if(c == '#') {
			*s = '\0';
			return;
		}
	}
}
char *
getLeft(s)
register char *s;
{
	register char *p;
	s = eatLeadingSpace(s);
	p = nextWhite(s);
	*p = '\0';
	if(strlen(s) == 0)
		return((char *) 0);
	return(s);
}
char *
getRight(s)
register char *s;
{
	register char *p;
	register int c;
	while(isspace(c = *s) && c)
		++s; 		/* Eat leading space. */
	if(c == 0) {
		fprintf(stderr,"Error:no right field\n");
		exit(1);
	}
	p = lastNonWhite(s);
	*p = '\0';
	return(s);
}

char *
lastNonWhite(s)
register char *s;
{
	while(*s++)
		; /* Go to end of string. */
	--s;
	while(isspace(*--s))
		; /* Back up over white space. */
	return(++s);	/* return ptr to 1st nonwhite char. */
}

char *
eatLeadingSpace(s)
char *s;
{
	while(isspace(*s))
		++s;
	return(s);
}

char *
nextWhite(s)
register char *s;
{
	while(not isspace(*s) && *s)
		++s;
	return(s);
}

