/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#ifndef CR_SEEN
#define CR_SEEN 1
/* $Header:creg.h 12.0$ */
/* $ACIS:creg.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/creg.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidcreg = "$Header:creg.h 12.0$";
#endif

	/*\
	|*	int	 cr_init(constraint);
	|*	CREG	*cr_mark()
	|*	int	 cr_remark(creg)
	|*	CREG	*cr_xymark(x,y)
	|*	int	 cr_xyremark(creg,x,y)
	|*	int	 cr_return(creg,done)
	|*	int	 cr_xreturn(creg)
	|*	int	 cr_yreturn(creg)
	|*	int	 cr_free(creg)
	\*/

extern int cr_debug;

typedef struct CR {
    			int16		cr_x;
			int16		cr_y;
			struct CR	*cr_next;
			int		 cr_orient;
		  } CREG;

/***============================================================***/

#define CR_FREE_REG	1
#define CR_KEEP_REG	0

#define _CR_X	0x01
#define _CR_Y	0x02

/***============================================================***/

extern	int	 cr_init();
#define cr_mark()	cr_xymark(vp_x,vp_y)
extern	CREG	*cr_xymark();
#define cr_remark(r)	cr_xyremark(r,vp_x,vp_y)
extern	int	 cr_xyremark();
#define cr_return(r,d)	_cr_return(_CR_X|_CR_Y,r,d)
#define cr_xreturn(r,d)	_cr_return(_CR_X,r,d)
#define cr_yreturn(r,d)	_cr_return(_CR_Y,r,d)
extern	int	 _cr_return();
extern	int	 cr_free();

#endif /* CR_SEEN */
