/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
#ifndef RP_PVT_SEEN
#define RP_PVT_SEEN
/* $Header:private_rp.h 12.0$ */
/* $ACIS:private_rp.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/private_rp.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidprivate_rp = "$Header:private_rp.h 12.0$";
#endif

/***============================================================***/
/***		PRIVATE INFORMATION -- SPEED WARTS		***/
/***============================================================***/

#define _RP_FONT_OVERHEAD	2048
#define _RP_CHAR_OVERHEAD(w,h)	14+(((w+15)/16)*2*h)

/***============================================================***/

#define _RP_LM_ENTRY_SIZE	(sizeof(unsigned)*8)
#define _RP_LOADMAP_SIZE	(RP_NUMBEROFCHARS/(_RP_LM_ENTRY_SIZE))

typedef struct RPMTE {
    			FONT		*rp_mt_font;
			unsigned	 rp_mt_map[_RP_LOADMAP_SIZE];
			int	 	 rp_mt_index;
			int	 	 rp_mt_size;
			int	 	 rp_mt_used;
		     } _rp_mtab_entry;

extern unsigned *_rp_loadmap;
extern int	_rp_download();

#define _rp_isloaded(c)	(rp_active?(_rp_loadmap[(c)/_RP_LM_ENTRY_SIZE]>>\
				((c)%_RP_LM_ENTRY_SIZE))&0x1:TRUE)

#define _rp_load(c)	(rp_active?_rp_loadmap[(c)/_RP_LM_ENTRY_SIZE]|=\
			((unsigned)01)<<((c)%_RP_LM_ENTRY_SIZE):FALSE)


/***============================================================***/

#define _rp_drw_command(c)	(_rp_byte(c),rp_state= RP_MARKED)
#define _rp_drw_parmcmd(c,p)	(_rp_byte((c)|(p)),rp_state= RP_MARKED)
#define _rp_command(c)		_rp_byte(c)
#define _rp_parmcmd(c,p)	_rp_byte((c)|(p))
#define _rp_byte(b)		putc((b),rp_file)
#define _rp_word(w)		u_put16(w,rp_file)
#define _rp_24bits(w)		u_put24(w,rp_file)
#define _rp_char(c)		_rp_byte(c)
#define _rp_string(st)		fprintf(rp_file,"%s",st)
#define _rp_block(b,n)		fwrite((char *)b,1,(unsigned)n,rp_file)
#define _rp_flush()		(fflush(rp_file))


#endif /* RP_PVT_SEEN */
