/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:text.c 12.0$ */
/* $ACIS:text.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/pmp/RCS/text.c,v $ */

#ifndef lint
static char *rcsid = "$Header:text.c 12.0$";
#endif

#include <stdio.h>
#include <ctype.h>
#include <utils.h>
#include <pmp_commands.h>
#include <char.h>
#include <font.h>
#include <text.h>
#include <rp.h>
#include <vp.h>

/***===================================================================***/

#define WHERE_AM_I	"text.c"

int txt_debug;

static char	 txt_chars[RP_MAX_STRING];
static int	 txt_length;
static int	 txt_width;
static FONT	*txt_font;

/***===================================================================***/

#define txt_checkxy()	 { if ((rp_y!=vp_y)||(rp_x+txt_width!=vp_x)) {\
    				if (txt_length) txt_flush(); \
				rp_mvabsolute(vp_x,vp_y); \
			  } }
#define txt_activate(f)	 { if (rp_active!=(f)) { \
    				if (!rp_activate(f)) (f)= rp_active;\
				txt_font= (f); \
			  } }

/*

*/

/***===================================================================***/

int
txt_flush()
{
    D_ENTRY(txt_debug,"txt_flush()\n");
    if ((!txt_length)||(!txt_font)) {
	RETURN(FALSE);
    }
    if (rp_active!=txt_font) {
	rp_activate(txt_font);
    }
    rp_string(txt_chars,txt_length,txt_width);
    txt_length= txt_width= 0;
    vp_mode(VP_NONE,NULL);
    RETURN(TRUE);
}

/*

*/

/***===================================================================***/

int
txt_putc(font,ch)
register1 FONT *font;
register4 char  ch;
{
register2 int    chr_width;
register3 CHAR	*fchar;

    D_ENTRY2(txt_debug,"txt_putc(0x%x,%d)\n",font,ch);
    if (!font) {			/* font doesn't exist */
        RETURN(FALSE);
    }
    vp_flush(VP_TEXT);
    if ((txt_font)&&(txt_font!=font)) {	/* nope, text in another font? */
       txt_flush();
    }

    txt_activate(font);

    fchar= fnt_char(font,ch);
    chr_width= ch_totalwidth(fchar);
					/* is character on virtual page? */
    if (vp_inpage(vp_x+chr_width,vp_y)) {
	if (txt_length>=RP_MAX_STRING) 	/* is buffer full? */
	    txt_flush();
	txt_checkxy();
    
	txt_chars[txt_length++]= ch;
	txt_width+= chr_width;
	rp_download(ch,fchar);
    }
    else {
	if (isprint(ch))
	   warning3("Character '%c' off page map (%d,%d)\n",ch,vp_x,vp_y);
	else
	   warning3("Character (0%o) off page map (%d,%d)\n",ch,vp_x,vp_y);
	action("not printed (cursor updated, though)\n");
    }
    vp_x+= chr_width;
    vp_mode(VP_TEXT,txt_flush);
    RETURN(TRUE);
}

/*

*/

/***===================================================================***/

int
txt_putnstr(font,str,char_knt)
register5 FONT	*font;
register2 char	*str;
register3 int	 char_knt;
{
register1 char	 ch;
register4 int	 chr_width;
register6 CHAR	*fchar;
register7 int	 y_inpage;

    D_ENTRY3(txt_debug,"txt_putnstr(0x%x,0x%x,%d)\n",font,str,char_knt);
    if (!font) {
	RETURN(FALSE);
    }

    vp_flush(VP_TEXT);
    if ((txt_font)&&(txt_font!=font)) {
	txt_flush();
    }

    y_inpage= vp_y_inpage(vp_y);
    if (y_inpage) {
       txt_checkxy();
    }

    txt_activate(font);
    
    while (char_knt--) {
	ch= *str++;
	if (txt_length>=RP_MAX_STRING) {
	    txt_flush();
	}
	fchar= fnt_char(font,ch);
	chr_width= ch_totalwidth(fchar);
	if (y_inpage&&vp_x_inpage(vp_x+chr_width)) {
	    txt_chars[txt_length++]= ch;
	    txt_width+= chr_width;
	    rp_download(ch,fchar);
	}
	else {
	    if (isprint(ch)) 
		warning3("'%c' off page map (%d,%d)\n",ch,vp_x,vp_y);
	    else
		warning3("Char (0%o) off page map (%d,%d)\n",ch,vp_x,vp_y);
	    action("not printed (cursor updated, though)\n");
	}
	vp_x+= chr_width;
    }
    vp_mode(VP_TEXT,txt_flush);
    RETURN(TRUE);
}

