/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:machdep.h 12.0$ */
/* $ACIS:machdep.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lib/tools/RCS/machdep.h,v $ */

#if !defined(lint) && !defined(LOCORE)  && defined(RCS_HDRS)
static char *rcsidmachdep = "$Header:machdep.h 12.0$";
#endif

  /*\
  |*
  |*   NOTES --  An attempt to classify the various kinds of machine
  |*             dependencies I've encountered.  Provides all kinds of
  |*		 macros that can be used to select integers of various
  |*             sizes on any architecture, to compensate for brain
  |*		 damage in various compilers, etc.  In general,
  |*		 selecting a known machine will cause all of the other
  |*		 parameters to be set correctly.
  |*
  |*   PROVIDES --
  |*		 ibm032	  -- code will run on an RT/PC.
  |*		 ibm370	  -- code will run on a 370
  |*		 VAX      -- code will run on a VAX
  |*		 PC	  -- code will run on a PC/AT or PC/XT
  |*
  |*		 BSD42    -- code will be running under 4.2bsd UNIX
  |*             SYSV     -- code will be running under SYS V  UNIX
  |*             XENIX    -- code will be running under XENIX
  |*             PCIX     -- code will be running under PCIX
  |*             UNIX     -- code will be running on some (unspecified)
  |*			     version of unix.  Selecting any of the
  |*                         flavors of unix defined above will define
  |*                         UNIX automatically.
  |*		 DOS	 --  code will be running under DOS
  |*             LATTICE --  code will be compiled with LATTICE C
  |*
  |*   Pseudo-types:
  |*	int8, u_int8, int16, u_int16, int32, u_int32  --
  |*			Integers and unsigned integers of the specified
  |*	length.  If the selected architecture does not provide a given
  |*    type, a syntactically invalid, but hopefully informative string
  |*	is defined.   The pseudo-type most commonly undefined is u_int8
  |*	a macro "signed(u_int8)" is provided in these cases which takes
  |*	a 8 bit unsigned quantity, and returns a signed int with the
  |*	corresponding value.  The signed macro should be used whenever
  |*	a signed 8 bit quantity is needed.  Use of int8 is discouraged.
  |*	The pseudo-type UNSIGNED_CHAR is usually defined to correspond
  |*	to u_int8, but is used when characters rather than values are
  |*	being manipulated.
  |*
  |*	MAXINT  -- the largest value that can be represented with the
  |*		type (int).
  |*
  |*	register1-8:
  |*	Different architectures provide different numbers of register
  |*	variables.  Defining too many or two few register variables can
  |*	result in less efficient code.  The defines register1 through
  |*	register8 allow register declarations to be ordered in terms of
  |*	importance.  The variables used most often should be declared
  |*	register1, the least often register8.  Each architecture should
  |*	define as many of these as it permits register variables to be
  |*	"register", and the rest to be ""
  |*
  \*/


#define UNKNOWN_ARCHITECTURE

#ifdef ibm032
#define BIG_ENDIAN
#define signed(c)		((c)>127?256-(c):(c))
#define int8	char		/* really unsigned */
#define u_int8	char
#define int16	short
#define u_int16	unsigned short
#define int32	int
#define u_int32	unsigned
#define UNSIGNED_CHAR	char
#define MAXINT	0x7FFFFFFF
#define register1	register
#define register2	register
#define register3	register
#define register4	register
#define register5	register
#define register6	register
#define register7
#define register8
#undef UNKNOWN_ARCHITECTURE
#endif /* ibm032 */

#ifdef ibm370
#define BIG_ENDIAN
#define signed(c)		((c)>127?256-(c):(c))
#define int8	char		/* really unsigned */
#define u_int8	char
#define int16	short
#define u_int16	unsigned short
#define int32	int
#define u_int32	unsigned
#define UNSIGNED_CHAR	char
#define MAXINT	0x7FFFFFFF
#define register1	register
#define register2	register
#define register3
#define register4
#define register5
#define register6
#define register7
#define register8
#undef UNKNOWN_ARCHITECTURE
#endif /* ibm370 */

#ifdef VAX
#define LITTLE_ENDIAN
#define signed(c)		(c)
#define int8	unsigned char
#define u_int8	char
#define int16	short
#define u_int16	unsigned short
#define int32	int
#define u_int32	unsigned
#define UNSIGNED_CHAR	unsigned char
#define MAXINT	0x7FFFFFFF
#define register1	register
#define register2	register
#define register3	register
#define register4	register
#define register5	register
#define register6	register
#define register7
#define register8
#undef UNKNOWN_ARCHITECTURE
#endif /* VAX */

#ifdef PC
#define LITTLE_ENDIAN
#define register1	register
#define register2	register
#define register3
#define register4
#define register5
#define register6
#define register7
#define register8
#define int16	int
#define u_int16	unsigned
#define int32	long
#define u_int32	unsigned long
#define UNSIGNED_CHAR	char
#define MAXINT	0x7FFF
#undef UNKNOWN_ARCHITECTURE

#ifdef LATTICE
#define signed(c)		((c)>127?256-(c):(c))
#define int8	char		/* really unsigned */
#define u_int8	char
#else /* ifdef PC, not LATTICE */
#define signed(c)		(c)
#define int8	unsigned char
#define u_int8	char
#define UNSIGNED_CHAR	unsigned char
#endif /* PC, not LATTICE */

#endif /* PC */

#ifdef UNKNOWN_ARCHITECTURE
NO KNOWN ARCHITECTURE WAS SELECTED
#endif
