/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:err_log.c 12.0$ */
/* $ACIS:err_log.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/lpfilter/tools/RCS/err_log.c,v $ */

#ifndef lint
static char *rcsid = "$Header:err_log.c 12.0$";
#endif

#include <stdio.h>
#include <utils.h>
#include <hash.h>
#include <environ.h>
#include <err_log.h>
#include <el_lib.h>

/***===================================================================***/

#define WHERE_AM_I	"err_log.c"

/***===================================================================***/

int el_debug=0;

static hashtable *ht_reports= NULL;

/***===================================================================***/

int
el_Init()
{
    D_ENTRY(el_debug,"el_Init()\n");
    el_AddReport("mail",el_txtopen,el_txtclose,el_mailreport);
    RETURN(TRUE);
}

/***===================================================================***/

int
el_AddReport(name,el_open,el_close,el_report)
register2 char  *name;
register3 int  (*el_open)();
register4 int  (*el_close)();
register5 int  (*el_report)();
{
register1 el_funcs *funcs;

    D_ENTRY4(el_debug,"el_AddReport(%s,0x%x,0x%x,0x%x)\n",name,el_open,
							el_close,el_report);
    funcs= (el_funcs *)u_malloc(sizeof(el_funcs));
    funcs->el_fopen=   el_open;
    funcs->el_fclose=  el_close;
    funcs->el_freport= el_report;
    if (!ht_reports)
       ht_reports= ht_new(5);
    ht_put(ht_reports,name,funcs);
    RETURN(TRUE);
}

/***===================================================================***/

error_log *
el_Open(env,fil)
register1 environ *env;
register3 FILE    *fil;
{
register2 char *err_out;

    D_ENTRY2(el_debug,"el_Open(0x%x,0x%x)\n",env,fil);
    err_out= env_String(env,"error_messages",NULL);
    if (err_out)
         RETURN(el_FmtOpen(env,err_out,fil));
    else RETURN(NULL);
}

/***===================================================================***/

error_log *
el_FmtOpen(env,type,fil)
register5 environ *env;
register4 char *type;
register7 FILE *fil;
{
register1 error_log *el;
register2 char *name;
register3 FILE *file;
static int el_lognum=0;
register6 el_funcs *funcs;

    D_ENTRY2(el_debug,"el_Open(%s,0x%x)\n",type,env);
    if (!type)
       RETURN(NULL);

    funcs= (el_funcs *)ht_get(ht_reports,type);
    if (!funcs)
       RETURN(NULL);
    name= u_malloc(30);
    sprintf(name,EL_NAME_FMT,getpid(),el_lognum++);
    if (fil)
         file= u_freopen(name,"w",fil);
    else file= u_fopen(name,"w");
    if (!file) {
	u_free(name);
	RETURN(NULL);
    }
    el= (error_log *)u_malloc(sizeof(error_log));
    el->el_name=  name;
    el->el_file=  file;
    el->el_env=   env;
    el->el_end=   0;
    el->el_calls= funcs;
    if (funcs->el_fopen)
       (*(funcs->el_fopen))(el,type);
    RETURN(el);
}

/***===================================================================***/

el_Report(el,outfil)
register1 error_log *el;
register5 FILE      *outfil;
{
register2 FILE *efil;
register6 int   data_written;

    D_ENTRY2(el_debug,"el_Report(0x%x,0x%x)\n",el,outfil);
    if (!el)
       RETURN(FALSE);

    efil= el->el_file;
    el->el_file= NULL;
    if (efil) {
	u_fclose(efil);
    }
    if (!el->el_name)
       RETURN(FALSE);

    efil= u_fopen(el->el_name,"r");
    if (efil) {
	fseek(efil,0,2); /* end of file */

        data_written= (ftell(efil)>el->el_end);
        if ((data_written)&&(el->el_calls->el_freport)) {
	    fseek(efil,0,0); /* beginning of file */
	    (*(el->el_calls->el_freport))(efil,outfil,el);
	}
        u_fclose(efil);
    }
    RETURN(TRUE);
}

/***===================================================================***/

int
el_Close(el)
register1 error_log *el;
{
    D_ENTRY1(el_debug,"el_Close(0x%x)\n",el);
    if (el->el_calls->el_fclose) {
	(*(el->el_calls->el_fclose))(el);
    }
    if (el->el_file) {
       u_fclose(el->el_file);
       el->el_file= NULL;
    }
    if (el->el_name) {
	unlink(el->el_name);
	u_free(el->el_name);
	el->el_name= NULL;
    }
    el->el_end= 0;
    RETURN(TRUE);
}

/***===================================================================***/
