#! /bin/sh
#
# 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
# LICENSED MATERIALS - PROPERTY OF IBM
# REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
#
# $Header:mergesym.sh 12.0$ 
# $ACIS:mergesym.sh 12.0$ 
# $Source: /ibm/acis/usr/src/ibm/RCS/mergesym.sh,v $ 
#
#
# take a .out file and merge the symbol table into it if it
# was linked with 'symrt0'
#
PATH="${PATH-/bin:/usr/bin:/usr/ucb:}:/usr/ibm:/sys/conf"
export PATH
file="${1?}"
start=${2-0x180}
size=${3-8192}
echo "$0: file $file starts at offset $start for a length $size"
if nm -pg $file | grep SYMTAB
then
	nm -ng $file >/tmp/nm$$
	fixsyms /tmp/nm$$ | makesym -h >/tmp/sym$$
	omerge -p2048 -$start -l+$size /tmp/sym$$ $file
	rm /tmp/sym$$ /tmp/nm$$
	echo "symbol table merged into $file"
else
	echo "SYMTAB not found - use samake... CRT0=symrt0"
	exit 1
fi
