/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdhosts.c 12.0$ */
/* $ACIS:rvdhosts.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/rvdhosts.c,v $ */

#ifndef lint
static char *rcsid = "$Header:rvdhosts.c 12.0$";
#endif

/* This program is part of the Project Athena Remote Virtual Disk (RVD) system.
 * It reads an rvdtab file and prints a list of RVD servers listed there.
 * Each host is listed only once.
 *
 *	$Source: /ibm/acis/usr/src/ibm/rvd/client/RCS/rvdhosts.c,v $
 *	$Author: root $
 *	$Header:rvdhosts.c 12.0$
 *	$ACIS:rvdhosts.c 12.0$
 */

#ifndef lint
static char *rcsid_rvdhosts_c = "$Header:rvdhosts.c 12.0$";
#endif	lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


#define _RVDHOSTS_C_

#include <netdb.h>			/* Network database defs. */
#include "rvdlib.h"			/* RVD library definitions. */

#define	HOSTNAMELENGTH	128		/* Max. length of canonical hostname.*/
#define MAXHOSTS	20		/* Max. number of hosts. */

static char hostlist[MAXHOSTS][HOSTNAMELENGTH];
					/* List of RVD servers. */
rvdhosts(argc, argv)
int argc;
char **argv;
{
  rvdtab_p rvdent;			/* Current RVD table entry. */
  struct hostent *host;			/* Returned by gethostbyname. */
  int hostcount;			/* Number of server hosts. */
  int i;				/* Index variable. */

  /* If there are any arguments, we were not invoked correctly. */

  if (argc != 1) {
    printf("Usage: rvdhosts");
    exit(1);
  }

  /* Open the rvdtab file. */

  setrvdent();
  hostcount = 0;

  /* Loop through the rvdtab entries.  Each time through, we canonicalize
     the hostname and compare it to the entries in the table.  If we
     don't find a match, add it to the list.
   */

  while ( (rvdent = getrvdent()) != NULL) {
    host = gethostbyname(rvdent->host);
    for (i = 0; i < hostcount; i++) {
      if ( !strcmp(hostlist[i], host->h_name) )
	goto found;
    }
    strcpy(hostlist[hostcount++], host->h_name);
  found:
    continue;
  }

  /* Now print the list. */

  for (i = 0; i < hostcount; i++)
    printf("%s\n", hostlist[i]);
}
	
       
