/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:canon.h 12.0$ */
/* $ACIS:canon.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/h/RCS/canon.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidcanon = "$Header:canon.h 12.0$";
#endif


#include	<sys/types.h>

typedef struct {
	char		*name;
	char		*fmt;
	u_long		(*cook)();
	char		**val;
	short		size;
	short		fnd;
	u_long		alias;
} tag;

typedef struct {
	char		*name;
	int		reqrd;
	int		optnl;
} op;

extern char	*k[], *v[];
extern tag	tag_tbl[];

#define	V(x)			*(x == -1 ? &s_keyword : (tag_tbl[x].val))
#define	F(x)			(tag_tbl[x].fnd)

extern char	*s_keyword,
		*s_error,
		*s_connect,
		*s_more,
		*s_number,
		*s_time,
		*s_oldmode,
		*s_message;

#define	_KEYWORD		-1
#define	_ACTIVITY		0
#define	_CONNECT		1
#define	_ERROR			2
#define	_MESSAGE		3
#define	_MORE			4
#define	_NUMBER			5
#define	_OLDMODE		6
#define	_TIME			7


#define	REQ_ERROR		B(_ERROR)
#define	OPT_ERROR		0
#define	REQ_ADD_PHYS		0
#define	OPT_ADD_PHYS		0
#define	REQ_DUSE_PHYS		0
#define	OPT_DUSE_PHYS		0
#define	REQ_USE_PHYS		0
#define	OPT_USE_PHYS		0
#define	REQ_ADD_VIRT		0
#define	OPT_ADD_VIRT		0
#define	REQ_ALW_SPIN		B(_OLDMODE)
#define	OPT_ALW_SPIN		0
#define	REQ_DEL_VIRT		0
#define	OPT_DEL_VIRT		0
#define	REQ_DSP_ACT		B(_ACTIVITY)|B(_NUMBER)|B(_TIME)
#define	OPT_DSP_ACT		B(_MORE)
#define	REQ_DSP_VIRT		B(_CONNECT)|B(_NUMBER)
#define	OPT_DSP_VIRT		B(_MORE)|B(_TIME)
#define	REQ_XCH_VIRT		0
#define	OPT_XCH_VIRT		0
#define	REQ_GET_MSG		0
#define	OPT_GET_MSG		B(_MESSAGE)|B(_TIME)
#define	REQ_LOG_ALL		0
#define	OPT_LOG_ALL		0
#define	REQ_LOG_XTRN		0
#define	OPT_LOG_XTRN		0
#define	REQ_LOG_LVL		0
#define	OPT_LOG_LVL		0
#define	REQ_MOD_VIRT		0
#define	OPT_MOD_VIRT		0
#define	REQ_REQ_AUTH		0
#define	OPT_REQ_AUTH		0
#define	REQ_SET_MSG		0
#define	OPT_SET_MSG		0
#define	REQ_SHT_SRVR		0
#define	OPT_SHT_SRVR		0
#define	REQ_SHT_HOST		0
#define	OPT_SHT_HOST		0
#define	REQ_SPN_VIRT		0
#define	OPT_SPN_VIRT		0
#define	REQ_TEST_ENTER		0
#define	OPT_TEST_ENTER		0
#define	REQ_TEST_EXIT		0
#define	OPT_TEST_EXIT		0
