/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:ctl_pkt.h 12.0$ */
/* $ACIS:ctl_pkt.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/h/RCS/ctl_pkt.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidctl_pkt = "$Header:ctl_pkt.h 12.0$";
#endif



/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* This file includes the declarations and definitions for parsing
 * control packets.
 */

#define	ENDKEY		'='		/* delimiter in keyword parameters */
#define	QUOTE		'\\'		/* quote character in strings */

struct	item	{			/* an item descriptor for parser */
	char	*it_key;		/* pointer to the keyword */
	char	*it_val;		/* pointer to the value */
	boolean	it_req;			/* true iff item is required */
};

/* The nitems macro returns the number of items in an array of items */

#define	nitems(itp)	(sizeof(itp)/sizeof(struct item))


/* The issep() macro is true iff the specified character is a separator (space,
 * tab, carriage return, newline, or formfeed).
 */

#define	issep(c)	isspace(c)


/* Macro to tell whether a specified character needs to be escaped */

#define	needesc(c)	((c) == ENDKEY || (c) == QUOTE || issep((c)))


/* The msg structure describes a control message */

struct	msg	{
	char	*ms_opcode;		/* character string operation name */
	struct	item	*ms_desc;	/* array of items parsed out of msg */
	int	ms_nitem;		/* number of items in array */
	int	(*ms_proc)();		/* procedure to process this msg */
};

#define	CTLSIZE		512		/* buffer size for control messages */
