/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:rvdadd.h 12.0$ */
/* $ACIS:rvdadd.h 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/h/RCS/rvdadd.h,v $ */

#if !defined(lint) && !defined(LOCORE) && defined(RCS_HDRS)
static char *rcsidrvdadd = "$Header:rvdadd.h 12.0$";
#endif


/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"

/* Additional RVD packet formats not defined in system rvd.h file (sigh) */

struct	rvdsa	{			/* spinack packet */
	u_char	rvd_type;		/* RVD packet type  = RVDSPACK */
	u_char	mode;			/* opening mode */
	u_char	padding;		/* 8 bits of padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	vd_uid;			/* Virtual Disk Unique ID */
	u_long	nblocks;		/* number of blocks on drive */
	u_short	burst;			/* max packets per burst */
	u_short	qlen;			/* max requests outstanding */
	u_char	f_pad2[3];		/* unused */
	u_char	wb_factor;		/* write blocking factor */
	};

struct	rvdack	{			/* spindown ack packet */
	u_char	rvd_type;		/* RVD packet type  = RVDACK */
	u_char	mode;			/* opening mode */
	u_char	padding;		/* 8 bits of padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	};

struct	rvdwa	{			/* write ack packet */
	u_char	rvd_type;		/* RVD packet type  = RVDWACK */
	u_char	mode;			/* opening mode */
	u_char	padding;		/* 8 bits of padding */
	u_char	version;		/* RVD version */
	u_long	drive;			/* Drive number */
	u_long	nonce;			/* Packet UID */
	u_long	index;			/* Servers connection index */
	u_long	cksum;			/* Packet checksum */
	u_long	reserved;		/* Reserved for future use */
	u_long	blockn;			/* block number */
	u_long	status;			/* status of drive */
	u_long	bcount;			/* number of blocks we are acking */
	};
