/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:time.c 12.0$ */
/* $ACIS:time.c 12.0$ */
/* $Source: /ibm/acis/usr/src/ibm/rvd/lib/RCS/time.c,v $ */

#ifndef lint
static char *rcsid = "$Header:time.c 12.0$";
#endif


#ifndef lint
static char rcsid_time_c[] = "$Header:time.c 12.0$";
#endif lint

/* Copyright 1984 by the Massachusetts Institute of Technology */
/* See permission and disclaimer notice in the file "notice.h" */
#include "notice.h"


/*
 *	Time printing/formatting routines.
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

#define	MINUTE		60
#define	HOUR		60
#define	DAY		24

/*
 *	format time as:
 *
 *		Nov 20 20:23	(if current year)
 *		Nov 20  1984	(if not current year)
 */

char *
ltime(i)

u_long	i;

{
	struct tm	*tm, *localtime();
	static long	year = -1;
	static char	buf[12],
			*mon[12] =	{ "Jan","Feb","Mar","Apr",
					  "May","Jun","Jul","Aug",
					  "Sep","Oct","Nov","Dec"
					};

	if(year == -1) {		/* get current year	*/
		u_long	now;

		time(&now);
		tm = localtime(&now);
		year = tm->tm_year;
	}

	tm = localtime(&i);
	if(tm->tm_year == year)
		sprintf(buf, "%3s %2d %02d:%02d", mon[tm->tm_mon], tm->tm_mday,
		  tm->tm_hour, tm->tm_min);
	else
		sprintf(buf, "%3s %2d  %4d", mon[tm->tm_mon], tm->tm_mday,
		  1900 + tm->tm_year);
	return(buf);
}

/*
 *	print idle time as ruptime(1) format:
 *
 *		[days+]hours:minutes
 */

char *
itime(i)

u_long	i;

{
	static char	buf[10];
	int	mins, hours, days;

	i /= MINUTE;		/* obliterate seconds */
	mins = i % MINUTE;	/* get minutes */

	i /= HOUR;		/* obliterate minutes */
	hours = i % DAY;	/* get hours */

	i /= DAY;		/* obliterate hours */
	days = i;		/* get days */

	if(days)
		sprintf(buf, "%2d+%02d:%02d", days, hours, mins);
	else
		sprintf(buf, "   %02d:%02d", hours, mins);
	return(buf);
}
