/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1986,1988
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:alloca.s 12.0$ */
/* $ACIS:alloca.s 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/gen/RCS/alloca.s,v $ */

	.data
rcsid:	.asciz	"$Header:alloca.s 12.0$"
	.text


  /*
   * Provides:
   *    (char *)alloca(size)
   *    int size;
   *
   * Alloca allocates size bytes of space in the stack frame of the caller,
   * word aligned. 
   * This temporary space is automatically freed on return.
   * (ef) 12/11/85 -- initial version
   *
   * Many assumptions surround this code and its use:
   *
   * 	1. Caller makes no use of r1 to address its stack frame; all such
   *	   addressing is done off some other frame pointer register.
   *
   *	2. In particular, caller will restore r1 on its return without
   *	   using r1's current value.
   *
   *    3. r14 on entry points to caller's constant pool; The halfword at
   *	   8(r14) is a magic number for validity checking, and the halfword
   *       at 10(r14) is the size of the caller's arglist area (from 0(r1)
   *       to the first auto variable in the frame).
   */

#include "LINKG.h"

	.data
msg:  	.ascii	"alloca: Caller probably not compiled with -ma\n"            
msgend:
	.text
ENTRY(alloca)			# must preserve caller's r14

	ai	r0,r2,0		# Negative size requested?
	blrx	r15		# Yup, we're outta here
	s	r2,r2		# with NULL in r2.
	ls	r2,8(r14)	# Get magic no. and arglist size
	xiu	r2,r2,0xf690	#
	cli	r2,0x7fff	# Magic must match and size be reasonable
	bnl	9f
	sf	r0,sp		# Adjust stack pointer,
	ni	sp,r0,0-4	# word aligned
	brx	r15		# Newly allocated area is that distance past
	cas	r2,r2,sp	# new value of r1.
 
9:      get     r2,$2           # Direct message to stderr
        get     r3,$msg         # Set r2 to point to message
        get     r4,$msgend-msg  # r4 = length of message
        get     r0,$_write      # Call write function
        bali    r15,_.write      

	get	r0,$_abort
	bali	r15,_.abort
	.globl  _abort
	.globl	_.abort
	.globl  _write
	.globl	_.write
TTNOFRM
