/*
 * 5799-WZQ (C) COPYRIGHT IBM CORPORATION 1987
 * LICENSED MATERIALS - PROPERTY OF IBM
 * REFER TO COPYRIGHT INSTRUCTIONS FORM NUMBER G120-2083
 */
/* $Header:dknu16.c 12.0$ */
/* $ACIS:dknu16.c 12.0$ */
/* $Source: /ibm/acis/usr/src/lib/libc/ca/gen/RCS/dknu16.c,v $ */

#ifndef lint
static char *rcsid = "$Header:dknu16.c 12.0$";
#endif

/* DIVIDE FOUR SHORTWORDS BY ONE SHORTWORD */

/* This function gives a five-element quotient resulting from 
dividing a list of four shortwords by a shortword. The algorithm 
is based on that given in D.E. Knuth's The Art of Programming, 
Section 4.3.1, answer to Exercise 16. Dividend and divisor are 
guaranteed to be normalized, that is, their leading elements are 
greater than 32767. */ 

/***************** FUNCTION SYNTAX AND ARGUMENTS ***************/

void _dknu16 (d, r)

/******************** ARGUMENT DECLARATIONS ********************/

unsigned short d[4];   /* dividend */
unsigned short r[6];   /* divisor, with r[1...5] guaranteed 0 */
                       /* and also result */

/******************* LOCAL VARIABLE DECLARATIONS ***************/

{
 union 
     {  
      unsigned long l;
      unsigned short s[2];
     } u;
 unsigned short k;
 unsigned short s;
 unsigned short j;
 unsigned short t[5];

 /************************** ALGORITHM *************************/

 k = r[0];
 t[0] = d[0];
 t[1] = d[1];
 t[2] = d[2];
 t[3] = d[3];
 t[4] = 0;
 for (j = s = 0; j < 5; j++)
     {
      u.s[0] = s;
      u.s[1] = t[j];
      r[j] = u.l / k;
      s = u.l % k;
     }
}
