#ifndef lint
static char rcsid[] = "$Header:table.c 12.0$";
#endif
/* $Source: /ibm/acis/usr/src/lib/pcc_ca/RCS/table.c,v $ */
#ifdef unix
# include "mfile2.h"
#else
# include "doption h *"  /* circumvention for -D problem with preprocessor */
# include "mfile2 h *"
#endif
 
# define INTREG INTAREG|INTBREG
# define INREG INTAREG|INTBREG|INAREG|INBREG
# define WPTR TPTRTO|TINT|TLONG|TFLOAT|TDOUBLE|TPOINT|TUNSIGNED|TULONG
# define AWD SNAME|SOREG|SCON  /* SCON changed to SSCON by tshape */
/* tbl */
# define ANYSIGNED TPOINT|TINT|TLONG|TSHORT|TCHAR
# define ANYUSIGNED TUNSIGNED|TULONG|TUSHORT|TUCHAR
# define ANYFLOAT TFLOAT|TDOUBLE
# define ANYFIXED ANYSIGNED|ANYUSIGNED
# define TWORD TINT|TUNSIGNED|TPOINT|TLONG|TULONG
/* tbl */
# define SREG SAREG|STAREG|SBREG|STBREG
 
/* Implementation assumptions: (ie wild guesses that seem to work)
/*
/* 10/20/83 JEC -- NASL, NASR, NBSL, NBSR mean that if the Left/Right subtree
/*   of the tree being matched is a temporary (scratch) A/B register, and the
/*   contents of that register are not needed after the tree being matched has
/*   been computed, then the computation of the tree being matched may use
/*   that register as a work register, and/or to hold the result.  A busy
/*   count of one indicates the register may be shared.
/*
/* 7/23/84 JEC -- A TDOUBLE is never loaded into a register pair.  Ordering
/*   a TDOUBLE into a register loads its address.  A TFLOAT may be loaded into
/*   a register, and is converted to a TDOUBLE by the runtime support routines.
/* 7/10/85 WFA -- DOUBLE, or anything else for that matter, is loaded into
/*   registers r2..r5, as arguments to a call
/*   
/* 8/29/84 JEC -- This has bitten me so many times that I thought I'd write it
/*  down.  If your cookie is a temp reg (INTAREG or INTBREG), the template that
/*  you match damn well better return that kind of temp reg as its result. This
/*  is very inconvient, as duplicate sets of templates are needed for temp A,
/*  temp B, non-temp A, and non-temp B regs.  Such is life...
/*
*/
 
/*----------------------------------------------------- init */
 
struct optab  table[] = {
INIT,  FOREFF,
     SCON, TANY,
     SANY, TWORD,
       0,  RNOP,
       " .long CL # 14\n",  /* .align 4 removed 2/4/83 */
 
INIT,  FOREFF,
     SCON, TANY,
     SANY, TSHORT|TUSHORT,
       0,  RNOP,
       " .short CL # 15\n",
 
INIT,  FOREFF,
     SCON, TANY,
     SANY, TCHAR|TUCHAR,
       0,  RNOP,
       " .byte CL # 16\n",
 
INIT,  FOREFF, /* added 10/18/83 JEC for string initializers */
     SNAME, TANY,
     SANY,  TWORD,
       0,   RNOP,
       " .long CL # 17\n",  /* .align 4 removed 2/4/83 */
 
INIT,  FOREFF, /* added 10/27/83 JEC for extern initializers */
     STARNM,TANY,
     SANY,  TWORD,
       0,   RNOP,
       " .long CL # 18\n",  /* .align 4 removed 2/4/83 */
 
/*-I don't like these, but they're needed. JEC ---- condition codes */
 
CCODES,  INTAREG,
    SANY,     TANY,
    SANY,     TANY,
         NAREG, RESC1,
         " lis A1,1 # 28\n ZN",
 
CCODES,  INTBREG,
    SANY,     TANY,
    SANY,     TANY,
         NBREG, RESC1,
         " lis A1,1 # 29\n ZN",
 
/*--------------------------------------------- logical ops (forcc) */
 
OPLOG,   FORCC,
    SREG,     ANYFIXED,
    SSCON,    ANYFIXED,
         0,   RESCC,
/*       " compZUi AL,AR # 30\n ZP", */
         " cZUi AL,AR # 30\n ZP",
 
OPLOG,   FORCC,
    SREG,     ANYFIXED,
    SREG,     ANYFIXED,
         0,   RESCC,
         " cZU AL,AR # 31\n ZP",
 
OPLOG,   FORCC,
    SREG,     ANYFLOAT,
    SREG,     ANYFLOAT,
         0,   RESCC,
         "F0 # 31f\n ZP",
 
/*------------------------------------------- logical ops (intbreg) */
 
OPLOG,   INTBREG,
    SREG,     ANYFIXED,
    SSCON,    ANYFIXED,
         NBREG|NBSL, RESC1,
/* " compZUi AL,AR # 32\n lis A1,0 # 32\n jZQ .+4 # 32\n lis A1,1 # 32\n", */
" cZUi AL,AR # 32\n lis A1,0 # 32\n jZQ 1f # 32\n lis A1,1 # 32\n1: # 32\n",
 
OPLOG,   INTBREG,
    SREG,     ANYFIXED,
    SREG,     ANYFIXED,
         NBREG|NBSL|NBSR, RESC1,
/* " cZU AL,AR # 33\n lis A1,0 # 33\n jZQ .+4 # 33\n lis A1,1 # 33\n", */
" cZU AL,AR # 33\n lis A1,0 # 33\n jZQ 1f # 33\n lis A1,1 # 33\n1: # 33\n",
 
OPLOG,   INTBREG,
    SREG,     ANYFLOAT,
    SREG,     ANYFLOAT,
         NBREG, RESC1,
"F0 lis A1,0 # 33f\n jZQ 1f # 33f\n lis A1,1 # 33f\n1: # 33f\n",
 
/*------------------------------------------- logical ops (intareg) */
 
OPLOG,   INTAREG,
    SREG,     ANYFIXED,
    SSCON,    ANYFIXED,
         NAREG, RESC1,
" lis A1,0 # 34\n cZUi AL,AR # 34\n jZQ 1f # 34\n lis A1,1 # 34\n1: # 34\n",
 
OPLOG,   INTAREG,
    SREG,     ANYFIXED,
    SREG,     ANYFIXED,
         NAREG, RESC1,
" lis A1,0 # 35\n cZU AL,AR # 35\n jZQ 1f # 35\n lis A1,1 # 35\n1: # 35\n",
 
OPLOG,   INTAREG,
    SREG,     ANYFLOAT,
    SREG,     ANYFLOAT,
         NAREG, RESC1,
"F0 lis A1,0 # 35f\n jZQ 1f # 35f\n lis A1,1 # 35f\n1: # 35f\n",
/*----------------------------------------------------- calls */
/* All calls updated for new convention, CSL WFA 7/5/85 */
/*------------------------------------------------------*/
/* (ef) 11/21/85 -- Removed warnings that instructions  */
/*     that follow balix/balrx must be 4 bytes. Current */
/*     (11/21) assembler pads instructions so that short*/
/*     instructions may follow.                         */
/*     Cleaned up some bogus looking templates          */
/* NCS convention --                                    */
/*     _.<name> == text entry point for function <name> */
/*     _<name>  == constant pool for function <name>,   */
/*                 First word of constant pool is       */
/*                 address of text entry point          */
/* To call a function --                                */
/*  branch and link through r15. (balix if possible)    */
/*  get constant pool pointer for called function in r0 */
/*  so a normal call is either:                         */
/*        balix  r15,_.<name>                           */
/*        get    r0,_<name>                             */
/* or                                                   */
/*        get r15,0(_<name>)                            */
/*        balrx  r15,r15                                */
/*        get    r0,_<name>                             */
/*------------------------------------------------------*/

UNARY CALL,   INTAREG,
    SCON,     ANYFIXED|TFLOAT,
    SANY,     TANY,
         NAREG,    RESC1,
         " balix r15,_BL # 47\n get r0,$.long(AL) # 47\n",

UNARY CALL,   INTAREG,
    SCON,     TDOUBLE,
    SANY,     TANY,
         2*NTEMP|NAREG,    RESC1,
         " balix r15,_BL # 47d\n get r0,$.long(AL) # 47d\nZD",

UNARY CALL,   INTAREG,
    SREG,     ANYFIXED|TFLOAT,
    SANY,     TANY,
           NAREG,    RESC1,
/* (ef) 12/19/85 -- deal with AL == r15 */
/*          " get r15,0(AL) # 47b\n balrx r15,r15 # 47b\n cas r0,AL,r0\n",*/
          "ZC # 47b\n",

UNARY CALL,   INTAREG,
    SREG,     TDOUBLE,
    SANY,     TANY,
         2*NTEMP|NAREG,    RESC1,
       "ZC ZD # 47bd\n",
 
CALL,   INTAREG,
    SCON,     ANYFIXED|TFLOAT,
    SANY,     TANY,
         NAREG,    RESC1,
         " balix r15,_BL # 48\n get r0,$.long(AL) # 48\n",
 
CALL,   INTAREG,
    SCON,     TDOUBLE,
    SANY,     TANY,
         2*NTEMP|NAREG,    RESC1,
         " balix r15,_BL # 48d\n get r0,$.long(AL) # 48d\nZD",
 
CALL,   INTAREG,
    SREG,     ANYFIXED|TFLOAT,
    SANY,     TANY,
         NAREG,    RESC1,
/* 12/19/85 -- deal with AL == r15 */
/*           " get r15,0(AL) # 48b\n balrx r15,r15 # 48b\n cas r0,AL,r0 # 48b\n",*/
	"ZC # 48b\n",


CALL,   INTAREG,
    SREG,     TDOUBLE,
    SANY,     TANY,
         2*NTEMP|NAREG,    RESC1,
/* 12/19/85 -- deal with AL == r15 */
/*     " get r15,0(AL) # 48bd\n balrx r15,r15 # 48bd\n cas r0,AL,r0 # 48bd\nZD",*/
	"ZC ZD # 48bd\n",
 
STCALL,       INTAREG, 
    SCON,     TANY,
    SANY,     TANY,
         NAREG|NTEMP,    RESC1,
         " cal r2,A2 # 51\n balix r15,_BL # 51\n get r0,$.long(AL)  # 51\n",
 
STCALL,       INTAREG, 
    SREG,     TANY,
    SANY,     TANY,
         NAREG|NTEMP,    RESC1,
         " cal r2,A2 # 51b\n ZC # 51b\n",
 
ASG STCALL,   INTAREG,
    SCON,     TANY,
    SANY,     TANY,
         NAREG,          RESC1,
	 " cal r2,ZV # 53\n balix r15,_BL # 53\n get r0,$.long(AL)  # 53\n",
 
ASG STCALL,   INTAREG,
    SREG,     TANY,
    SANY,     TANY,
         NAREG,          RESC1,
         " cal r2,ZV # 53b\n ZC # 53b\n",
 
/*----------------------------------------------------- shift-assigns */
 
ASG OPSHFT,   INAREG|INBREG|FOREFF|FORCC,
    SAREG|SBREG,   ANYFIXED,
    SREG|SCON,     ANYFIXED,
         0,   RLEFT|RESCC,
         " Z> AL,AR # 56\nZA",
 
ASG OPSHFT,   INTAREG|FOREFF|FORCC,
    AWD,           ANYFIXED,
    SREG|SCON,     ANYFIXED,
         NAREG, RESC1|RESCC,
         " getZL A1,AL # 58\n Z> A1,AR # 58\n putZL A1,AL # 58\nZ1",
 
ASG OPSHFT,   INTAREG|FOREFF|FORCC,
    STARNM,        ANYFIXED,
    SREG|SCON,     ANYFIXED,
         2*NAREG, RESC1|RESCC,
" get A2,$AL # 60\n getZL A1,0(A2) # 60\n Z> A1,AR # 60\n putZL A1,0(A2) # 60\nZ1",
 
/*----------------------------------------------------- incr,decr (foreff) */
 
INCR,    FOREFF,
    SREG,     ANYFIXED,
    SSCON,    ANYFIXED,
         0,   RNULL,
         " ai AL,AL,AR # 65\nZA",
 
INCR,    FOREFF,
    AWD,     ANYFIXED,
    SSCON,   ANYFIXED,
         NAREG, RNULL,
         " getZL A1,AL # 66\n ai A1,A1,AR # 66\n putZL A1,AL # 66\n",
 
INCR,    FOREFF,
    STARNM,  ANYFIXED,
    SSCON,   ANYFIXED,
         2*NAREG, RNULL,
         " get A2,$AL # 67\n getZL A1,0(A2) # 67\n\
 ai A1,A1,AR # 67\n putZL A1,0(A2) # 67\n",
 
DECR,    FOREFF,
    SREG,     ANYFIXED,
    SSCON,    ANYFIXED,
         0,   RNULL,
/*       " subi AL,AR # 68\n", */
         " ai AL,AL,-AR # 68\nZA",
 
DECR,    FOREFF,
    AWD,     ANYFIXED,
    SSCON,   ANYFIXED,
         NAREG, RNULL,
/*       " getZL A1,AL # 69\n subi A1,AR # 69\n putZL A1,AL # 69\n", */
         " getZL A1,AL # 69\n ai A1,A1,-AR # 69\n putZL A1,AL # 69\n",
 
DECR,    FOREFF,
    STARNM,  ANYFIXED,
    SSCON,   ANYFIXED,
         2*NAREG, RNULL,
" get A2,$AL # 70\n getZL A1,0(A2) # 70\n ai A1,A1,-AR # 70\n\
 putZL A1,0(A2) # 70\n",
 
/*----------------------------------------------------- incr,decr (intreg) */
 
INCR,    INTAREG, /* FORCC handled by REG template */
    SREG,    ANYFIXED,
    SSCON,   ANYFIXED,
       NAREG, RESC1,
         " cas A1,AL,r0 # 71\n ai AL,AL,AR # 71\nZA",  /* not addi A1,AL,AR */
 
INCR,    INTAREG|FORCC,
    AWD,     ANYFIXED,
    SSCON,   ANYFIXED,
         NAREG, RESC1|RESCC,
/*" getZL A1,AL # 72\n addi A1,AR # 72\n putZL A1,AL # 72\n subi A1,AR # 72\n",*/
" getZL A1,AL # 72\n ai A1,A1,AR # 72\n putZL A1,AL # 72\n ai A1,A1,-AR # 72\n",
 
INCR,    INTAREG|FORCC,
    STARNM,  ANYFIXED,
    SSCON,   ANYFIXED,
         2*NAREG, RESC1|RESCC,
    " get A2,$AL # 73\n getZL A1,0(A2) # 73\n ai A1,A1,AR # 73\n\
 putZL A1,0(A2) # 73\n ai A1,A1,-AR # 73\n",
 
DECR,    INTAREG, /* FORCC handled by REG template */
    SREG,    ANYFIXED,
    SSCON,   ANYFIXED,
       NAREG|NASL, RESC1,
         " cas A1,AL,r0 # 74\n ai AL,AL,-AR # 74\nZA", /* not subi A1,Al,AR */
 
DECR,    INTAREG|FORCC,
    AWD,     ANYFIXED,
    SSCON,   ANYFIXED,
         NAREG, RESC1|RESCC,
/*  " getZL A1,AL # 75\n subi A1,AR # 75\n putZL A1,AL # 75\n addi A1,AR # 72\n", */
" getZL A1,AL # 75\n ai A1,A1,-AR # 75\n putZL A1,AL # 75\n ai A1,A1,AR # 72\n",
 
DECR,    INTAREG|FORCC,
    STARNM,  ANYFIXED,
    SSCON,   ANYFIXED,
         2*NAREG, RESC1|RESCC,
" get A2,$AL # 76\n getZL A1,0(A2) # 76\n ai A1,A1,-AR # 76\n\
 putZL A1,0(A2) # 76\n ai A1,A1,AR # 76\n",
 
/*----------------------------------------------- fixed assign (inreg) */
 
ASSIGN,  INAREG|INBREG|FOREFF, /* use REG template to copy to temp */
    SAREG|SBREG,   ANYFIXED,
    SREG,     ANYFIXED,
         0,   RLEFT|RRIGHT,
         " cas AL,AR,r0 # 78\nZA",
 
ASSIGN,  INAREG|INBREG|FOREFF,
    SAREG|SBREG,   ANYFIXED,
    SCON,     ANYFIXED,
         0,   RLEFT,

/* (ef) 12/23/85 -- adjust contents of target register to correct size */
/*         " get AL,$AR # 79\n",*/
         " get AL,$AR # 79\nZA",
 
ASSIGN,  INAREG|INBREG|FOREFF,
    AWD, ANYFIXED,
    SREG,ANYFIXED,
         0,   RRIGHT,
         " putZL AR,AL # 80\nZa",
 
ASSIGN,  INAREG|INBREG|FOREFF,
    STARNM,   ANYFIXED,
    SREG,     ANYFIXED,
         NAREG, RRIGHT,
         " get A1,$AL # 81\n putZL AR,0(A1) # 81\nZa",
 
/*----------------------------------------------- float assign */
 
ASSIGN,  INAREG|INBREG|FOREFF,
    AWD,     TFLOAT,
    SREG,    TFLOAT,
         0,  RRIGHT,
         " put AR,AL # 82f\n",
 
ASSIGN,  INAREG|INBREG|FOREFF,
    STARNM,  TFLOAT,
    SREG,    TFLOAT,
         NAREG, RRIGHT,
         " get A1,$AL # 82p\n put AR,0(A1) # 82p\n",
 
ASSIGN,  FOREFF|INTAREG,
    AWD,     TDOUBLE,
    STAREG,  TDOUBLE,
         NAREG, RRIGHT,  /* not NASR */
" get A1,4(AR) # 83d\n put A1,4+AL # 83d\n\
 get A1,0(AR) # 83d\n put A1,AL # 83d\n",
 
ASSIGN,  INTAREG|FOREFF,
    STARNM,  TDOUBLE,
    STAREG,  TDOUBLE,
         2*NAREG, RRIGHT,  /* not NASR */
" get A2,$AL # 83p\n get A1,4(AR) # 83p\n put A1,4(A2) # 83p\n\
 get A1,0(AR) # 83p\n put A1,0(A2) # 83p\n",
 
ASSIGN,  FOREFF, /* convert double to float */
    AWD|STARNM,  TFLOAT,
    STAREG,      TDOUBLE,
         0, RNULL,
         "EL # 84f\n",

ASSIGN,  INTAREG, /* convert double to float created to solve infinite compiler loop problem, apar #215*/
    AWD|STARNM,  TFLOAT,
    STAREG,      TDOUBLE,
         NAREG, RESC1,
         "EL # 84f jsw\n get A1,AL # 84f jsw\n",
 
ASSIGN,  FOREFF, /* convert float to double */
    AWD|STARNM,  TDOUBLE,
    STAREG,      TFLOAT,
         0, RNULL,
         "EL # 84d\n",
 
/*----------------------------------------------------- reg */
 
REG, INBREG|INTBREG,  /* Sorry about this. There must be a better way */
     SANY, TANY,      /* Added 10/21/83 by JEC for return(expr) into  */
     SBREG|STBREG, ANYFIXED,  /* R0 without going thru a temp A reg.  */
       NBREG|NBSR, RESC1,
       "",
 
REG, FORCC,
     SANY, TANY,
     SREG, ANYSIGNED|TFLOAT,
       0,  RESCC,
       " cis AR,0 # 85\n",
 
REG, FORCC,
     SANY, TANY,
     SREG, ANYUSIGNED,
       0,  RESCC,
       " cli AR,0 # 85u\n",
 
REG, FORCC,
     SANY, TANY,
     SAREG, TDOUBLE,
       NAREG*2, RESCC,
" get A2,4(AR)  # 85d\n sli  A2,1  # 85d\n\
 get A1,0(AR)  # 85d\n o A2,A1  # 85d\n",

REG, FORCC,
     SANY, TANY,
     SAREG, TDOUBLE,
       NAREG|NBREG, RESCC,
/* JSW - 7/3/86 lisa said it should be this way!
" get A2,4(AR)  # 85bd\n sli  A2,1  # 85bd\n\
 get A1,0(AR)  # 85bd\n o A2,A1  # 85bd\n",
*/
" get A2,0(AR)  # 85bd\n sli  A2,1  # 85bd\n\
 get A1,4(AR)  # 85bd\n o A2,A1  # 85bd\n",

REG, FORARG,	
     SANY,     TANY,
     SREG,     ANYFIXED,
       0,   RNULL,
       " WWR # 86\n",	/* WFA 7/13/85 */
 
   REG, FORARG,  /* convert float to double */
        SANY,    TANY,
        SREG,    TFLOAT,
            NAREG|2*NTEMP, RNULL,
            "ES # 86f\n",
 
REG, FORARG,  /* copy double as an argument */
     SANY,    TANY,
     STAREG,  TDOUBLE,
         NAREG, RNULL, /* not NASR */
         " WR # 87\n",	/* WFA 7/13/85 */
 
REG, INTEMP,
     SANY, TANY,
     SREG, ANYFIXED|TFLOAT,
       NTEMP,  RESC1,
       " put AR,A1 # 88\n",
 
REG, INTEMP,
     SANY,  TANY,
     SAREG, TDOUBLE,
       NAREG|2*NTEMP, RESC2,
" get A1,4(AR) # 89\n put A1,4+A2 # 89\n get A1,0(AR) # 89\n put A1,A2 # 89\n",
 
/*** No SCONV is present for REG ops, although conversion is required (by the
/*** Bourne shell, for example).  All the SCONV templates are repeated here
/*** twice for that reason.
***/
 
REG, INTAREG,
     SANY, TANY,
     SREG, TCHAR|TUCHAR,
         NAREG|NASR, RESC1,
         " nilz A1,AR,0xff # 90c\n",
 
REG, INTAREG,
     SANY, TANY,
     SREG, TSHORT,
         NAREG|NASR, RESC1,
         " exts A1,AR # 90s\n",
 
REG, INTAREG,
     SANY, TANY,
     SREG, TUSHORT,
         NAREG|NASR, RESC1,
         " nilz A1,AR,0xffff # 90u\n",
 
REG, INTAREG,
     SANY, TANY,
     SREG, ANYFIXED|TFLOAT,
         NAREG|NASR, RESC1,
         " cas A1,AR,r0 # 90sigh\n",

REG, INTAREG,
     SANY, TFLOAT,
     SREG, TDOUBLE,
        NAREG|NASR, RESC1,
	   "E1 # 91df\n",

REG, INTBREG,
     SANY, TANY,
     SREG, TCHAR|TUCHAR,
         NBREG|NBSR, RESC1,
         " nilz A1,AR,0xff # 91c\n",
 
REG, INTBREG,
     SANY, TANY,
     SREG, TSHORT,
         NBREG|NBSR, RESC1,
         " exts A1,AR # 91s\n",
 
REG, INTBREG,
     SANY, TANY,
     SREG, TUSHORT,
         NBREG|NBSR, RESC1,
         " nilz A1,AR,0xffff # 91u\n",

REG, INTBREG,
     SANY, TFLOAT,
     SREG, TDOUBLE,
        NBREG|NBSR,  RESC1,
	"E1 # 91df\n",
 
REG, INTBREG,
     SANY, TANY,
     SREG, TANY,
         NBREG|NBSR, RESC1,
         " cas A1,AR,r0 # 91\n",
 
/*-Here's a gem---------------------------------------- opleaf (foreff)*/
 
OPLEAF,  FOREFF,
     SANY, TANY,
     SREG|AWD,  TANY,
       0,  RLEFT,
       "",
 
/*----------------------------------------------------- opltype (inreg)*/
 
OPLTYPE, INTAREG,
    SANY,     TANY,
    SCON,     ANYFIXED,
         NAREG,    RESC1,
/*       " loadi A1,AR # 92\n", */
         " get A1,$AR # 92\nZ1",
 
OPLTYPE, INTBREG,
    SANY,     TANY,
    SCON,     ANYFIXED,
         NBREG,    RESC1,
/*       " loadi A1,AR # 92b\n", */
         " get A1,$AR # 92b\nZ1",
 
/***** Deleted as per K&R page 183, section 6.1, paragraph 1 *****
OPLTYPE, INTAREG,
    SANY,     TANY,
    AWD ,     TCHAR,
         NAREG,    RESC1,
    " getc A1,AR # 93\n shla A1,24 # 93\n shra A1,24 # 93\n",
    " getc A1,AR # 93\n sari A1,24 # 93\n sari A1,24 # 93\n",
 
*****************************************************************/
 
OPLTYPE, INTAREG,
    SANY,     TANY,
    AWD ,     ANYFIXED|TFLOAT,
         NAREG|NASR,    RESC1,
         " getZR A1,AR # 94\n",
 
OPLTYPE, INTBREG,
    SANY,     TANY,
    AWD ,     ANYFIXED|TFLOAT,
         NBREG,    RESC1,
         " getZR A1,AR # 94b\n",
 
OPLTYPE, INTAREG,
    SANY,     TANY,
    STARNM,   ANYFIXED|TFLOAT,
         NAREG,    RESC1,
         " get A1,$AR # 96\n getZR A1,0(A1) # 96\n",
 
OPLTYPE, INTBREG,
    SANY,     TANY,
    STARNM,   ANYFIXED|TFLOAT,
         NAREG|NBREG,    RESC2,
         " get A1,$AR # 96b\n getZR A2,0(A1) # 96b\n",
 
/*----------------------------------------------- float opltype (inreg)*/
 
/* Templates 98, 98b, 99, 99b dont make a copy...may be a problem.  */
/* Might be worth checking in 98 that AR is an OREG, may be shared, */
/* and offset is zero.  No inst is needed in that case.  JEC        */
 
OPLTYPE, INTAREG,
    SANY,     TANY,
    AWD,      TDOUBLE,
         NAREG|NASR,  RESC1,
         " cal A1,AR # 98\n",

/*
 * JSW 7/3/86 - Added this template as a fix to apar #'s 2 and 111.  Finds
 * condition codes for double OREG.
 */
OPLTYPE, FORCC,
    SANY,     TANY,
    AWD,      TDOUBLE,
         NAREG*2, RESCC,
" cal A1,AR # 98c\n\
 get A2,0(A1) # 98c\n\
 sli A2,1 #98c\n\
 get A1,4(A1) # 98c\n\
 o A2,A1 # 98c\n",
 
OPLTYPE, INTBREG,
    SANY,     TANY,
    AWD,      TDOUBLE,
         NBREG, RESC1,
         " cal A1,AR # 98b\n",
 
OPLTYPE, INTAREG,
    SANY,     TANY,
    STARNM,   TDOUBLE,
         NAREG,    RESC1,
         " get A1,$AR # 99\n",
 
OPLTYPE, INTBREG,
    SANY,     TANY,
    STARNM,   TDOUBLE,
         NBREG,    RESC1,
         " get A1,$AR # 99b\n",
 
OPLTYPE, FORARG,  /* copy double to stack */
     SANY,    TANY,
     AWD,     TDOUBLE,
         2*NAREG, RNULL,
         " cal A2,AR # 100\n W2",

OPLTYPE, FORARG,  /* copy double to stack */
     SANY,    TANY,
     STARNM,  TDOUBLE,
         2*NAREG, RNULL,
	 " get A2,$AR # 101\n W2",	/* WFA 7/13/85 */
 
/*----------------------------------------------------- unary minus */
 
UNARY MINUS,  INTAREG|FORCC|FOREFF,
    SREG,     ANYFIXED,
    SANY,     TANY,
         NAREG|NASL,  RESC1|RESCC,
         " twoc A1,AL # 106\nZ1",
 
UNARY MINUS,  INTBREG,
    SREG,     ANYFIXED,
    SANY,     TANY,
         NBREG|NBSL,  RESC1,
         " twoc A1,AL # 106b\nZ1",
 
UNARY MINUS,  INTEMP,
    SREG,     ANYFLOAT,
    SANY,     TANY,
         2*NTEMP,     RESC1,
         "F1 # 107\n",
 
/*----------------------------------------------------- compl */
 
COMPL,        INTAREG|FORCC|FOREFF,
    SREG,     ANYFIXED,
    SANY,     TANY,
         NAREG|NASL,  RESC1|RESCC,
         " onec A1,AL # 108\nZ1",
 
COMPL,        INTBREG,
    SREG,     ANYFIXED,
    SANY,     TANY,
         NBREG|NBSL,  RESC1,
         " onec A1,AL # 108b\nZ1",
 
/*------------------------------------------------------ sfi inst */
 
MINUS,   INTAREG|FOREFF|FORCC,
    SSCON,    ANYFIXED,
    SREG,     ANYFIXED,
         NAREG|NASR,    RESC1|RESCC,
         " sfi A1,AR,AL # 109\nZ1",
 
MINUS,   INTBREG,
    SSCON,    ANYFIXED,
    SREG,     ANYFIXED,
         NBREG|NBSR,    RESC1,
         " sfi A1,AR,AL # 109b\nZ1",
 
/*------------------------------------------------------ cas inst */
 
PLUS,    INTAREG|FOREFF,
    SREG,          ANYFIXED,
    SAREG|STAREG,  ANYFIXED,  /* cas inst can not use r0 as 3rd operand */
         NAREG|NASL, RESC1,
         " cas A1,AL,AR # 110\nZ1",
 
PLUS,    INTBREG,
    SREG,          ANYFIXED,
    SAREG|STAREG,  ANYFIXED,  /* cas inst can not use r0 as 3rd operand */
         NBREG|NBSL, RESC1,
         " cas A1,AL,AR # 110b\nZ1",
 
/*------------------------------- plus minus and or xor (opsimp) */
 
OPSIMP,       INTAREG|FOREFF|FORCC,
    SREG,     ANYFIXED,
    SSCON,    ANYFIXED,
         NAREG|NASL,   RESC1|RESCC,
         " OI A1,AL,AR # 111\nZ1",
 
OPSIMP,       INTBREG,
    SREG,     ANYFIXED,
    SSCON,    ANYFIXED,
         NBREG|NBSL,   RESC1,
         " OI A1,AL,AR # 112\nZ1",
 
/*------------------------------- plus minus mul or div (opfloat) */
 
OPFLOAT,      INTEMP,
    SREG,     ANYFLOAT,
    SREG,     ANYFLOAT,
         2*NTEMP,      RESC1,
         "F1 # 113\n",
 
OPFLOAT,      FORARG,
    SREG,     ANYFLOAT,
    SREG,     ANYFLOAT,
         0,   RNULL,
         "FS # 114\n", /* XXX WFA 7/13/85 needs to be fixed! */
 
/*-needed to share register zero --------------- mul, div, and mod */

OPMUL,	      INTBREG|INTAREG|FOREFF,
    SREG,     ANYFIXED,
    SCON,     ANYFIXED,
         NAREG|NBREG, RESC2,
	 "ML01 # 115constant\nZ2", /* (ef) 11/24/85 -- M<source><dest><temp> */


OPMUL,        INTBREG|FOREFF,
    SREG,     ANYFIXED,
    SREG,     ANYFIXED,
         NBREG|NBSL|NBSR, RESC1,
        "X0 # 115\nZ1",
 
OPMUL,        INTAREG,
    SAREG|STAREG,  ANYFIXED,
    SCON,          ANYFIXED,
	 2*NAREG,  RESC1,
	 "ML12 # 115constant,busyR0\nZ1",

OPMUL,        INTAREG,           /* NOTE: This template should be used  */
    SAREG|STAREG,  ANYFIXED,     /* only if the the preceeding template */
    SAREG|STAREG,  ANYFIXED,     /* failed for resource allocation (ie  */
         NAREG|NASL|NASR, RESC1, /* r0 is busy).  It is ORDER DEPENDENT */
        "X1 # 115busyR0\nZ1",
 
OPDIV,        INTBREG|FOREFF,
    SREG,     ANYFIXED,
    SREG,     ANYFIXED,
         NBREG|NBSL|NBSR, RESC1,
        "X0 # 116\nZ1",
 
OPDIV,        INTAREG,           /* NOTE: This template should be used  */
    SAREG|STAREG,  ANYFIXED,     /* only if the the preceeding template */
    SAREG|STAREG,  ANYFIXED,     /* failed for resource allocation (ie  */
         NAREG|NASL|NASR, RESC1, /* r0 is busy).  It is ORDER DEPENDENT */
        "X1 # 116busyR0\nZ1",
 
/*----------------------------------------------------- asg opmul */

ASG OPMUL,    INAREG|INBREG|INTBREG|FOREFF,
    SAREG|SBREG,  ANYFIXED,
    SCON,         ANYFIXED,
         2*NAREG|NBREG|NBSL,   RLEFT|RESC3,
	 "ML01 # 117constant\n cas AL,r0,r0 # 117constant(sigh)\nZAZ3",


ASG OPMUL,    INAREG|INBREG|INTBREG|FOREFF,
    SAREG|SBREG, ANYFIXED,
    SREG,        ANYFIXED,
         NBREG|NBSL|NBSR, RLEFT|RESC1,
        "XL # 117\nZAZ1",
 
ASG OPDIV,    INAREG|INBREG|INTBREG|FOREFF,
    SAREG|SBREG, ANYFIXED,
    SREG,        ANYFIXED,
         NBREG|NBSL|NBSR, RLEFT|RESC1,
        "XL # 118\nZAZ1",
 
ASG OPMUL,    INTBREG|FOREFF,
    AWD,      ANYFIXED,
    SCON,     ANYFIXED,
         2*NAREG|NBREG,  RESC3,
	 " getZL A1,AL # 119constant\n M102 putZL r0,AL # 119constant\nZ3",


ASG OPMUL,    INTBREG|FOREFF,
    AWD,      ANYFIXED,
    SREG,     ANYFIXED,
         NAREG|NBREG|NBSR, RESC2,
        " getZL A1,AL # 119\n X0 putZL r0,AL # 119\nZ2",
 
ASG OPDIV,    INTBREG|FOREFF,
    AWD,      ANYFIXED,
    SREG,     ANYFIXED,
         NAREG|NBREG|NBSR, RESC2,
        " getZL A1,AL # 120\n X0 putZL r0,AL # 120\nZ2",

ASG OPMUL,    INTBREG|FOREFF,
    STARNM,   ANYFIXED,
    SCON,     ANYFIXED,
         2*NAREG|NBREG, RESC3,
" get A2,$AL # 121constant\n getZL A1,0(A2) # 121constant\n M102 get A2,$AL # 121constant\n putZL r0,0(A2) # 121constant\nZ3",
 

ASG OPMUL,    INTBREG|FOREFF,
    STARNM,   ANYFIXED,
    SREG,     ANYFIXED,
         2*NAREG|NBREG|NBSR, RESC3,
" get A2,$AL # 121\n getZL A1,0(A2) # 121\n X0 putZL r0,0(A2) # 121\nZ3",
 
ASG OPDIV,    INTBREG|FOREFF,
    STARNM,   ANYFIXED,
    SREG,     ANYFIXED,
         2*NAREG|NBREG|NBSR, RESC3,
" get A2,$AL # 122\n getZL A1,0(A2) # 122\n X0 putZL r0,0(A2) # 122\nZ3",
 
/*----------------------------------------------------- asg opsimp */
 
ASG OPSIMP,  INAREG|INBREG|FOREFF|FORCC,
    SAREG|SBREG, ANYFIXED,
    SSCON,    ANYFIXED,
         0, RLEFT|RESCC,
         " OI AL,AL,AR # 190\nZA",
 
ASG OPSIMP,  INAREG|INBREG|FOREFF|FORCC,
    SAREG|SBREG, ANYFIXED,
    SREG,     ANYFIXED,
         0, RLEFT|RESCC,
         " O_ AL,AR # 191\nZA",
 
ASG OPSIMP,  INTAREG|FOREFF|FORCC,
    AWD,      ANYFIXED,
    SSCON,    ANYFIXED,
         NAREG, RESC1|RESCC,
/*       " getZL A1,AL # 200\n OI A1,AR # 200\n putZL A1,AL # 200\n", */
         " getZL A1,AL # 200\n OI A1,A1,AR # 200\n putZL A1,AL # 200\nZ1",
 
ASG OPSIMP,  INTAREG|FOREFF|FORCC,
    AWD,      ANYFIXED,
    SREG,     ANYFIXED,
         NAREG,   RESC1|RESCC,
         " getZL A1,AL # 201\n O_ A1,AR # 201\n putZL A1,AL # 201\nZ1",
 
ASG OPSIMP,  INTAREG|FOREFF|FORCC,
    STARNM,   ANYFIXED,
    SSCON,    ANYFIXED,
         2*NAREG, RESC1|RESCC,
" get A2,$AL # 202\n getZL A1,0(A2) # 202\n OI A1,A1,AR # 202\n\
 putZL A1,0(A2) # 202\nZ1",
 
ASG OPSIMP,  INTAREG|FOREFF|FORCC,
    STARNM,   ANYFIXED,
    SREG,     ANYFIXED,
         2*NAREG, RESC1|RESCC,
" get A2,$AL # 203\n getZL A1,0(A2) # 203\n O_ A1,AR # 203\n putZL A1,0(A2) # 203\nZ1",
 
/*----------------------------------------------------- asg opfloat */
 
/***
ASG OPFLOAT, INAREG|INBREG|FOREFF,
    AWD,      TDOUBLE,
    SREG,     TDOUBLE,
         0,   RLEFT,
         "FL # 290\n",
***/
 
/*-------------------------------------------------- address of */
 
UNARY AND,    INTAREG|FOREFF,  /* needed for & of local statics (eg strings) */
    SNAME,    TANY,
    SANY,     TANY,
         NAREG, RESC1,
         " get A1,$AL # 300\n",
 
UNARY AND,    INTBREG,
    SNAME,    TANY,
    SANY,     TANY,
         NBREG, RESC1,
         " get A1,$AL # 300b\n",
 
UNARY AND,    INTAREG|FOREFF,
    STARNM,   TANY,
    SANY,     TANY,
         NAREG, RESC1,
         " get A1,$AL # 301\n",
 
UNARY AND,    INTBREG,
    STARNM,   TANY,
    SANY,     TANY,
         NBREG, RESC1,
         " get A1,$AL # 301b\n",
 
/*-------------------------------------------- scalar conversions */
 
SCONV,   INTAREG,
    SREG,     ANYFIXED,                 /* type of pre-converted operand */
    SANY,     TCHAR|TUCHAR,             /* type of post-converted operand */
         NAREG|NASL, RESC1,
         " nilz A1,AL,0xff # 400\n",
 
SCONV,   INTBREG,
    SREG,     ANYFIXED,                 /* type of pre-converted operand */
    SANY,     TCHAR|TUCHAR,             /* type of post-converted operand */
         NBREG|NBSL, RESC1,
         " nilz A1,AL,0xff # 400b\n",
 
SCONV,   INTAREG,
    SREG,     ANYFIXED,                 /* type of pre-converted operand */
    SANY,     TUSHORT,                  /* type of post-converted operand */
         NAREG|NASL, RESC1,
         " nilz A1,AL,0xffff # 401\n",
 
SCONV,   INTBREG,
    SREG,     ANYFIXED,                 /* type of pre-converted operand */
    SANY,     TUSHORT,                  /* type of post-converted operand */
         NBREG|NBSL, RESC1,
         " nilz A1,AL,0xffff # 401b\n",
 
SCONV,   INTAREG,
    SREG,     TUNSIGNED|TULONG|TUSHORT, /* type of pre-converted operand */
    SANY,     TSHORT,                   /* type of post-converted operand */
         NAREG|NASL, RESC1,
         " exts A1,AL # 402\n",
 
SCONV,   INTBREG,
    SREG,     TUNSIGNED|TULONG|TUSHORT, /* type of pre-converted operand */
    SANY,     TSHORT,                   /* type of post-converted operand */
         NBREG|NBSL, RESC1,
         " exts A1,AL # 402b\n",
 
SCONV,   INTAREG,
    SREG,       TFLOAT,                 /* type of pre-converted operand */
    SANY,       ANYFIXED,               /* type of post-converted operand */
         NAREG, RESC1,
         "E1 # 410\n",
 
SCONV,   INTBREG,
    SREG,       TFLOAT,                 /* type of pre-converted operand */
    SANY,       ANYFIXED,               /* type of post-converted operand */
/*         NBREG, RESC1,	*/
	 NBREG|NBSL, RESC1,
         "E1 # 410b\n",
 
SCONV,   INTAREG,
    SREG,     ANYFIXED,                 /* type of pre-converted operand */
    SANY,     TFLOAT,                   /* type of post-converted operand */
         NAREG|NASL, RESC1,
         "E1 # 411\n",
 
SCONV,   INTBREG,
    SREG,     ANYFIXED,                 /* type of pre-converted operand */
    SANY,     TFLOAT,                   /* type of post-converted operand */
         NBREG|NBSL, RESC1,
         "E1 # 411b\n",
 
SCONV,   INTAREG,
/*    SAREG,    TDOUBLE,                  /* type of pre-converted operand */
    SREG,    TDOUBLE,                  /* type of pre-converted operand */
    SANY,     ANYFIXED,                 /* type of post-converted operand */
         NAREG|NASL, RESC1,
         "E1 # 420\n",
 
SCONV,   INTBREG,
/*    SAREG,    TDOUBLE,                  /* type of pre-converted operand */
    SREG,    TDOUBLE,                  /* type of pre-converted operand */
    SANY,     ANYFIXED,                 /* type of post-converted operand */
         NBREG|NBSL, RESC1,
         "E1 # 420b\n",
 
SCONV,   INTEMP,
    SREG,     ANYFIXED,                 /* type of pre-converted operand */
    SANY,     TDOUBLE,                  /* type of post-converted operand */
         2*NTEMP, RESC1,
         "E1 # 421\n",
 
SCONV,   INTEMP,
    SREG,     TFLOAT,                   /* type of pre-converted operand */
    SANY,     TDOUBLE,                  /* type of post-converted operand */
         2*NTEMP, RESC1,
         "E1 # 430\n",
 
SCONV,   INTAREG,
    SREG,    TDOUBLE,                  /* type of pre-converted operand */
    SANY,     TFLOAT,                   /* type of post-converted operand */
         NAREG|NASL, RESC1,
         "E1 # 431\n",
 
SCONV,   INTBREG,
    SREG,    TDOUBLE,                  /* type of pre-converted operand */
    SANY,     TFLOAT,                   /* type of post-converted operand */
         NBREG, RESC1,
         "E1 # 431\n",
 

SCONV,   INTAREG,
    STAREG,  TDOUBLE,
    SANY,    TDOUBLE,
       0,    RLEFT,
       " # 444dda\n",

SCONV,   INTBREG,
    STBREG,  TDOUBLE,
    SANY,    TDOUBLE,
       0,   RLEFT,
       " # 444ddb\n",

SCONV,   INTAREG,                       /* the rest are ok w/o coersion */
    STAREG,   TANY,                     /* type of pre-converted operand */
    SANY,     ANYFIXED,                 /* type of post-converted operand */
         0,   RLEFT,
         " # 444\n",
 
SCONV,   INTBREG,                       /* the rest are ok w/o coersion */
    STBREG,   TANY,                     /* type of pre-converted operand */
    SANY,     ANYFIXED,                 /* type of post-converted operand */
         0,   RLEFT,
         " # 444b\n",
 
/*-------------------------------------------- structure ops      */
 
STASG,   INTAREG|FOREFF,
    SNAME|SOREG,  TANY,
    SAREG|STAREG, TANY,
         NAREG|NASR, RESC1, /* JSW 10/2/86 - changed from B regs for NCS&A268 */
         "ZS # 500\n",
 
STARG,   FORARG,
    SREG,     ANYFIXED,  /* source structure address */
    SANY,     TANY,
         NAREG,   RNULL,
  " # 501\n WL ",	/* WFA 7/13/85 */
 
STARG,   INTEMP,
    SREG,     ANYFIXED,  /* source structure address */
    SANY,     TANY,
         NTEMP,   RESC1,
         " put AL,A1 # 502\n",
     /* Default actions for hard trees ... */
 
# define DF(x) FORREW,SANY,TANY,SANY,TANY,REWRITE,x,""
 
UNARY MUL, DF( UNARY MUL ),
 
INCR, DF(INCR),
 
DECR, DF(INCR),
 
ASSIGN, DF(ASSIGN),
 
STASG, DF(STASG),
 
OPLEAF, DF(NAME),
 
OPSIMP, DF(BITYPE),
 
COMOP, DF(COMOP),
 
INIT, DF(INIT),
 
OPUNARY, DF(UNARY MINUS),
 
ASG OPANY, DF(ASG PLUS),
 
OPANY, DF(BITYPE),  /* OPSHFT, OPLOG, etc */
 
FREE,  FREE, FREE, FREE, FREE, FREE, FREE, FREE, "HELP, I'm in trouble # 999\n" };
