/*
 * 5799-WZQ (C) COPYRIGHT = NONE
 * LICENSED MATERIALS - PROPERTY OF IBM
 */
/* $Header:ypvipw.c 12.0$ */
/* $ACIS:ypvipw.c 12.0$ */
/* $Source: /ibm/acis/usr/src/nfs/etc/RCS/ypvipw.c,v $ */

#ifndef lint
static char *rcsid = "$Header:ypvipw.c 12.0$";
#endif

#include <sys/nfs_defines.h>

/*
 * Copyright (c) 1980 Regents of the University of California.
 * All rights reserved.  The Berkeley software License Agreement
 * specifies the terms and conditions for redistribution.
 */

#ifndef lint
char copyright[] =
"@(#) Copyright (c) 1980 Regents of the University of California.\n\
 All rights reserved.\n";
#endif not lint

#ifndef lint
static char sccsid[] = "@(#)vipw.c	5.1 (Berkeley) 5/28/85";
#endif not lint

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>

#include <stdio.h>
#include <errno.h>
#include <signal.h>

/*
 * Password file editor with locking.
 * This is a slightly modified version of the regular vipw.c which
 * allows one to edit and lock a passwd file in a different directory
 * than /etc.  Usage is ypvipw directory_name.
 */
char	temp[BUFSIZ];
char	passwd[BUFSIZ];
char	buf[BUFSIZ];
char	*getenv();
char	*index();
extern	int errno;

main(argc, argv)
	char *argv[];
{
	int fd;
	FILE *ft, *fp;
	char *editor, *strcat(), *strcpy();

	if (argc != 2) {
		printf("Usage: %s directory_name\n", argv[0]);
		exit(1);
	}
	
	(void)strcpy(temp, argv[1]);
	(void)strcat(temp, "/ptmp");
	(void)strcpy(passwd, argv[1]);
	(void)strcat(passwd, "/passwd");

	signal(SIGHUP, SIG_IGN);
	signal(SIGINT, SIG_IGN);
	signal(SIGQUIT, SIG_IGN);
	setbuf(stderr, NULL);
	umask(0);
	fd = open(temp, O_WRONLY|O_CREAT|O_EXCL, 0644);
	if (fd < 0) {
		if (errno == EEXIST) {
			fprintf(stderr, "%s: password file busy\n", argv[0]);
			exit(1);
		}
		fprintf(stderr, "%s: ", argv[0]); perror(temp);
		exit(1);
	}
	ft = fdopen(fd, "w");
	if (ft == NULL) {
		fprintf(stderr, "%s: ", argv[0]); perror(temp);
		goto bad;
	}
	fp = fopen(passwd, "r");
	if (fp == NULL) {
		fprintf(stderr, "%s: ", argv[0]); perror(passwd);
		goto bad;
	}
	while (fgets(buf, sizeof (buf) - 1, fp) != NULL)
		fputs(buf, ft);
	fclose(ft); fclose(fp);
	editor = getenv("EDITOR");
	if (editor == 0)
		editor = "vi";
	sprintf(buf, "%s %s", editor, temp);
	if (system(buf) == 0) {
		struct stat sbuf;
		int ok;

		/* sanity checks */
		if (stat(temp, &sbuf) < 0) {
			fprintf(stderr,
			    "%s: can't stat temp file, %s unchanged\n",
			    argv[0], passwd);
			goto bad;
		}
		if (sbuf.st_size == 0) {
			fprintf(stderr, "%s: bad temp file, %s unchanged\n",
			    argv[0], passwd);
			goto bad;
		}
		ft = fopen(temp, "r");
		if (ft == NULL) {
			fprintf(stderr,
			    "%s: can't reopen temp file, %s unchanged\n",
			    argv[0], passwd);
			goto bad;
		}
		ok = 0;
		while (fgets(buf, sizeof (buf) - 1, ft) != NULL) {
			register char *cp;

			cp = index(buf, '\n');
			if (cp == 0)
				continue;
			*cp = '\0';
			cp = index(buf, ':');
			if (cp == 0)
				continue;
			*cp = '\0';
			if (strcmp(buf, "root"))
				continue;
			/* password */
			cp = index(cp + 1, ':');
			if (cp == 0)
				break;
			/* uid */
			if (atoi(cp + 1) != 0)
				break;
			cp = index(cp + 1, ':');
			if (cp == 0)
				break;
			/* gid */
			cp = index(cp + 1, ':');
			if (cp == 0)
				break;
			/* gecos */
			cp = index(cp + 1, ':');
			if (cp == 0)
				break;
			/* login directory */
			if (strncmp(++cp, "/:", 2))
				break;
			cp += 2;
			if (*cp && strcmp(cp, "/bin/sh") &&
			    strcmp(cp, "/bin/csh"))
				break;
			ok++;
		}
		fclose(ft);
		if (ok) {
			if (rename(temp, passwd) < 0)
				fprintf(stderr, "%s: ", argv[0]), perror("rename");
			else
				exit(0);
		} else
			fprintf(stderr,
			    "%s: you mangled the temp file, %s unchanged\n",
			    argv[0], passwd);
	}
bad:
	unlink(temp);
	exit(1);
}
