/* $Header:_cursor.c 12.0$ */
/* $ACIS:_cursor.c 12.0$ */
/* $Source: /ibm/acis/usr/src/usr.lib/libaed/RCS/_cursor.c,v $ */

#ifndef lint
static char *rcsid = "$Header:_cursor.c 12.0$";
#endif

#include "whim.h"
/*--------------------------------------------------------------*/
/*  Define Cursor from Memory					*/
/*--------------------------------------------------------------*/

VI_MDefnCur(xoff,yoff,black,white)
  INT16 xoff,yoff;		       /* cursor center offset */
  unsigned INT16 *black;		       /* black bit pattern */
  unsigned INT16 *white;		       /* white bit pattern */

  begin
#include "whimdcl.h"
    unsigned INT16 *svb;		       /* black bit pattern */
    unsigned INT16 *svw;		       /* white bit pattern */
    INT16 svcnt;

    if (saving) { JOURNL(V_MDCUR);
		  JOURNL(xoff);
		  JOURNL(yoff);
		  write(savefile,black,512);
		  write(savefile,white,512);
		}

    /* force out any pending graphics */
    VI_Force();

    /* build cursor definition command */
    vikoff = 1; 		     /* so we can use copy */
    vikint[vikoff++] = 7;	     /* define cursor command */
    vikint[vikoff++] = xoff;	/* x offset */
    vikint[vikoff++] = yoff;	/* y offset */

    /* copy black bits */
    copy(black,256);

    /* copy white bits */
    copy(white,256);

    /* send command to viking */
    command(vikoff-1);

    /* reset vikoff to keep from looking like buffer of orders */
    vikoff = 0;
  end

/*--------------------------------------------------------------*/
/*  Enable Cursor						*/
/*--------------------------------------------------------------*/

VI_EnCur()

  begin
    /* force out any pending graphics */
#include "whimdcl.h"

    if (saving) JOURNL(V_ENCUR);

    VI_Force();

    /* build cursor enable command */
    vikint[1] = 8;     /* Enable cursor command */

    /* send command to Viking */
    command(1);
  end

/*--------------------------------------------------------------*/
/*  Disable Cursor						*/
/*--------------------------------------------------------------*/

VI_DisCur()

  begin
#include "whimdcl.h"

    if (saving) JOURNL(V_DSCUR);

    /* force out any pending graphics */
    VI_Force();

    /* build cursor enable command */
    vikint[1] = 9;     /* Disable cursor command */

    /* send command to Viking */
    command(1);
  end

/*--------------------------------------------------------------*/
/*  Position Cursor						*/
/*--------------------------------------------------------------*/

VI_PosnCur(x,y)
  INT16 x,y;		       /* cursor position */

  begin
#include "whimdcl.h"

    if (saving) {JOURNL(V_PSCUR);
		 JOURNL(x);
		 JOURNL(y);}

    /* force out any pending graphics */
    VI_Force();

    /* constrain the position to the screen */
    x = max(0,min(1023,x));
    y = max(0,min(799,y));

    /* build position cursor command */
    vikint[1] = 10;	 /* Position cursor command */
    vikint[2] = x;	 /* x position */
    vikint[3] = y;	 /* y position */

    /* send command to Viking */
    command(3);
  end

VI_FDefnCur(name)
  char *name;			/* name of cursor file */

  begin
#include "whimdcl.h"
    INT16 xoff,yoff;
    INT_PURE curfile;
    unsigned INT16 black[256];
    unsigned INT16 white[256];


    if (saving) {JOURNL(V_FDCUR);
		 strjour(name);}

    VI_Force();

    /* open the curfile file */
    curfile = open(name,BREAD);
    if (curfile == -1) { fprintf(stderr,"Error opening file %s\n",name);
		       return;
		     }

    /* get the offsets from the first two words */
    read(curfile,&xoff,2);
    xoff = xoff;
    read(curfile,&yoff,2);
    yoff = yoff;

    read(curfile,black,512);
    read(curfile,white,512);

    close(curfile);

    /* build cursor definition command */
    vikoff = 1; 		     /* so we can use copy */
    vikint[vikoff++] = 7;	     /* define cursor command */
    vikint[vikoff++] = xoff;	/* x offset */
    vikint[vikoff++] = yoff;	/* y offset */

    /* copy black bits */
    copy(black,256);

    /* copy white bits */
    copy(white,256);

    /* send command to viking */
    command(vikoff-1);

    /* reset vikoff to keep from looking like buffer of orders */
    vikoff = 0;
  end
